/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.BigInt;
import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.AttributeNameEnumeration;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.Extension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public class PolicyConstraintsExtension
extends Extension
implements CertAttrSet {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final int[] PolicyConstraints_data = new int[]{2, 5, 29, 36};
    public static final String IDENT = "x509.info.extensions.PolicyConstraints";
    public static final String NAME = "PolicyConstraints";
    public static final String REQUIRE = "require";
    public static final String INHIBIT = "inhibit";
    private static final byte TAG_REQUIRE = 0;
    private static final byte TAG_INHIBIT = 1;
    private int require = -1;
    private int inhibit = -1;

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (this.require == -1 && this.inhibit == -1) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.require != -1) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(new BigInt(this.require));
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream);
        }
        if (this.inhibit != -1) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(new BigInt(this.inhibit));
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream);
        }
        derOutputStream3.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream3.toByteArray();
    }

    public PolicyConstraintsExtension(int n, int n2) throws IOException {
        this.require = n;
        this.inhibit = n2;
        this.extensionId = new ObjectIdentifier(PolicyConstraints_data);
        this.critical = false;
        this.encodeThis();
    }

    public PolicyConstraintsExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = new ObjectIdentifier(PolicyConstraints_data);
        this.critical = bl;
        if (!(object instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("Sequence tag missing for PolicyConstraint.");
        }
        DerInputStream derInputStream = derValue.data;
        while (derInputStream != null && derInputStream.available() != 0) {
            DerValue derValue2 = derInputStream.getDerValue();
            if (derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
                if (this.require != -1) {
                    throw new IOException("Duplicate requireExplicitPolicyfound in the PolicyConstraintsExtension");
                }
                derValue2.resetTag((byte)2);
                this.require = derValue2.getInteger().toInt();
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                if (this.inhibit != -1) {
                    throw new IOException("Duplicate inhibitPolicyMappingfound in the PolicyConstraintsExtension");
                }
                derValue2.resetTag((byte)2);
                this.inhibit = derValue2.getInteger().toInt();
                continue;
            }
            throw new IOException("Invalid encoding of PolicyConstraint");
        }
    }

    public String toString() {
        String string = String.valueOf(super.toString()) + "PolicyConstraints: [" + "  Require: ";
        string = this.require == -1 ? String.valueOf(string) + "unspecified;" : String.valueOf(string) + this.require + ";";
        string = String.valueOf(string) + "\tInhibit: ";
        string = this.inhibit == -1 ? String.valueOf(string) + "unspecified" : String.valueOf(string) + this.inhibit;
        string = String.valueOf(string) + " ]\n";
        return string;
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = new ObjectIdentifier(PolicyConstraints_data);
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Integer)) {
            throw new IOException("Attribute value should be of type Integer.");
        }
        if (string.equalsIgnoreCase(REQUIRE)) {
            this.require = (Integer)object;
        } else if (string.equalsIgnoreCase(INHIBIT)) {
            this.inhibit = (Integer)object;
        } else {
            throw new IOException("Attribute name [" + string + "]" + " not recognized by " + "CertAttrSet:PolicyConstraints.");
        }
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(REQUIRE)) {
            return new Integer(this.require);
        }
        if (string.equalsIgnoreCase(INHIBIT)) {
            return new Integer(this.inhibit);
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:PolicyConstraints.");
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(REQUIRE)) {
            this.require = -1;
        } else if (string.equalsIgnoreCase(INHIBIT)) {
            this.inhibit = -1;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyConstraints.");
        }
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(REQUIRE);
        attributeNameEnumeration.addElement(INHIBIT);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

