/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.AttributeNameEnumeration;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.CertificatePolicyMap;
import com.ibm.security12.sun.security.x509.Extension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;

public class PolicyMappingsExtension
extends Extension
implements CertAttrSet {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final int[] PolicyMappings_data = new int[]{2, 5, 29, 33};
    private static final int[] KeyUsage_data = new int[]{2, 5, 29, 15};
    public static final String IDENT = "x509.info.extensions.PolicyMappings";
    public static final String NAME = "PolicyMappings";
    public static final String MAP = "map";
    private Vector maps;

    private void encodeThis() throws IOException {
        if (this.maps == null || this.maps.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        int n = 0;
        while (n < this.maps.size()) {
            ((CertificatePolicyMap)this.maps.elementAt(n)).encode(derOutputStream2);
            ++n;
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public PolicyMappingsExtension(Vector vector) throws IOException {
        this.maps = vector;
        this.extensionId = new ObjectIdentifier(PolicyMappings_data);
        this.critical = false;
        this.encodeThis();
    }

    public PolicyMappingsExtension() {
        this.extensionId = new ObjectIdentifier(KeyUsage_data);
        this.critical = false;
        this.maps = new Vector(1, 1);
    }

    public PolicyMappingsExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = new ObjectIdentifier(PolicyMappings_data);
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = Array.getByte(object, n2);
            ++n2;
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for PolicyMappingsExtension.");
        }
        this.maps = new Vector(1, 1);
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            CertificatePolicyMap certificatePolicyMap = new CertificatePolicyMap(derValue2);
            this.maps.addElement(certificatePolicyMap);
        }
    }

    public String toString() {
        if (this.maps == null) {
            return "";
        }
        String string = String.valueOf(super.toString()) + "PolicyMappings [\n" + this.maps.toString() + "]\n";
        return string;
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = new ObjectIdentifier(PolicyMappings_data);
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(MAP)) {
            if (!(object instanceof Vector)) {
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.maps = (Vector)object;
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(MAP)) {
            return this.maps;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(MAP)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.maps = null;
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(MAP);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

