/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.java.security.cert.CertificateException;
import com.ibm.security12.java.security.cert.CertificateExpiredException;
import com.ibm.security12.java.security.cert.CertificateNotYetValidException;
import com.ibm.security12.java.security.cert.CertificateParsingException;
import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.AttributeNameEnumeration;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.Extension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Enumeration;

public class PrivateKeyUsageExtension
extends Extension
implements CertAttrSet {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final int[] PrivateKeyUsage_data = new int[]{2, 5, 29, 16};
    public static final String IDENT = "x509.info.extensions.PrivateKeyUsage";
    public static final String NAME = "PrivateKeyUsage";
    public static final String NOT_BEFORE = "not_before";
    public static final String NOT_AFTER = "not_after";
    private static final byte TAG_BEFORE = 0;
    private static final byte TAG_AFTER = 1;
    private Date notBefore;
    private Date notAfter;

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (this.notBefore == null && this.notAfter == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.notBefore != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putGeneralizedTime(this.notBefore);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream);
        }
        if (this.notAfter != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putGeneralizedTime(this.notAfter);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        this.extensionValue = derOutputStream2.toByteArray();
    }

    public PrivateKeyUsageExtension(Date date, Date date2) throws IOException {
        this.notBefore = date;
        this.notAfter = date2;
        this.extensionId = new ObjectIdentifier(PrivateKeyUsage_data);
        this.critical = false;
        this.encodeThis();
    }

    public PrivateKeyUsageExtension(Boolean bl, Object object) throws CertificateException, IOException {
        this.extensionId = new ObjectIdentifier(PrivateKeyUsage_data);
        this.critical = bl;
        if (!(object instanceof byte[])) {
            throw new CertificateException("Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n2 = 0;
        while (n2 < derValueArray.length) {
            DerValue derValue = derValueArray[n2];
            if (derValue.isContextSpecific((byte)0) && !derValue.isConstructed()) {
                if (this.notBefore != null) {
                    throw new CertificateParsingException("Duplicate notBefore in PrivateKeyUsage.");
                }
                derValue.resetTag((byte)24);
                derInputStream = new DerInputStream(derValue.toByteArray());
                this.notBefore = derInputStream.getGeneralizedTime();
            } else if (derValue.isContextSpecific((byte)1) && !derValue.isConstructed()) {
                if (this.notAfter != null) {
                    throw new CertificateParsingException("Duplicate notAfter in PrivateKeyUsage.");
                }
                derValue.resetTag((byte)24);
                derInputStream = new DerInputStream(derValue.toByteArray());
                this.notAfter = derInputStream.getGeneralizedTime();
            } else {
                throw new IOException("Invalid encoding of PrivateKeyUsageExtension");
            }
            ++n2;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + "PrivateKeyUsage: [\n" + (this.notBefore == null ? "" : "From: " + this.notBefore.toString() + ", ") + (this.notAfter == null ? "" : "To: " + this.notAfter.toString()) + "]\n";
    }

    public void valid() throws CertificateNotYetValidException, CertificateExpiredException {
        Date date = new Date();
        this.valid(date);
    }

    public void valid(Date date) throws CertificateNotYetValidException, CertificateExpiredException {
        if (this.notBefore.after(date)) {
            throw new CertificateNotYetValidException("NotBefore: " + this.notBefore.toString());
        }
        if (this.notAfter.before(date)) {
            throw new CertificateExpiredException("NotAfter: " + this.notAfter.toString());
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = new ObjectIdentifier(PrivateKeyUsage_data);
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void decode(InputStream inputStream) throws CertificateException {
        throw new CertificateException("Method not to be called directly.");
    }

    public void set(String string, Object object) throws CertificateException, IOException {
        if (!(object instanceof Date)) {
            throw new CertificateException("Attribute must be of type Date.");
        }
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = (Date)object;
        } else if (string.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = (Date)object;
        } else {
            throw new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
        }
        this.encodeThis();
    }

    public Object get(String string) throws CertificateException {
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            return new Date(this.notBefore.getTime());
        }
        if (string.equalsIgnoreCase(NOT_AFTER)) {
            return new Date(this.notAfter.getTime());
        }
        throw new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
    }

    public void delete(String string) throws CertificateException, IOException {
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = null;
        } else if (string.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = null;
        } else {
            throw new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
        }
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(NOT_BEFORE);
        attributeNameEnumeration.addElement(NOT_AFTER);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

