/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.java.security.Signature;
import com.ibm.security12.java.security.Signer;
import com.ibm.security12.sun.security.x509.AlgorithmId;
import com.ibm.security12.sun.security.x509.X500Name;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;

public final class X500Signer
extends Signer {
    private Signature sig;
    private X500Name agent;
    private AlgorithmId algid;

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.sig.update(byArray, n, n2);
    }

    public byte[] sign() throws SignatureException {
        return this.sig.sign();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public X500Name getSigner() {
        return this.agent;
    }

    public X500Signer(Signature signature, X500Name x500Name) {
        if (signature == null || x500Name == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.sig = signature;
        this.agent = x500Name;
        try {
            this.algid = AlgorithmId.get(signature.getAlgorithm());
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("internal error! " + noSuchAlgorithmException.getMessage());
        }
    }
}

