/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.java.security.cert.CertificateEncodingException;
import com.ibm.security12.java.security.cert.CertificateException;
import com.ibm.security12.java.security.cert.CertificateParsingException;
import com.ibm.security12.java.util.Collection;
import com.ibm.security12.java.util.Hashtable;
import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.x509.AttributeNameEnumeration;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.CertificateAlgorithmId;
import com.ibm.security12.sun.security.x509.CertificateExtensions;
import com.ibm.security12.sun.security.x509.CertificateIssuerName;
import com.ibm.security12.sun.security.x509.CertificateIssuerUniqueIdentity;
import com.ibm.security12.sun.security.x509.CertificateSerialNumber;
import com.ibm.security12.sun.security.x509.CertificateSubjectName;
import com.ibm.security12.sun.security.x509.CertificateSubjectUniqueIdentity;
import com.ibm.security12.sun.security.x509.CertificateValidity;
import com.ibm.security12.sun.security.x509.CertificateVersion;
import com.ibm.security12.sun.security.x509.CertificateX509Key;
import com.ibm.security12.sun.security.x509.Extension;
import com.ibm.security12.sun.security.x509.OIDMap;
import com.ibm.security12.sun.security.x509.X509AttributeName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.misc.HexDumpEncoder;

public class X509CertInfo
implements CertAttrSet {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    public static final String IDENT = "x509.info";
    public static final String NAME = "info";
    public static final String VERSION = "version";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String ALGORITHM_ID = "algorithmID";
    public static final String ISSUER = "issuer";
    public static final String VALIDITY = "validity";
    public static final String SUBJECT = "subject";
    public static final String KEY = "key";
    public static final String ISSUER_ID = "issuerID";
    public static final String SUBJECT_ID = "subjectID";
    public static final String EXTENSIONS = "extensions";
    protected CertificateVersion version = new CertificateVersion();
    protected CertificateSerialNumber serialNum;
    protected CertificateAlgorithmId algId;
    protected CertificateIssuerName issuer;
    protected CertificateValidity interval;
    protected CertificateSubjectName subject;
    protected CertificateX509Key pubKey;
    protected CertificateIssuerUniqueIdentity issuerUniqueId;
    protected CertificateSubjectUniqueIdentity subjectUniqueId;
    protected CertificateExtensions extensions;
    private static final int ATTR_VERSION = 1;
    private static final int ATTR_SERIAL = 2;
    private static final int ATTR_ALGORITHM = 3;
    private static final int ATTR_ISSUER = 4;
    private static final int ATTR_VALIDITY = 5;
    private static final int ATTR_SUBJECT = 6;
    private static final int ATTR_KEY = 7;
    private static final int ATTR_ISSUER_ID = 8;
    private static final int ATTR_SUBJECT_ID = 9;
    private static final int ATTR_EXTENSIONS = 10;
    private byte[] rawCertInfo;
    private static final Hashtable map = new Hashtable();

    public X509CertInfo() {
    }

    public X509CertInfo(byte[] byArray) throws CertificateParsingException {
        try {
            DerValue derValue = new DerValue(byArray);
            this.parse(derValue);
            return;
        }
        catch (IOException iOException) {
            throw new CertificateParsingException(iOException.toString());
        }
    }

    public X509CertInfo(DerValue derValue) throws CertificateParsingException {
        try {
            this.parse(derValue);
            return;
        }
        catch (IOException iOException) {
            throw new CertificateParsingException(iOException.toString());
        }
    }

    public void decode(InputStream inputStream) throws CertificateParsingException, IOException {
        DerValue derValue = new DerValue(inputStream);
        this.parse(derValue);
    }

    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        if (this.rawCertInfo == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.emit(derOutputStream);
            this.rawCertInfo = derOutputStream.toByteArray();
        }
        outputStream.write((byte[])this.rawCertInfo.clone());
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(VERSION);
        attributeNameEnumeration.addElement(SERIAL_NUMBER);
        attributeNameEnumeration.addElement(ALGORITHM_ID);
        attributeNameEnumeration.addElement(ISSUER);
        attributeNameEnumeration.addElement(VALIDITY);
        attributeNameEnumeration.addElement(SUBJECT);
        attributeNameEnumeration.addElement(KEY);
        attributeNameEnumeration.addElement(ISSUER_ID);
        attributeNameEnumeration.addElement(SUBJECT_ID);
        attributeNameEnumeration.addElement(EXTENSIONS);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public byte[] getEncodedInfo() throws CertificateEncodingException {
        try {
            if (this.rawCertInfo == null) {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.emit(derOutputStream);
                this.rawCertInfo = derOutputStream.toByteArray();
            }
            return (byte[])this.rawCertInfo.clone();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
        catch (CertificateException certificateException) {
            throw new CertificateEncodingException(certificateException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof X509CertInfo) {
            return this.equals((X509CertInfo)object);
        }
        return false;
    }

    public boolean equals(X509CertInfo x509CertInfo) {
        if (this == x509CertInfo) {
            return true;
        }
        if (this.rawCertInfo == null || x509CertInfo.rawCertInfo == null) {
            return false;
        }
        if (this.rawCertInfo.length != x509CertInfo.rawCertInfo.length) {
            return false;
        }
        int n = 0;
        while (n < this.rawCertInfo.length) {
            if (this.rawCertInfo[n] != x509CertInfo.rawCertInfo[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.rawCertInfo.length) {
            n += this.rawCertInfo[n2] * n2;
            ++n2;
        }
        return n;
    }

    public String toString() {
        if (this.subject == null || this.pubKey == null || this.interval == null || this.issuer == null || this.algId == null || this.serialNum == null) {
            throw new NullPointerException("X.509 cert is incomplete");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        stringBuffer.append("  " + this.version.toString() + "\n");
        stringBuffer.append("  Subject: " + this.subject.toString() + "\n");
        stringBuffer.append("  Signature Algorithm: " + this.algId.toString() + "\n");
        stringBuffer.append("  Key:  " + this.pubKey.toString() + "\n");
        stringBuffer.append("  " + this.interval.toString() + "\n");
        stringBuffer.append("  Issuer: " + this.issuer.toString() + "\n");
        stringBuffer.append("  " + this.serialNum.toString() + "\n");
        if (this.issuerUniqueId != null) {
            stringBuffer.append("  Issuer Id:\n" + this.issuerUniqueId.toString() + "\n");
        }
        if (this.subjectUniqueId != null) {
            stringBuffer.append("  Subject Id:\n" + this.subjectUniqueId.toString() + "\n");
        }
        if (this.extensions != null) {
            Collection collection = this.extensions.getAllExtensions();
            Object[] objectArray = collection.toArray();
            stringBuffer.append("\nCertificate Extensions: " + objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append("\n[" + (n + 1) + "]: ");
                Extension extension = (Extension)objectArray[n];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuffer.append(extension.toString());
                        byte[] byArray = extension.getExtensionValue();
                        if (byArray != null) {
                            DerOutputStream derOutputStream = new DerOutputStream();
                            derOutputStream.putOctetString(byArray);
                            byArray = derOutputStream.toByteArray();
                            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                            stringBuffer.append("Extension unknown: DER encoded OCTET string =\n" + hexDumpEncoder.encodeBuffer(byArray) + "\n");
                        }
                    } else {
                        stringBuffer.append(extension.toString());
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append(", Error parsing this extension");
                }
                ++n;
            }
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    public void set(String string, Object object) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n = this.attributeMap(x509AttributeName.getPrefix());
        if (n == 0) {
            throw new CertificateException("Attribute name not recognized: " + string);
        }
        this.rawCertInfo = null;
        switch (n) {
            case 1: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setVersion(object);
                    return;
                }
                this.version.set(x509AttributeName.getSuffix(), object);
                return;
            }
            case 2: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setSerialNumber(object);
                    return;
                }
                this.serialNum.set(x509AttributeName.getSuffix(), object);
                return;
            }
            case 3: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setAlgorithmId(object);
                    return;
                }
                this.algId.set(x509AttributeName.getSuffix(), object);
                return;
            }
            case 4: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setIssuer(object);
                    return;
                }
                this.issuer.set(x509AttributeName.getSuffix(), object);
                return;
            }
            case 5: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setValidity(object);
                    return;
                }
                this.interval.set(x509AttributeName.getSuffix(), object);
                return;
            }
            case 6: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setSubject(object);
                    return;
                }
                this.subject.set(x509AttributeName.getSuffix(), object);
                return;
            }
            case 7: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setKey(object);
                    return;
                }
                this.pubKey.set(x509AttributeName.getSuffix(), object);
                return;
            }
            case 8: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setIssuerUniqueId(object);
                    return;
                }
                this.issuerUniqueId.set(x509AttributeName.getSuffix(), object);
                return;
            }
            case 9: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setSubjectUniqueId(object);
                    return;
                }
                this.subjectUniqueId.set(x509AttributeName.getSuffix(), object);
                return;
            }
            case 10: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setExtensions(object);
                    return;
                }
                this.extensions.set(x509AttributeName.getSuffix(), object);
                return;
            }
        }
    }

    public void delete(String string) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n = this.attributeMap(x509AttributeName.getPrefix());
        if (n == 0) {
            throw new CertificateException("Attribute name not recognized: " + string);
        }
        this.rawCertInfo = null;
        switch (n) {
            case 1: {
                if (x509AttributeName.getSuffix() == null) {
                    this.version = null;
                    return;
                }
                this.version.delete(x509AttributeName.getSuffix());
                return;
            }
            case 2: {
                if (x509AttributeName.getSuffix() == null) {
                    this.serialNum = null;
                    return;
                }
                this.serialNum.delete(x509AttributeName.getSuffix());
                return;
            }
            case 3: {
                if (x509AttributeName.getSuffix() == null) {
                    this.algId = null;
                    return;
                }
                this.algId.delete(x509AttributeName.getSuffix());
                return;
            }
            case 4: {
                if (x509AttributeName.getSuffix() == null) {
                    this.issuer = null;
                    return;
                }
                this.issuer.delete(x509AttributeName.getSuffix());
                return;
            }
            case 5: {
                if (x509AttributeName.getSuffix() == null) {
                    this.interval = null;
                    return;
                }
                this.interval.delete(x509AttributeName.getSuffix());
                return;
            }
            case 6: {
                if (x509AttributeName.getSuffix() == null) {
                    this.subject = null;
                    return;
                }
                this.subject.delete(x509AttributeName.getSuffix());
                return;
            }
            case 7: {
                if (x509AttributeName.getSuffix() == null) {
                    this.pubKey = null;
                    return;
                }
                this.pubKey.delete(x509AttributeName.getSuffix());
                return;
            }
            case 8: {
                if (x509AttributeName.getSuffix() == null) {
                    this.issuerUniqueId = null;
                    return;
                }
                this.issuerUniqueId.delete(x509AttributeName.getSuffix());
                return;
            }
            case 9: {
                if (x509AttributeName.getSuffix() == null) {
                    this.subjectUniqueId = null;
                    return;
                }
                this.subjectUniqueId.delete(x509AttributeName.getSuffix());
                return;
            }
            case 10: {
                if (x509AttributeName.getSuffix() == null) {
                    this.extensions = null;
                    return;
                }
                this.extensions.delete(x509AttributeName.getSuffix());
                return;
            }
        }
    }

    public Object get(String string) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n = this.attributeMap(x509AttributeName.getPrefix());
        if (n == 0) {
            throw new CertificateParsingException("Attribute name not recognized: " + string);
        }
        switch (n) {
            case 1: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.version;
                }
                return this.version.get(x509AttributeName.getSuffix());
            }
            case 2: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.serialNum;
                }
                return this.serialNum.get(x509AttributeName.getSuffix());
            }
            case 3: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.algId;
                }
                return this.algId.get(x509AttributeName.getSuffix());
            }
            case 4: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.issuer;
                }
                return this.issuer.get(x509AttributeName.getSuffix());
            }
            case 5: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.interval;
                }
                return this.interval.get(x509AttributeName.getSuffix());
            }
            case 6: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.subject;
                }
                return this.subject.get(x509AttributeName.getSuffix());
            }
            case 7: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.pubKey;
                }
                return this.pubKey.get(x509AttributeName.getSuffix());
            }
            case 8: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.issuerUniqueId;
                }
                if (this.issuerUniqueId == null) {
                    return null;
                }
                return this.issuerUniqueId.get(x509AttributeName.getSuffix());
            }
            case 9: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.subjectUniqueId;
                }
                if (this.subjectUniqueId == null) {
                    return null;
                }
                return this.subjectUniqueId.get(x509AttributeName.getSuffix());
            }
            case 10: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.extensions;
                }
                if (this.extensions == null) {
                    return null;
                }
                return this.extensions.get(x509AttributeName.getSuffix());
            }
        }
        return null;
    }

    private void parse(DerValue derValue) throws CertificateParsingException, IOException {
        if (derValue.tag != 48) {
            throw new CertificateParsingException("signed fields invalid");
        }
        this.rawCertInfo = derValue.toByteArray();
        DerInputStream derInputStream = derValue.data;
        DerValue derValue2 = derInputStream.getDerValue();
        if (derValue2.isContextSpecific((byte)0)) {
            this.version = new CertificateVersion(derValue2);
            derValue2 = derInputStream.getDerValue();
        }
        this.serialNum = new CertificateSerialNumber(derValue2);
        this.algId = new CertificateAlgorithmId(derInputStream);
        this.issuer = new CertificateIssuerName(derInputStream);
        if (this.version.compare(0) == 0 && this.issuer.toString() == null) {
            throw new CertificateParsingException("Null issuer DN not allowed in v1 certificate");
        }
        this.interval = new CertificateValidity(derInputStream);
        this.subject = new CertificateSubjectName(derInputStream);
        if (this.version.compare(0) == 0 && this.subject.toString() == null) {
            throw new CertificateParsingException("Null subject DN not allowed in v1 certificate");
        }
        this.pubKey = new CertificateX509Key(derInputStream);
        if (derInputStream.available() != 0) {
            if (this.version.compare(0) == 0) {
                throw new CertificateParsingException("no more data allowed for version 1 certificate");
            }
        } else {
            return;
        }
        derValue2 = derInputStream.getDerValue();
        if (derValue2.isContextSpecific((byte)1)) {
            this.issuerUniqueId = new CertificateIssuerUniqueIdentity(derValue2);
            if (derInputStream.available() == 0) {
                return;
            }
            derValue2 = derInputStream.getDerValue();
        }
        if (derValue2.isContextSpecific((byte)2)) {
            this.subjectUniqueId = new CertificateSubjectUniqueIdentity(derValue2);
            if (derInputStream.available() == 0) {
                return;
            }
            derValue2 = derInputStream.getDerValue();
        }
        if (this.version.compare(2) != 0) {
            throw new CertificateParsingException("Extensions not allowed in v2 certificate");
        }
        if (derValue2.isConstructed() && derValue2.isContextSpecific((byte)3)) {
            this.extensions = new CertificateExtensions(derValue2.data);
        }
    }

    private void emit(DerOutputStream derOutputStream) throws CertificateException, IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.version.encode(derOutputStream2);
        this.serialNum.encode(derOutputStream2);
        this.algId.encode(derOutputStream2);
        if (this.version.compare(0) == 0 && this.issuer.toString() == null) {
            throw new CertificateParsingException("Null issuer DN not allowed in v1 certificate");
        }
        this.issuer.encode(derOutputStream2);
        this.interval.encode(derOutputStream2);
        if (this.version.compare(0) == 0 && this.subject.toString() == null) {
            throw new CertificateParsingException("Null subject DN not allowed in v1 certificate");
        }
        this.subject.encode(derOutputStream2);
        this.pubKey.encode(derOutputStream2);
        if (this.issuerUniqueId != null) {
            this.issuerUniqueId.encode(derOutputStream2);
        }
        if (this.subjectUniqueId != null) {
            this.subjectUniqueId.encode(derOutputStream2);
        }
        if (this.extensions != null) {
            this.extensions.encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    private int attributeMap(String string) {
        Integer n = (Integer)map.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private void setVersion(Object object) throws CertificateException {
        if (!(object instanceof CertificateVersion)) {
            throw new CertificateException("Version class type invalid.");
        }
        this.version = (CertificateVersion)object;
    }

    private void setSerialNumber(Object object) throws CertificateException {
        if (!(object instanceof CertificateSerialNumber)) {
            throw new CertificateException("SerialNumber class type invalid.");
        }
        this.serialNum = (CertificateSerialNumber)object;
    }

    private void setAlgorithmId(Object object) throws CertificateException {
        if (!(object instanceof CertificateAlgorithmId)) {
            throw new CertificateException("AlgorithmId class type invalid.");
        }
        this.algId = (CertificateAlgorithmId)object;
    }

    private void setIssuer(Object object) throws CertificateException {
        if (!(object instanceof CertificateIssuerName)) {
            throw new CertificateException("Issuer class type invalid.");
        }
        this.issuer = (CertificateIssuerName)object;
    }

    private void setValidity(Object object) throws CertificateException {
        if (!(object instanceof CertificateValidity)) {
            throw new CertificateException("CertificateValidity class type invalid.");
        }
        this.interval = (CertificateValidity)object;
    }

    private void setSubject(Object object) throws CertificateException {
        if (!(object instanceof CertificateSubjectName)) {
            throw new CertificateException("Subject class type invalid.");
        }
        this.subject = (CertificateSubjectName)object;
    }

    private void setKey(Object object) throws CertificateException {
        if (!(object instanceof CertificateX509Key)) {
            throw new CertificateException("Key class type invalid.");
        }
        this.pubKey = (CertificateX509Key)object;
    }

    private void setIssuerUniqueId(Object object) throws CertificateException {
        if (this.version.compare(1) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(object instanceof CertificateIssuerUniqueIdentity)) {
            throw new CertificateException("IssuerUniqueId class type invalid.");
        }
        this.issuerUniqueId = (CertificateIssuerUniqueIdentity)object;
    }

    private void setSubjectUniqueId(Object object) throws CertificateException {
        if (this.version.compare(1) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(object instanceof CertificateSubjectUniqueIdentity)) {
            throw new CertificateException("SubjectUniqueId class type invalid.");
        }
        this.subjectUniqueId = (CertificateSubjectUniqueIdentity)object;
    }

    private void setExtensions(Object object) throws CertificateException {
        if (this.version.compare(2) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(object instanceof CertificateExtensions)) {
            throw new CertificateException("Extensions class type invalid.");
        }
        this.extensions = (CertificateExtensions)object;
    }

    static {
        map.put(VERSION, new Integer(1));
        map.put(SERIAL_NUMBER, new Integer(2));
        map.put(ALGORITHM_ID, new Integer(3));
        map.put(ISSUER, new Integer(4));
        map.put(VALIDITY, new Integer(5));
        map.put(SUBJECT, new Integer(6));
        map.put(KEY, new Integer(7));
        map.put(ISSUER_ID, new Integer(8));
        map.put(SUBJECT_ID, new Integer(9));
        map.put(EXTENSIONS, new Integer(10));
    }
}

