/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.rmi.registry;

import com.sun.jndi.rmi.registry.RegistryContext;
import com.sun.jndi.toolkit.VersionHelper;
import com.sun.jndi.url.rmi.rmiURLContextFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;

public class RegistryContextFactory
implements ObjectFactory,
InitialContextFactory {
    private static VersionHelper helper = VersionHelper.getVersionHelper();
    public static final String ADDRESS_TYPE = "URL";
    static /* synthetic */ Class class$com$sun$jndi$rmi$registry$RegistryContextFactory;

    private static Context URLToContext(String string, Hashtable hashtable) throws NamingException {
        rmiURLContextFactory rmiURLContextFactory2 = new rmiURLContextFactory();
        Object object = rmiURLContextFactory2.getObjectInstance((Object)string, (Name)null, (Context)null, hashtable);
        if (object instanceof Context) {
            return (Context)object;
        }
        throw new NotContextException(string);
    }

    private static Object URLsToObject(String[] stringArray, Hashtable hashtable) throws NamingException {
        rmiURLContextFactory rmiURLContextFactory2 = new rmiURLContextFactory();
        return rmiURLContextFactory2.getObjectInstance((Object)stringArray, (Name)null, (Context)null, hashtable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String getInitCtxURL(Hashtable hashtable) {
        String string = "rmi:";
        String string2 = null;
        if (hashtable != null) {
            string2 = (String)hashtable.get("java.naming.provider.url");
        }
        if (string2 == null) {
            try {
                string2 = helper.getJndiProperty(0);
            }
            catch (SecurityException securityException) {}
        }
        return string2 != null ? string2 : "rmi:";
    }

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        return RegistryContextFactory.URLToContext(RegistryContextFactory.getInitCtxURL(hashtable), hashtable);
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        if (!RegistryContextFactory.isRegistryRef(object)) {
            return null;
        }
        Object object2 = RegistryContextFactory.URLsToObject(RegistryContextFactory.getURLs((Reference)object), hashtable);
        if (object2 instanceof RegistryContext) {
            RegistryContext registryContext = (RegistryContext)object2;
            registryContext.reference = (Reference)object;
        }
        return object2;
    }

    private static String[] getURLs(Reference reference) throws NamingException {
        String[] stringArray;
        int n = 0;
        String[] stringArray2 = new String[reference.size()];
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            stringArray = enumeration.nextElement();
            if (!(stringArray instanceof StringRefAddr) || !stringArray.getType().equals(ADDRESS_TYPE)) continue;
            stringArray2[n++] = (String)stringArray.getContent();
        }
        if (n == 0) {
            throw new ConfigurationException("Reference contains no valid addresses");
        }
        if (n == reference.size()) {
            return stringArray2;
        }
        stringArray = new String[n];
        System.arraycopy(stringArray2, 0, stringArray, 0, n);
        return stringArray;
    }

    private static boolean isRegistryRef(Object object) {
        if (!(object instanceof Reference)) {
            return false;
        }
        String string = (class$com$sun$jndi$rmi$registry$RegistryContextFactory != null ? class$com$sun$jndi$rmi$registry$RegistryContextFactory : (class$com$sun$jndi$rmi$registry$RegistryContextFactory = RegistryContextFactory.class$("com.sun.jndi.rmi.registry.RegistryContextFactory"))).getName();
        Reference reference = (Reference)object;
        return string.equals(reference.getFactoryClassName());
    }
}

