/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;

public class BasicAttribute
implements Attribute {
    protected String attrID;
    protected transient Vector values;

    public BasicAttribute(String string) {
        this.attrID = string;
        this.values = new Vector();
    }

    public BasicAttribute(String string, Object object) {
        this.attrID = string;
        this.values = new Vector();
        this.values.addElement(object);
    }

    public boolean add(Object object) {
        if (this.find(object) < 0) {
            this.values.addElement(object);
            return true;
        }
        return false;
    }

    private static boolean arrayEquals(Object object, Object object2) {
        int n = Array.getLength(object);
        if (n != Array.getLength(object2)) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            Object object3 = Array.get(object, n2);
            Object object4 = Array.get(object2, n2);
            if (object3 == null || object4 == null ? object3 != object4 : !object3.equals(object4)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void clear() {
        this.values.setSize(0);
    }

    public Object clone() {
        BasicAttribute basicAttribute;
        try {
            basicAttribute = (BasicAttribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            basicAttribute = new BasicAttribute(this.attrID);
        }
        basicAttribute.values = (Vector)this.values.clone();
        return basicAttribute;
    }

    public boolean contains(Object object) {
        return this.find(object) >= 0;
    }

    public boolean equals(Object object) {
        Attribute attribute;
        if (object != null && object instanceof Attribute && this.attrID.equals((attribute = (Attribute)object).getID()) && this.size() == attribute.size()) {
            try {
                NamingEnumeration namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    if (this.find(namingEnumeration.nextElement()) >= 0) continue;
                    return false;
                }
            }
            catch (NamingException namingException) {
                return false;
            }
            return true;
        }
        return false;
    }

    private int find(Object object) {
        if (object == null) {
            int n = this.values.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.values.elementAt(n2) == null) {
                    return n2;
                }
                ++n2;
            }
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = this.values.size();
                int n3 = 0;
                while (n3 < n) {
                    Object e = this.values.elementAt(n3);
                    if (e != null && clazz == e.getClass() && BasicAttribute.arrayEquals(object, e)) {
                        return n3;
                    }
                    ++n3;
                }
            } else {
                return this.values.indexOf(object, 0);
            }
        }
        return -1;
    }

    public Object get() throws NamingException {
        if (this.values.size() == 0) {
            throw new NoSuchElementException("Attribute " + this.getID() + " has no value");
        }
        return this.values.elementAt(0);
    }

    public NamingEnumeration getAll() throws NamingException {
        return new ValuesEnumImpl();
    }

    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute definition");
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute syntax");
    }

    public String getID() {
        return this.attrID;
    }

    public int hashCode() {
        int n = this.attrID.hashCode();
        int n2 = this.values.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e = this.values.elementAt(n3);
            if (e != null) {
                if (e.getClass().isArray()) {
                    int n4 = Array.getLength(e);
                    int n5 = 0;
                    while (n5 < n4) {
                        Object object = Array.get(e, n5);
                        if (object != null) {
                            n += object.hashCode();
                        }
                        ++n5;
                    }
                } else {
                    n += e.hashCode();
                }
            }
            ++n3;
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.values = new Vector(n);
        while (--n >= 0) {
            this.values.addElement(objectInputStream.readObject());
        }
    }

    public boolean remove(Object object) {
        int n = this.find(object);
        if (n >= 0) {
            this.values.removeElementAt(n);
            return true;
        }
        return false;
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.attrID) + ": ");
        if (this.values.size() == 0) {
            stringBuffer.append("No values");
        } else {
            boolean bl = true;
            Enumeration enumeration = this.values.elements();
            while (enumeration.hasMoreElements()) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(enumeration.nextElement());
                bl = false;
            }
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.values.size());
        int n = 0;
        while (n < this.values.size()) {
            objectOutputStream.writeObject(this.values.elementAt(n));
            ++n;
        }
    }

    class ValuesEnumImpl
    implements NamingEnumeration {
        Enumeration list;

        ValuesEnumImpl() {
            this.list = BasicAttribute.this.values.elements();
        }

        public boolean hasMore() throws NamingException {
            return this.list.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.list.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.list.nextElement();
        }

        public Object nextElement() {
            return this.list.nextElement();
        }
    }
}

