/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sslight;

import com.ibm.sslight.SSLCert;
import com.ibm.sslight.SSLConnection;
import com.ibm.sslight.SSLException;
import com.ibm.sslight.Util;
import java.util.StringTokenizer;
import java.util.Vector;

public class SSLContext {
    public static final int CA = 0;
    public static final int SITE = 1;
    public static final int PRIVATE = 2;
    public static final int CONNECTION = 0;
    public static final int SESSION = 1;
    public static final int CONNECT = 2;
    public boolean clientAuthentication;
    public boolean asyncConnections;
    public boolean debug;
    static final byte[][] bug_null = null;
    static final byte[] cmEnabled = new byte[]{0, -15, -7};
    static String[] cmName = (String[])SSLContext.getTokens("NULL IBM_ZIP_SPEED IBM_ZIP_SIZE", null);
    static final short[] csEnabled = new short[]{3, 1, 2};
    static String[] csName = (String[])SSLContext.getTokens("SSL_RSA_EXPORT_WITH_RC4_40_MD5 SSL_RSA_WITH_NULL_MD5 SSL_RSA_WITH_NULL_SHA ", null);
    private static int contextCounter;
    private static final int[][] timeoutLimit;
    int context_id;
    int[] timeout = new int[3];
    short[] cs_list = csEnabled;
    byte[] cm_list = cmEnabled;
    Vector[] ring = new Vector[3];
    byte[] authorities;

    private static synchronized int newContextId() {
        return contextCounter++;
    }

    static final Object getTokens(String string, String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n != 0) {
            String[] stringArray2 = new String[n];
            short[] sArray = stringArray != null ? new short[n] : null;
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray2[n] = stringTokenizer.nextToken();
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length && stringArray2[n].compareTo(stringArray[n2]) != 0) {
                        ++n2;
                    }
                    if (n2 == stringArray.length) {
                        return null;
                    }
                    sArray[n] = (short)n2;
                    n2 = 0;
                    while (sArray[n2] != sArray[n]) {
                        ++n2;
                    }
                    if (n2 != n) {
                        return null;
                    }
                }
                ++n;
            }
            if (stringArray == null) {
                return stringArray2;
            }
            return sArray;
        }
        return null;
    }

    private static void mac(byte[] byArray, int n, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        byte[] byArray4 = new byte[64 + (n3 < 16 ? 16 : n3)];
        System.arraycopy(byArray, n, byArray4, 0, 16);
        System.arraycopy(SSLConnection.Pad1, 0, byArray4, 16, 48);
        System.arraycopy(byArray2, n2, byArray4, 64, n3);
        Util.util11(byArray4, 0, byArray4.length, byArray4, 64);
        System.arraycopy(SSLConnection.Pad2, 0, byArray4, 16, 48);
        Util.util11(byArray4, 0, 80, byArray3, n4);
    }

    private static byte[] secret(String string, byte[] byArray, int n, boolean bl) {
        int n2;
        if (string != null && (n2 = string.length()) > 0) {
            if (bl) {
                Util.random(byArray, n, 16);
            }
            byte[] byArray2 = new byte[16];
            byte[] byArray3 = new byte[n2];
            string.getBytes(0, n2, byArray3, 0);
            SSLContext.mac(byArray, n, byArray3, 0, n2, byArray2, 0);
            return byArray2;
        }
        return null;
    }

    static final String getCipherSuite(short s) {
        int n = 0;
        while (n < csEnabled.length) {
            if (s == csEnabled[n]) {
                return csName[n];
            }
            ++n;
        }
        return "<UNKNOWN CIPHER SUITE>";
    }

    static final String getCompressionMethod(byte by) {
        int n = 0;
        while (n < cmEnabled.length) {
            if (by == cmEnabled[n]) {
                return cmName[n];
            }
            ++n;
        }
        return "<UNKNOWN COMPRESSION METHOD>";
    }

    final synchronized Object getCert(int n, byte[] byArray, int n2, int n3) throws SSLException {
        int n4;
        Vector vector = this.ring[2];
        int n5 = vector != null ? vector.size() : 0;
        if (n5 == 0) {
            return null;
        }
        boolean bl = false;
        if (byArray == null) {
            bl = (n & 0x1000) != 0 && (n & 0xF00) == 256;
            n >>>= 16;
        }
        Object var16_8 = null;
        while ((n4 = n & 0x7F) != 0) {
            int n6 = 0;
            do {
                Object e = vector.elementAt(n6);
                SSLCert sSLCert = ((SSLCert[])((Object[])e)[0])[0];
                if (byArray != null) {
                    int n7;
                    int n8 = 0;
                    while ((n7 = (int)Util.msbf(byArray, n2 + n8, 2)) >= 3 && n3 - (n8 += 2) >= n7) {
                        if (n7 == sSLCert.issL) {
                            boolean bl2;
                            block12: {
                                byte[] byArray2 = sSLCert.x509;
                                int n9 = sSLCert.iss;
                                int n10 = n2 + n8;
                                int n11 = n7;
                                while (--n11 >= 0) {
                                    if (byArray2[n9++] == byArray[n10++]) continue;
                                    bl2 = false;
                                    break block12;
                                }
                                bl2 = true;
                            }
                            if (bl2) {
                                n8 = 0;
                                break;
                            }
                        }
                        if ((n8 += n7) + 5 < n3) continue;
                    }
                    if (n8 == n3) continue;
                    if (n8 != 0) {
                        throw new SSLException();
                    }
                }
                int n12 = sSLCert.sigAlg;
                int n13 = sSLCert.alg;
                if (n13 != 1 || n4 != 1 || n12 > 5) continue;
                if (bl ^ sSLCert.keyL > 64) {
                    return e;
                }
                if (var16_8 != null) continue;
                var16_8 = e;
            } while (++n6 < n5);
            if (var16_8 != null) {
                return var16_8;
            }
            n >>>= 8;
        }
        this.handleNoSiteCertificate();
        return null;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    final synchronized byte[] getAuth(int n) {
        if (this.authorities == null) {
            int n2;
            int n3;
            int n4;
            Vector vector;
            int n5 = 5;
            byte[] byArray = new byte[256];
            int n6 = 0;
            while (n6 < 2 && (vector = this.ring[n6]) != null && (n4 = vector.size()) != 0) {
                int n7 = 0;
                while (n7 < n4) {
                    SSLCert sSLCert = (SSLCert)vector.elementAt(n7);
                    int n8 = n6 == 0 ? sSLCert.sub : sSLCert.iss;
                    int n9 = n6 == 0 ? sSLCert.subL : sSLCert.issL;
                    int n10 = 5;
                    boolean bl = true;
                    while (true) {
                        boolean bl2;
                        block11: {
                            int n11;
                            if (!bl || (bl = false) || !true) {
                                n10 += 2 + n11;
                            }
                            if (n10 >= n5) break;
                            n11 = (int)Util.msbf(byArray, n10, 2);
                            if (n11 != n9) continue;
                            n3 = n10 + 2;
                            byte[] byArray2 = sSLCert.x509;
                            n2 = n8;
                            int n12 = n9;
                            while (--n12 >= 0) {
                                if (byArray[n3++] == byArray2[n2++]) continue;
                                bl2 = false;
                                break block11;
                            }
                            bl2 = true;
                        }
                        if (bl2) break;
                    }
                    if (n10 == n5) {
                        if (byArray.length - n5 < n9 + 2) {
                            byte[] byArray3 = new byte[n5 + 256 + 2 + n9];
                            System.arraycopy(byArray, 0, byArray3, 0, n5);
                            byArray = byArray3;
                        }
                        n3 = n5;
                        int n13 = 2;
                        do {
                            byArray[n3++] = (byte)(n9 >>> --n13 * 8);
                        } while (n13 > 0);
                        System.arraycopy(sSLCert.x509, n8, byArray, n5 += 2, n9);
                        n5 += n9;
                    }
                    ++n7;
                }
                ++n6;
            }
            if (n5 != 2) {
                byArray[0] = 2;
                byArray[1] = 1;
                byArray[2] = 2;
                n3 = n5 - 5;
                int n14 = 3;
                n2 = 2;
                do {
                    byArray[n14++] = (byte)(n3 >>> --n2 * 8);
                } while (n2 > 0);
                this.authorities = byArray;
            }
        }
        return this.authorities;
    }

    final synchronized byte verify(SSLCert[] sSLCertArray) throws SSLException {
        int n = sSLCertArray.length;
        int n2 = 0;
        do {
            int n3;
            int n4;
            Vector vector;
            int n5;
            int n6;
            if ((n6 = sSLCertArray[n2].verify(null)) != 0) {
                throw new SSLException(3, n6, sSLCertArray[n2].x509, sSLCertArray[n2].ser, sSLCertArray[n2].serL);
            }
            if (n2 > 0 && (n6 = sSLCertArray[n2 - 1].verify(sSLCertArray[n2])) != 0) {
                switch (n6) {
                    case 1021: 
                    case 1022: 
                    case 1027: {
                        throw new SSLException(3, n6, sSLCertArray[n2].x509, sSLCertArray[n2].ser, sSLCertArray[n2].serL);
                    }
                    case 1013: 
                    case 1024: {
                        throw new SSLException(4, n6, sSLCertArray[n2 - 1].x509, sSLCertArray[n2 - 1].ser, sSLCertArray[n2 - 1].serL, sSLCertArray[n2].x509, sSLCertArray[n2].ser, sSLCertArray[n2].serL);
                    }
                }
                throw new SSLException(3, n6, sSLCertArray[n2 - 1].x509, sSLCertArray[n2 - 1].ser, sSLCertArray[n2 - 1].serL);
            }
            int n7 = n5 = n2 == 0 ? 1 : 0;
            do {
                if ((vector = this.ring[n5]) == null || (n4 = vector.size()) == 0) continue;
                n3 = 0;
                do {
                    if (!sSLCertArray[n2].equals((SSLCert)vector.elementAt(n3))) continue;
                    if (this.confirmCertificateChain(sSLCertArray)) {
                        return 0;
                    }
                    throw new SSLException(4, 1002);
                } while (++n3 < n4);
            } while (--n5 >= 0);
            if (n2 != n - 1) continue;
            vector = this.ring[0];
            n4 = vector != null ? vector.size() : 0;
            n3 = 0;
            while (n3 < n4) {
                SSLCert sSLCert = (SSLCert)vector.elementAt(n3);
                if (sSLCert.verify(null) == 0 && sSLCertArray[n2].verify((SSLCert)vector.elementAt(n3)) == 0) {
                    if (this.confirmCertificateChain(sSLCertArray)) {
                        return 0;
                    }
                    throw new SSLException(4, 1002);
                }
                ++n3;
            }
            if (this.handleCertificateChain(sSLCertArray)) {
                return 0;
            }
            throw new SSLException(4, 1017, sSLCertArray[0].x509, sSLCertArray[0].ser, sSLCertArray[0].serL);
        } while (++n2 < n);
        throw new SSLException(4, 1017, sSLCertArray[0].x509, sSLCertArray[0].ser, sSLCertArray[0].serL);
    }

    protected synchronized void handleConnection(byte[] byArray) {
    }

    protected synchronized boolean handleCertificateChain(SSLCert[] sSLCertArray) {
        return false;
    }

    protected synchronized boolean confirmCertificateChain(SSLCert[] sSLCertArray) {
        return true;
    }

    protected synchronized void handleNoSiteCertificate() {
    }

    protected synchronized boolean handleNoPeerCertificate() {
        return false;
    }

    public SSLContext() {
        this.timeout[0] = 0;
        this.timeout[1] = 3600000;
        this.timeout[2] = 120000;
        this.context_id = SSLContext.newContextId();
    }

    public synchronized String[] getEnabledCipherSuites() {
        String[] stringArray = new String[this.cs_list.length];
        int n = 0;
        while (n < this.cs_list.length) {
            stringArray[n] = SSLContext.getCipherSuite(this.cs_list[n]);
            ++n;
        }
        return stringArray;
    }

    public synchronized String[] getEnabledCompressionMethods() {
        String[] stringArray = new String[this.cm_list.length];
        int n = 0;
        while (n < this.cm_list.length) {
            stringArray[n] = SSLContext.getCompressionMethod(this.cm_list[n]);
            ++n;
        }
        return stringArray;
    }

    public synchronized void setEnabledCipherSuites(String string) throws SSLException {
        short[] sArray = (short[])SSLContext.getTokens(string, csName);
        if (sArray != null) {
            int n = 0;
            do {
                sArray[n] = csEnabled[sArray[n]];
            } while (++n < sArray.length);
            this.cs_list = sArray;
            return;
        }
        throw new SSLException(7, 1012, 1);
    }

    public synchronized void setEnabledCompressionMethods(String string) throws SSLException {
        short[] sArray = (short[])SSLContext.getTokens(string, cmName);
        if (sArray != null) {
            byte[] byArray = new byte[sArray.length];
            int n = 0;
            do {
                byArray[n] = cmEnabled[sArray[n]];
            } while (++n < sArray.length);
            this.cm_list = byArray;
            return;
        }
        throw new SSLException(7, 1012, 1);
    }

    public synchronized void setTimeout(int n, int n2) throws SSLException {
        if (n2 < timeoutLimit[n][0] || n2 > timeoutLimit[n][1]) {
            throw new SSLException(7, 1012, 2);
        }
        this.timeout[n] = n2 * 1000;
    }

    public int getTimeout(int n) {
        return this.timeout[n] / 1000;
    }

    public synchronized void setKeyRing(int n, Vector vector) {
        this.ring[n] = vector != null ? (Vector)vector.clone() : null;
        this.authorities = null;
    }

    public synchronized Vector getKeyRing(int n) {
        if (this.ring[n] != null) {
            return (Vector)this.ring[n].clone();
        }
        return null;
    }

    public synchronized boolean importKeyRings(byte[] byArray, int n, int n2, String string) throws SSLException {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            int n3;
            Object object;
            if (byArray[n] == -1) {
                boolean bl;
                block33: {
                    byArray2 = SSLContext.secret(string, byArray, n + 1, false);
                    if (byArray2 == null) {
                        return false;
                    }
                    byArray3 = Util.util13(byArray2, 0, 16);
                    object = new byte[16];
                    SSLContext.mac(byArray2, 0, byArray, n, n2 -= 16, object, 0);
                    int n4 = 0;
                    n3 = n + n2;
                    int n5 = 16;
                    while (--n5 >= 0) {
                        if (object[n4++] == byArray[n3++]) continue;
                        bl = false;
                        break block33;
                    }
                    bl = true;
                }
                if (!bl) {
                    throw new SSLException(7, 1012, 4);
                }
                n += 17;
                n2 -= 17;
            } else if (byArray2 != null) {
                throw new SSLException();
            }
            n2 += n;
            do {
                Object object2;
                int n6;
                int n7;
                int n8;
                if ((n8 = byArray[n++] & 0xFF) == 2) {
                    object = new Object[2];
                    SSLCert[] sSLCertArray = null;
                    n3 = 0;
                    while (n3 < 2) {
                        int n9 = byArray[n++];
                        byte[][] byArray4 = new byte[n9][];
                        n7 = 0;
                        while (n7 < n9) {
                            n6 = (int)Util.msbf(byArray, n, 2);
                            if (n6 != 0) {
                                byArray4[n7] = new byte[n6];
                                System.arraycopy(byArray, n + 2, byArray4[n7], 0, n6);
                                if (n3 == 1 && byArray3 != null) {
                                    Util.util14(byArray3, byArray4[n7], 0, n6, byArray4[n7], 0);
                                    byte[] byArray5 = byArray4[n7];
                                    byArray5[0] = (byte)(byArray5[0] ^ byArray4[n7][n6 - 1]);
                                }
                            }
                            n += n6 + 2;
                            ++n7;
                        }
                        if (n3 == 0) {
                            sSLCertArray = new SSLCert[n9];
                            n7 = 0;
                            while (n7 < n9) {
                                sSLCertArray[n7] = new SSLCert(byArray4[n7]);
                                ++n7;
                            }
                            object[0] = (byte)sSLCertArray;
                        } else {
                            if (byArray4[0] == null && sSLCertArray != null) {
                                byte[][] byArray6 = sSLCertArray[0].key();
                                n7 = 0;
                                do {
                                    byArray4[n7] = byArray6[n7];
                                } while (++n7 < (sSLCertArray[0].alg == 1 ? 1 : 3));
                            }
                            object[1] = (byte)byArray4;
                        }
                        ++n3;
                    }
                    object2 = object;
                } else if (n8 == 0 || n8 == 1) {
                    n6 = (int)Util.msbf(byArray, n, 2);
                    object = new byte[n6];
                    System.arraycopy(byArray, n += 2, object, 0, n6);
                    SSLCert sSLCert = new SSLCert((byte[])object);
                    n += n6;
                    object2 = sSLCert;
                } else if (n8 == 3 || n8 == 4) {
                    object = new Object[3];
                    n7 = 0;
                    while (n7 < 3) {
                        Long l;
                        n6 = (int)Util.msbf(byArray, n, 2);
                        n += 2;
                        if (n7 < 2) {
                            byte[] byArray7 = new byte[n6];
                            System.arraycopy(byArray, n, byArray7, 0, n6);
                            if (n7 == 1 && byArray3 != null) {
                                Util.util14(byArray3, byArray7, 0, n6, byArray7, 0);
                            }
                            object[n7] = (byte)byArray7;
                        } else if (n6 == 8 && (l = new Long(Util.msbf(byArray, n, 8))) > System.currentTimeMillis()) {
                            object[2] = (byte)l;
                        }
                        n += n6;
                        ++n7;
                    }
                    if (this.ring.length < 4 || object[2] == null) continue;
                    object2 = object;
                } else {
                    if (n8 == 255) {
                        return true;
                    }
                    break;
                }
                if (this.ring[n8] == null) {
                    this.ring[n8] = new Vector();
                }
                n7 = 0;
                while (n7 < (n6 = this.ring[n8].size())) {
                    object = this.ring[n8].elementAt(n7);
                    if (n8 != 2 ? n8 < 2 && ((SSLCert)object).equals((SSLCert)object2) : ((SSLCert[])((Object[])object)[0])[0].equals(((SSLCert[])((Object[])object2)[0])[0])) break;
                    ++n7;
                }
                if (n7 != n6) continue;
                this.ring[n8].addElement(object2);
            } while (n < n2);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {}
        throw new SSLException(7, 1012, 1);
    }

    public synchronized boolean importKeyRings(String string, String string2) throws SSLException {
        boolean bl;
        byte[] byArray = new byte[string.length() * 7 / 8];
        int n = 0;
        do {
            byArray[n] = Util.getBits(string, n * 8, 8);
        } while (++n < byArray.length);
        try {
            bl = this.importKeyRings(byArray, 0, n, string2);
        }
        catch (SSLException sSLException) {
            if (sSLException.getCategory() == 7 && sSLException.getError() == 1012) {
                if (sSLException.getInt1() == 4) {
                    sSLException.setInt1(2);
                } else {
                    sSLException.setInt1(1);
                }
            }
            throw sSLException;
        }
        return bl;
    }

    public synchronized byte[] exportKeyRings(String string) throws SSLException {
        int n = 81920;
        byte[] byArray = new byte[16];
        byte[] byArray2 = SSLContext.secret(string, byArray, 0, true);
        byte[] byArray3 = null;
        try {
            Object object;
            byte[] byArray4 = new byte[n];
            int n2 = 0;
            int n3 = 0;
            if (byArray2 != null) {
                byArray3 = Util.util13(byArray2, 0, 16);
                byArray4[n2] = -1;
                System.arraycopy(byArray, 0, byArray4, n2 + 1, 16);
                n2 += 17;
            }
            n *= 2;
            do {
                Vector vector;
                if ((vector = this.ring[n3]) == null || vector.size() <= 0) continue;
                int n4 = 0;
                do {
                    int n5;
                    int n6;
                    int n7;
                    byArray4[n2++] = (byte)n3;
                    if (n3 == 2) {
                        object = (SSLCert[])((Object[])vector.elementAt(n4))[0];
                        byArray4[n2++] = (byte)((byte[])object).length;
                        int n8 = 0;
                        do {
                            int n9 = n7 = object[n8].x509.length;
                            n6 = n2;
                            n5 = 2;
                            do {
                                byArray4[n6++] = (byte)(n9 >>> --n5 * 8);
                            } while (n5 > 0);
                            System.arraycopy(object[n8].x509, 0, byArray4, n2 + 2, n7);
                            n2 += 2 + n7;
                        } while (++n8 < ((byte[])object).length);
                        byte[][] byArray5 = (byte[][])((Object[])vector.elementAt(n4))[1];
                        byArray4[n2++] = (byte)byArray5.length;
                        n8 = 0;
                        do {
                            n7 = object[0].alg == 1 && (n8 == 0 || n8 == 2 || n8 == 1 && byArray5.length == 8) || object[0].alg != 1 && n8 != 3 ? 0 : byArray5[n8].length;
                            n6 = n2;
                            n5 = 2;
                            do {
                                byArray4[n6++] = (byte)(n7 >>> --n5 * 8);
                            } while (n5 > 0);
                            n2 += 2;
                            if (n7 == 0) continue;
                            System.arraycopy(byArray5[n8], 0, byArray4, n2, n7);
                            if (byArray3 != null) {
                                int n10 = n2;
                                byArray4[n10] = (byte)(byArray4[n10] ^ byArray4[n2 + n7 - 1]);
                                Util.util14(byArray3, byArray4, n2, n7, byArray4, n2);
                            }
                            n2 += n7;
                        } while (++n8 < byArray5.length);
                        continue;
                    }
                    if (n3 >= 2) continue;
                    object = (SSLCert)vector.elementAt(n4);
                    int n11 = n7 = object.x509.length;
                    n6 = n2;
                    n5 = 2;
                    do {
                        byArray4[n6++] = (byte)(n11 >>> --n5 * 8);
                    } while (n5 > 0);
                    System.arraycopy(object.x509, 0, byArray4, n2 + 2, n7);
                    n2 += 2 + n7;
                } while (++n4 < vector.size());
            } while (++n3 < this.ring.length);
            byArray4[n2++] = -1;
            if (byArray2 != null) {
                SSLContext.mac(byArray2, 0, byArray4, 0, n2, byArray4, n2);
                n2 += 16;
            }
            object = new byte[n2];
            System.arraycopy(byArray4, 0, object, 0, n2);
            return object;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SSLException(8, 1009, arrayIndexOutOfBoundsException);
        }
    }

    static {
        timeoutLimit = new int[][]{{0, 3600}, {0, 86400}, {0, 600}};
    }
}

