/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.HelpFrame;
import com.ibm.gsk.ikeyman.awt.PageLoader;
import com.sun.java.swing.JEditorPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.border.BevelBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.SoftBevelBorder;
import com.sun.java.swing.event.HyperlinkEvent;
import com.sun.java.swing.event.HyperlinkListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

class HtmlPanel
extends JPanel
implements HyperlinkListener {
    private JEditorPane html;
    private HelpFrame parent;

    public HtmlPanel(HelpFrame helpFrame, URL uRL) {
        this.parent = helpFrame;
        SoftBevelBorder softBevelBorder = new SoftBevelBorder(1);
        BevelBorder bevelBorder = new BevelBorder(0);
        this.setBorder((Border)bevelBorder);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        try {
            this.html = new JEditorPane(uRL);
            this.html.setEditable(false);
            this.html.addHyperlinkListener((HyperlinkListener)this);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setBorder((Border)softBevelBorder);
            JViewport jViewport = jScrollPane.getViewport();
            jViewport.add((Component)this.html);
            jViewport.setBackingStoreEnabled(true);
            ((Container)((Object)this)).add((Component)jScrollPane, "Center");
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......htmlPanel hPolicy=" + jScrollPane.getHorizontalScrollBarPolicy());
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL: " + malformedURLException);
            return;
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
        }
    }

    JEditorPane getEditorPane() {
        return this.html;
    }

    public void linkActivated(URL uRL, boolean bl) {
        Cursor cursor = this.html.getCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor2);
        SwingUtilities.invokeLater((Runnable)new PageLoader(this.parent, this.html, uRL, cursor, bl));
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......HelpFrame: link e=" + hyperlinkEvent + ", type=" + hyperlinkEvent.getEventType() + ", url=" + hyperlinkEvent.getURL());
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......HelpFrame: to activate url");
            }
            this.linkActivated(hyperlinkEvent.getURL(), false);
        }
    }
}

