/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.border.BevelBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.SoftBevelBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;

public class KeyDbFileDialog
extends JDialog
implements IkeymanConstants,
ActionListener,
ItemListener {
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton helpButton;
    private KMButton browseButton;
    private JLabel typeLabel;
    private JComboBox typeChoice;
    private int[] types;
    private JLabel fileNameLabel;
    private JTextField fileNameField;
    private JLabel dirNameLabel;
    private JTextField dirNameField;
    private String currWorkingDirName;
    private int mode;
    private String browserFileName;
    private String browserDirName;
    private String fileName;
    private String dirName;
    private int keyDbTypeSelected;
    private JPanel fileNamePanel;
    private JDialog diagInstance;

    public KeyDbFileDialog(Frame frame, String string) {
        this(frame, string, 0);
    }

    public KeyDbFileDialog(Frame frame, String string, int n) {
        super(frame, string, true);
        this.mode = n;
        this.diagInstance = this;
        this.populateFields();
        this.fileNamePanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.fileNamePanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this.typeLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this.typeChoice, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this.fileNameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this.fileNameField, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagLayout.setConstraints((Component)((Object)this.browseButton), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this.dirNameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this.dirNameField, gridBagConstraints);
        this.fileNamePanel.add((Component)this.typeLabel);
        this.fileNamePanel.add((Component)this.typeChoice);
        this.fileNamePanel.add((Component)this.fileNameLabel);
        this.fileNamePanel.add((Component)this.fileNameField);
        this.fileNamePanel.add((Component)((Object)this.browseButton));
        this.fileNamePanel.add((Component)this.dirNameLabel);
        this.fileNamePanel.add((Component)this.dirNameField);
        new SoftBevelBorder(1);
        KMHorizontalButtonPanel kMHorizontalButtonPanel = new KMHorizontalButtonPanel();
        kMHorizontalButtonPanel.add(this.okButton);
        kMHorizontalButtonPanel.add(this.cancelButton);
        kMHorizontalButtonPanel.add(this.helpButton);
        kMHorizontalButtonPanel.equalizeButtons();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.fileNamePanel, "Center");
        jPanel.add((Component)((Object)kMHorizontalButtonPanel), "South");
        BevelBorder bevelBorder = new BevelBorder(0);
        jPanel.setBorder((Border)bevelBorder);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        ((Window)((Object)this)).addWindowListener(new DiagAdapter());
        ((Window)((Object)this)).pack();
        ((Dialog)((Object)this)).setResizable(false);
        this.fileNameField.requestFocus();
    }

    protected void populateFields() {
        this.populateInputFields();
        this.populateButtons();
        this.setToolTips();
    }

    protected void populateInputFields() {
        this.typeLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_DBTYPE"));
        this.typeChoice = new JComboBox();
        this.types = KeyDatabase.getSupportedDatabaseTypes();
        int n = 0;
        while (n < this.types.length) {
            this.typeChoice.addItem((Object)KeyDbFileDialog.getKeyDbTypeNLSName(this.types[n]));
            ++n;
        }
        this.typeChoice.addItemListener((ItemListener)this);
        this.keyDbTypeSelected = this.types[0];
        int n2 = 30;
        String string = Locale.getDefault().getLanguage();
        if (string.equals("ja")) {
            n2 *= 2;
        }
        this.fileNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_FILENAME"));
        this.fileNameField = new JTextField(KeyDatabase.getDefaultKeyDbFileName(this.keyDbTypeSelected), n2);
        this.currWorkingDirName = KeyDatabase.getDefaultKeyDbFileLocation(this.keyDbTypeSelected);
        this.dirNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_LOCATION"));
        this.dirNameField = new JTextField(this.currWorkingDirName, n2);
        if (string.equals("ko") || string.equals("ja")) {
            this.fileNameField.setFont(Ikeyman.defaultMonospacedFont);
            this.dirNameField.setFont(Ikeyman.defaultMonospacedFont);
        }
    }

    protected void populateButtons() {
        this.browseButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_BROWSE"));
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.helpButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_HELP"));
        this.browseButton.setActionCommand("Browse");
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("Cancel");
        this.helpButton.setActionCommand("Help");
        this.browseButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        if (!Ikeyman.isHelpAvailable()) {
            this.helpButton.setEnabled(false);
        }
    }

    protected void setToolTips() {
        this.typeChoice.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_DBTYPE_CHOICE"));
        this.fileNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_DBFILE_NAME"));
        this.dirNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_FILE_LOCATION"));
    }

    public String getFileName() {
        return KMUtil.trimBlankSpace(this.fileName);
    }

    public String getDirName() {
        return KMUtil.trimBlankSpace(this.dirName);
    }

    public int[] getKeyDbTypes() {
        return this.types;
    }

    public void setKeyDbTypes(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            int n;
            int[] nArray2 = KeyDatabase.getSupportedDatabaseTypes();
            if (nArray.length > nArray2.length) {
                return;
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] < 0 || nArray[n2] == 0 || nArray[n2] > 10) {
                    return;
                }
                n = 0;
                int n3 = 0;
                while (n3 < nArray2.length) {
                    if (nArray[n2] == nArray2[n3]) {
                        n = 1;
                        break;
                    }
                    ++n3;
                }
                if (n == 0) {
                    return;
                }
                ++n2;
            }
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("ComboBox: removeAllItems...");
            }
            this.types = new int[nArray.length];
            this.typeChoice.removeAllItems();
            n = 0;
            while (n < nArray.length) {
                this.types[n] = nArray[n];
                if (Ikeyman.printDebugMsg) {
                    Ikeyman.debugMsg("ComboBox: addItem(" + nArray[n] + ")");
                }
                this.typeChoice.addItem((Object)KeyDbFileDialog.getKeyDbTypeNLSName(nArray[n]));
                ++n;
            }
            this.typeChoice.setSelectedIndex(0);
        }
    }

    public static String getKeyDbTypeNLSName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_CMS");
                break;
            }
            case 2: {
                string = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_WEBDB");
                break;
            }
            case 3: {
                string = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_SSLIGHT");
                break;
            }
            case 4: {
                string = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_SSLINK");
                break;
            }
            case 5: {
                string = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_CDSA");
                break;
            }
            case 6: {
                string = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_BERKELEY");
                break;
            }
            case 7: {
                string = Ikeyman.getNLSResString("GUI_LABEL_KEY_FILE_TYPE_PFX");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public int getSelectedKeyDbType() {
        this.keyDbTypeSelected = this.types[this.typeChoice.getSelectedIndex()];
        return this.keyDbTypeSelected;
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent var1_1) {
        block17: {
            block13: {
                block14: {
                    block12: {
                        block15: {
                            block16: {
                                block11: {
                                    var1_1.getSource();
                                    var2_2 = var1_1.getActionCommand();
                                    if (!var2_2.equals("OK")) break block14;
                                    this.fileName = this.fileNameField.getText();
                                    this.dirName = this.dirNameField.getText();
                                    if (this.fileName.equals("") || this.fileName.indexOf(42) >= 0 || KMUtil.trimBlankSpace(this.fileName) == null) break block15;
                                    if (this.dirName == null) {
                                        this.dirName = this.currWorkingDirName;
                                    }
                                    if (!this.dirName.endsWith(File.separator)) {
                                        this.dirName = String.valueOf(this.dirName) + File.separator;
                                    }
                                    if (Ikeyman.isOverwriteConfirmedFileDialog() && this.fileName.equals(this.browserFileName) && this.dirName.equals(this.browserDirName) || this.mode != 1 || !(var3_3 = new File(this.dirName, this.fileName)).exists()) break block16;
                                    var4_6 = this;
                                    if (!(var4_6 instanceof Frame)) ** GOTO lbl20
                                    v0 = (Frame)var4_6;
                                    break block11;
lbl-1000:
                                    // 1 sources

                                    {
                                        if (!(var4_6 instanceof Frame)) continue;
                                        v0 = (Frame)var4_6;
                                        break block11;
lbl20:
                                        // 2 sources

                                        ** while ((var4_6 = var4_6.getParent()) != null)
                                    }
lbl21:
                                    // 1 sources

                                    v0 = null;
                                }
                                var4_7 = KMFrame.showConfirmDialog(v0, Ikeyman.getNLSResString("GUI_DIALOG_QST_OVERWRITE_KDB_FILE"), 0);
                                if (var4_7 != 0) {
                                    this.fileNameField.requestFocus();
                                    return;
                                }
                            }
                            this.setVisible(false);
                            return;
                        }
                        var3_4 = this;
                        if (!(var3_4 instanceof Frame)) ** GOTO lbl38
                        v1 = (Frame)var3_4;
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            if (!(var3_4 instanceof Frame)) continue;
                            v1 = (Frame)var3_4;
                            break block12;
lbl38:
                            // 2 sources

                            ** while ((var3_4 = var3_4.getParent()) != null)
                        }
lbl39:
                        // 1 sources

                        v1 = null;
                    }
                    KMFrame.errorHandler(v1, KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
                    this.fileNameField.requestFocus();
                    return;
                }
                if (var2_2.equals("Cancel")) {
                    if (Ikeyman.printDebugMsg) {
                        Ikeyman.debugMsg("Cancel button is hit\n");
                    }
                    this.fileName = null;
                    this.dirName = null;
                    this.setVisible(false);
                    return;
                }
                if (!var2_2.equals("Browse")) break block17;
                if (Ikeyman.printDebugMsg) {
                    Ikeyman.debugMsg("Browse button is hit\n");
                }
                if (!((var3_5 = this) instanceof Frame)) ** GOTO lbl61
                v2 = (Frame)var3_5;
                break block13;
lbl-1000:
                // 1 sources

                {
                    if (!(var3_5 instanceof Frame)) continue;
                    v2 = (Frame)var3_5;
                    break block13;
lbl61:
                    // 2 sources

                    ** while ((var3_5 = var3_5.getParent()) != null)
                }
lbl62:
                // 1 sources

                v2 = null;
            }
            var3_5 = new FileDialog(v2, Ikeyman.getNLSResString("GUI_DIALOG_TITLE_KEYDBFILE"), this.mode);
            var3_5.setFile("*" + KeyDatabase.getKeyDbFileExtensionWithType(this.getSelectedKeyDbType()));
            var3_5.setDirectory(this.dirNameField.getText());
            var4_8 = var3_5.getSize();
            var3_5.setLocation((Ikeyman.screenSize.width - var4_8.width) / 2, (Ikeyman.screenSize.height - var4_8.height) / 2);
            var3_5.setVisible(true);
            this.browserFileName = var3_5.getFile();
            if (this.browserFileName != null) {
                this.fileNameField.setText(this.browserFileName);
                this.browserDirName = var3_5.getDirectory();
                this.dirNameField.setText(this.browserDirName);
                this.fileName = this.browserFileName;
                this.dirName = this.browserDirName;
            }
            var3_5.dispose();
            return;
        }
        if (var2_2.equals("Help")) {
            Ikeyman.showHelpWindow((Window)this, "packages.html");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        Object object2 = itemEvent.getSource();
        int n = this.typeChoice.getSelectedIndex();
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("getItem=" + object + ", getSource=" + object2 + itemEvent.getStateChange() + ", selectedIndex=" + n);
        }
        if (n < 0) {
            n = 0;
        }
        this.keyDbTypeSelected = this.types[n];
        this.fileNameField.setText(KeyDatabase.getDefaultKeyDbFileName(this.keyDbTypeSelected));
        this.currWorkingDirName = KeyDatabase.getDefaultKeyDbFileLocation(this.keyDbTypeSelected);
        this.dirNameField.setText(this.currWorkingDirName);
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.okButton.requestFocus();
    }

    static /* synthetic */ String access$0(KeyDbFileDialog keyDbFileDialog) {
        return keyDbFileDialog.fileName;
    }

    static /* synthetic */ void access$1(KeyDbFileDialog keyDbFileDialog, String string) {
        keyDbFileDialog.fileName = string;
    }

    static /* synthetic */ String access$2(KeyDbFileDialog keyDbFileDialog) {
        return keyDbFileDialog.dirName;
    }

    static /* synthetic */ void access$3(KeyDbFileDialog keyDbFileDialog, String string) {
        keyDbFileDialog.dirName = string;
    }

    class DiagAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            KeyDbFileDialog keyDbFileDialog = KeyDbFileDialog.this;
            keyDbFileDialog.fileName = null;
            keyDbFileDialog = KeyDbFileDialog.this;
            keyDbFileDialog.dirName = null;
            ((Component)((Object)KeyDbFileDialog.this)).setVisible(false);
        }

        DiagAdapter() {
            KeyDbFileDialog.this = KeyDbFileDialog.this;
        }
    }
}

