/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonGroup;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JRadioButton;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.border.BevelBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.SoftBevelBorder;
import com.sun.java.swing.border.TitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;

public class KeyFileDialog
extends JDialog
implements IkeymanConstants,
ActionListener,
ItemListener {
    public static final int TRANSFER_KEY = 1;
    public static final int TRANSFER_KEY_EXPORT = 2;
    public static final int TRANSFER_KEY_IMPORT = 4;
    public static final int EXTRACT_DATA = 8;
    public static String[] DEFAULT_EXPORT_DATA_TYPES = new String[]{Ikeyman.getNLSResString("GUI_LABEL_DATA_TYPE_BASE64"), Ikeyman.getNLSResString("GUI_LABEL_DATA_TYPE_DER"), Ikeyman.getNLSResString("GUI_LABEL_DATA_TYPE_SSLIGHT")};
    private int taskType = 1;
    private boolean isExportAllowed = true;
    private int transferType = 4;
    private JRadioButton exportRButton;
    private JRadioButton importRButton;
    private ButtonGroup buttonGroup;
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton helpButton;
    private KMButton browseButton;
    private JLabel typeLabel;
    private JComboBox typeChoice;
    private JLabel fileNameLabel;
    private JTextField fileNameField;
    private JLabel dirNameLabel;
    private JTextField dirNameField;
    private KeyDatabase keyDb;
    private String currWorkingDirName;
    private int mode;
    private String browserFileName;
    private String browserDirName;
    private JDialog diagInstance;
    private String fileName;
    private String dirName;
    private int fileTypeSelected;
    private JPanel fileNamePanel;

    public KeyFileDialog(Frame frame, String string) {
        this(frame, string, 0);
    }

    public KeyFileDialog(Frame frame, String string, int n) {
        this(frame, string, null, 1, n);
    }

    public KeyFileDialog(Frame frame, String string, KeyDatabase keyDatabase, boolean bl) {
        this(frame, string, keyDatabase, Ikeyman.getNLSResString("GUI_LABEL_FILENAME"), 1, bl, Ikeyman.getNLSResString("GUI_LABEL_KEY_FILE_TYPE"), KeyFileDialog.getSupportedExportTargetsLabels(), bl ? 1 : 0);
    }

    public KeyFileDialog(Frame frame, String string, KeyDatabase keyDatabase, int n, int n2) {
        this(frame, string, keyDatabase, Ikeyman.getNLSResString("GUI_LABEL_FILENAME"), n, false, n == 1 ? Ikeyman.getNLSResString("GUI_LABEL_KEY_FILE_TYPE") : (n == 8 ? Ikeyman.getNLSResString("GUI_LABEL_TARGET_DATA_TYPE") : null), (String[])(n == 1 ? KeyFileDialog.getSupportedExportTargetsLabels() : (n == 8 ? DEFAULT_EXPORT_DATA_TYPES : null)), n2);
    }

    public KeyFileDialog(Frame frame, String string, KeyDatabase keyDatabase, String string2, int n, int n2) {
        this(frame, string, keyDatabase, string2, n, false, n == 1 ? Ikeyman.getNLSResString("GUI_LABEL_KEY_FILE_TYPE") : (n == 8 ? Ikeyman.getNLSResString("GUI_LABEL_TARGET_DATA_TYPE") : null), (String[])(n == 1 ? KeyFileDialog.getSupportedExportTargetsLabels() : (n == 8 ? DEFAULT_EXPORT_DATA_TYPES : null)), n2);
    }

    public KeyFileDialog(Frame frame, String string, KeyDatabase keyDatabase, String string2, int n, boolean bl, String string3, String[] stringArray, int n2) {
        super(frame, string, true);
        TitledBorder titledBorder;
        JPanel jPanel;
        this.keyDb = keyDatabase;
        this.mode = n2;
        this.taskType = n;
        this.isExportAllowed = bl;
        this.diagInstance = this;
        this.populateFields(string2, string3, stringArray);
        this.fileNamePanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.fileNamePanel.setLayout(gridBagLayout);
        if (n == 1 && bl) {
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add((Component)this.exportRButton);
            jPanel.add((Component)this.importRButton);
            titledBorder = new TitledBorder(Ikeyman.getNLSResString("GUI_LABEL_CHOOSE_ACTION_TYPE"));
            jPanel.setBorder((Border)titledBorder);
            ((TitledBorder)jPanel.getBorder()).setTitleJustification(1);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints((Component)jPanel, gridBagConstraints);
            this.fileNamePanel.add((Component)jPanel);
            this.transferType = 2;
            this.exportRButton.setSelected(true);
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this.typeLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this.typeChoice, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this.fileNameLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints((Component)this.fileNameField, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagLayout.setConstraints((Component)((Object)this.browseButton), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this.dirNameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this.dirNameField, gridBagConstraints);
        this.fileNamePanel.add((Component)this.typeLabel);
        this.fileNamePanel.add((Component)this.typeChoice);
        this.fileNamePanel.add((Component)this.fileNameLabel);
        this.fileNamePanel.add((Component)this.fileNameField);
        this.fileNamePanel.add((Component)((Object)this.browseButton));
        this.fileNamePanel.add((Component)this.dirNameLabel);
        this.fileNamePanel.add((Component)this.dirNameField);
        new SoftBevelBorder(1);
        jPanel = new KMHorizontalButtonPanel();
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        jPanel.add(this.helpButton);
        jPanel.equalizeButtons();
        titledBorder = new JPanel();
        titledBorder.setLayout(new BorderLayout());
        titledBorder.add((Component)this.fileNamePanel, "Center");
        titledBorder.add((Component)jPanel, "South");
        BevelBorder bevelBorder = new BevelBorder(0);
        titledBorder.setBorder((Border)bevelBorder);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)titledBorder, "Center");
        ((Window)((Object)this)).addWindowListener(new DiagAdapter());
        ((Window)((Object)this)).pack();
        ((Dialog)((Object)this)).setResizable(false);
        if (n == 1 && bl) {
            this.exportRButton.requestFocus();
            return;
        }
        this.fileNameField.requestFocus();
    }

    public static String getTypeLabelText(int n) {
        if (n == 1) {
            return Ikeyman.getNLSResString("GUI_LABEL_KEY_FILE_TYPE");
        }
        if (n == 8) {
            return Ikeyman.getNLSResString("GUI_LABEL_TARGET_DATA_TYPE");
        }
        return null;
    }

    public static String[] getTypeChoiceLabels(int n) {
        if (n == 1) {
            return KeyFileDialog.getSupportedExportTargetsLabels();
        }
        if (n == 8) {
            return DEFAULT_EXPORT_DATA_TYPES;
        }
        return null;
    }

    public static String[] getSupportedExportTargetsLabels() {
        int n;
        String[] stringArray = null;
        int[] nArray = KeyDatabase.getSupportedDatabaseTypes();
        int n2 = 1;
        if (KMSystem.getVersion() < 18) {
            n = 0;
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] == 3) {
                    n = 1;
                    break;
                }
                ++n3;
            }
            n2 = nArray.length + (n != 0 ? 0 : 1);
        } else {
            n2 = nArray.length + 1;
        }
        stringArray = new String[n2];
        stringArray[0] = Ikeyman.getNLSResString("GUI_LABEL_KEY_FILE_TYPE_PFX");
        n = 0;
        while (n < n2 - 1) {
            if (nArray[n] == 0) break;
            if (KMSystem.getVersion() >= 18 || nArray[n] != 3) {
                stringArray[n + 1] = Ikeyman.getDatabaseNLSTypeName(nArray[n]);
            }
            ++n;
        }
        return stringArray;
    }

    protected void populateFields(String string, String string2, String[] stringArray) {
        this.populateTypeChoices(string2, stringArray);
        this.populateNameFields(string);
        this.populateButtons();
        this.setToolTips();
    }

    protected void populateTypeChoices(String string, String[] stringArray) {
        if (this.taskType != 8 && this.isExportAllowed) {
            this.buttonGroup = new ButtonGroup();
            this.exportRButton = new JRadioButton(Ikeyman.getNLSResString("GUI_BUTTON_LABEL_EXPORT_KEY"));
            this.importRButton = new JRadioButton(Ikeyman.getNLSResString("GUI_BUTTON_LABEL_IMPORT_KEY"));
            this.exportRButton.setActionCommand("Export");
            this.importRButton.setActionCommand("Import");
            this.exportRButton.addActionListener((ActionListener)this);
            this.importRButton.addActionListener((ActionListener)this);
            this.buttonGroup.add((AbstractButton)this.exportRButton);
            this.buttonGroup.add((AbstractButton)this.importRButton);
        }
        this.typeLabel = new JLabel(string);
        this.typeChoice = new JComboBox();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.typeChoice.addItem((Object)stringArray[n2]);
            ++n2;
        }
        this.typeChoice.addItemListener((ItemListener)this);
        if (this.taskType == 1) {
            this.fileTypeSelected = 7;
            return;
        }
        if (this.taskType == 8) {
            this.fileTypeSelected = 8;
            return;
        }
        this.fileTypeSelected = 0;
    }

    protected void populateNameFields(String string) {
        int n = 45;
        if (Ikeyman.screenSize.width < 800) {
            n = 25;
        } else if (Ikeyman.screenSize.width < 1024) {
            n = 35;
        }
        String string2 = Locale.getDefault().getLanguage();
        if (string2.equals("ja")) {
            n *= 2;
        }
        this.fileNameLabel = new JLabel(string);
        this.fileNameField = new JTextField("*" + KeyDatabase.DEFAULT_PKCS12_FILE_NAME_EXT, n);
        int n2 = 0;
        if (this.keyDb != null) {
            n2 = this.keyDb.getType();
        }
        this.currWorkingDirName = this.taskType == 1 ? KeyDatabase.DEFAULT_PKCS12_FILE_LOCATION : KeyDatabase.getDefaultKeyDbFileLocation(n2);
        this.dirNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_LOCATION"));
        this.dirNameField = new JTextField(this.currWorkingDirName, n);
        if (string2.equals("ko") || string2.equals("ja")) {
            this.fileNameField.setFont(Ikeyman.defaultMonospacedFont);
            this.dirNameField.setFont(Ikeyman.defaultMonospacedFont);
        }
    }

    protected void populateButtons() {
        this.browseButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_BROWSE"));
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.helpButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_HELP"));
        this.browseButton.setActionCommand("Browse");
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("Cancel");
        this.helpButton.setActionCommand("Help");
        this.browseButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        if (!Ikeyman.isHelpAvailable()) {
            this.helpButton.setEnabled(false);
        }
    }

    protected void setToolTips() {
        if (this.taskType == 1) {
            this.typeChoice.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_KEY_FILE_TYPE"));
        } else if (this.taskType == 8) {
            this.typeChoice.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_DATA_TYPE"));
        }
        this.fileNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_FILE_NAME"));
        this.dirNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_FILE_LOCATION"));
    }

    public int getTransferType() {
        return this.transferType;
    }

    public String getFileName() {
        return KMUtil.trimBlankSpace(this.fileName);
    }

    public String getDirName() {
        return KMUtil.trimBlankSpace(this.dirName);
    }

    public void setFileName(String string) {
        this.fileNameField.setText(string);
    }

    public void setDirName(String string) {
        this.dirNameField.setText(string);
    }

    public int getFileTypeSelected() {
        int n = this.typeChoice.getSelectedIndex();
        if (this.taskType == 8) {
            this.fileTypeSelected = n == 0 ? 8 : (n == 1 ? 9 : (n == 2 ? 10 : 8));
        } else if (this.taskType == 1) {
            switch (n) {
                case 0: {
                    this.fileTypeSelected = 7;
                    break;
                }
                case 1: {
                    this.fileTypeSelected = 1;
                    break;
                }
                case 2: {
                    this.fileTypeSelected = 2;
                    break;
                }
                case 3: {
                    this.fileTypeSelected = 3;
                    break;
                }
                case 4: {
                    this.fileTypeSelected = 4;
                    break;
                }
                case 5: {
                    this.fileTypeSelected = 5;
                    break;
                }
                case 6: {
                    this.fileTypeSelected = 6;
                    break;
                }
                default: {
                    this.fileTypeSelected = 0;
                    break;
                }
            }
        } else {
            this.fileTypeSelected = 0;
        }
        return this.fileTypeSelected;
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent var1_1) {
        block24: {
            block18: {
                block19: {
                    block23: {
                        block17: {
                            block20: {
                                block21: {
                                    block16: {
                                        block22: {
                                            var1_1.getSource();
                                            var2_2 = var1_1.getActionCommand();
                                            if (!var2_2.equals("OK")) break block19;
                                            this.fileName = this.fileNameField.getText();
                                            this.dirName = this.dirNameField.getText();
                                            if (this.fileName.equals("") || this.fileName.indexOf(42) >= 0 || KMUtil.trimBlankSpace(this.fileName) == null) break block20;
                                            if (this.dirName == null) {
                                                this.dirName = this.currWorkingDirName;
                                            }
                                            if (!this.dirName.endsWith(File.separator)) {
                                                this.dirName = String.valueOf(this.dirName) + File.separator;
                                            }
                                            if (Ikeyman.isOverwriteConfirmedFileDialog() && this.fileName.equals(this.browserFileName) && this.dirName.equals(this.browserDirName) || this.mode != 1 || !(var3_3 = new File(this.dirName, this.fileName)).exists()) break block21;
                                            if (this.getFileTypeSelected() != 10) break block22;
                                            var4_6 = new String[]{Ikeyman.getNLSResString("GUI_BUTTON_LABEL_ADDTO"), Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CREATE")};
                                            var5_10 = Ikeyman.getNLSResString("GUI_DIALOG_QST_REPLACE_OR_ADD");
                                            var7_12 = MessageFormat.format(var5_10, var6_11 = new Object[]{this.fileName});
                                            var8_13 = JOptionPane.showOptionDialog((Component)this, (Object)var7_12, null, (int)-1, (int)3, null, (Object[])var4_6, (Object)var4_6[0]);
                                            if (var8_13 == 1) {
                                                var3_3.delete();
                                            }
                                            break block21;
                                        }
                                        var4_7 = this;
                                        if (!(var4_7 instanceof Frame)) ** GOTO lbl30
                                        v0 = (Frame)var4_7;
                                        break block16;
lbl-1000:
                                        // 1 sources

                                        {
                                            if (!(var4_7 instanceof Frame)) continue;
                                            v0 = (Frame)var4_7;
                                            break block16;
lbl30:
                                            // 2 sources

                                            ** while ((var4_7 = var4_7.getParent()) != null)
                                        }
lbl31:
                                        // 1 sources

                                        v0 = null;
                                    }
                                    var4_8 = KMFrame.showConfirmDialog(v0, Ikeyman.getNLSResString("GUI_DIALOG_QST_OVERWRITE_KDB_FILE"), 1);
                                    if (var4_8 != 0) {
                                        this.fileNameField.requestFocus();
                                        return;
                                    }
                                }
                                if (Ikeyman.printDebugMsg) {
                                    Ikeyman.debugMsg("DEBUG......KeyFileDialog to hide");
                                }
                                this.setVisible(false);
                                if (Ikeyman.printDebugMsg) {
                                    Ikeyman.debugMsg("DEBUG......KeyFileDialog after hide");
                                    return;
                                }
                                break block23;
                            }
                            var3_4 = this;
                            if (!(var3_4 instanceof Frame)) ** GOTO lbl53
                            v1 = (Frame)var3_4;
                            break block17;
lbl-1000:
                            // 1 sources

                            {
                                if (!(var3_4 instanceof Frame)) continue;
                                v1 = (Frame)var3_4;
                                break block17;
lbl53:
                                // 2 sources

                                ** while ((var3_4 = var3_4.getParent()) != null)
                            }
lbl54:
                            // 1 sources

                            v1 = null;
                        }
                        KMFrame.errorHandler(v1, KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
                        this.fileNameField.requestFocus();
                    }
                    return;
                }
                if (var2_2.equals("Cancel")) {
                    if (Ikeyman.printDebugMsg) {
                        Ikeyman.debugMsg("Cancel button is hit\n");
                    }
                    this.fileName = null;
                    this.dirName = null;
                    this.setVisible(false);
                    return;
                }
                if (!var2_2.equals("Browse")) break block24;
                if (Ikeyman.printDebugMsg) {
                    Ikeyman.debugMsg("Browse button is hit\n");
                }
                if (!((var3_5 = this) instanceof Frame)) ** GOTO lbl77
                v2 = (Frame)var3_5;
                break block18;
lbl-1000:
                // 1 sources

                {
                    if (!(var3_5 instanceof Frame)) continue;
                    v2 = (Frame)var3_5;
                    break block18;
lbl77:
                    // 2 sources

                    ** while ((var3_5 = var3_5.getParent()) != null)
                }
lbl78:
                // 1 sources

                v2 = null;
            }
            var3_5 = new FileDialog(v2, Ikeyman.getNLSResString("GUI_DIALOG_TITLE_FILE_NAME"), this.mode);
            var3_5.setFile(this.fileNameField.getText());
            var3_5.setDirectory(this.dirNameField.getText());
            var4_9 = var3_5.getSize();
            var3_5.setLocation((Ikeyman.screenSize.width - var4_9.width) / 2, (Ikeyman.screenSize.height - var4_9.height) / 2);
            var3_5.setVisible(true);
            this.browserFileName = var3_5.getFile();
            if (this.browserFileName != null) {
                this.fileNameField.setText(this.browserFileName);
                this.browserDirName = var3_5.getDirectory();
                this.dirNameField.setText(this.browserDirName);
                this.fileName = this.browserFileName;
                this.dirName = this.browserDirName;
            }
            var3_5.dispose();
            return;
        }
        if (var2_2.equals("Export")) {
            this.transferType = 2;
            this.mode = 1;
            return;
        }
        if (var2_2.equals("Import")) {
            this.transferType = 4;
            this.mode = 0;
            return;
        }
        if (var2_2.equals("Help")) {
            Ikeyman.showHelpWindow((Window)this, "packages.html");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        Object object2 = itemEvent.getSource();
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("getItem=" + object + ", getSource=" + object2 + itemEvent.getStateChange());
        }
        int n = this.typeChoice.getSelectedIndex();
        if (this.taskType == 8) {
            this.dirNameField.setText(this.currWorkingDirName);
            if (n == 0) {
                this.fileNameField.setText(KeyDatabase.DEFAULT_CERTIFICATE_NAME_ARM);
                return;
            }
            if (n == 1) {
                this.fileNameField.setText(KeyDatabase.DEFAULT_CERTIFICATE_NAME_DER);
                return;
            }
            if (n == 2) {
                this.fileNameField.setText(KeyDatabase.DEFAULT_SSLIGHT_EXTRACT_FILE_NAME);
                this.dirNameField.setText(KeyDatabase.DEFAULT_SSLIGHT_EXTRACT_FILE_LOCATION);
                return;
            }
            this.fileNameField.setText(KeyDatabase.DEFAULT_CERTIFICATE_NAME_ARM);
            return;
        }
        if (n > 0) {
            this.dirNameField.setText(KeyDatabase.getDefaultKeyDbFileLocation(n));
        }
        switch (n) {
            case 0: {
                this.fileNameField.setText("*" + KeyDatabase.DEFAULT_PKCS12_FILE_NAME_EXT);
                this.dirNameField.setText(KeyDatabase.DEFAULT_PKCS12_FILE_LOCATION);
                return;
            }
            case 1: {
                this.fileNameField.setText("*" + KeyDatabase.DEFAULT_KEYDB_NAME_EXT_CMS);
                return;
            }
            case 2: {
                this.fileNameField.setText("*" + KeyDatabase.DEFAULT_KEYDB_NAME_EXT_WEBDB);
                return;
            }
            case 3: {
                this.fileNameField.setText("*" + KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT);
                return;
            }
            case 4: {
                this.fileNameField.setText("*" + KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLINK);
                return;
            }
            case 5: {
                this.fileNameField.setText("*" + KeyDatabase.DEFAULT_KEYDB_NAME_EXT_CDSA);
                return;
            }
            case 6: {
                this.fileNameField.setText("*" + KeyDatabase.DEFAULT_KEYDB_NAME_EXT_BERKELEY);
                return;
            }
        }
        this.fileNameField.setText("");
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.okButton.requestFocus();
    }

    static /* synthetic */ String access$0(KeyFileDialog keyFileDialog) {
        return keyFileDialog.fileName;
    }

    static /* synthetic */ void access$1(KeyFileDialog keyFileDialog, String string) {
        keyFileDialog.fileName = string;
    }

    static /* synthetic */ String access$2(KeyFileDialog keyFileDialog) {
        return keyFileDialog.dirName;
    }

    static /* synthetic */ void access$3(KeyFileDialog keyFileDialog, String string) {
        keyFileDialog.dirName = string;
    }

    class DiagAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            KeyFileDialog keyFileDialog = KeyFileDialog.this;
            keyFileDialog.fileName = null;
            keyFileDialog = KeyFileDialog.this;
            keyFileDialog.dirName = null;
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......KeyFileDialog WindowAdapter to hide");
            }
            ((Component)((Object)KeyFileDialog.this)).setVisible(false);
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......KeyFileDialog WindowAdapter after hide");
            }
        }

        DiagAdapter() {
            KeyFileDialog.this = KeyFileDialog.this;
        }
    }
}

