/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSeparator;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.CompoundBorder;
import com.sun.java.swing.border.EtchedBorder;
import com.sun.java.swing.border.SoftBevelBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;

public class KeyInfoDialog
extends JDialog
implements ActionListener {
    private KeyInfoPanel keyInfoPanel;
    private KMButton okButton;
    private DateFormat dateFmt;
    private JCheckBox cbox = new JCheckBox();
    private boolean reuse = false;
    private boolean propertyChanged = false;

    public KeyInfoDialog(Frame frame, String string) {
        this(frame, string, true, null);
    }

    public KeyInfoDialog(Frame frame, String string, boolean bl) {
        this(frame, string, bl, null);
    }

    public KeyInfoDialog(Frame frame, String string, KeyItem keyItem) {
        this(frame, string, true, keyItem);
    }

    public KeyInfoDialog(Frame frame, String string, boolean bl, KeyItem keyItem) {
        super(frame, string, true);
        this.reuse = bl;
        this.dateFmt = DateFormat.getDateInstance(1, ((Window)((Object)this)).getLocale());
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("dateFmt=" + this.dateFmt);
        }
        this.keyInfoPanel = new KeyInfoPanel(keyItem);
        JPanel jPanel = new JPanel();
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        jPanel.add((Component)((Object)this.okButton));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)((Object)this.keyInfoPanel), "Center");
        container.add((Component)jPanel, "South");
        ((Window)((Object)this)).addWindowListener(new DiagAdapter());
        if (!bl) {
            this.setDefaultCloseOperation(2);
        }
        ((Window)((Object)this)).pack();
        ((Dialog)((Object)this)).setResizable(false);
        if (this.cbox != null && this.cbox.isEnabled() && this.cbox.isShowing()) {
            this.cbox.requestFocus();
            return;
        }
        this.okButton.requestFocus();
    }

    public void reduceFontSize() {
        ((Dialog)((Object)this)).setResizable(true);
        this.reduceFontSize((Container)((Object)this.keyInfoPanel));
        ((Container)((Object)this.keyInfoPanel)).validate();
        ((Component)((Object)this.keyInfoPanel)).repaint();
        ((Window)((Object)this)).pack();
        ((Dialog)((Object)this)).setResizable(false);
    }

    public void reduceFontSize(Container container) {
        Font font = container.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
        ((Component)container).setFont(font2);
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......comp:" + container + ", f=" + font + ", nf=" + font2);
        }
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                this.reduceFontSize((Container)componentArray[n]);
            } else {
                font = componentArray[n].getFont();
                font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
                componentArray[n].setFont(font2);
                if (Ikeyman.printDebugMsg) {
                    Ikeyman.debugMsg("DEBUG......comps:" + container + ", f=" + font + ", nf=" + font2);
                }
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......actionPerformed, source=" + object + ", arg=" + string);
        }
        if (string.equals("OK")) {
            if (this.reuse) {
                ((Component)((Object)this)).setVisible(false);
                return;
            }
            ((Window)((Object)this)).dispose();
        }
    }

    public boolean isPropertyChanged() {
        return this.propertyChanged;
    }

    public void displayKeyItem(KeyItem keyItem) {
        this.keyInfoPanel.populateLabelsWithKeyItem(keyItem);
        ((Container)((Object)this.keyInfoPanel)).validate();
        ((Window)((Object)this)).pack();
        if (this.cbox != null && this.cbox.isEnabled() && this.cbox.isShowing()) {
            this.cbox.requestFocus();
            return;
        }
        this.okButton.requestFocus();
    }

    public void setCheckBoxEnabled(boolean bl) {
        this.keyInfoPanel.setCheckBoxEnabled(bl);
    }

    public DateFormat getDateFormat() {
        return this.dateFmt;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFmt = dateFormat;
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.okButton.requestFocus();
    }

    static /* synthetic */ boolean access$0(KeyInfoDialog keyInfoDialog) {
        return keyInfoDialog.propertyChanged;
    }

    static /* synthetic */ void access$1(KeyInfoDialog keyInfoDialog, boolean bl) {
        keyInfoDialog.propertyChanged = bl;
    }

    static /* synthetic */ JCheckBox access$2(KeyInfoDialog keyInfoDialog) {
        return keyInfoDialog.cbox;
    }

    static /* synthetic */ DateFormat access$3(KeyInfoDialog keyInfoDialog) {
        return keyInfoDialog.dateFmt;
    }

    class KeyInfoPanel
    extends JPanel {
        JLabel titleLabel = new JLabel("Information for the currently selected key");
        JLabel keySizeLabel = new JLabel(String.valueOf(Ikeyman.getNLSResString("GUI_LABEL_KEY_SIZE")) + ":");
        JLabel certLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_PROPERTY"));
        JLabel versionLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_VERSION"));
        JLabel serialNoLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_SERIALNO"));
        JLabel subjectLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_ISSUED_TO"));
        JLabel issuerLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_ISSUED_BY"));
        JLabel validityLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_VALIDITY"));
        JLabel fingerPrintLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_FINGERPRINT"));
        JLabel sigNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_SIG_ALG"));
        JLabel keySizeValue = new JLabel("");
        JLabel versionValue = new JLabel("");
        JLabel serialNoValue = new JLabel("");
        JTextArea issuerValue = new JTextArea(4, 30);
        JTextArea subjectValue = new JTextArea(4, 30);
        JLabel validityValue = new JLabel("");
        JLabel fingerPrintValue = new JLabel("");
        JLabel sigNameValue = new JLabel("");

        public KeyInfoPanel() {
            this(null);
        }

        public KeyInfoPanel(KeyItem keyItem) {
            super(true);
            KeyInfoDialog.this = KeyInfoDialog.this;
            if (keyItem != null) {
                this.populateLabelsWithKeyItem(keyItem);
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            CompoundBorder compoundBorder = new CompoundBorder((Border)new EtchedBorder(), (Border)new SoftBevelBorder(1));
            jPanel.setBorder((Border)compoundBorder);
            Font font = new Font(Ikeyman.defaultFont.getName(), 1, Ikeyman.defaultFont.getSize() + 2);
            this.titleLabel.setFont(font);
            this.titleLabel.setHorizontalAlignment(0);
            jPanel.add((Component)this.titleLabel, "Center");
            JSeparator jSeparator = new JSeparator();
            InfoPane infoPane = new InfoPane(keyItem);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)((Object)infoPane), "Center");
            CompoundBorder compoundBorder2 = new CompoundBorder((Border)new EtchedBorder(), (Border)new SoftBevelBorder(1));
            jPanel2.setBorder((Border)compoundBorder2);
            JScrollPane jScrollPane = new JScrollPane((Component)jPanel2);
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......infoScrollPane HPolicy=" + jScrollPane.getHorizontalScrollBarPolicy() + ", HORIZONTAL_SCROLLBAR_AS_NEEDED=" + 30);
            }
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......infoScrollPane.getViewportBorder=" + jScrollPane.getViewportBorder());
            }
            JSeparator jSeparator2 = new JSeparator();
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout(10, 20));
            jPanel3.add((Component)jSeparator, "North");
            jPanel3.add((Component)jScrollPane, "Center");
            jPanel3.add((Component)jSeparator2, "South");
            ((Container)((Object)this)).setLayout(new BorderLayout(10, 10));
            ((Container)((Object)this)).add((Component)jPanel, "North");
            ((Container)((Object)this)).add((Component)jPanel3, "Center");
            if (keyItem != null && keyItem.hasCertificate()) {
                ((Container)((Object)this)).add((Component)KeyInfoDialog.this.cbox, "South");
            }
        }

        public void populateLabelsWithKeyItem(KeyItem keyItem) {
            if (keyItem == null) {
                return;
            }
            this.keySizeLabel.setFont(Ikeyman.defaultBoldFont);
            this.certLabel.setFont(Ikeyman.defaultBoldFont);
            this.versionLabel.setFont(Ikeyman.defaultBoldFont);
            this.serialNoLabel.setFont(Ikeyman.defaultBoldFont);
            this.subjectLabel.setFont(Ikeyman.defaultBoldFont);
            this.issuerLabel.setFont(Ikeyman.defaultBoldFont);
            this.validityLabel.setFont(Ikeyman.defaultBoldFont);
            this.fingerPrintLabel.setFont(Ikeyman.defaultBoldFont);
            this.sigNameLabel.setFont(Ikeyman.defaultBoldFont);
            this.titleLabel.setText(keyItem.getKeyLabel());
            this.keySizeValue.setText(String.valueOf(keyItem.getKeySize()));
            if (keyItem.hasCertificate()) {
                Vector vector = keyItem.getCertificateChain();
                if (vector != null && vector.size() > 0) {
                    KeyInfoDialog keyInfoDialog;
                    Object object;
                    Object object2;
                    Object object3;
                    CertificateItem certificateItem = (CertificateItem)vector.elementAt(0);
                    this.versionValue.setText("X509 V" + certificateItem.getVersion());
                    String string = KMUtil.trimBlankSpace(certificateItem.getSerialNumber());
                    if (string != null && string.length() % 2 == 0) {
                        object3 = string.toUpperCase();
                        object2 = ((String)object3).toCharArray();
                        int n = ((char[])object2).length / 2;
                        object = new char[n * 3 - 1];
                        int n2 = 0;
                        while (n2 < n) {
                            object[3 * n2] = object2[2 * n2];
                            object[3 * n2 + 1] = object2[2 * n2 + 1];
                            if (n2 != n - 1) {
                                object[3 * n2 + 2] = 58;
                            }
                            ++n2;
                        }
                        this.serialNoValue.setText(new String((char[])object));
                    } else {
                        this.serialNoValue.setText(string);
                    }
                    this.issuerValue.setText(certificateItem.getIssuer().toStringWithoutTag());
                    this.subjectValue.setText(certificateItem.getSubject().toStringWithoutTag());
                    this.issuerValue.setEditable(false);
                    this.subjectValue.setEditable(false);
                    object3 = certificateItem.getValidNotBefore();
                    object2 = certificateItem.getValidNotAfter();
                    String string2 = Ikeyman.getNLSResString("GUI_LABEL_CERT_VALIDITY_FORMAT");
                    Object[] objectArray = new Object[2];
                    object = KeyInfoDialog.this;
                    objectArray[0] = object.dateFmt.format((Date)object3);
                    object = KeyInfoDialog.this;
                    objectArray[1] = object.dateFmt.format((Date)object2);
                    object = objectArray;
                    String string3 = MessageFormat.format(string2, object);
                    this.validityValue.setText(string3);
                    this.fingerPrintValue.setText(certificateItem.getFingerPrint());
                    this.sigNameValue.setText(String.valueOf(certificateItem.getSigAlgorithmIdOIDName()) + "(" + certificateItem.getSigAlgorithmIdOID() + ")");
                    if (keyItem.hasPrivateKey()) {
                        keyInfoDialog = KeyInfoDialog.this;
                        keyInfoDialog.cbox.setText(Ikeyman.getNLSResString("GUI_LABEL_SET_DEFAULT"));
                        keyInfoDialog = KeyInfoDialog.this;
                        keyInfoDialog.cbox.setSelected(keyItem.isDefault());
                        if (keyItem.isDefault() && !keyItem.containExpiredCertificate()) {
                            keyInfoDialog = KeyInfoDialog.this;
                            keyInfoDialog.cbox.setEnabled(false);
                        }
                    } else {
                        keyInfoDialog = KeyInfoDialog.this;
                        keyInfoDialog.cbox.setText(Ikeyman.getNLSResString("GUI_LABEL_SET_TRUST"));
                        keyInfoDialog = KeyInfoDialog.this;
                        keyInfoDialog.cbox.setSelected(keyItem.isTrusted());
                    }
                    keyInfoDialog = KeyInfoDialog.this;
                    keyInfoDialog.cbox.setFont(Ikeyman.defaultBoldFont);
                    keyInfoDialog = KeyInfoDialog.this;
                    keyInfoDialog.cbox.addItemListener((ItemListener)new CheckBoxItemListener());
                }
            } else {
                this.certLabel.setText(Ikeyman.getNLSResString("GUI_LABEL_CERTREQ_PROPERTY"));
                this.subjectLabel.setText(Ikeyman.getNLSResString("GUI_LABEL_CERTREQ_REQUESTED_BY"));
                CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
                this.subjectValue.setText(certificateRequestItem.getSubject().toStringWithoutTag());
                this.subjectValue.setEditable(false);
                this.fingerPrintValue.setText(certificateRequestItem.getFingerPrint());
                this.sigNameValue.setText(String.valueOf(certificateRequestItem.getSigAlgorithmIdOIDName()) + "(" + certificateRequestItem.getSigAlgorithmIdOID() + ")");
            }
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......Done populateLabelsWithKeyItem()");
            }
        }

        public void setCheckBoxEnabled(boolean bl) {
            KeyInfoDialog keyInfoDialog = KeyInfoDialog.this;
            keyInfoDialog.cbox.setEnabled(bl);
        }

        class InfoPane
        extends JPanel {
            public InfoPane(KeyItem keyItem) {
                super(true);
                KeyInfoPanel.this = KeyInfoPanel.this;
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                ((Container)((Object)this)).setLayout(gridBagLayout);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                gridBagLayout.setConstraints((Component)KeyInfoPanel.this.keySizeLabel, gridBagConstraints);
                ((Container)((Object)this)).add((Component)KeyInfoPanel.this.keySizeLabel);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagLayout.setConstraints((Component)KeyInfoPanel.this.keySizeValue, gridBagConstraints);
                ((Container)((Object)this)).add((Component)KeyInfoPanel.this.keySizeValue);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                gridBagLayout.setConstraints((Component)KeyInfoPanel.this.certLabel, gridBagConstraints);
                ((Container)((Object)this)).add((Component)KeyInfoPanel.this.certLabel);
                if (keyItem != null && keyItem.hasCertificate()) {
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagLayout.setConstraints((Component)KeyInfoPanel.this.versionLabel, gridBagConstraints);
                    ((Container)((Object)this)).add((Component)KeyInfoPanel.this.versionLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                    gridBagLayout.setConstraints((Component)KeyInfoPanel.this.versionValue, gridBagConstraints);
                    ((Container)((Object)this)).add((Component)KeyInfoPanel.this.versionValue);
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagLayout.setConstraints((Component)KeyInfoPanel.this.serialNoLabel, gridBagConstraints);
                    ((Container)((Object)this)).add((Component)KeyInfoPanel.this.serialNoLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                    gridBagLayout.setConstraints((Component)KeyInfoPanel.this.serialNoValue, gridBagConstraints);
                    ((Container)((Object)this)).add((Component)KeyInfoPanel.this.serialNoValue);
                }
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                gridBagLayout.setConstraints((Component)KeyInfoPanel.this.subjectLabel, gridBagConstraints);
                ((Container)((Object)this)).add((Component)KeyInfoPanel.this.subjectLabel);
                gridBagConstraints.gridheight = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.insets = new Insets(0, 25, 2, 5);
                gridBagLayout.setConstraints((Component)KeyInfoPanel.this.subjectValue, gridBagConstraints);
                ((Container)((Object)this)).add((Component)KeyInfoPanel.this.subjectValue);
                if (keyItem != null && keyItem.hasCertificate()) {
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagLayout.setConstraints((Component)KeyInfoPanel.this.issuerLabel, gridBagConstraints);
                    ((Container)((Object)this)).add((Component)KeyInfoPanel.this.issuerLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridheight = 2;
                    gridBagConstraints.insets = new Insets(0, 25, 2, 5);
                    gridBagLayout.setConstraints((Component)KeyInfoPanel.this.issuerValue, gridBagConstraints);
                    ((Container)((Object)this)).add((Component)KeyInfoPanel.this.issuerValue);
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.gridheight = 1;
                    gridBagLayout.setConstraints((Component)KeyInfoPanel.this.validityLabel, gridBagConstraints);
                    ((Container)((Object)this)).add((Component)KeyInfoPanel.this.validityLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints((Component)KeyInfoPanel.this.validityValue, gridBagConstraints);
                    ((Container)((Object)this)).add((Component)KeyInfoPanel.this.validityValue);
                }
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints((Component)KeyInfoPanel.this.fingerPrintLabel, gridBagConstraints);
                ((Container)((Object)this)).add((Component)KeyInfoPanel.this.fingerPrintLabel);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 25, 0, 5);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints((Component)KeyInfoPanel.this.fingerPrintValue, gridBagConstraints);
                ((Container)((Object)this)).add((Component)KeyInfoPanel.this.fingerPrintValue);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                gridBagConstraints.gridwidth = 1;
                gridBagLayout.setConstraints((Component)KeyInfoPanel.this.sigNameLabel, gridBagConstraints);
                ((Container)((Object)this)).add((Component)KeyInfoPanel.this.sigNameLabel);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints((Component)KeyInfoPanel.this.sigNameValue, gridBagConstraints);
                ((Container)((Object)this)).add((Component)KeyInfoPanel.this.sigNameValue);
            }
        }
    }

    class CheckBoxItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl;
            Object object = itemEvent.getItem();
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("CheckboxItemListener is called, obj=" + object);
            }
            KeyInfoDialog keyInfoDialog = KeyInfoDialog.this;
            KeyInfoDialog keyInfoDialog2 = KeyInfoDialog.this;
            keyInfoDialog.propertyChanged = bl = !keyInfoDialog2.propertyChanged;
        }

        CheckBoxItemListener() {
            KeyInfoDialog.this = KeyInfoDialog.this;
        }
    }

    class DiagAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            KeyInfoDialog keyInfoDialog = KeyInfoDialog.this;
            keyInfoDialog.propertyChanged = false;
            ((Component)((Object)KeyInfoDialog.this)).setVisible(false);
        }

        DiagAdapter() {
            KeyInfoDialog.this = KeyInfoDialog.this;
        }
    }
}

