/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperator;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.PrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class CMSKeyDatabase
extends KeyDatabase
implements KeyDatabaseOperator {
    public native int c_CreateNewKeyDb(String var1, String var2, long var3);

    public native int c_OpenKeyDb(String var1, String var2);

    public native int c_BuildKeyLabelList(String var1, String var2);

    public native KeyItem c_GetKeyItemByLabel(String var1, String var2, String var3, boolean var4);

    public native KeyItem c_GetDefaultKeyItem(String var1, String var2);

    public native Vector c_GetKeyItemsByPublicKey(String var1, String var2, BERObject var3);

    public native boolean c_ChangeKeyDbPwd(String var1, String var2, String var3, long var4);

    public static native boolean c_StashKeyDbPwd(String var0, String var1);

    public native int c_CreateNewSelfSigedCertificate(String var1, String var2, int var3, String var4, boolean var5, int var6, DNItem var7, int var8, String var9, boolean var10);

    public native int c_CreateNewCertRequest(String var1, String var2, String var3, int var4, DNItem var5, String var6, boolean var7);

    public native int c_IssueCertificate(String var1, String var2, String var3, int var4, String var5, int var6, String var7, String var8, boolean var9);

    public native boolean c_IsPrivateKeyPresent(String var1, String var2, String var3);

    public native int c_InsertKey(String var1, String var2, String var3, int var4, byte[] var5, int var6, byte[] var7, boolean var8, boolean var9);

    public native int c_InsertReqKey(String var1, String var2, String var3, int var4, byte[] var5, int var6, byte[] var7);

    public native int c_DeleteKeyByLabel(String var1, String var2, String var3, boolean var4);

    public native int c_SetDefaultKey(String var1, String var2, String var3);

    public native int c_SetKeyTrust(String var1, String var2, String var3, boolean var4);

    public native int c_ExportToPFXFile(String var1, String var2, String var3, String var4, String[] var5);

    public native int c_ImportFromPFXFile(String var1, String var2, String var3, String var4);

    public native int c_ReceiveCert(String var1, String var2, String var3, boolean var4, boolean var5);

    public native int c_AddCaCert(String var1, String var2, String var3, String var4, boolean var5);

    public native int c_ExtractCert(String var1, String var2, String var3, String var4, boolean var5);

    public native int c_ExtractCertReq(String var1, String var2, String var3, String var4);

    public native boolean c_CheckCertAsRenewal(String var1, String var2, int var3, byte[] var4);

    public native int c_RenewCert(String var1, String var2, int var3, byte[] var4);

    public static native int c_Kyr2Kdb(String var0, String var1, String var2, String var3);

    public static native int c_Kdb2Kyr(String var0, String var1, String var2, String var3);

    public native PrivateKeyInfoItem c_DecryptPrivateKey(int var1, byte[] var2, String var3);

    public native EncryptedPrivateKeyInfoItem c_EncryptPrivateKey(int var1, byte[] var2, String var3);

    public native KeyItem[] c_GetKeyItemListByLabel(String var1, String var2, String var3);

    public CMSKeyDatabase() {
        this.type = 1;
        this.op = this;
    }

    public CMSKeyDatabase(KeyDatabase keyDatabase) {
        super(keyDatabase);
        this.type = 1;
        this.op = this;
    }

    public CMSKeyDatabase(String string, String string2) {
        super(1, string, string2);
        this.op = this;
    }

    public CMSKeyDatabase(String string, String string2, long l) {
        super(1, string, string2, l);
        this.op = this;
    }

    public void create() throws CMSKeyDatabaseException {
        int n = this.c_CreateNewKeyDb(this.keyDbFileName, this.keyDbPwd, this.keyDbPwdExpireTime);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_CREATE"));
        }
        this.buildKeyLabelList();
    }

    public void open() throws CMSKeyDatabaseException {
        int n = this.c_OpenKeyDb(this.keyDbFileName, this.keyDbPwd);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OPEN"));
        }
        this.buildKeyLabelList();
    }

    public void close() {
    }

    public void save() {
    }

    public void reCreate(KeyDatabase keyDatabase) throws CMSKeyDatabaseException {
        block23: {
            if (this.keyDbFileName == null) {
                throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
            }
            KeyDatabaseOperator keyDatabaseOperator = (KeyDatabaseOperator)((Object)keyDatabase);
            try {
                if (this.keyDbFileName.equals(keyDatabase.getKeyDbFileName()) && this.type != keyDatabase.getType()) {
                    if (keyDatabase.getType() == 2) {
                        String string = KMUtil.getTmpFileName(this.keyDbFileName, "_tmp");
                        int n = CMSKeyDatabase.c_Kyr2Kdb(keyDatabase.getKeyDbFileName(), keyDatabase.getKeyDbPwd(), string, this.keyDbPwd);
                        File file = new File(string);
                        File file2 = new File(this.keyDbFileName);
                        if (n != 0) {
                            if (file.exists()) {
                                file.delete();
                            }
                            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KYR2KDB"));
                        }
                        file2.delete();
                        file.renameTo(file2);
                    } else {
                        Vector<KeyItem> vector = new Vector<KeyItem>();
                        KeyItem keyItem = keyDatabaseOperator.getFirstKeyItem();
                        while (keyItem != null) {
                            vector.addElement(keyItem);
                            keyItem = keyDatabaseOperator.getNextKeyItem();
                        }
                        File file = new File(this.keyDbFileName);
                        file.delete();
                        this.create();
                        int n = vector.size();
                        int n2 = 0;
                        while (n2 < n) {
                            this.insertKey((KeyItem)vector.elementAt(n2));
                            ++n2;
                        }
                    }
                    this.copyKeyLabelLists(keyDatabase);
                    return;
                }
                if (this.keyDbFileName.equals(keyDatabase.getKeyDbFileName())) break block23;
                if (this.type != keyDatabase.getType()) {
                    if (keyDatabase.getType() == 2) {
                        int n = CMSKeyDatabase.c_Kyr2Kdb(keyDatabase.getKeyDbFileName(), keyDatabase.getKeyDbPwd(), this.keyDbFileName, this.keyDbPwd);
                        if (n != 0) {
                            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_KYR2KDB"));
                        }
                        this.buildKeyLabelList();
                        return;
                    }
                    this.create();
                    KeyItem keyItem = keyDatabaseOperator.getFirstKeyItem();
                    while (keyItem != null) {
                        this.insertKey(keyItem);
                        keyItem = keyDatabaseOperator.getNextKeyItem();
                    }
                    this.copyKeyLabelLists(keyDatabase);
                    return;
                }
                File file = new File(keyDatabase.getKeyDbFileName());
                File file3 = new File(this.keyDbFileName);
                boolean bl = file3.exists();
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    byte[] byArray = new byte[512];
                    int n = 0;
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(file3);
                    while ((n = fileInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                        if (n > 0) continue;
                    }
                    fileInputStream.close();
                    fileOutputStream.close();
                    this.copyKeyLabelLists(keyDatabase);
                    return;
                }
                catch (IOException iOException) {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                        throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
                    }
                    if (!bl && file3.exists()) {
                        file3.delete();
                    }
                    iOException.printStackTrace();
                    throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
                }
            }
            catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
                throw cMSKeyDatabaseException;
            }
            catch (KeyDatabaseException keyDatabaseException) {
                throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
            }
        }
    }

    public void changeKeyDbPwd(String string, long l) throws CMSKeyDatabaseException {
        if (this.c_ChangeKeyDbPwd(this.keyDbFileName, this.keyDbPwd, string, l)) {
            this.keyDbPwd = string;
            this.keyDbPwdExpireTime = l;
            return;
        }
        throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_PWDCHG"));
    }

    public static boolean stashKeyDbPwd(String string, String string2) {
        boolean bl = false;
        if (string == null || string2 == null || string2.length() == 0 || string.length() == 0) {
            return false;
        }
        bl = CMSKeyDatabase.c_StashKeyDbPwd(string, string2);
        return bl;
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, String string2, boolean bl2) throws CMSKeyDatabaseException {
        int n4 = this.c_CreateNewSelfSigedCertificate(this.keyDbFileName, this.keyDbPwd, n - 1, string, bl, n2, dNItem, n3, string2, bl2);
        if (n4 != 0) {
            throw new CMSKeyDatabaseException(n4, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_NEW_SSCERT"));
        }
        this.addKeyLabelAt(string, 0);
        this.addMyCertLabelAt(string, 0);
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, String string2, boolean bl) throws CMSKeyDatabaseException {
        int n2 = this.c_CreateNewCertRequest(this.keyDbFileName, this.keyDbPwd, string, n, dNItem, string2, bl);
        if (n2 != 0) {
            throw new CMSKeyDatabaseException(n2, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_NEW_CERTREQ"));
        }
        if (bl) {
            this.addReqKeyLabelAt(string, 0);
        }
    }

    public void issueCertificate(String string, int n, String string2, int n2, String string3, String string4, boolean bl) throws CMSKeyDatabaseException {
        int n3 = this.c_IssueCertificate(this.keyDbFileName, this.keyDbPwd, string, n - 1, string2, n2, string3, string4, bl);
        if (n3 != 0) {
            throw new CMSKeyDatabaseException(n3);
        }
    }

    public boolean isPrivateKeyPresent(String string) {
        return this.c_IsPrivateKeyPresent(this.keyDbFileName, this.keyDbPwd, string);
    }

    public void buildKeyLabelList() throws CMSKeyDatabaseException {
        if (this.keyLabelList != null) {
            return;
        }
        this.keyLabelList = new Vector();
        int n = this.c_BuildKeyLabelList(this.keyDbFileName, this.keyDbPwd);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
        }
        this.classifyKeyLabels();
    }

    public void classifyKeyLabels() {
        this.myCertLabelList = null;
        this.caCertLabelList = null;
        if (this.keyLabelList == null) {
            return;
        }
        int n = this.keyLabelList.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.keyLabelList.elementAt(n2);
            if (this.isPrivateKeyPresent(string)) {
                this.addMyCertLabel(string);
            } else {
                this.addCaCertLabel(string);
            }
            ++n2;
        }
    }

    public void refreshKeyLabelList() throws CMSKeyDatabaseException {
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
        } else {
            this.keyLabelList.removeAllElements();
        }
        if (this.reqKeyLabelList == null) {
            this.reqKeyLabelList = new Vector();
        } else {
            this.reqKeyLabelList.removeAllElements();
        }
        int n = this.c_BuildKeyLabelList(this.keyDbFileName, this.keyDbPwd);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
        }
        this.classifyKeyLabels();
    }

    public KeyItem getKeyItemByLabel(String string) throws CMSKeyDatabaseException {
        KeyItem keyItem;
        boolean bl = false;
        if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
            bl = true;
        }
        if ((keyItem = this.c_GetKeyItemByLabel(this.keyDbFileName, this.keyDbPwd, string, bl)) == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_LABEL"));
        }
        return keyItem;
    }

    public Vector getKeyItemsByPublicKey(BERObject bERObject) throws CMSKeyDatabaseException {
        Vector vector = this.c_GetKeyItemsByPublicKey(this.keyDbFileName, this.keyDbPwd, bERObject);
        if (vector == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_PUBKEY"));
        }
        return vector;
    }

    public KeyItem getDefaultKeyItem() throws CMSKeyDatabaseException {
        KeyItem keyItem = this.c_GetDefaultKeyItem(this.keyDbFileName, this.keyDbPwd);
        if (keyItem == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_DEFAULT_KEY"));
        }
        return keyItem;
    }

    public synchronized KeyItem getFirstKeyItem() throws CMSKeyDatabaseException {
        this.currentKeyIndex = 0;
        if (this.keyLabelList == null) {
            return null;
        }
        String string = (String)this.keyLabelList.elementAt(0);
        if (string == null) {
            return null;
        }
        return this.getKeyItemByLabel(string);
    }

    public synchronized KeyItem getNextKeyItem() throws CMSKeyDatabaseException {
        ++this.currentKeyIndex;
        if (this.currentKeyIndex < this.keyLabelList.size()) {
            String string = (String)this.keyLabelList.elementAt(this.currentKeyIndex);
            if (string == null) {
                return null;
            }
            return this.getKeyItemByLabel(string);
        }
        return null;
    }

    public void deleteKeyByLabel(String string) throws CMSKeyDatabaseException {
        int n;
        if (string == null) {
            return;
        }
        boolean bl = false;
        if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
            bl = true;
        }
        if ((n = this.c_DeleteKeyByLabel(this.keyDbFileName, this.keyDbPwd, string, bl)) != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_DELETE"));
        }
        if (bl) {
            this.reqKeyLabelList.removeElement(string);
            return;
        }
        this.keyLabelList.removeElement(string);
        if (this.caCertLabelList != null && this.caCertLabelList.contains(string)) {
            this.caCertLabelList.removeElement(string);
            return;
        }
        if (this.myCertLabelList != null && this.myCertLabelList.contains(string)) {
            this.myCertLabelList.removeElement(string);
            return;
        }
        throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_LABEL_LIST_CORRUPT"));
    }

    public void insertKey(KeyItem keyItem) throws CMSKeyDatabaseException {
        byte[] byArray;
        CertificateRequestItem certificateRequestItem;
        int n;
        int n2 = 0;
        if (keyItem == null) {
            return;
        }
        String string = keyItem.getKeyLabel();
        int n3 = 0;
        byte[] byArray2 = null;
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = keyItem.getEncryptedPrivateKeyInfoItem();
        if (encryptedPrivateKeyInfoItem != null) {
            byArray2 = encryptedPrivateKeyInfoItem.getEncoded();
            n3 = encryptedPrivateKeyInfoItem.getLength();
        }
        if (keyItem.hasCertificate()) {
            boolean bl;
            boolean bl2;
            byte[] byArray3;
            CertificateItem certificateItem = (CertificateItem)keyItem.getCertificateChain().elementAt(0);
            int n4 = certificateItem.getLength();
            n2 = this.c_InsertKey(this.keyDbFileName, this.keyDbPwd, string, n4, byArray3 = certificateItem.getEncoded(), n3, byArray2, bl2 = keyItem.isTrusted(), bl = keyItem.isDefault());
            if (n2 == 0) {
                this.addKeyLabelAt(string, 0);
                if (n3 > 0) {
                    this.addMyCertLabelAt(string, 0);
                } else {
                    this.addCaCertLabelAt(string, 0);
                }
            }
        } else if (keyItem.getCertificateRequestItem() != null && (n2 = this.c_InsertReqKey(this.keyDbFileName, this.keyDbPwd, string, n = (certificateRequestItem = keyItem.getCertificateRequestItem()).getLength(), byArray = certificateRequestItem.getEncoded(), n3, byArray2)) == 0) {
            this.addReqKeyLabelAt(string, 0);
        }
        if (n2 != 0) {
            throw new CMSKeyDatabaseException(n2, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
    }

    public void setDefaultKey(String string) throws CMSKeyDatabaseException {
        int n = this.c_SetDefaultKey(this.keyDbFileName, this.keyDbPwd, string);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SET_DEFAULT_KEY"));
        }
    }

    public void setKeyTrust(String string, boolean bl) throws CMSKeyDatabaseException {
        int n = this.c_SetKeyTrust(this.keyDbFileName, this.keyDbPwd, string, bl);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SET_TRUST_KEY"));
        }
    }

    public void exportToPFXFile(String string, String string2, String[] stringArray) throws CMSKeyDatabaseException {
        int n = this.c_ExportToPFXFile(this.keyDbFileName, this.keyDbPwd, string, string2, stringArray);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
        }
    }

    public void importFromPFXFile(String string, String string2) throws CMSKeyDatabaseException {
        int n = this.c_ImportFromPFXFile(this.keyDbFileName, this.keyDbPwd, string, string2);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_IMPORT_KEY_FROM_PFX"));
        }
        this.refreshKeyLabelList();
    }

    public KeyItem[] getKeyItemListByLabel(String string) throws CMSKeyDatabaseException {
        KeyItem[] keyItemArray = this.c_GetKeyItemListByLabel(this.keyDbFileName, this.keyDbPwd, string);
        if (keyItemArray == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
        }
        return keyItemArray;
    }

    public PrivateKeyInfoItem decryptPrivateKey(EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem) throws CMSKeyDatabaseException {
        PrivateKeyInfoItem privateKeyInfoItem = null;
        byte[] byArray = null;
        int n = 0;
        if (encryptedPrivateKeyInfoItem != null) {
            byArray = encryptedPrivateKeyInfoItem.getEncoded();
            n = encryptedPrivateKeyInfoItem.getLength();
            privateKeyInfoItem = this.c_DecryptPrivateKey(n, byArray, this.keyDbPwd);
        }
        if (privateKeyInfoItem == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
        }
        return privateKeyInfoItem;
    }

    public EncryptedPrivateKeyInfoItem encryptPrivateKey(PrivateKeyInfoItem privateKeyInfoItem) throws CMSKeyDatabaseException {
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = null;
        byte[] byArray = null;
        int n = 0;
        if (privateKeyInfoItem != null) {
            byArray = privateKeyInfoItem.getEncoded();
            n = privateKeyInfoItem.getLength();
            encryptedPrivateKeyInfoItem = this.c_EncryptPrivateKey(n, byArray, this.keyDbPwd);
        }
        if (encryptedPrivateKeyInfoItem == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_IMPORT_KEY_FROM_PFX"));
        }
        return encryptedPrivateKeyInfoItem;
    }

    /*
     * Unable to fully structure code
     */
    public boolean[] insertKeyItemList(KeyItem[] var1_1) throws CMSKeyDatabaseException {
        var2_2 = null;
        if (var1_1 != null && var1_1.length > 0) {
            var2_2 = new boolean[var1_1.length];
            var3_3 = var1_1.length - 1;
            while (var3_3 >= 0) {
                block11: {
                    var2_2[var3_3] = false;
                    if (var1_1[var3_3].getKeyLabel() != null) {
                        try {
                            var1_1[var3_3].setTrusted(true);
                            this.insertKey(var1_1[var3_3]);
                            var2_2[var3_3] = true;
                            break block11;
                        }
                        catch (CMSKeyDatabaseException var4_4) {
                            var5_5 = var4_4.getErrCode();
                            var6_6 = CMSKeyDatabaseException.getErrKey(var5_5);
                            if (var6_6.equals("GSKKM_ERR_DATABASE_DUPLICATE_KEY")) {
                                var2_2[var3_3] = false;
                                if (var3_3 == 0) {
                                    throw var4_4;
                                }
                                break block11;
                            }
                            var2_2[var3_3] = false;
                            var7_7 = var1_1.length - 1;
                            ** while (var7_7 >= var3_3)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (var2_2[var7_7]) {
                                try {
                                    this.deleteKeyByLabel(var1_1[var7_7].getKeyLabel());
                                    var2_2[var7_7] = false;
                                }
                                catch (CMSKeyDatabaseException v0) {}
                            }
                            --var7_7;
                            continue;
                        }
lbl32:
                        // 1 sources

                        throw var4_4;
                    }
                }
                --var3_3;
            }
        }
        return var2_2;
    }

    public void receiveCertificate(String string, boolean bl, boolean bl2) throws CMSKeyDatabaseException {
        int n = this.c_ReceiveCert(this.keyDbFileName, this.keyDbPwd, string, bl, bl2);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
        }
        this.refreshKeyLabelList();
    }

    public void addCACertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        int n = this.c_AddCaCert(this.keyDbFileName, this.keyDbPwd, string, string2, bl);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_STORE"));
        }
        this.addCaCertLabelAt(string, 0);
        this.addKeyLabelAt(string, 0);
    }

    public void extractCertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        int n = this.c_ExtractCert(this.keyDbFileName, this.keyDbPwd, string, string2, bl);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYREC_EXTRACT_CERT"));
        }
    }

    public void extractCertificateRequest(String string, String string2) throws CMSKeyDatabaseException {
        int n = this.c_ExtractCertReq(this.keyDbFileName, this.keyDbPwd, string, string2);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
        }
    }

    public boolean checkCertAsRenewal(String string, boolean bl) throws CMSKeyDatabaseException {
        byte[] byArray = null;
        byArray = bl ? SSLightKeyDatabase.base64DearmorFileToBuf(string) : SSLightKeyDatabase.fileToBuf(string);
        if (byArray != null && byArray.length > 0) {
            return this.c_CheckCertAsRenewal(this.keyDbFileName, this.keyDbPwd, byArray.length, byArray);
        }
        throw new CMSKeyDatabaseException(0, "GSKKM_ERR_CMN_INVALID_INPUT");
    }

    public void renewCert(String string, boolean bl) throws CMSKeyDatabaseException {
        byte[] byArray = null;
        int n = 0;
        byArray = bl ? SSLightKeyDatabase.base64DearmorFileToBuf(string) : SSLightKeyDatabase.fileToBuf(string);
        if (byArray != null && byArray.length > 0) {
            n = this.c_RenewCert(this.keyDbFileName, this.keyDbPwd, byArray.length, byArray);
            if (n != 0) {
                throw new CMSKeyDatabaseException(n, "GSKKM_ERR_CMN_RENEW_CERT");
            }
        } else {
            throw new CMSKeyDatabaseException(n, "GSKKM_ERR_CMN_INVALID_INPUT");
        }
    }
}

