/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMUSKrypto;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import java.applet.Applet;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class KMSystem
implements IkeymanConstants {
    private static boolean isKMSystemInitialized;
    private static int version;
    private static boolean nativeMethodEnabled;
    private static boolean nativeLibraryInited;
    private static boolean enableJNITracing;
    private static boolean isUSVersion;
    private static boolean printVerboseMsg;
    private static boolean useDosPrompt;
    private static Vector verboseMsgQueue;
    private static boolean msgQueueEnabled;
    private static String defaultFileLocation;
    private static String hostName;
    private static String countryName;
    public static String nativeLibraryName;
    public static Locale locale;
    private static ResourceBundle errRB;
    private static ResourceBundle initRB;
    public static final String[][] ISO_3166_COUNTRY_CODE_TABLE;
    public static final String[] ISO_3166_ORDERED_COUNTRY_CODES;

    public static native boolean c_IsUSSharedLibraryLoaded();

    public static native int c_GSKKMInit(boolean var0);

    public static void init() throws MissingResourceException {
        KMSystem.init(null);
    }

    public static void init(Applet applet) throws MissingResourceException {
        if (!isKMSystemInitialized) {
            KMSystem.getUserEnv(applet);
            if (locale == null) {
                locale = Locale.getDefault();
            }
            errRB = ResourceBundle.getBundle("ikmerr", locale);
            KMSystem.verboseMsg(KMSystem.getNLSErrString("GSKKM_MSG_V_LOADED_ERR_RES"));
            if (locale == null) {
                locale = Locale.getDefault();
            }
            KMSystem.verboseMsg(String.valueOf(KMSystem.getNLSErrString("GSKKM_MSG_V_LOCALE")) + " " + locale.toString());
            if (applet == null) {
                String string = System.getProperty("java.version");
                KMSystem.verboseMsg(String.valueOf(KMSystem.getNLSErrString("GSKKM_MSG_V_JDK_VER")) + " " + string);
                if (string.compareTo("1.1.2") < 0) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_JDK_VER"));
                }
                KMSystem.initHostInformation();
                KMSystem.verboseMsg(String.valueOf(KMSystem.getNLSErrString("GSKKM_MSG_V_HOSTNAME")) + " " + hostName);
            }
            if (applet == null) {
                KMSystem.loadJNI();
            }
            KMSystem.determineExportStatus(applet);
            KMSystem.verboseMsg(String.valueOf(KMSystem.getNLSErrString("GSKKM_MSG_V_IKM_VER")) + " " + (isUSVersion ? "US " : KMSystem.getNLSErrString("GSKKM_MSG_V_IKM_VER_EXPORT")) + KMSystem.getVersionString());
            isKMSystemInitialized = true;
        }
    }

    private static void loadJNI() {
        try {
            nativeMethodEnabled = true;
            nativeLibraryInited = true;
            String string = KMSystem.getNLSErrString("GSKKM_MSG_V_LOAD_JNI");
            Object[] objectArray = new Object[]{nativeLibraryName};
            String string2 = MessageFormat.format(string, objectArray);
            KMSystem.verboseMsg(string2);
            System.loadLibrary(nativeLibraryName);
            int n = KMSystem.c_GSKKMInit(enableJNITracing);
            if (n != 0) {
                System.err.println(KMSystem.getNLSErrString("GSKKM_ERR_NOT_INITIALIZED"));
                nativeMethodEnabled = false;
                nativeLibraryInited = false;
                return;
            }
            KMSystem.verboseMsg(KMSystem.getNLSErrString("GSKKM_MSG_V_LOAD_CMS_ERR"));
            try {
                CMSKeyDatabaseException.buildErrCodeNameTable();
                return;
            }
            catch (KMException kMException) {
                nativeMethodEnabled = false;
                kMException.printStackTrace();
                return;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            nativeMethodEnabled = false;
            return;
        }
    }

    public static Locale getLocale() {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static void setLocale(Locale locale) {
        KMSystem.locale = locale;
    }

    public static String getNLSErrString(String string) {
        String string2;
        if (errRB == null) {
            string2 = null;
            string2 = "Can not find NLS message for " + string + " due to empty resource handle.";
        } else {
            try {
                string2 = (String)errRB.getObject(string);
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
                string2 = "Can not find NLS message for " + string;
            }
        }
        return string2;
    }

    public static String getInitSetting(String string) {
        String string2 = null;
        if (initRB == null) {
            string2 = null;
        } else {
            try {
                string2 = (String)initRB.getObject(string);
                if (KMUtil.trimBlankSpace(string2) == null) {
                    string2 = null;
                }
            }
            catch (MissingResourceException missingResourceException) {
                string2 = null;
            }
        }
        return string2;
    }

    public static String findCountryAbbreviationName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n <= 0 || n == string.length() - 1) {
            return null;
        }
        string2 = string.substring(n + 1);
        string2 = string2.length() == 3 ? "US" : (string2.length() == 2 ? string2.toUpperCase() : null);
        return string2;
    }

    public static boolean isUSVersion() {
        return isUSVersion;
    }

    public static int getVersion() {
        return version;
    }

    public static int getVersionMajor() {
        return version >> 4;
    }

    public static int getVersionMinor() {
        return version & 0xF;
    }

    public static String getVersionString() {
        return (version >> 4) + "." + (version & 0xF);
    }

    public static String getHostName() {
        if (hostName == null || hostName.equals("")) {
            KMSystem.initHostInformation();
        }
        return hostName;
    }

    public static String getCountryName() {
        if (countryName == null || countryName.length() != 2) {
            KMSystem.initHostInformation();
        }
        return countryName;
    }

    public static boolean isJNIEnabled() {
        return nativeMethodEnabled;
    }

    public static synchronized void verboseMsg(String string) {
        if (printVerboseMsg && useDosPrompt) {
            System.out.println("[" + string + "]");
        }
        if (!useDosPrompt && msgQueueEnabled) {
            KMSystem.updateMsgQueue("[" + string + "]", true);
        }
    }

    public static synchronized void updateMsgQueue(String string, boolean bl) {
        if (!msgQueueEnabled) {
            return;
        }
        if (bl) {
            if (string != null) {
                verboseMsgQueue.addElement(string);
                return;
            }
        } else if (!verboseMsgQueue.isEmpty()) {
            verboseMsgQueue.removeElementAt(0);
        }
    }

    public static synchronized String getVerboseMsg() {
        String string = null;
        if (!verboseMsgQueue.isEmpty()) {
            string = (String)verboseMsgQueue.firstElement();
            KMSystem.updateMsgQueue(null, false);
        }
        return string;
    }

    public static synchronized void setMsgQueueEnabled(boolean bl) {
        msgQueueEnabled = bl;
    }

    public static String getWorkingDirName() {
        return defaultFileLocation;
    }

    private static void getUserEnv(Applet applet) {
        String string;
        String string2;
        String string3 = null;
        if (applet == null) {
            string2 = System.getProperty("keyman.verbose");
            string = System.getProperty("keyman.jnitracing");
            string3 = System.getProperty("keyman.useDosPrompt");
        } else {
            string2 = applet.getParameter("keyman.verbose");
            string = System.getProperty("keyman.jnitracing");
            string3 = applet.getParameter("keyman.useDosPrompt");
        }
        if (string2 != null) {
            printVerboseMsg = string2.equals("true") || string2.equals("TRUE");
        }
        if (string != null) {
            enableJNITracing = string.equals("on") || string.equals("ON");
        }
        if (string3 != null && (string3.equals("true") || string3.equals("TRUE"))) {
            useDosPrompt = true;
            msgQueueEnabled = false;
        } else {
            useDosPrompt = false;
            msgQueueEnabled = true;
        }
        String string4 = "ikminit";
        string4 = applet == null ? KMUtil.trimBlankSpace(System.getProperty("initPropertyFile")) : KMUtil.trimBlankSpace(applet.getParameter("initPropertyFile"));
        if (string4 == null) {
            string4 = "ikminit";
        } else if (string4.endsWith(".properties")) {
            int n = ".properties".length();
            string4 = string4.substring(0, string4.length() - n);
        }
        KMSystem.loadInitSettingResource(string4);
        defaultFileLocation = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_FILE_LOCATION"));
        if (defaultFileLocation == null && (defaultFileLocation = KMUtil.getFullPathFileName(".")) == null) {
            defaultFileLocation = "." + File.separator;
        }
        KeyDatabase.loadInitSetting();
    }

    private static void loadErrorMessageResource() throws MissingResourceException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        errRB = ResourceBundle.getBundle("ikmerr", locale);
    }

    private static void loadInitSettingResource(String string) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            initRB = ResourceBundle.getBundle(string, locale);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            initRB = null;
            return;
        }
    }

    private static void initHostInformation() {
        KMSystem.findHostInformation();
        countryName = KMSystem.findCountryNameByLocale();
        if (countryName == null || countryName.equals("")) {
            countryName = KMSystem.findCountryAbbreviationName(hostName);
        }
        if (countryName == null || countryName.equals("")) {
            countryName = "US";
        }
    }

    private static void findHostInformation() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            InetAddress inetAddress2 = InetAddress.getByName(inetAddress.getHostAddress());
            hostName = inetAddress2.getHostName();
            String string = System.getProperty("os.name");
            if (string != null && string.startsWith("Windows 9")) {
                try {
                    ServerSocket serverSocket = new ServerSocket(11111);
                    serverSocket.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            hostName = "";
        }
    }

    private static String findCountryNameByLocale() {
        String string = "";
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale != null && (string = locale.getCountry()) != null && string.equals("KO") && locale.getLanguage().equals("ko")) {
            string = "KR";
        }
        return string;
    }

    private static void determineExportStatus(Applet applet) {
        try {
            Class.forName("com.ibm.gsk.ikeyman.basic.KMUSKrypto");
            if (KMUSKrypto.hashValue() == 103) {
                isUSVersion = true;
            }
            if (applet == null && nativeMethodEnabled) {
                isUSVersion = KMSystem.c_IsUSSharedLibraryLoaded();
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            isUSVersion = false;
            classNotFoundException.printStackTrace();
        }
    }

    private static Vector getOrderedCountryCodes() {
        int n;
        Vector<String> vector = new Vector<String>(ISO_3166_COUNTRY_CODE_TABLE.length);
        vector.addElement(ISO_3166_COUNTRY_CODE_TABLE[0][1]);
        int n2 = 1;
        while (n2 < ISO_3166_COUNTRY_CODE_TABLE.length) {
            n = 0;
            int n3 = 0;
            n3 = 0;
            while (n3 < n2) {
                if (ISO_3166_COUNTRY_CODE_TABLE[n2][1].compareTo((String)vector.elementAt(n3)) < 0) {
                    vector.insertElementAt(ISO_3166_COUNTRY_CODE_TABLE[n2][1], n3);
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n == 0) {
                vector.addElement(ISO_3166_COUNTRY_CODE_TABLE[n2][1]);
            }
            ++n2;
        }
        System.out.println("public static final String ISO_3166_ORDERED_COUNTRY_CODES[] = {");
        n = 0;
        while (n < vector.size()) {
            if (n > 0 && n % 10 == 0) {
                System.out.println("");
            }
            System.out.print("\"" + vector.elementAt(n) + "\", ");
            ++n;
        }
        System.out.println("};");
        return vector;
    }

    static {
        version = 17;
        verboseMsgQueue = new Vector();
        msgQueueEnabled = true;
        defaultFileLocation = null;
        hostName = "";
        countryName = "";
        nativeLibraryName = "ikmjni";
        locale = null;
        errRB = null;
        initRB = null;
        ISO_3166_COUNTRY_CODE_TABLE = new String[][]{{"AFGHANISTAN", "AF", "AFG", "004"}, {"ALBANIA", "AL", "ALB", "008"}, {"ALGERIA", "DZ", "DZA", "012"}, {"AMERICAN SAMOA", "AS", "ASM", "016"}, {"ANDORRA", "AD", "AND", "020"}, {"ANGOLA", "AO", "AGO", "024"}, {"ANGUILLA", "AI", "AIA", "660"}, {"ANTARCTICA", "AQ", "ATA", "010"}, {"ANTIGUA AND BARBUDA", "AG", "ATG", "028"}, {"ARGENTINA", "AR", "ARG", "032"}, {"ARMENIA", "AM", "ARM", "051"}, {"ARUBA", "AW", "ABW", "533"}, {"AUSTRALIA", "AU", "AUS", "036"}, {"AUSTRIA", "AT", "AUT", "040"}, {"AZERBAIJAN", "AZ", "AZE", "031"}, {"BAHAMAS", "BS", "BHS", "044"}, {"BAHRAIN", "BH", "BHR", "048"}, {"BANGLADESH", "BD", "BGD", "050"}, {"BARBADOS", "BB", "BRB", "052"}, {"BELARUS", "BY", "BLR", "112"}, {"BELGIUM", "BE", "BEL", "056"}, {"BELIZE", "BZ", "BLZ", "084"}, {"BENIN", "BJ", "BEN", "204"}, {"BERMUDA", "BM", "BMU", "060"}, {"BHUTAN", "BT", "BTN", "064"}, {"BOLIVIA", "BO", "BOL", "068"}, {"BOSNIA AND HERZEGOWINA", "BA", "BIH", "070"}, {"BOTSWANA", "BW", "BWA", "072"}, {"BOUVET ISLAND", "BV", "BVT", "074"}, {"BRAZIL", "BR", "BRA", "076"}, {"BRITISH INDIAN OCEAN TERRITORY", "IO", "IOT", "086"}, {"BRUNEI DARUSSALAM", "BN", "BRN", "096"}, {"BULGARIA", "BG", "BGR", "100"}, {"BURKINA FASO", "BF", "BFA", "854"}, {"BURUNDI", "BI", "BDI", "108"}, {"CAMBODIA", "KH", "KHM", "116"}, {"CAMEROON", "CM", "CMR", "120"}, {"CANADA", "CA", "CAN", "124"}, {"CAPE VERDE", "CV", "CPV", "132"}, {"CAYMAN ISLANDS", "KY", "CYM", "136"}, {"CENTRAL AFRICAN REPUBLIC", "CF", "CAF", "140"}, {"CHAD", "TD", "TCD", "148"}, {"CHILE", "CL", "CHL", "152"}, {"CHINA", "CN", "CHN", "156"}, {"CHRISTMAS ISLAND", "CX", "CXR", "162"}, {"COCOS (KEELING) ISLANDS", "CC", "CCK", "166"}, {"COLOMBIA", "CO", "COL", "170"}, {"COMOROS", "KM", "COM", "174"}, {"CONGO", "CG", "COG", "178"}, {"COOK ISLANDS", "CK", "COK", "184"}, {"COSTA RICA", "CR", "CRI", "188"}, {"COTE D'IVOIRE", "CI", "CIV", "384"}, {"CROATIA (local name: Hrvatska)", "HR", "HRV", "191"}, {"CUBA", "CU", "CUB", "192"}, {"CYPRUS", "CY", "CYP", "196"}, {"CZECH REPUBLIC", "CZ", "CZE", "203"}, {"DENMARK", "DK", "DNK", "208"}, {"DJIBOUTI", "DJ", "DJI", "262"}, {"DOMINICA", "DM", "DMA", "212"}, {"DOMINICAN REPUBLIC", "DO", "DOM", "214"}, {"EAST TIMOR", "TP", "TMP", "626"}, {"ECUADOR", "EC", "ECU", "218"}, {"EGYPT", "EG", "EGY", "818"}, {"EL SALVADOR", "SV", "SLV", "222"}, {"EQUATORIAL GUINEA", "GQ", "GNQ", "226"}, {"ERITREA", "ER", "ERI", "232"}, {"ESTONIA", "EE", "EST", "233"}, {"ETHIOPIA", "ET", "ETH", "231"}, {"FALKLAND ISLANDS (MALVINAS)", "FK", "FLK", "238"}, {"FAROE ISLANDS", "FO", "FRO", "234"}, {"FIJI", "FJ", "FJI", "242"}, {"FINLAND", "FI", "FIN", "246"}, {"FRANCE", "FR", "FRA", "250"}, {"FRANCE, METROPOLITAN", "FX", "FXX", "249"}, {"FRENCH GUIANA", "GF", "GUF", "254"}, {"FRENCH POLYNESIA", "PF", "PYF", "258"}, {"FRENCH SOUTHERN TERRITORIES", "TF", "ATF", "260"}, {"GABON", "GA", "GAB", "266"}, {"GAMBIA", "GM", "GMB", "270"}, {"GEORGIA", "GE", "GEO", "268"}, {"GERMANY", "DE", "DEU", "276"}, {"GHANA", "GH", "GHA", "288"}, {"GIBRALTAR", "GI", "GIB", "292"}, {"GREECE", "GR", "GRC", "300"}, {"GREENLAND", "GL", "GRL", "304"}, {"GRENADA", "GD", "GRD", "308"}, {"GUADELOUPE", "GP", "GLP", "312"}, {"GUAM", "GU", "GUM", "316"}, {"GUATEMALA", "GT", "GTM", "320"}, {"GUINEA", "GN", "GIN", "324"}, {"GUINEA-BISSAU", "GW", "GNB", "624"}, {"GUYANA", "GY", "GUY", "328"}, {"HAITI", "HT", "HTI", "332"}, {"HEARD AND MC DONALD ISLANDS", "HM", "HMD", "334"}, {"HONDURAS", "HN", "HND", "340"}, {"HONG KONG", "HK", "HKG", "344"}, {"HUNGARY", "HU", "HUN", "348"}, {"ICELAND", "IS", "ISL", "352"}, {"INDIA", "IN", "IND", "356"}, {"INDONESIA", "ID", "IDN", "360"}, {"IRAN (ISLAMIC REPUBLIC OF)", "IR", "IRN", "364"}, {"IRAQ", "IQ", "IRQ", "368"}, {"IRELAND", "IE", "IRL", "372"}, {"ISRAEL", "IL", "ISR", "376"}, {"ITALY", "IT", "ITA", "380"}, {"JAMAICA", "JM", "JAM", "388"}, {"JAPAN", "JP", "JPN", "392"}, {"JORDAN", "JO", "JOR", "400"}, {"KAZAKHSTAN", "KZ", "KAZ", "398"}, {"KENYA", "KE", "KEN", "404"}, {"KIRIBATI", "KI", "KIR", "296"}, {"KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF", "KP", "PRK", "408"}, {"KOREA, REPUBLIC OF", "KR", "KOR", "410"}, {"KUWAIT", "KW", "KWT", "414"}, {"KYRGYZSTAN", "KG", "KGZ", "417"}, {"LAO PEOPLE'S DEMOCRATIC REPUBLIC", "LA", "LAO", "418"}, {"LATVIA", "LV", "LVA", "428"}, {"LEBANON", "LB", "LBN", "422"}, {"LESOTHO", "LS", "LSO", "426"}, {"LIBERIA", "LR", "LBR", "430"}, {"LIBYAN ARAB JAMAHIRIYA", "LY", "LBY", "434"}, {"LIECHTENSTEIN", "LI", "LIE", "438"}, {"LITHUANIA", "LT", "LTU", "440"}, {"LUXEMBOURG", "LU", "LUX", "442"}, {"MACAU", "MO", "MAC", "446"}, {"MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF", "MK", "MKD", "807"}, {"MADAGASCAR", "MG", "MDG", "450"}, {"MALAWI", "MW", "MWI", "454"}, {"MALAYSIA", "MY", "MYS", "458"}, {"MALDIVES", "MV", "MDV", "462"}, {"MALI", "ML", "MLI", "466"}, {"MALTA", "MT", "MLT", "470"}, {"MARSHALL ISLANDS", "MH", "MHL", "584"}, {"MARTINIQUE", "MQ", "MTQ", "474"}, {"MAURITANIA", "MR", "MRT", "478"}, {"MAURITIUS", "MU", "MUS", "480"}, {"MAYOTTE", "YT", "MYT", "175"}, {"MEXICO", "MX", "MEX", "484"}, {"MICRONESIA, FEDERATED STATES OF", "FM", "FSM", "583"}, {"MOLDOVA, REPUBLIC OF", "MD", "MDA", "498"}, {"MONACO", "MC", "MCO", "492"}, {"MONGOLIA", "MN", "MNG", "496"}, {"MONTSERRAT", "MS", "MSR", "500"}, {"MOROCCO", "MA", "MAR", "504"}, {"MOZAMBIQUE", "MZ", "MOZ", "508"}, {"MYANMAR", "MM", "MMR", "104"}, {"NAMIBIA", "NA", "NAM", "516"}, {"NAURU", "NR", "NRU", "520"}, {"NEPAL", "NP", "NPL", "524"}, {"NETHERLANDS", "NL", "NLD", "528"}, {"NETHERLANDS ANTILLES", "AN", "ANT", "530"}, {"NEW CALEDONIA", "NC", "NCL", "540"}, {"NEW ZEALAND", "NZ", "NZL", "554"}, {"NICARAGUA", "NI", "NIC", "558"}, {"NIGER", "NE", "NER", "562"}, {"NIGERIA", "NG", "NGA", "566"}, {"NIUE", "NU", "NIU", "570"}, {"NORFOLK ISLAND", "NF", "NFK", "574"}, {"NORTHERN MARIANA ISLANDS", "MP", "MNP", "580"}, {"NORWAY", "NO", "NOR", "578"}, {"OMAN", "OM", "OMN", "512"}, {"PAKISTAN", "PK", "PAK", "586"}, {"PALAU", "PW", "PLW", "585"}, {"PANAMA", "PA", "PAN", "591"}, {"PAPUA NEW GUINEA", "PG", "PNG", "598"}, {"PARAGUAY", "PY", "PRY", "600"}, {"PERU", "PE", "PER", "604"}, {"PHILIPPINES", "PH", "PHL", "608"}, {"PITCAIRN", "PN", "PCN", "612"}, {"POLAND", "PL", "POL", "616"}, {"PORTUGAL", "PT", "PRT", "620"}, {"PUERTO RICO", "PR", "PRI", "630"}, {"QATAR", "QA", "QAT", "634"}, {"REUNION", "RE", "REU", "638"}, {"ROMANIA", "RO", "ROM", "642"}, {"RUSSIAN FEDERATION", "RU", "RUS", "643"}, {"RWANDA", "RW", "RWA", "646"}, {"SAINT KITTS AND NEVIS", "KN", "KNA", "659"}, {"SAINT LUCIA", "LC", "LCA", "662"}, {"SAINT VINCENT AND THE GRENADINES", "VC", "VCT", "670"}, {"SAMOA", "WS", "WSM", "882"}, {"SAN MARINO", "SM", "SMR", "674"}, {"SAO TOME AND PRINCIPE", "ST", "STP", "678"}, {"SAUDI ARABIA", "SA", "SAU", "682"}, {"SENEGAL", "SN", "SEN", "686"}, {"SEYCHELLES", "SC", "SYC", "690"}, {"SIERRA LEONE", "SL", "SLE", "694"}, {"SINGAPORE", "SG", "SGP", "702"}, {"SLOVAKIA (Slovak Republic)", "SK", "SVK", "703"}, {"SLOVENIA", "SI", "SVN", "705"}, {"SOLOMON ISLANDS", "SB", "SLB", "090"}, {"SOMALIA", "SO", "SOM", "706"}, {"SOUTH AFRICA", "ZA", "ZAF", "710"}, {"SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS", "GS", "SGS", "239"}, {"SPAIN", "ES", "ESP", "724"}, {"SRI LANKA", "LK", "LKA", "144"}, {"ST. HELENA", "SH", "SHN", "654"}, {"ST. PIERRE AND MIQUELON", "PM", "SPM", "666"}, {"SUDAN", "SD", "SDN", "736"}, {"SURINAME", "SR", "SUR", "740"}, {"SVALBARD AND JAN MAYEN ISLANDS", "SJ", "SJM", "744"}, {"SWAZILAND", "SZ", "SWZ", "748"}, {"SWEDEN", "SE", "SWE", "752"}, {"SWITZERLAND", "CH", "CHE", "756"}, {"SYRIAN ARAB REPUBLIC", "SY", "SYR", "760"}, {"TAIWAN, PROVINCE OF CHINA", "TW", "TWN", "158"}, {"TAJIKISTAN", "TJ", "TJK", "762"}, {"TANZANIA, UNITED REPUBLIC OF", "TZ", "TZA", "834"}, {"THAILAND", "TH", "THA", "764"}, {"TOGO", "TG", "TGO", "768"}, {"TOKELAU", "TK", "TKL", "772"}, {"TONGA", "TO", "TON", "776"}, {"TRINIDAD AND TOBAGO", "TT", "TTO", "780"}, {"TUNISIA", "TN", "TUN", "788"}, {"TURKEY", "TR", "TUR", "792"}, {"TURKMENISTAN", "TM", "TKM", "795"}, {"TURKS AND CAICOS ISLANDS", "TC", "TCA", "796"}, {"TUVALU", "TV", "TUV", "798"}, {"UGANDA", "UG", "UGA", "800"}, {"UKRAINE", "UA", "UKR", "804"}, {"UNITED ARAB EMIRATES", "AE", "ARE", "784"}, {"UNITED KINGDOM", "GB", "GBR", "826"}, {"UNITED STATES", "US", "USA", "840"}, {"UNITED STATES MINOR OUTLYING ISLANDS", "UM", "UMI", "581"}, {"URUGUAY", "UY", "URY", "858"}, {"UZBEKISTAN", "UZ", "UZB", "860"}, {"VANUATU", "VU", "VUT", "548"}, {"VATICAN CITY STATE (HOLY SEE)", "VA", "VAT", "336"}, {"VENEZUELA", "VE", "VEN", "862"}, {"VIET NAM", "VN", "VNM", "704"}, {"VIRGIN ISLANDS (BRITISH)", "VG", "VGB", "092"}, {"VIRGIN ISLANDS (U.S.)", "VI", "VIR", "850"}, {"WALLIS AND FUTUNA ISLANDS", "WF", "WLF", "876"}, {"WESTERN SAHARA", "EH", "ESH", "732"}, {"YEMEN", "YE", "YEM", "887"}, {"YUGOSLAVIA", "YU", "YUG", "891"}, {"ZAIRE", "ZR", "ZAR", "180"}, {"ZAMBIA", "ZM", "ZMB", "894"}, {"ZIMBABWE", "ZW", "ZWE", "716"}};
        ISO_3166_ORDERED_COUNTRY_CODES = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "FX", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TM", "TN", "TO", "TP", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "YU", "ZA", "ZM", "ZR", "ZW"};
    }
}

