/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import java.util.Vector;

public class KeyItem {
    public static final int RSA_KEY_ENTRY = 1;
    public static final int DES_KEY_ENTRY = 2;
    public static final int CRL_ENTRY = 3;
    private int itemType = 1;
    private String keyLabel;
    private short uniqueId;
    private short keySize;
    private boolean isTrustedRoot;
    private boolean isDefault;
    private boolean hasPrivateKey;
    private boolean hasCertificate;
    private boolean isUserDefinedFieldPresent;
    private EncryptedPrivateKeyInfoItem epkiItem;
    private BERObject udfBER;
    private Vector certificatesChain;
    private CertificateRequestItem certReq;
    private boolean hasCRL;
    private String desKey;

    public KeyItem() {
        this((String)null, 0, 0, (EncryptedPrivateKeyInfoItem)null, (Vector)null, (BERObject)null, false, false);
    }

    public KeyItem(String string, short s, short s2, EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem, Vector vector, BERObject bERObject, boolean bl, boolean bl2) {
        this.keyLabel = string;
        this.uniqueId = s;
        this.keySize = s2;
        this.epkiItem = encryptedPrivateKeyInfoItem;
        this.setCertificateChain(vector);
        this.udfBER = bERObject;
        this.isTrustedRoot = bl;
        this.isDefault = bl2;
        this.isUserDefinedFieldPresent = bERObject != null;
        this.hasCertificate = this.certificatesChain != null && !this.certificatesChain.isEmpty();
        this.hasPrivateKey = encryptedPrivateKeyInfoItem != null;
        this.certReq = null;
        this.desKey = null;
        this.hasCRL = false;
    }

    public KeyItem(String string, short s, short s2, EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem, CertificateItem[] certificateItemArray, BERObject bERObject, boolean bl, boolean bl2) {
        this.keyLabel = string;
        this.uniqueId = s;
        this.keySize = s2;
        this.epkiItem = encryptedPrivateKeyInfoItem;
        this.setCertificateChain(certificateItemArray);
        this.udfBER = bERObject;
        this.isTrustedRoot = bl;
        this.isDefault = bl2;
        this.isUserDefinedFieldPresent = bERObject != null;
        this.hasCertificate = this.certificatesChain != null && !this.certificatesChain.isEmpty();
        this.hasPrivateKey = encryptedPrivateKeyInfoItem != null;
        this.certReq = null;
        this.desKey = null;
        this.hasCRL = false;
    }

    public KeyItem(String string, short s, short s2, EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem, CertificateRequestItem certificateRequestItem, BERObject bERObject) {
        this.keyLabel = string;
        this.uniqueId = s;
        this.keySize = s2;
        this.epkiItem = encryptedPrivateKeyInfoItem;
        this.certificatesChain = null;
        this.udfBER = bERObject;
        this.isTrustedRoot = false;
        this.isDefault = false;
        this.isUserDefinedFieldPresent = bERObject != null;
        this.hasCertificate = false;
        this.hasPrivateKey = encryptedPrivateKeyInfoItem != null;
        this.certReq = certificateRequestItem;
        this.desKey = null;
        this.hasCRL = false;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isTrusted() {
        return this.isTrustedRoot;
    }

    public int getItemType() {
        return this.itemType;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public short getKeySize() {
        return this.keySize;
    }

    public Vector getCertificateChain() {
        return this.certificatesChain;
    }

    public void setCertificateChain(CertificateItem[] certificateItemArray) {
        if (this.certificatesChain == null) {
            this.certificatesChain = new Vector();
        } else {
            this.certificatesChain.removeAllElements();
        }
        if (certificateItemArray != null) {
            int n = 0;
            while (n < certificateItemArray.length) {
                this.certificatesChain.addElement(certificateItemArray[n]);
                this.hasCertificate = true;
                ++n;
            }
        }
    }

    public void setCertificateChain(Vector vector) {
        if (this.certificatesChain == null) {
            this.certificatesChain = new Vector();
        } else {
            this.certificatesChain.removeAllElements();
        }
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                CertificateItem certificateItem = (CertificateItem)vector.elementAt(n);
                this.certificatesChain.addElement(certificateItem);
                this.hasCertificate = true;
                ++n;
            }
        }
    }

    public int addCertificate(CertificateItem certificateItem) {
        if (certificateItem == null) {
            return 0;
        }
        if (this.certificatesChain == null) {
            this.certificatesChain = new Vector();
        }
        this.certificatesChain.addElement(certificateItem);
        this.hasCertificate = true;
        return this.certificatesChain.size();
    }

    public EncryptedPrivateKeyInfoItem getEncryptedPrivateKeyInfoItem() {
        return this.epkiItem;
    }

    public BERObject getUserDefinedFields() {
        return this.udfBER;
    }

    public CertificateRequestItem getCertificateRequestItem() {
        return this.certReq;
    }

    public String getDESKey() {
        return this.desKey;
    }

    public boolean hasPrivateKey() {
        return this.hasPrivateKey;
    }

    public boolean hasCertificate() {
        return this.hasCertificate;
    }

    public boolean containExpiredCertificate() {
        boolean bl = false;
        if (this.certificatesChain != null) {
            int n = this.certificatesChain.size();
            int n2 = 0;
            while (n2 < n) {
                CertificateItem certificateItem = (CertificateItem)this.certificatesChain.elementAt(n2);
                if (certificateItem.isExpired()) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public boolean hasUserDefinedFields() {
        return this.isUserDefinedFieldPresent;
    }

    public String toString() {
        return this.paramString();
    }

    public String paramString() {
        return String.valueOf(super.toString()) + ", type=" + this.itemType + ", keyLabel=" + this.keyLabel + ", isDefault=" + this.isDefault + ", isTrusted=" + this.isTrustedRoot + ", isPrivateKeyPresent=" + this.hasPrivateKey + ", keySize=" + this.keySize + ", certificate=" + this.certificatesChain + ", certificateRequest=" + this.certReq;
    }

    public void setEncryptedPrivateKeyInfoItem(EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem) {
        if (encryptedPrivateKeyInfoItem != null) {
            this.epkiItem = encryptedPrivateKeyInfoItem;
            this.hasPrivateKey = true;
        }
    }

    public void setKeyLabel(String string) {
        this.keyLabel = string;
    }

    public void setTrusted(boolean bl) {
        this.isTrustedRoot = bl;
    }

    public boolean equalsCert(KeyItem keyItem) {
        if (this.hasCertificate && keyItem.hasCertificate()) {
            String string;
            String string2 = ((CertificateItem)this.certificatesChain.elementAt(0)).getFingerPrint();
            return string2.equals(string = ((CertificateItem)keyItem.getCertificateChain().elementAt(0)).getFingerPrint());
        }
        return !this.hasCertificate && !keyItem.hasCertificate();
    }
}

