/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperator;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabaseException;
import com.ibm.sslight.SSLCert;
import com.ibm.sslight.SSLContext;
import com.ibm.sslight.SSLException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;

public class SSLightKeyDatabase
extends KeyDatabase
implements KeyDatabaseOperator {
    static final long[] ClassHeader = new long[]{-3819410108756852691L, 7608620649218062L, 504428477099346432L, 288238111387942920L, 864705422274854938L, 5630599384017228L, 7665538200540832110L, 7435253269412802151L, 4251679536773158401L};
    static final String ClassPackage = null;
    static final String BASE64BEGINCERT = "-----BEGIN CERTIFICATE-----";
    static final String BASE64ENDCERT = "-----END CERTIFICATE-----";
    static final String Armored64RdChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    static final String Armored64WrChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    static final int Armored64PadIndx = 64;
    static final int Armored64MaxLine = 64;
    static final int[] nameComps = new int[]{3, 7, 11, 10, 6};
    static final String[] compLabs = new String[]{"CN=", "L=", "OU=", "O=", "C="};
    private SSLContext context;
    private Vector certList;

    private void ssltCheckName(String string) throws SSLightKeyDatabaseException {
        File file = new File(string);
        String string2 = file.getName();
        if (!string2.endsWith(KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT)) {
            String string3 = KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_EXT");
            Object[] objectArray = new Object[]{KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT};
            String string4 = MessageFormat.format(string3, objectArray);
            throw new SSLightKeyDatabaseException(string4);
        }
        String string5 = string2.substring(0, string2.lastIndexOf(KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT));
        int n = string5.length();
        while (--n >= 0) {
            char c = string2.charAt(n);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || (c >= '0' && c <= '9' || c == '.') && n > 0) continue;
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
        }
    }

    private int ssltCreateNewKeyDb(String string, String string2, long l) throws SSLightKeyDatabaseException {
        this.ssltCheckName(string);
        this.ssltSaveKeyDb();
        return 0;
    }

    private void ssltSaveKeyDb() throws SSLightKeyDatabaseException {
        int n;
        int n2;
        byte[] byArray;
        Object object;
        int n3;
        if (this.keyDbFileName == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILENAME_NULL"));
        }
        Vector[] vectorArray = new Vector[2];
        int n4 = 0;
        while (n4 < vectorArray.length) {
            vectorArray[n4] = new Vector();
            ++n4;
        }
        if (this.certList != null) {
            n3 = 0;
            while (n3 < this.certList.size()) {
                object = (SSLCert)this.certList.elementAt(n3);
                vectorArray[0].addElement(object);
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < vectorArray.length) {
            this.context.setKeyRing(n3, vectorArray[n3]);
            ++n3;
        }
        object = new byte[40960];
        int n5 = 0;
        int n6 = 0;
        while (n6 < ClassHeader.length) {
            n5 = SSLightKeyDatabase.putLong(object, ClassHeader[n6], n5);
            ++n6;
        }
        try {
            byArray = this.context.exportKeyRings(null);
        }
        catch (SSLException sSLException) {
            byArray = null;
        }
        if (byArray != null && byArray.length > 1) {
            int n7;
            int n8;
            int n9 = 0;
            int n10 = 0;
            int n11 = n5;
            n5 += 2;
            n2 = 0;
            while (n2 < byArray.length || n10 >= 7) {
                n9 = n9 << 8 | byArray[n2] & 0xFF;
                n10 += 8;
                while (n10 >= 7) {
                    n = (byte)(n9 >>> (n10 -= 7) & 0x7F);
                    if (n == 0) {
                        n5 = SSLightKeyDatabase.putShort(object, 49280, n5);
                        continue;
                    }
                    n8 = n;
                    n7 = n5;
                    object[n7++] = (byte)n8;
                    n5 = n7;
                }
                ++n2;
            }
            if (n10 > 0) {
                n = (byte)(n9 << 7 - n10 & 0x7F);
                if (n == 0) {
                    n5 = SSLightKeyDatabase.putShort(object, 49280, n5);
                } else {
                    n8 = n;
                    n7 = n5;
                    object[n7++] = (byte)n8;
                    n5 = n7;
                }
            }
            n = n5 - n11 - 2;
            SSLightKeyDatabase.putShort(object, n, n11);
        } else {
            n5 = SSLightKeyDatabase.putShort(object, 0, n5);
        }
        n5 = SSLightKeyDatabase.putLong(object, 72066649497037166L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 7598766645297167465L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 474215628289L, 5, n5);
        File file = new File(this.keyDbFileName);
        String string = file.getName();
        String string2 = null;
        string2 = null != null ? String.valueOf(null) + "." + string.substring(0, string.lastIndexOf(".class")) : string.substring(0, string.lastIndexOf(".class"));
        n5 = SSLightKeyDatabase.putShort(object, string2.length(), n5);
        n2 = n5 = SSLightKeyDatabase.putString(object, string2.replace('.', '/'), n5);
        object[n2++] = 1;
        n5 = n2;
        n5 = SSLightKeyDatabase.putShort(object, string2.length() + 5, n5);
        n5 = SSLightKeyDatabase.putString(object, string2, n5);
        n5 = SSLightKeyDatabase.putString(object, ".java", n5);
        n5 = SSLightKeyDatabase.putLong(object, 72062281716098305L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 3733320570729569L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 7959081417901958401L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 2891133133090932L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 7597412536614391628L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 7597121009072562789L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 8238316693720727808L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 1318545757743165292L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 7020662322078446185L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 7955392142255213679L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 7161124000753674593L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 7092155057814112851L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 8031451281711589740L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 25857L, 2, n5);
        n5 = SSLightKeyDatabase.putShort(object, "com.ibm.sslight.SSLightKeyRing".length(), n5);
        n5 = SSLightKeyDatabase.putString(object, "com.ibm.sslight.SSLightKeyRing".replace('.', '/'), n5);
        n5 = SSLightKeyDatabase.putLong(object, 72073431284468581L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 8742165749579407732L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 6989868167159969377L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 3417213344072814434L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 7666643290552273771L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 7311966082790016097L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 8385984122874626052L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 281487861678089L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 7318435293822979L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 281578056515585L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 0x100000001C0001L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 281474977018368L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 481885160128708627L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 0x600010000L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 2251804109504522L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 0x100100000001DL, n5);
        n5 = SSLightKeyDatabase.putLong(object, 0x1000100000005L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 3077928894775427072L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 72078484758857216L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 0x100000001000800L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 864702123588194304L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 41781458632704L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 6674407686150L, n5);
        n5 = SSLightKeyDatabase.putLong(object, -5692549928979524864L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 0xE0003000000L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 216174981170595072L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 0x100010016000000L, n5);
        n5 = SSLightKeyDatabase.putLong(object, 131087L, 3, n5);
        File file2 = new File(this.keyDbFileName);
        n = file2.exists() ? 1 : 0;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write((byte[])object, 0, n5);
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
            }
            if (n == 0 && file2.exists()) {
                file2.delete();
            }
            iOException.printStackTrace();
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
        }
    }

    private int ssltOpenKeyDb(String string, String string2) throws SSLightKeyDatabaseException {
        if (string == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILENAME_NULL"));
        }
        try {
            byte[] byArray = SSLightKeyDatabase.fileToBuf(string);
            int n = 0;
            while (n < ClassHeader.length && SSLightKeyDatabase.msbf(byArray, n * 8, 8) == ClassHeader[n]) {
                ++n;
            }
            if (n < ClassHeader.length) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
            }
            int n2 = (int)SSLightKeyDatabase.msbf(byArray, ClassHeader.length * 8, 2);
            byte[] byArray2 = new byte[n2];
            int n3 = 0;
            int n4 = 74;
            int n5 = 74 + n2;
            while (n4 < n5) {
                if (byArray[n4] == -64) {
                    byArray2[n3] = 0;
                    ++n4;
                } else {
                    byArray2[n3] = byArray[n4];
                }
                ++n4;
                ++n3;
            }
            byte[] byArray3 = new byte[n3 * 7 / 8];
            int n6 = 0;
            do {
                byArray3[n6] = SSLightKeyDatabase.getBits(byArray2, n6 * 8, 8);
            } while (++n6 < byArray3.length);
            this.context.importKeyRings(byArray3, 0, byArray3.length, null);
        }
        catch (SSLightKeyDatabaseException sSLightKeyDatabaseException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OPEN"));
        }
        catch (Exception exception) {}
        return 0;
    }

    private int ssltBuildKeyLabelList() {
        Vector[] vectorArray = new Vector[2];
        int n = 0;
        while (n < vectorArray.length) {
            vectorArray[n] = this.context.getKeyRing(n);
            if (vectorArray[n] != null) {
                int n2 = 0;
                while (n2 < vectorArray[n].size()) {
                    SSLCert sSLCert = (SSLCert)vectorArray[n].elementAt(n2);
                    this.keyLabelList.addElement(SSLightKeyDatabase.getLabel(sSLCert));
                    this.certList.addElement(sSLCert);
                    ++n2;
                }
            }
            ++n;
        }
        return 0;
    }

    private KeyItem ssltGetKeyItemByLabel(String string, String string2, String string3, boolean bl) throws SSLightKeyDatabaseException {
        if (string == null || string3 == null) {
            return null;
        }
        if (!string.equals(this.keyDbFileName)) {
            this.ssltOpenKeyDb(string, string2);
        }
        if (this.keyLabelList == null) {
            return null;
        }
        int n = this.keyLabelList.indexOf(string3);
        if (n != -1) {
            SSLCert sSLCert = (SSLCert)this.certList.elementAt(n);
            short s = (short)sSLCert.getKeySize();
            Date[] dateArray = sSLCert.getValidity();
            DNItem dNItem = new DNItem(sSLCert.getNameComponent(0, 3), sSLCert.getNameComponent(0, 11), sSLCert.getNameComponent(0, 10), sSLCert.getNameComponent(0, 6));
            DNItem dNItem2 = new DNItem(sSLCert.getNameComponent(1, 3), sSLCert.getNameComponent(1, 11), sSLCert.getNameComponent(1, 10), sSLCert.getNameComponent(1, 6));
            BERObject bERObject = new BERObject(sSLCert.getSubPubKeyInfoBER());
            BERObject bERObject2 = new BERObject(sSLCert.getSigAlgIDBER());
            CertificateItem[] certificateItemArray = new CertificateItem[]{new CertificateItem((short)sSLCert.getVersion(), s, sSLCert.getSerialNumber(), dNItem, dNItem2, dateArray[0], dateArray[1], bERObject, null, sSLCert.getSignature(), bERObject2, sSLCert.getSigAlgOID(), sSLCert.getSigAlgName(), sSLCert.getEncoding())};
            KeyItem keyItem = new KeyItem(string3, (short)n, s, null, certificateItemArray, null, true, false);
            return keyItem;
        }
        return null;
    }

    private KeyItem ssltGetDefaultKeyItem(String string, String string2) {
        return null;
    }

    private Vector ssltGetKeyItemsByPublicKey(String string, String string2, BERObject bERObject) {
        return null;
    }

    private boolean ssltChangeKeyDbPwd(String string, String string2, String string3, long l) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    private static boolean ssltStashKeyDbPwd(String string, String string2) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    private int ssltCreateNewSelfSigedCertificate(String string, String string2, int n, String string3, boolean bl, int n2, DNItem dNItem, int n3, String string4, boolean bl2) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    private int ssltCreateNewCertRequest(String string, String string2, String string3, int n, DNItem dNItem, String string4, boolean bl) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    private int ssltIssueCertificate(String string, String string2, String string3, int n, String string4, int n2, String string5, String string6, boolean bl) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    private boolean ssltIsPrivateKeyPresent(String string, String string2, String string3) {
        return false;
    }

    private int ssltInsertKey(String string, String string2, String string3, int n, byte[] byArray, int n2, byte[] byArray2, boolean bl, boolean bl2) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    private int ssltInsertReqKey(String string, String string2, String string3, int n, byte[] byArray, int n2, byte[] byArray2) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    private int ssltDeleteKeyByLabel(String string, String string2, String string3, boolean bl) {
        return 0;
    }

    private int ssltSetDefaultKey(String string, String string2, String string3) {
        return 0;
    }

    private int ssltSetKeyTrust(String string, String string2, String string3, boolean bl) {
        return 0;
    }

    private int ssltExportToPFXFile(String string, String string2, String string3, String string4, String[] stringArray) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    private int ssltImportFromPFXFile(String string, String string2, String string3, String string4) {
        return 0;
    }

    private int ssltReceiveCert(String string, String string2, String string3, boolean bl, boolean bl2) {
        return 0;
    }

    private int ssltAddCaCert(String string, String string2, String string3, String string4, boolean bl) throws SSLightKeyDatabaseException {
        SSLCert sSLCert;
        Object object;
        if (string == null || string4 == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILENAME_NULL"));
        }
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
            this.certList = new Vector();
            object = new File(string);
            if (object.exists()) {
                this.ssltOpenKeyDb(string, string2);
                this.ssltBuildKeyLabelList();
                this.classifyKeyLabels();
            }
        }
        object = bl ? SSLightKeyDatabase.base64DearmorFileToBuf(string4) : SSLightKeyDatabase.fileToBuf(string4);
        try {
            sSLCert = new SSLCert(object);
        }
        catch (SSLException sSLException) {
            sSLCert = null;
        }
        if (sSLCert != null) {
            int n = 0;
            while (n < this.certList.size() && !sSLCert.equals((SSLCert)this.certList.elementAt(n))) {
                ++n;
            }
            if (n < this.certList.size()) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
            }
            int n2 = this.keyLabelList.indexOf(SSLightKeyDatabase.getLabel(sSLCert));
            if (n2 != -1) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
            }
            this.keyLabelList.addElement(SSLightKeyDatabase.getLabel(sSLCert));
            this.certList.addElement(sSLCert);
            this.classifyKeyLabels();
            this.ssltSaveKeyDb();
        }
        return 0;
    }

    private int ssltExtractCert(String string, String string2, String string3, String string4, boolean bl) throws SSLightKeyDatabaseException {
        if (string == null || string3 == null || string4 == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILENAME_NULL"));
        }
        if (!string.equals(this.keyDbFileName)) {
            this.ssltOpenKeyDb(string, string2);
        }
        if (this.keyLabelList == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEYDB_NULL"));
        }
        int n = this.keyLabelList.indexOf(string3);
        if (n != -1) {
            try {
                SSLCert sSLCert = (SSLCert)this.certList.elementAt(n);
                byte[] byArray = sSLCert.getEncoding();
                if (bl) {
                    byArray = SSLightKeyDatabase.BufToBase64ArmorBuf(byArray);
                }
                File file = new File(string4);
                file.delete();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    private int ssltExtractCertReq(String string, String string2, String string3, String string4) {
        return 0;
    }

    private static int ssltKyr2Kdb(String string, String string2, String string3, String string4) {
        return 0;
    }

    private static int ssltKdb2Kyr(String string, String string2, String string3, String string4) {
        return 0;
    }

    public SSLightKeyDatabase() {
        this.type = 3;
        this.op = this;
        this.context = new SSLContext();
    }

    public SSLightKeyDatabase(KeyDatabase keyDatabase) {
        super(keyDatabase);
        this.type = 3;
        this.op = this;
        this.context = new SSLContext();
    }

    public SSLightKeyDatabase(String string, String string2) {
        super(3, string, string2);
        this.op = this;
        this.context = new SSLContext();
    }

    public SSLightKeyDatabase(String string, String string2, long l) {
        super(3, string, string2, l);
        this.op = this;
        this.context = new SSLContext();
    }

    public void create() throws SSLightKeyDatabaseException {
        String string = this.keyDbFileName;
        this.ssltCheckName(string);
        this.ssltSaveKeyDb();
        int n = 0;
        if (n != 0) {
            throw new SSLightKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_CREATE"));
        }
        this.buildKeyLabelList();
    }

    public void open() throws SSLightKeyDatabaseException {
        int n = this.ssltOpenKeyDb(this.keyDbFileName, this.keyDbPwd);
        if (n != 0) {
            throw new SSLightKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OPEN"));
        }
        this.buildKeyLabelList();
    }

    public void close() {
    }

    public void save() {
    }

    public void reCreate(KeyDatabase keyDatabase) throws SSLightKeyDatabaseException {
        block13: {
            if (this.keyDbFileName == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
            }
            try {
                if (this.keyDbFileName.equals(keyDatabase.getKeyDbFileName()) && this.type != keyDatabase.getType()) {
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
                }
                if (this.keyDbFileName.equals(keyDatabase.getKeyDbFileName()) || this.type != keyDatabase.getType()) break block13;
                File file = new File(keyDatabase.getKeyDbFileName());
                File file2 = new File(this.keyDbFileName);
                boolean bl = file2.exists();
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    byte[] byArray = new byte[512];
                    int n = 0;
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(file2);
                    while ((n = fileInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                        if (n > 0) continue;
                    }
                    fileInputStream.close();
                    fileOutputStream.close();
                    this.copyKeyLabelLists(keyDatabase);
                    return;
                }
                catch (IOException iOException) {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
                    }
                    if (!bl && file2.exists()) {
                        file2.delete();
                    }
                    iOException.printStackTrace();
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
                }
            }
            catch (SSLightKeyDatabaseException sSLightKeyDatabaseException) {
                throw sSLightKeyDatabaseException;
            }
            catch (KeyDatabaseException keyDatabaseException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
            }
        }
    }

    public void changeKeyDbPwd(String string, long l) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    public static boolean stashKeyDbPwd(String string, String string2) {
        if (string == null || string2 == null || string2.length() == 0 || string.length() == 0) {
            return false;
        }
        return false;
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, String string2, boolean bl2) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, String string2, boolean bl) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    public void issueCertificate(String string, int n, String string2, int n2, String string3, String string4, boolean bl) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    public boolean isPrivateKeyPresent(String string) {
        return false;
    }

    public void buildKeyLabelList() throws SSLightKeyDatabaseException {
        int n;
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
            this.certList = new Vector();
        }
        if ((n = this.ssltBuildKeyLabelList()) != 0) {
            throw new SSLightKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
        }
        this.classifyKeyLabels();
    }

    public void classifyKeyLabels() {
        this.myCertLabelList = null;
        this.caCertLabelList = null;
        if (this.keyLabelList == null) {
            return;
        }
        int n = this.keyLabelList.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.keyLabelList.elementAt(n2);
            SSLCert cfr_ignored_0 = (SSLCert)this.certList.elementAt(n2);
            this.addCaCertLabel(string);
            ++n2;
        }
    }

    public void refreshKeyLabelList() throws SSLightKeyDatabaseException {
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
        } else {
            this.keyLabelList.removeAllElements();
        }
        if (this.reqKeyLabelList == null) {
            this.reqKeyLabelList = new Vector();
        } else {
            this.reqKeyLabelList.removeAllElements();
        }
        int n = this.ssltBuildKeyLabelList();
        if (n != 0) {
            throw new SSLightKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
        }
        this.classifyKeyLabels();
    }

    public KeyItem getKeyItemByLabel(String string) throws SSLightKeyDatabaseException {
        KeyItem keyItem;
        boolean bl = false;
        if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
            bl = true;
        }
        if ((keyItem = this.ssltGetKeyItemByLabel(this.keyDbFileName, this.keyDbPwd, string, bl)) == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_LABEL"));
        }
        return keyItem;
    }

    public Vector getKeyItemsByPublicKey(BERObject bERObject) throws SSLightKeyDatabaseException {
        if (null == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_PUBKEY"));
        }
        return null;
    }

    public KeyItem getDefaultKeyItem() throws SSLightKeyDatabaseException {
        if (null == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_DEFAULT_KEY"));
        }
        return null;
    }

    public synchronized KeyItem getFirstKeyItem() throws SSLightKeyDatabaseException {
        this.currentKeyIndex = 0;
        if (this.keyLabelList == null) {
            return null;
        }
        String string = (String)this.keyLabelList.elementAt(0);
        if (string == null) {
            return null;
        }
        return this.getKeyItemByLabel(string);
    }

    public synchronized KeyItem getNextKeyItem() throws SSLightKeyDatabaseException {
        ++this.currentKeyIndex;
        if (this.currentKeyIndex < this.keyLabelList.size()) {
            String string = (String)this.keyLabelList.elementAt(this.currentKeyIndex);
            if (string == null) {
                return null;
            }
            return this.getKeyItemByLabel(string);
        }
        return null;
    }

    public void deleteKeyByLabel(String string) throws SSLightKeyDatabaseException {
        if (string == null) {
            return;
        }
        int n = this.keyLabelList.indexOf(string);
        if (n == -1) {
            return;
        }
        this.keyLabelList.removeElementAt(n);
        this.certList.removeElementAt(n);
        if (this.caCertLabelList != null && this.caCertLabelList.contains(string)) {
            this.caCertLabelList.removeElement(string);
        } else if (this.myCertLabelList != null && this.myCertLabelList.contains(string)) {
            this.myCertLabelList.removeElement(string);
        }
        this.ssltSaveKeyDb();
    }

    public void insertKey(KeyItem keyItem) throws SSLightKeyDatabaseException {
        int n = 0;
        if (keyItem == null) {
            return;
        }
        String string = keyItem.getKeyLabel();
        int n2 = 0;
        byte[] byArray = null;
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = keyItem.getEncryptedPrivateKeyInfoItem();
        if (encryptedPrivateKeyInfoItem != null) {
            byArray = encryptedPrivateKeyInfoItem.getEncoded();
            n2 = encryptedPrivateKeyInfoItem.getLength();
        }
        if (keyItem.hasCertificate()) {
            CertificateItem certificateItem = (CertificateItem)keyItem.getCertificateChain().elementAt(0);
            int n3 = certificateItem.getLength();
            byte[] byArray2 = certificateItem.getEncoded();
            boolean bl = keyItem.isTrusted();
            boolean bl2 = keyItem.isDefault();
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
        }
        if (keyItem.getCertificateRequestItem() != null) {
            CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
            int n4 = certificateRequestItem.getLength();
            byte[] byArray3 = certificateRequestItem.getEncoded();
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
        }
        if (n != 0) {
            throw new SSLightKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
    }

    public void setDefaultKey(String string) throws SSLightKeyDatabaseException {
    }

    public void setKeyTrust(String string, boolean bl) throws SSLightKeyDatabaseException {
    }

    public void exportToPFXFile(String string, String string2, String[] stringArray) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    public void importFromPFXFile(String string, String string2) throws SSLightKeyDatabaseException {
        this.refreshKeyLabelList();
    }

    public void receiveCertificate(String string, boolean bl, boolean bl2) throws SSLightKeyDatabaseException {
        this.refreshKeyLabelList();
    }

    public void addCACertificate(String string, String string2, boolean bl) throws SSLightKeyDatabaseException {
        int n = this.ssltAddCaCert(this.keyDbFileName, this.keyDbPwd, string, string2, bl);
        if (n != 0) {
            throw new SSLightKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_STORE"));
        }
    }

    public void extractCertificate(String string, String string2, boolean bl) throws SSLightKeyDatabaseException {
        int n = this.ssltExtractCert(this.keyDbFileName, this.keyDbPwd, string, string2, bl);
        if (n != 0) {
            throw new SSLightKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYREC_EXTRACT_CERT"));
        }
    }

    public void extractCertificateRequest(String string, String string2) throws SSLightKeyDatabaseException {
    }

    public static boolean promptForPW() {
        return false;
    }

    public static boolean promptForLabel() {
        return false;
    }

    static long msbf(byte[] byArray, int n, int n2) {
        long l = 0L;
        do {
            l |= (long)(byArray[n++] & 0xFF) << --n2 * 8;
        } while (n2 > 0);
        return l;
    }

    static byte getBits(byte[] byArray, int n, int n2) {
        int n3 = n / 7;
        byte by = byArray[n3];
        int n4 = n % 7;
        by = (byte)(by & 127 >>> n4);
        if ((n4 = n2 - (7 - n4)) > 0) {
            return (byte)(by << n4 | (byte)(byArray[n3 + 1] >>> 7 - n4));
        }
        if (n4 < 0) {
            return (byte)(by >>> -n4);
        }
        return by;
    }

    private static int putByte(byte[] byArray, int n, int n2) {
        byArray[n2++] = (byte)n;
        return n2;
    }

    private static int putShort(byte[] byArray, int n, int n2) {
        int n3 = 8;
        while (n3 >= 0) {
            byArray[n2++] = (byte)(n >> n3);
            n3 -= 8;
        }
        return n2;
    }

    private static int putLong(byte[] byArray, long l, int n) {
        int n2 = 56;
        while (n2 >= 0) {
            byArray[n++] = (byte)(l >> n2);
            n2 -= 8;
        }
        return n;
    }

    private static int putLong(byte[] byArray, long l, int n, int n2) {
        int n3 = n * 8 - 8;
        while (n3 >= 0) {
            byArray[n2++] = (byte)(l >> n3);
            n3 -= 8;
        }
        return n2;
    }

    private static int putString(byte[] byArray, String string, int n) {
        int n2 = string.length();
        string.getBytes(0, n2, byArray, n);
        return n + n2;
    }

    public static byte[] fileToBuf(String string) throws SSLightKeyDatabaseException {
        int n;
        File file = new File(string);
        if (!file.exists()) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_FILE_NOT_FOUND"));
        }
        int n2 = (int)file.length();
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[n2];
        try {
            fileInputStream = new FileInputStream(file);
            n = 0;
            int n3 = 0;
            while (n < byArray.length && (n3 = fileInputStream.read(byArray, n, byArray.length - n)) != -1) {
                n += n3;
            }
            fileInputStream.close();
            fileInputStream = null;
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {}
            }
            fileInputStream = null;
            n = 0;
        }
        if (n != byArray.length) {
            return null;
        }
        return byArray;
    }

    public static byte[] base64DearmorFileToBuf(String string) throws SSLightKeyDatabaseException {
        byte[] byArray;
        int n;
        byte[] byArray2 = SSLightKeyDatabase.fileToBuf(string);
        if (byArray2 == null) {
            return null;
        }
        byte by = (byte)BASE64BEGINCERT.charAt(0);
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < byArray2.length && n2 == -1) {
            if (byArray2[n4] == by) {
                n = 0;
                while (n + n4 < byArray2.length && n < BASE64BEGINCERT.length() && Character.toUpperCase((char)byArray2[n4 + n]) == BASE64BEGINCERT.charAt(n)) {
                    ++n;
                }
                if (n == BASE64BEGINCERT.length()) {
                    n2 = n4 + BASE64BEGINCERT.length();
                }
            }
            ++n4;
        }
        if (n2 == -1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        by = (byte)BASE64ENDCERT.charAt(0);
        n4 = n2;
        while (n4 < byArray2.length && n3 == -1) {
            if (byArray2[n4] == by) {
                n = 0;
                while (n + n4 < byArray2.length && n < BASE64ENDCERT.length() && Character.toUpperCase((char)byArray2[n4 + n]) == BASE64ENDCERT.charAt(n)) {
                    ++n;
                }
                if (n == BASE64ENDCERT.length()) {
                    n3 = n4;
                }
            }
            ++n4;
        }
        if (n3 == -1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        n = n3 - n2;
        byte[] byArray3 = new byte[n];
        int n5 = n2;
        int n6 = 0;
        while (n5 < n + n2) {
            int n7 = Armored64RdChars.indexOf(byArray2[n5]);
            if (n7 != -1) {
                byArray3[n6] = (byte)n7;
                ++n6;
            }
            ++n5;
        }
        int n8 = n6;
        int n9 = n8 % 4;
        int n10 = (n8 - n9) * 3 / 4;
        if (n9 == 1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        if (n9 == 2) {
            byArray = new byte[++n10];
            byArray[n10 - 1] = (byte)(byArray3[n6 - 2] << 2 | byArray3[n6 - 1] >>> 4);
        } else if (n9 == 3) {
            byArray = new byte[n10 += 2];
            byArray[n10 - 2] = (byte)(byArray3[n6 - 3] << 2 | byArray3[n6 - 2] >>> 4);
            byArray[n10 - 1] = (byte)(byArray3[n6 - 2] << 4 | byArray3[n6 - 1] >>> 2);
        } else {
            byArray = new byte[n10];
        }
        int n11 = 0;
        n6 = 0;
        n11 = 0;
        while (n6 + 3 < n8) {
            byArray[n11] = (byte)(byArray3[n6] << 2 | byArray3[n6 + 1] >>> 4);
            byArray[n11 + 1] = (byte)(byArray3[n6 + 1] << 4 | byArray3[n6 + 2] >>> 2);
            byArray[n11 + 2] = (byte)(byArray3[n6 + 2] << 6 | byArray3[n6 + 3]);
            n6 += 4;
            n11 += 3;
        }
        return byArray;
    }

    private static int PutSextWithNL(PrintWriter printWriter, int n, int n2) {
        printWriter.print(Armored64WrChars.charAt(n));
        if (++n2 == 64) {
            printWriter.println();
            n2 = 0;
        }
        return n2;
    }

    private static byte[] BufToBase64ArmorBuf(byte[] byArray) {
        int n;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println(BASE64BEGINCERT);
        int n3 = 0;
        int n4 = 0;
        while (n3 + 2 < byArray.length) {
            n2 = byArray[n3] >>> 2 & 0x3F;
            n = n4;
            printWriter.print(Armored64WrChars.charAt(n2));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
            n2 = byArray[n3] << 4 & 0x30 | byArray[n3 + 1] >>> 4 & 0xF;
            n = n4;
            printWriter.print(Armored64WrChars.charAt(n2));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
            n2 = byArray[n3 + 1] << 2 & 0x3C | byArray[n3 + 2] >>> 6 & 3;
            n = n4;
            printWriter.print(Armored64WrChars.charAt(n2));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
            n2 = byArray[n3 + 2] & 0x3F;
            n = n4;
            printWriter.print(Armored64WrChars.charAt(n2));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
            n3 += 3;
        }
        n2 = byArray.length % 3;
        if (n2 == 1) {
            n = byArray[byArray.length - 1] >>> 2 & 0x3F;
            int n5 = n4;
            printWriter.print(Armored64WrChars.charAt(n));
            if (++n5 == 64) {
                printWriter.println();
                n5 = 0;
            }
            n4 = n5;
            n = byArray[byArray.length - 1] << 4 & 0x30;
            n5 = n4;
            printWriter.print(Armored64WrChars.charAt(n));
            if (++n5 == 64) {
                printWriter.println();
                n5 = 0;
            }
            n = n4 = n5;
            printWriter.print(Armored64WrChars.charAt(64));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n = n4 = n;
            printWriter.print(Armored64WrChars.charAt(64));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
        } else {
            n = byArray[byArray.length - 2] >>> 2 & 0x3F;
            int n6 = n4;
            printWriter.print(Armored64WrChars.charAt(n));
            if (++n6 == 64) {
                printWriter.println();
                n6 = 0;
            }
            n4 = n6;
            n = byArray[byArray.length - 2] << 4 & 0x30 | byArray[byArray.length - 1] >>> 4 & 0xF;
            n6 = n4;
            printWriter.print(Armored64WrChars.charAt(n));
            if (++n6 == 64) {
                printWriter.println();
                n6 = 0;
            }
            n4 = n6;
            n = byArray[byArray.length - 1] << 2 & 0x3C;
            n6 = n4;
            printWriter.print(Armored64WrChars.charAt(n));
            if (++n6 == 64) {
                printWriter.println();
                n6 = 0;
            }
            n = n4 = n6;
            printWriter.print(Armored64WrChars.charAt(64));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
        }
        if (n4 != 0) {
            printWriter.println();
        }
        printWriter.println(BASE64ENDCERT);
        printWriter.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private static String getLabel(SSLCert sSLCert) {
        StringBuffer stringBuffer = new StringBuffer(20);
        boolean bl = true;
        int n = 0;
        while (n < nameComps.length) {
            String string = sSLCert.getNameComponent(1, nameComps[n]);
            if (string != null) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                bl = false;
                stringBuffer.append(compLabs[n]);
                stringBuffer.append(string);
            }
            ++n;
        }
        return new String(stringBuffer);
    }
}

