/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.CompoundBorder;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicComboBoxUI;
import com.sun.java.swing.plaf.basic.BasicComboPopup;
import com.sun.java.swing.plaf.basic.ComboPopup;
import com.sun.java.swing.plaf.motif.MotifBorderFactory;
import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class MotifComboBoxUI
extends BasicComboBoxUI
implements Serializable {
    Icon arrowIcon;
    static final int HORIZ_MARGIN = 3;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(new CompoundBorder(MotifBorderFactory.getFocusBorder(), MotifBorderFactory.getRaisedBevelBorder()));
        this.arrowIcon = new MotifComboBoxArrowIcon(UIManager.getColor("controlHighlight"), UIManager.getColor("controlShadow"), UIManager.getColor("control"));
        Component component = this.editor;
        SwingUtilities.invokeLater(new 1(component));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setBorder(null);
    }

    protected ComboPopup createPopup() {
        return new MotifComboPopup(this.comboBox);
    }

    protected void addSubComponents() {
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void removeSubComponents() {
        this.removeEditor();
        this.comboBox.removeAll();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle;
        boolean bl = this.comboBox.hasFocus();
        graphics.setColor(this.comboBox.getBackground());
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        if (!this.comboBox.isEditable()) {
            rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValue(graphics, rectangle, bl);
        }
        rectangle = this.rectangleForArrowIcon();
        this.arrowIcon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        if (!this.comboBox.isEditable()) {
            Border border = this.comboBox.getBorder();
            Insets insets = border.getBorderInsets(this.comboBox);
            rectangle.x -= 5;
            rectangle.y = insets.top;
            rectangle.width = 1;
            rectangle.height = this.comboBox.getBounds().height - insets.bottom - insets.top;
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++rectangle.x;
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        component.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        Dimension dimension = component.getPreferredSize();
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, dimension.height);
    }

    protected Rectangle rectangleForArrowIcon() {
        Rectangle rectangle = this.comboBox.getBounds();
        Border border = this.comboBox.getBorder();
        Insets insets = border.getBorderInsets(this.comboBox);
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        rectangle.x = rectangle.x + rectangle.width - 3 - this.arrowIcon.getIconWidth();
        rectangle.y += (rectangle.height - this.arrowIcon.getIconHeight()) / 2;
        rectangle.width = this.arrowIcon.getIconWidth();
        rectangle.height = this.arrowIcon.getIconHeight();
        return rectangle;
    }

    protected Rectangle rectangleForCurrentValue() {
        Border border = this.comboBox.getBorder();
        Dimension dimension = this.comboBox.getSize();
        Insets insets = border.getBorderInsets(this.comboBox);
        return new Rectangle(insets.left, insets.top, dimension.width - this.iconAreaWidth() - insets.left - insets.right, dimension.height - insets.bottom - insets.top);
    }

    public int iconAreaWidth() {
        if (this.comboBox.isEditable()) {
            return this.arrowIcon.getIconWidth() + 6;
        }
        return this.arrowIcon.getIconWidth() + 9 + 2;
    }

    public void configureEditor() {
        super.configureEditor();
        this.editor.setBackground(UIManager.getColor("text"));
    }

    public void layoutContainer(Container container) {
        if (this.editor != null) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            ++rectangle.x;
            ++rectangle.y;
            --rectangle.width;
            rectangle.height -= 2;
            this.editor.setBounds(rectangle);
        }
    }

    protected void selectNextPossibleValue() {
        super.selectNextPossibleValue();
    }

    protected void selectPreviousPossibleValue() {
        super.selectPreviousPossibleValue();
    }

    protected void addKeyAccelerators(JComponent jComponent) {
        super.addKeyAccelerators(jComponent);
        JComboBox jComboBox = this.comboBox;
        MotifComboBoxUI motifComboBoxUI = this;
        3 var4_4 = new 3(jComboBox, motifComboBoxUI);
        jComboBox.registerKeyboardAction(var4_4, KeyStroke.getKeyStroke(40, 0), 1);
        4 var5_5 = new 4(jComboBox, motifComboBoxUI);
        jComboBox.registerKeyboardAction(var5_5, KeyStroke.getKeyStroke(38, 0), 1);
    }

    protected void removeKeyAccelerators(JComponent jComponent) {
        super.removeKeyAccelerators(jComponent);
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
    }

    private static final class 1
    implements Runnable {
        private final /* synthetic */ Component val$edit;

        public void run() {
            if (this.val$edit != null) {
                this.val$edit.setBackground(UIManager.getColor("text"));
            }
        }

        /* synthetic */ 1(Component component) {
            this.val$edit = component;
        }
    }

    protected class MotifComboPopup
    extends BasicComboPopup {
        JComboBox cBox;

        public MotifComboPopup(JComboBox jComboBox) {
            super(jComboBox);
            MotifComboBoxUI.this = MotifComboBoxUI.this;
            this.cBox = jComboBox;
        }

        protected MouseMotionListener createListMouseMotionListener() {
            return new 2();
        }

        public KeyListener createKeyListener() {
            return new MotifKeyListener();
        }

        protected class MotifKeyListener
        extends BasicComboPopup.InvocationKeyListener {
            public void keyReleased(KeyEvent keyEvent) {
                if (!MotifComboPopup.this.cBox.isEditable()) {
                    if (keyEvent.getKeyCode() == 40) {
                        if (!MotifComboPopup.this.isVisible()) {
                            MotifComboPopup.this.show();
                            return;
                        }
                    } else {
                        super.keyReleased(keyEvent);
                    }
                    return;
                }
                if (!(keyEvent.getKeyCode() != 38 && keyEvent.getKeyCode() != 40 || MotifComboPopup.this.isVisible())) {
                    MotifComboPopup.this.show();
                }
            }

            MotifKeyListener() {
                super(MotifComboPopup.this);
                MotifComboPopup.this = MotifComboPopup.this;
            }
        }
    }

    static class MotifComboBoxArrowIcon
    implements Icon,
    Serializable {
        private Color lightShadow;
        private Color darkShadow;
        private Color fill;

        public MotifComboBoxArrowIcon(Color color, Color color2, Color color3) {
            this.lightShadow = color;
            this.darkShadow = color2;
            this.fill = color3;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            graphics.setColor(this.lightShadow);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2 + 1, n + n3 - 3, n2 + 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 1, n2 + 1);
            int n5 = n + 1;
            int n6 = n2 + 2;
            int n7 = n3 - 6;
            while (n6 + 1 < n2 + n4) {
                graphics.setColor(this.lightShadow);
                graphics.drawLine(n5, n6, n5 + 1, n6);
                graphics.drawLine(n5, n6 + 1, n5 + 1, n6 + 1);
                if (n7 > 0) {
                    graphics.setColor(this.fill);
                    graphics.drawLine(n5 + 2, n6, n5 + 1 + n7, n6);
                    graphics.drawLine(n5 + 2, n6 + 1, n5 + 1 + n7, n6 + 1);
                }
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n5 + n7 + 2, n6, n5 + n7 + 3, n6);
                graphics.drawLine(n5 + n7 + 2, n6 + 1, n5 + n7 + 3, n6 + 1);
                ++n5;
                n7 -= 2;
                n6 += 2;
            }
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n + n3 / 2, n2 + n4 - 1, n + n3 / 2, n2 + n4 - 1);
        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 11;
        }
    }

    private final class 3
    extends AbstractAction {
        private final /* synthetic */ JComboBox val$thisComboBox;
        private final /* synthetic */ MotifComboBoxUI val$thisUI;

        public void actionPerformed(ActionEvent actionEvent) {
            this.val$thisUI.selectNextPossibleValue();
        }

        public boolean isEnabled() {
            return this.val$thisComboBox.isEnabled() && MotifComboBoxUI.this.popupIsVisible();
        }

        /* synthetic */ 3(JComboBox jComboBox, MotifComboBoxUI motifComboBoxUI2) {
            this.val$thisComboBox = jComboBox;
            this.val$thisUI = motifComboBoxUI2;
        }
    }

    private final class 4
    extends AbstractAction {
        private final /* synthetic */ JComboBox val$thisComboBox;
        private final /* synthetic */ MotifComboBoxUI val$thisUI;

        public void actionPerformed(ActionEvent actionEvent) {
            this.val$thisUI.selectPreviousPossibleValue();
        }

        public boolean isEnabled() {
            return this.val$thisComboBox.isEnabled() && MotifComboBoxUI.this.popupIsVisible();
        }

        /* synthetic */ 4(JComboBox jComboBox, MotifComboBoxUI motifComboBoxUI2) {
            this.val$thisComboBox = jComboBox;
            this.val$thisUI = motifComboBoxUI2;
        }
    }
}

