/*REXX*/
/*------------------------------------------------------------------------------------ */
/* REXX script                                                                         */
/* Purpose:   Launch iKeyman GUI                                                       */
/* Author:    Trung D Nguyen/IBM                                                       */
/* Date:      08/02/2000                                                               */
/*------------------------------------------------------------------------------------ */

'@ECHO OFF'
trace "o"
env = 'OS2ENVIRONMENT'

/*------------------------------------------------------------------------------------*/
/* Determine java version                                                                                             */
/*------------------------------------------------------------------------------------*/
'java -version 2> temp_file'
n = stream('temp_file', 'C', 'OPEN READ')
parse value linein('temp_file', 1) with version
first_word = word(version, 1)
third_word = substr(word(version, words(version)), 2 , 3)
if first_word == 'SYS1041:' then
   java_version_1 = true
else if third_word <= 1.1 then
   java_version_1 = true
else
   java_version_1 = false
n = stream('temp_file', 'C', 'CLOSE')
'del temp_file' 

'setlocal'
/* Determine if JAVA_HOME or IKEYMAN_HOME.  If these are not set, */
/* Give an error message and exit.  Else, Run Ikeyman Gui */
if value(JAVA_HOME, ,env) == '' then call noJavaHome 
else if value(IKEYMAN_HOME, ,env) == '' then call noIkeymanHome
else 
   Do
      /* Add %IKEYMAN_HOME%\lib to library paches */
      if java_version_1 == TRUE then do
         'SET LIBPATH=%IKEYMAN_HOME%\lib;%LIBPATH%'
         'SET BEGINLIBPATH=%IKEYMAN_HOME%\lib;%BEGINLIBPATH%'
         end /* do */
      else do 
         'SET LIBPATH=%IKEYMAN_HOME%\lib;%JAVA_HOME%\BIN;%LIBPATH%'
         'SET BEGINLIBPATH=%IKEYMAN_HOME%\lib;%JAVA_HOME%\BIN;%BEGINLIBPATH%'
         end

      /* Current SwingSet needs to have the following environment due to bug */
      /* and performance reason */

      'SET IKEYMAN_CLASS_DIR=%IKEYMAN_HOME%\classes'
     
      /* iKeyman GUI will log progress messages and some other helpful messages */
      /* when verbose mode is set. */
      'SET IKEYMAN_VERBOSE=true'

      /*------------------------------------------------------------------------------ */ 
      /* Comment out the following environment setting to use a workaround to fix      */
      /* JFC (SwingSet) bug related to Lightweight components, where mouse target      */
      /* is lost when a JDialog is disposed and an exception message as the            */
      /* following is logged.                                                          */
      /*                                                                               */
      /* Exception occurred during event dispatching:                                  */
      /* java.lang.NullPointerException:                                               */
      /* at java.awt.LightweightDispatcher.retargetMouseEvent(Container.java:1544)     */
      /* at java.awt.LightweightDispatcher.processMouseEvent(Container.java:1448)      */
      /* at java.awt.LightweightDispatcher.dispatchEvent(Container.java:1383)          */
      /* at java.awt.Container.dispatchEventImpl(Container.java:922)                   */
      /* at java.awt.Window.dispatchEventImpl(Window.java:443)                         */
      /* at java.awt.Component.dispatchEvent(Component.java:1704)                      */
      /* at java.awt.EventDispatchThread.run(EventDispatchThread.java:63)              */
      /*                                                                               */
      /* IKEYMAN will retarget the mouse after each Dialog invoked by a lightweight    */
      /* component by dispatching a mouse event. This workaround seems to work well    */
      /* most time. If IKEYMAN runs to crash, please turn off this fix flag and        */
      /* be kind to tolerate the exception message above but ignore them.              */
      /*                                                                               */
      /* set IKEYMAN_FIX_JFC_MOUSE_RETARGET=true                                     */
      /*                                                                               */
      /*------------------------------------------------------------------------------ */

      'SET ARGS = '''
      'SET JAVA_FLAGS = '''
      if java_version_1 == TRUE then
         'SET JDK_CLASSES=%JAVA_HOME%\lib\classes.zip'
      else do
         'SET JDK_CLASSES=%JAVA_HOME%\lib\rt.jar'
         'SET JAVA_DEFAULT_STACK_SIZE=262144'
         end

      'SET IKEYMAN_CLASSES=%IKEYMAN_CLASS_DIR%\ikmclass.jar'
      'SET CSNT_HELP_CLASSES=%SNARoot%\sg\sguides.jar;%IKEYMAN_CLASS_DIR%'

      if value(SNARoot, ,env) == '' then
         'SET CSNT_HELP_CLASSES=%IKEYMAN_CLASS_DIR%\sguides.jar;%IKEYMAN_CLASS_DIR%'
     
      'SET SWINGSET_CLASSES=%IKEYMAN_CLASS_DIR%\swingall.jar'
      'SET IBMCFWK_CLASSES=%IKEYMAN_CLASS_DIR%\cfwk.zip'
      'SET IBMSSLIGHT_CLASSES=%IKEYMAN_CLASS_DIR%\sslight.jar'
      'SET CLASSPATH_FLAG=-classpath %IBMCFWK_CLASSES%;%IKEYMAN_CLASSES%;%IKEYMAN_CLASS_DIR%;%SWINGSET_CLASSES%;%CSNT_HELP_CLASSES%;%JDK_CLASSES%;%CLASSPATH%'

      Parse Arg all
      Do i = 1 to words(all) 
         word = word(all, i)
         arglen = LENGTH(word)
         if word == '-classpath' then 
            do
               i = i + 1
               word = word(all, i)
               call doClassPath word
            end /* do */
         else if word == '-v' | word == '-verbose' | word == '-verbose:class' | word == '-verbose:gc' | word == '-verbosegc' | word == '-verbose:jni' then call doBothJavaIkeymanVerbose word
         else if arglen >= 2 & LEFT(word, 1) == '-' then call doJavaFlag word
         else call doArgs word
      end /* do */
      call doRun  
   End /* do */
'endlocal'
'@ECHO ON' 
exit

/*---------------------------------------------------------------------------- */
/* Subroutine do all classpath if user specify from command line               */
/*---------------------------------------------------------------------------- */
doClassPath:
parse arg word
CLASSPATH_FLAG=value("CLASSPATH_FLAG", value("CLASSPATH_FLAG", ,env) || word || ';', env)
return

/*---------------------------------------------------------------------------- */
/* Subroutine doBothJavaIkeymanVerbose                                         */
/*---------------------------------------------------------------------------- */
doBothJavaIkeymanVerbose:
parse arg word
'SET IKEYMAN_VERBOSE=true'
JAVA_FLAGS=value("JAVA_FLAGS", value("JAVA_FLAGS", ,env) || word, env)
return

/*---------------------------------------------------------------------------- */
/* Subroutine doJavaFlag                                                       */
/*---------------------------------------------------------------------------- */
doJavaFlag:
parse arg word
JAVA_FLAGS=value("JAVA_FLAGS", value("JAVA_FLAGS", ,env) || word || ' ', env)
return

/*---------------------------------------------------------------------------- */
/* Subroutine doArgs                                                           */
/*---------------------------------------------------------------------------- */
doArgs:
parse arg word
ARGS=value("ARGS",value("ARGS", , env) || word || ' ', env)
return

/*---------------------------------------------------------------------------- */
/* Subroutine that run the Ikeyman GUI                                         */
/*---------------------------------------------------------------------------- */
doRun:
'@ECHO ON'
if java_version_1 == TRUE then
   'jre -nojit %JAVA_FLAGS%%CLASSPATH_FLAG% -Dkeyman.verbose=%IKEYMAN_VERBOSE% -Dkeyman.fix.jfc.mouse.retarget=%IKEYMAN_FIX_JFC_MOUSE_RETARGET% com.ibm.gsk.ikeyman.Ikeyman %ARGS%'
else
   'java %JAVA_FLAGS%%CLASSPATH_FLAG% -Dkeyman.verbose=%IKEYMAN_VERBOSE% -Dkeyman.fix.jfc.mouse.retarget=%IKEYMAN_FIX_JFC_MOUSE_RETARGET% com.ibm.gsk.ikeyman.Ikeyman %ARGS%'
return

/*---------------------------------------------------------------------------- */
/* Subroutine that printout error message when JAVA_HOME is not set            */
/*---------------------------------------------------------------------------- */
noJavaHome: 
SAY "Error: JAVA_HOME is not set. JRE in OS2 platform is not shipped" 
SAY "seperately like other platforms. Instead it is embedded into java" 
SAY "enabled OS2 OS. If your OS is not java enabled one, please download a"
SAY "OS2 JDK package 1.1.2 or its later version from IBM, and then set" 
SAY "JAVA_HOME to be the full path name of the home directory of JDK" 
SAY "installed in your host machine.  For example," 
SAY "     SET JAVA_HOME=C:\java11"
return

/*--------------------------------------------------------------------------- */
/* Subroutine that printout error message when IKEYMAN_HOME is not set      */
/*--------------------------------------------------------------------------- */
noIkeymanHome: 
SAY "Error: IKEYMAN_HOME is not set. Please set IKEYMAN_HOME to be the full"
SAY "path name of the home directory of iKeyman package installed in your" 
SAY "host machine.  For example," 
SAY "       SET IKEYMAN_HOME=C:\ikeyman"
return  

