/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class GenkeyDialog
extends JDialog
implements IkeymanConstants,
ActionListener,
ItemListener {
    public static final int CREATE_NEW_SELFSIGNED_CERTIFICATE = 1;
    public static final int CREATE_NEW_KEYPAIR_AND_CERTREQ = 2;
    public static final int[] KEYSIZE_CHOICE = new int[]{512, 1024};
    public static final int KEYSIZE_EXPORT_MAX = 512;
    public static final int KEYSIZE_EXPORT_DEFAULT = 512;
    public static final int KEYSIZE_US_DEFAULT = 1024;
    public static final int MAX_NUMBER_CERTIFICATE_VALID_DAYS = 7300;
    private KeyDatabase keyDb;
    private String currWorkingDirName;
    private String defaultCertReqFileFullPathName;
    private int mode;
    private JLabel titleLabel;
    private JLabel versionLabel;
    private JLabel keyLabelLabel;
    private JLabel keySizeLabel;
    private JLabel commonNameLabel;
    private JLabel orgLabel;
    private JLabel optionLabel1;
    private JLabel optionLabel2;
    private JLabel optionLabel3;
    private JLabel optionLabel4;
    private JLabel orgUnitLabel;
    private JLabel localityLabel;
    private JLabel stateLabel;
    private JLabel zipCodeLabel;
    private JLabel countryLabel;
    private JLabel validityPeriodLabel;
    private JLabel daysLabel;
    private JTextField labelField;
    private JComboBox certVersionChoice;
    private JComboBox keySizeChoice;
    private int defIdx;
    private JTextField commonNameField;
    private JTextField orgField;
    private JTextField orgUnitField;
    private JTextField localityField;
    private JTextField stateField;
    private JTextField zipCodeField;
    private JComboBox countryCodeChoices;
    private JTextField validityPeriodField;
    private JLabel certReqFileNameLabel;
    private JTextField certReqFileNameField;
    private KMButton browseButton;
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton resetButton;
    private KMButton helpButton;
    private JPanel keyInfoInputPanel;
    private String keyLabel;
    private DNItem subjectDNItem;
    private int keySize;
    private int certVersion;
    private String certReqFileName;
    private int numValidDays = 365;
    private JTextField invalidInputField;
    private String invalidInputFieldName;
    private JDialog diagInstance;

    public GenkeyDialog(Frame frame, KeyDatabase keyDatabase, int n) {
        super(frame, Ikeyman.getNLSResString("GUI_DIALOG_TITLE_NEW_SSCERT"), true);
        this.keyDb = keyDatabase;
        this.mode = n;
        this.diagInstance = this;
        if (n == 2) {
            this.setTitle(Ikeyman.getNLSResString("GUI_DIALOG_TITLE_NEW_CERTREQ"));
        }
        this.populateFields();
        this.commonNameField.setText(KMSystem.getHostName());
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......KMSystem.getCountryName() returns " + KMSystem.getCountryName());
        }
        this.countryCodeChoices.setSelectedItem(KMSystem.getCountryName());
        this.validityPeriodField.setText("365");
        this.keyInfoInputPanel = new KeyInfoInputPanel();
        KMHorizontalButtonPanel kMHorizontalButtonPanel = new KMHorizontalButtonPanel();
        kMHorizontalButtonPanel.add(this.okButton);
        kMHorizontalButtonPanel.add(this.resetButton);
        kMHorizontalButtonPanel.add(this.cancelButton);
        kMHorizontalButtonPanel.add(this.helpButton);
        kMHorizontalButtonPanel.equalizeButtons();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.keyInfoInputPanel, gridBagConstraints);
        jPanel.add(this.keyInfoInputPanel);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(kMHorizontalButtonPanel, gridBagConstraints);
        jPanel.add(kMHorizontalButtonPanel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        this.addWindowListener(new DiagAdapter());
        this.pack();
        this.labelField.requestFocus();
    }

    protected void populateFields() {
        this.populateInputFields();
        this.populateButtons();
        this.setToolTips();
    }

    protected void populateInputFields() {
        int n;
        if (this.mode == 1) {
            this.certVersionChoice = new JComboBox();
            n = CertificateItem.CERTIFICATE_VERSIONS.length - 1;
            while (n >= 0) {
                this.certVersionChoice.addItem(CertificateItem.CERTIFICATE_VERSIONS[n]);
                --n;
            }
        }
        this.keySizeChoice = new JComboBox();
        n = KMSystem.isUSVersion();
        int n2 = 0;
        while (n2 < KEYSIZE_CHOICE.length) {
            if (n == 0 && KEYSIZE_CHOICE[n2] > 512) break;
            this.keySizeChoice.addItem(String.valueOf(KEYSIZE_CHOICE[n2]));
            ++n2;
        }
        this.keySizeChoice.addItemListener(this);
        int n3 = 0;
        while (n3 < KEYSIZE_CHOICE.length) {
            if (n == 0) {
                if (KEYSIZE_CHOICE[n3] == 512) {
                    this.defIdx = n3;
                    break;
                }
            } else if (KEYSIZE_CHOICE[n3] == 1024) {
                this.defIdx = n3;
                break;
            }
            ++n3;
        }
        this.keySizeChoice.setSelectedIndex(this.defIdx);
        this.titleLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_ENTER_INFO"));
        this.versionLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_VERSION"));
        this.keyLabelLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_KEY_LABEL"));
        this.keySizeLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_KEY_SIZE"));
        this.commonNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_COMMON_NAME"));
        this.orgLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_ORG"));
        String string = Ikeyman.getNLSResString("GUI_LABEL_OPTIONAL");
        this.optionLabel1 = new JLabel(string);
        this.optionLabel2 = new JLabel(string);
        this.optionLabel3 = new JLabel(string);
        this.optionLabel4 = new JLabel(string);
        this.orgUnitLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_ORG_UNIT"));
        this.localityLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_LOCALITY"));
        this.stateLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_STATE"));
        this.zipCodeLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_ZIPCODE"));
        this.countryLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_COUNTRY"));
        this.validityPeriodLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_VALIDITY_PERIOD"));
        this.daysLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_EXPIRE_DAYS"));
        int n4 = 35;
        if (Ikeyman.screenSize.width < 800) {
            n4 = 25;
        }
        this.labelField = new JTextField(n4);
        this.commonNameField = new JTextField(n4);
        this.orgField = new JTextField(n4);
        this.orgUnitField = new JTextField(n4);
        this.localityField = new JTextField(n4);
        this.stateField = new JTextField(10);
        this.zipCodeField = new JTextField(10);
        this.countryCodeChoices = new JComboBox<String>(KMSystem.ISO_3166_ORDERED_COUNTRY_CODES);
        this.countryCodeChoices.addItemListener(this);
        this.validityPeriodField = new JTextField(5);
        if (this.mode == 2) {
            this.certReqFileNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERTREQ_FILE_NAME"));
            int n5 = 0;
            if (this.keyDb != null) {
                n5 = this.keyDb.getType();
            }
            this.currWorkingDirName = KeyDatabase.getDefaultKeyDbFileLocation(n5);
            this.defaultCertReqFileFullPathName = String.valueOf(this.currWorkingDirName) + KeyDatabase.DEFAULT_CERTREQ_NAME;
            this.certReqFileNameField = new JTextField(this.defaultCertReqFileFullPathName, n4 + 5);
            String string2 = Locale.getDefault().getLanguage();
            if (string2.equals("ko") || string2.equals("ja")) {
                this.certReqFileNameField.setFont(Ikeyman.defaultMonospacedFont);
            }
            this.browseButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_BROWSE"));
            this.browseButton.setActionCommand("Browse");
            this.browseButton.addActionListener(this);
        }
    }

    protected void populateButtons() {
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.resetButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_RESET"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.helpButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_HELP"));
        this.okButton.setActionCommand("OK");
        this.resetButton.setActionCommand("Reset");
        this.cancelButton.setActionCommand("Cancel");
        this.helpButton.setActionCommand("Help");
        this.okButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        if (!Ikeyman.isHelpAvailable()) {
            this.helpButton.setEnabled(false);
        }
    }

    protected void setToolTips() {
        this.labelField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_KEY_LABEL"));
        if (this.mode == 1) {
            this.certVersionChoice.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_CERT_VERSION"));
        }
        this.keySizeChoice.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_KEY_SIZE_CHOICE"));
        this.commonNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_COMMON_NAME"));
        this.orgField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_ORG_NAME"));
        this.orgUnitField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_ORG_UNIT_NAME"));
        this.localityField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_LOCALITY"));
        this.stateField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_STATE"));
        this.zipCodeField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_ZIPCODE"));
        this.countryCodeChoices.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_COUNTRY_NAME"));
        if (this.mode == 1) {
            this.validityPeriodField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_CERT_VALID_DAYS"));
        }
        if (this.mode == 2) {
            this.certReqFileNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_CERTREQ_FILE"));
        }
    }

    private void layoutKeyInfoWithGridLayout() {
        this.keyInfoInputPanel = new JPanel();
        this.keyInfoInputPanel.setLayout(new GridLayout(11, 1));
        this.keyInfoInputPanel.add(this.titleLabel);
        this.keyInfoInputPanel.add(new JLabel());
        if (this.mode == 1) {
            this.keyInfoInputPanel.add(this.versionLabel);
            this.keyInfoInputPanel.add(this.certVersionChoice);
        }
        this.keyInfoInputPanel.add(this.keyLabelLabel);
        this.keyInfoInputPanel.add(this.labelField);
        this.keyInfoInputPanel.add(this.keySizeLabel);
        this.keyInfoInputPanel.add(this.keySizeChoice);
        this.keyInfoInputPanel.add(this.commonNameLabel);
        this.keyInfoInputPanel.add(this.commonNameField);
        this.keyInfoInputPanel.add(this.orgLabel);
        this.keyInfoInputPanel.add(this.orgField);
        this.keyInfoInputPanel.add(this.orgUnitLabel);
        this.keyInfoInputPanel.add(this.orgUnitField);
        this.keyInfoInputPanel.add(this.localityLabel);
        this.keyInfoInputPanel.add(this.localityField);
        this.keyInfoInputPanel.add(this.stateLabel);
        this.keyInfoInputPanel.add(this.stateField);
        this.keyInfoInputPanel.add(this.zipCodeLabel);
        this.keyInfoInputPanel.add(this.zipCodeField);
        this.keyInfoInputPanel.add(this.countryLabel);
        this.keyInfoInputPanel.add(this.countryCodeChoices);
        if (this.mode == 2) {
            this.keyInfoInputPanel.add(this.certReqFileNameLabel);
            this.keyInfoInputPanel.add(this.certReqFileNameField);
        }
    }

    public int getCertificateVersion() {
        return this.certVersion;
    }

    public void setCertificateVersion(int n) {
        if (n < 1 || n > CertificateItem.CERTIFICATE_VERSIONS.length) {
            return;
        }
        this.certVersionChoice.setSelectedIndex(CertificateItem.CERTIFICATE_VERSIONS.length - n);
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public void setKeyLabel(String string) {
        this.labelField.setText(string);
    }

    public String getCertReqFileName() {
        return this.certReqFileName;
    }

    public void setCertReqFileName(String string) {
        this.certReqFileNameField.setText(string);
        this.certReqFileName = string;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int n) {
        int n2 = 0;
        while (n2 < KEYSIZE_CHOICE.length) {
            if (n == KEYSIZE_CHOICE[n2]) {
                this.keySizeChoice.setSelectedIndex(n2);
                this.keySize = n;
                return;
            }
            ++n2;
        }
    }

    public DNItem getSubjectDNItem() {
        return this.subjectDNItem;
    }

    public int getNumberOfValidDays() {
        return this.numValidDays;
    }

    public void setSubjectDNItem(DNItem dNItem) {
        this.subjectDNItem = dNItem;
        this.commonNameField.setText(dNItem.getCommonName());
        this.orgField.setText(dNItem.getOrganization());
        this.orgUnitField.setText(dNItem.getOrganizationUnit());
        this.localityField.setText(dNItem.getLocality());
        this.stateField.setText(dNItem.getState());
        this.zipCodeField.setText(dNItem.getZipCode());
        this.countryCodeChoices.setSelectedItem(dNItem.getCountryName());
    }

    private boolean isInputValid() {
        this.invalidInputField = null;
        String string = this.labelField.getText();
        if (KMUtil.trimBlankSpace(string, true, true) == null) {
            this.invalidInputField = this.labelField;
            this.invalidInputFieldName = this.keyLabelLabel.getText();
        } else {
            string = this.commonNameField.getText();
            if (KMUtil.trimBlankSpace(string, true, true) == null) {
                this.invalidInputField = this.commonNameField;
                this.invalidInputFieldName = this.commonNameLabel.getText();
            } else {
                string = this.orgField.getText();
                if (KMUtil.trimBlankSpace(string, true, true) == null) {
                    this.invalidInputField = this.orgField;
                    this.invalidInputFieldName = this.orgLabel.getText();
                } else if (this.mode == 2) {
                    string = this.certReqFileNameField.getText();
                    if (KMUtil.trimBlankSpace(string, true, true) == null) {
                        this.invalidInputField = this.certReqFileNameField;
                        this.invalidInputFieldName = this.certReqFileNameLabel.getText();
                    }
                } else if (this.mode == 1) {
                    try {
                        this.numValidDays = Integer.parseInt(this.validityPeriodField.getText());
                        if (this.numValidDays <= 0 || this.numValidDays > 7300) {
                            this.invalidInputField = this.validityPeriodField;
                            this.invalidInputFieldName = this.validityPeriodLabel.getText();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.invalidInputField = this.validityPeriodField;
                        this.invalidInputFieldName = this.validityPeriodLabel.getText();
                    }
                }
            }
        }
        return this.invalidInputField == null;
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent var1_1) {
        block23: {
            block22: {
                block24: {
                    block21: {
                        var2_2 = var1_1.getSource();
                        var3_3 = var1_1.getActionCommand();
                        if (Ikeyman.printDebugMsg) {
                            Ikeyman.debugMsg("evt=" + var1_1 + ", arg=" + var3_3);
                        }
                        if (var2_2 instanceof JTextField || !(var2_2 instanceof KMButton)) break block23;
                        if (!var3_3.equals("OK")) break block24;
                        if (this.isInputValid()) {
                            if (this.mode == 1) {
                                this.certVersion = CertificateItem.CERTIFICATE_VERSIONS.length - this.certVersionChoice.getSelectedIndex();
                            }
                            var4_4 = this.labelField.getText();
                            this.keyLabel = KMUtil.trimBlankSpace(var4_4, true, true);
                            this.keySize = GenkeyDialog.KEYSIZE_CHOICE[this.keySizeChoice.getSelectedIndex()];
                            if (this.mode != 1) {
                                var4_4 = this.certReqFileNameField.getText();
                                this.certReqFileName = KMUtil.trimBlankSpace(var4_4, true, true);
                            } else {
                                this.certReqFileName = null;
                            }
                            var4_4 = this.commonNameField.getText();
                            v0 = KMUtil.trimBlankSpace(var4_4, true, true);
                            var4_4 = this.orgUnitField.getText();
                            v1 = KMUtil.trimBlankSpace(var4_4, true, true);
                            var4_4 = this.orgField.getText();
                            v2 = KMUtil.trimBlankSpace(var4_4, true, true);
                            var4_4 = this.localityField.getText();
                            v3 = KMUtil.trimBlankSpace(var4_4, true, true);
                            var4_4 = this.stateField.getText();
                            v4 = KMUtil.trimBlankSpace(var4_4, true, true);
                            var4_4 = this.zipCodeField.getText();
                            this.subjectDNItem = new DNItem(v0, v1, v2, v3, v4, KMUtil.trimBlankSpace(var4_4, true, true), (String)this.countryCodeChoices.getSelectedItem(), null, null);
                            if (this.mode == 1) {
                                try {
                                    this.numValidDays = Integer.parseInt(this.validityPeriodField.getText());
                                    if (this.numValidDays == 0) {
                                        this.validityPeriodField.setText("");
                                        this.validityPeriodField.requestFocus();
                                        return;
                                    }
                                }
                                catch (NumberFormatException v5) {
                                    this.validityPeriodField.setText("");
                                    this.validityPeriodField.requestFocus();
                                    return;
                                }
                            }
                            this.setVisible(false);
                            return;
                        }
                        if (this.invalidInputField == this.validityPeriodField && this.numValidDays > 7300) {
                            var4_5 = KMSystem.getNLSErrString("GSKKM_ERR_EXPIRE_DAYS_TOO_LARGE");
                        } else {
                            var5_7 = KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT");
                            var6_9 = new Object[]{this.invalidInputFieldName};
                            var4_5 = MessageFormat.format((String)var5_7, var6_9);
                        }
                        var5_7 = this;
                        if (!(var5_7 instanceof Frame)) ** GOTO lbl57
                        v6 = (Frame)var5_7;
                        break block21;
lbl-1000:
                        // 1 sources

                        {
                            if (!(var5_7 instanceof Frame)) continue;
                            v6 = (Frame)var5_7;
                            break block21;
lbl57:
                            // 2 sources

                            ** while ((var5_7 = var5_7.getParent()) != null)
                        }
lbl58:
                        // 1 sources

                        v6 = null;
                    }
                    KMFrame.errorHandler(v6, var4_5);
                    if (Ikeyman.printDebugMsg) {
                        Ikeyman.debugMsg("DEBUG......invalidInputField: " + this.invalidInputField);
                    }
                    this.invalidInputField.requestFocus();
                    return;
                }
                if (var3_3.equals("Cancel")) {
                    this.keyLabel = null;
                    this.subjectDNItem = null;
                    this.certReqFileName = null;
                    this.setVisible(false);
                    return;
                }
                if (var3_3.equals("Reset")) {
                    this.labelField.setText("");
                    this.keySizeChoice.setSelectedIndex(this.defIdx);
                    this.orgUnitField.setText("");
                    this.orgField.setText("");
                    this.localityField.setText("");
                    this.stateField.setText("");
                    this.zipCodeField.setText("");
                    this.commonNameField.setText(KMSystem.getHostName());
                    this.countryCodeChoices.setSelectedItem(KMSystem.getCountryName());
                    if (this.mode == 1) {
                        this.validityPeriodField.setText("365");
                    }
                    if (this.mode != 1) {
                        this.certReqFileNameField.setText(this.defaultCertReqFileFullPathName);
                        return;
                    }
                    this.certVersionChoice.setSelectedIndex(0);
                    return;
                }
                if (var3_3.equals("Help")) {
                    Ikeyman.showHelpWindow(this, "packages.html");
                    return;
                }
                if (!var3_3.equals("Browse")) break block23;
                if (Ikeyman.printDebugMsg) {
                    Ikeyman.debugMsg("Browse button is hit\n");
                }
                if (!((var4_6 = this) instanceof Frame)) ** GOTO lbl101
                v7 = (Frame)var4_6;
                break block22;
lbl-1000:
                // 1 sources

                {
                    if (!(var4_6 instanceof Frame)) continue;
                    v7 = (Frame)var4_6;
                    break block22;
lbl101:
                    // 2 sources

                    ** while ((var4_6 = var4_6.getParent()) != null)
                }
lbl102:
                // 1 sources

                v7 = null;
            }
            var4_6 = new FileDialog(v7, Ikeyman.getNLSResString("GUI_DIALOG_TITLE_CERTREQFILE"), 1);
            var4_6.setFile("*" + KeyDatabase.DEFAULT_BASE64_FILE_NAME_EXT);
            var4_6.setDirectory(this.currWorkingDirName);
            var5_8 = var4_6.getSize();
            var4_6.setLocation((Ikeyman.screenSize.width - var5_8.width) / 2, (Ikeyman.screenSize.height - var5_8.height) / 2);
            var4_6.setVisible(true);
            var6_10 = var4_6.getFile();
            if (var6_10 != null) {
                this.certReqFileNameField.setText(String.valueOf(var4_6.getDirectory()) + var6_10);
            }
            var4_6.dispose();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        Object object2 = itemEvent.getSource();
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("getItem=" + object + ", getSource=" + object2 + itemEvent.getStateChange());
        }
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.labelField.requestFocus();
    }

    static /* synthetic */ String access$0(GenkeyDialog genkeyDialog) {
        return genkeyDialog.keyLabel;
    }

    static /* synthetic */ void access$1(GenkeyDialog genkeyDialog, String string) {
        genkeyDialog.keyLabel = string;
    }

    static /* synthetic */ DNItem access$2(GenkeyDialog genkeyDialog) {
        return genkeyDialog.subjectDNItem;
    }

    static /* synthetic */ void access$3(GenkeyDialog genkeyDialog, DNItem dNItem) {
        genkeyDialog.subjectDNItem = dNItem;
    }

    static /* synthetic */ String access$4(GenkeyDialog genkeyDialog) {
        return genkeyDialog.certReqFileName;
    }

    static /* synthetic */ void access$5(GenkeyDialog genkeyDialog, String string) {
        genkeyDialog.certReqFileName = string;
    }

    static /* synthetic */ JLabel access$6(GenkeyDialog genkeyDialog) {
        return genkeyDialog.titleLabel;
    }

    static /* synthetic */ JLabel access$7(GenkeyDialog genkeyDialog) {
        return genkeyDialog.keyLabelLabel;
    }

    static /* synthetic */ JTextField access$8(GenkeyDialog genkeyDialog) {
        return genkeyDialog.labelField;
    }

    static /* synthetic */ int access$9(GenkeyDialog genkeyDialog) {
        return genkeyDialog.mode;
    }

    static /* synthetic */ JLabel access$10(GenkeyDialog genkeyDialog) {
        return genkeyDialog.versionLabel;
    }

    static /* synthetic */ JComboBox access$11(GenkeyDialog genkeyDialog) {
        return genkeyDialog.certVersionChoice;
    }

    static /* synthetic */ JLabel access$12(GenkeyDialog genkeyDialog) {
        return genkeyDialog.keySizeLabel;
    }

    static /* synthetic */ JComboBox access$13(GenkeyDialog genkeyDialog) {
        return genkeyDialog.keySizeChoice;
    }

    static /* synthetic */ JLabel access$14(GenkeyDialog genkeyDialog) {
        return genkeyDialog.commonNameLabel;
    }

    static /* synthetic */ JTextField access$15(GenkeyDialog genkeyDialog) {
        return genkeyDialog.commonNameField;
    }

    static /* synthetic */ JLabel access$16(GenkeyDialog genkeyDialog) {
        return genkeyDialog.orgLabel;
    }

    static /* synthetic */ JTextField access$17(GenkeyDialog genkeyDialog) {
        return genkeyDialog.orgField;
    }

    static /* synthetic */ JLabel access$18(GenkeyDialog genkeyDialog) {
        return genkeyDialog.orgUnitLabel;
    }

    static /* synthetic */ JLabel access$19(GenkeyDialog genkeyDialog) {
        return genkeyDialog.optionLabel1;
    }

    static /* synthetic */ JTextField access$20(GenkeyDialog genkeyDialog) {
        return genkeyDialog.orgUnitField;
    }

    static /* synthetic */ JLabel access$21(GenkeyDialog genkeyDialog) {
        return genkeyDialog.localityLabel;
    }

    static /* synthetic */ JLabel access$22(GenkeyDialog genkeyDialog) {
        return genkeyDialog.optionLabel2;
    }

    static /* synthetic */ JTextField access$23(GenkeyDialog genkeyDialog) {
        return genkeyDialog.localityField;
    }

    static /* synthetic */ JLabel access$24(GenkeyDialog genkeyDialog) {
        return genkeyDialog.stateLabel;
    }

    static /* synthetic */ JLabel access$25(GenkeyDialog genkeyDialog) {
        return genkeyDialog.optionLabel3;
    }

    static /* synthetic */ JTextField access$26(GenkeyDialog genkeyDialog) {
        return genkeyDialog.stateField;
    }

    static /* synthetic */ JLabel access$27(GenkeyDialog genkeyDialog) {
        return genkeyDialog.zipCodeLabel;
    }

    static /* synthetic */ JLabel access$28(GenkeyDialog genkeyDialog) {
        return genkeyDialog.optionLabel4;
    }

    static /* synthetic */ JTextField access$29(GenkeyDialog genkeyDialog) {
        return genkeyDialog.zipCodeField;
    }

    static /* synthetic */ JLabel access$30(GenkeyDialog genkeyDialog) {
        return genkeyDialog.countryLabel;
    }

    static /* synthetic */ JComboBox access$31(GenkeyDialog genkeyDialog) {
        return genkeyDialog.countryCodeChoices;
    }

    static /* synthetic */ JLabel access$32(GenkeyDialog genkeyDialog) {
        return genkeyDialog.validityPeriodLabel;
    }

    static /* synthetic */ JTextField access$33(GenkeyDialog genkeyDialog) {
        return genkeyDialog.validityPeriodField;
    }

    static /* synthetic */ JLabel access$34(GenkeyDialog genkeyDialog) {
        return genkeyDialog.daysLabel;
    }

    static /* synthetic */ JLabel access$35(GenkeyDialog genkeyDialog) {
        return genkeyDialog.certReqFileNameLabel;
    }

    static /* synthetic */ JTextField access$36(GenkeyDialog genkeyDialog) {
        return genkeyDialog.certReqFileNameField;
    }

    static /* synthetic */ KMButton access$37(GenkeyDialog genkeyDialog) {
        return genkeyDialog.browseButton;
    }

    class KeyInfoInputPanel
    extends JPanel {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();

        public KeyInfoInputPanel() {
            super(true);
            JSeparator jSeparator;
            GenkeyDialog.this = GenkeyDialog.this;
            this.setLayout(this.gbl);
            this.gbc.anchor = 17;
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 0.0;
            this.gbc.gridwidth = 0;
            JSeparator jSeparator2 = new JSeparator();
            this.gbl.setConstraints(jSeparator2, this.gbc);
            this.add(jSeparator2);
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.titleLabel, this.gbc);
            this.add(GenkeyDialog.this.titleLabel);
            this.gbc.insets = new Insets(5, 5, 2, 5);
            this.gbc.gridwidth = 3;
            this.gbl.setConstraints(GenkeyDialog.this.keyLabelLabel, this.gbc);
            this.add(GenkeyDialog.this.keyLabelLabel);
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.labelField, this.gbc);
            this.add(GenkeyDialog.this.labelField);
            this.gbc.insets = new Insets(2, 5, 2, 5);
            this.gbc.fill = 0;
            if (GenkeyDialog.this.mode == 1) {
                this.gbc.gridwidth = 3;
                this.gbl.setConstraints(GenkeyDialog.this.versionLabel, this.gbc);
                this.add(GenkeyDialog.this.versionLabel);
                this.gbc.gridwidth = 0;
                this.gbl.setConstraints(GenkeyDialog.this.certVersionChoice, this.gbc);
                this.add(GenkeyDialog.this.certVersionChoice);
            }
            this.gbc.fill = 0;
            this.gbc.gridwidth = 3;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.keySizeLabel, this.gbc);
            this.add(GenkeyDialog.this.keySizeLabel);
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.keySizeChoice, this.gbc);
            this.add(GenkeyDialog.this.keySizeChoice);
            this.gbc.gridwidth = 3;
            this.gbl.setConstraints(GenkeyDialog.this.commonNameLabel, this.gbc);
            this.add(GenkeyDialog.this.commonNameLabel);
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.commonNameField, this.gbc);
            this.add(GenkeyDialog.this.commonNameField);
            this.gbc.fill = 0;
            this.gbc.gridwidth = 3;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.orgLabel, this.gbc);
            this.add(GenkeyDialog.this.orgLabel);
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.orgField, this.gbc);
            this.add(GenkeyDialog.this.orgField);
            this.gbc.fill = 0;
            this.gbc.weightx = 0.0;
            this.gbc.gridwidth = 2;
            this.gbl.setConstraints(GenkeyDialog.this.orgUnitLabel, this.gbc);
            this.add(GenkeyDialog.this.orgUnitLabel);
            this.gbc.gridwidth = 1;
            this.gbl.setConstraints(GenkeyDialog.this.optionLabel1, this.gbc);
            this.add(GenkeyDialog.this.optionLabel1);
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.orgUnitField, this.gbc);
            this.add(GenkeyDialog.this.orgUnitField);
            this.gbc.fill = 0;
            this.gbc.gridwidth = 2;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.localityLabel, this.gbc);
            this.add(GenkeyDialog.this.localityLabel);
            this.gbc.gridwidth = 1;
            this.gbl.setConstraints(GenkeyDialog.this.optionLabel2, this.gbc);
            this.add(GenkeyDialog.this.optionLabel2);
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.localityField, this.gbc);
            this.add(GenkeyDialog.this.localityField);
            this.gbc.fill = 0;
            this.gbc.gridwidth = 2;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.stateLabel, this.gbc);
            this.add(GenkeyDialog.this.stateLabel);
            this.gbc.gridwidth = 1;
            this.gbl.setConstraints(GenkeyDialog.this.optionLabel3, this.gbc);
            this.add(GenkeyDialog.this.optionLabel3);
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.stateField, this.gbc);
            this.add(GenkeyDialog.this.stateField);
            this.gbc.gridwidth = 2;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.zipCodeLabel, this.gbc);
            this.add(GenkeyDialog.this.zipCodeLabel);
            this.gbc.gridwidth = 1;
            this.gbl.setConstraints(GenkeyDialog.this.optionLabel4, this.gbc);
            this.add(GenkeyDialog.this.optionLabel4);
            this.gbc.weightx = 0.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.zipCodeField, this.gbc);
            this.add(GenkeyDialog.this.zipCodeField);
            this.gbc.gridwidth = 3;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.countryLabel, this.gbc);
            this.add(GenkeyDialog.this.countryLabel);
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.countryCodeChoices, this.gbc);
            this.add(GenkeyDialog.this.countryCodeChoices);
            if (GenkeyDialog.this.mode == 1) {
                this.gbc.gridwidth = 3;
                this.gbc.weightx = 0.0;
                this.gbl.setConstraints(GenkeyDialog.this.validityPeriodLabel, this.gbc);
                this.add(GenkeyDialog.this.validityPeriodLabel);
                this.gbl.setConstraints(GenkeyDialog.this.validityPeriodField, this.gbc);
                this.add(GenkeyDialog.this.validityPeriodField);
                this.gbc.gridwidth = 0;
                this.gbl.setConstraints(GenkeyDialog.this.daysLabel, this.gbc);
                this.add(GenkeyDialog.this.daysLabel);
            }
            if (GenkeyDialog.this.mode == 2) {
                jSeparator = new JSeparator();
                this.gbc.weightx = 1.0;
                this.gbc.gridwidth = 0;
                this.gbc.insets = new Insets(10, 5, 10, 5);
                this.gbc.fill = 2;
                this.gbl.setConstraints(jSeparator, this.gbc);
                this.add(jSeparator);
                this.gbc.insets = new Insets(2, 5, 2, 5);
                this.gbc.weightx = 0.0;
                this.gbl.setConstraints(GenkeyDialog.this.certReqFileNameLabel, this.gbc);
                this.add(GenkeyDialog.this.certReqFileNameLabel);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)GenkeyDialog.this.certReqFileNameField, "Center");
                jPanel.add((Component)GenkeyDialog.this.browseButton, "East");
                this.gbc.weightx = 1.0;
                this.gbc.insets = new Insets(2, 10, 2, 5);
                this.gbl.setConstraints(jPanel, this.gbc);
                this.add(jPanel);
            }
            jSeparator = new JSeparator();
            this.gbc.insets = new Insets(10, 5, 10, 5);
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.fill = 2;
            this.gbl.setConstraints(jSeparator, this.gbc);
            this.add(jSeparator);
        }

        private void add(Component component, int n, int n2, float f, float f2, int n3, Insets insets) {
            this.gbc.anchor = n;
            this.gbc.fill = n2;
            this.gbc.weightx = f;
            this.gbc.weighty = f2;
            this.gbc.gridwidth = n3;
            this.gbc.insets = insets;
            this.gbl.setConstraints(component, this.gbc);
            this.add(component);
        }

        public Insets getInsets() {
            return new Insets(10, 10, 10, 10);
        }
    }

    class DiagAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            GenkeyDialog genkeyDialog = GenkeyDialog.this;
            genkeyDialog.keyLabel = null;
            genkeyDialog = GenkeyDialog.this;
            genkeyDialog.subjectDNItem = null;
            genkeyDialog = GenkeyDialog.this;
            genkeyDialog.certReqFileName = null;
            ((Component)GenkeyDialog.this).setVisible(false);
        }

        DiagAdapter() {
            GenkeyDialog.this = GenkeyDialog.this;
        }
    }
}

