/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.HtmlPanel;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;

public class HelpFrame
extends JFrame
implements ActionListener {
    public static final String CONTENT_HTML = "packages.html";
    private HtmlPanel htmlPanel;
    private JButton contentButton;
    private JButton backButton;
    private JButton forwardButton;
    private JButton searchButton;
    private JButton exitButton;
    private URL currentUrl;
    private int currentUrlIndex;
    private Vector urlHistory;

    public HelpFrame() {
        this(CONTENT_HTML);
    }

    public HelpFrame(URL uRL) {
        this(uRL == null ? CONTENT_HTML : uRL.getFile());
    }

    public HelpFrame(String string) {
        if (string == null) {
            this.currentUrl = HelpFrame.getURL(CONTENT_HTML);
        } else {
            this.currentUrl = HelpFrame.getURL(string);
            if (this.currentUrl == null) {
                this.currentUrl = HelpFrame.getURL(CONTENT_HTML);
            }
        }
        this.urlHistory = new Vector();
        this.currentUrlIndex = 0;
        this.urlHistory.addElement(this.currentUrl);
        this.setDefaultCloseOperation(2);
        ((Component)this).setBackground(Color.lightGray);
        this.setTitle(Ikeyman.getNLSResString("HELP_TITLE"));
        this.createMenuBar();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.htmlPanel = new HtmlPanel(this, this.currentUrl);
        KMHorizontalButtonPanel kMHorizontalButtonPanel = new KMHorizontalButtonPanel();
        kMHorizontalButtonPanel.setLayout(new FlowLayout(0));
        this.populateButtons();
        kMHorizontalButtonPanel.add(this.contentButton);
        kMHorizontalButtonPanel.add(this.backButton);
        kMHorizontalButtonPanel.add(this.forwardButton);
        kMHorizontalButtonPanel.add(this.searchButton);
        kMHorizontalButtonPanel.add(this.exitButton);
        kMHorizontalButtonPanel.equalizeButtons();
        container.add((Component)kMHorizontalButtonPanel, "North");
        container.add((Component)this.htmlPanel, "Center");
        container.validate();
        container.repaint();
    }

    protected void createMenuBar() {
    }

    protected void populateButtons() {
        this.contentButton = new JButton(Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CONTENTS"));
        this.backButton = new JButton(Ikeyman.getNLSResString("GUI_BUTTON_LABEL_BACK"));
        this.forwardButton = new JButton(Ikeyman.getNLSResString("GUI_BUTTON_LABEL_FORWARD"));
        this.searchButton = new JButton(Ikeyman.getNLSResString("GUI_BUTTON_LABEL_SEARCH"));
        this.exitButton = new JButton(Ikeyman.getNLSResString("GUI_BUTTON_LABEL_EXIT"));
        this.contentButton.setActionCommand("Content");
        this.backButton.setActionCommand("Back");
        this.forwardButton.setActionCommand("Forward");
        this.searchButton.setActionCommand("Search");
        this.exitButton.setActionCommand("Exit");
        this.contentButton.addActionListener(this);
        this.backButton.addActionListener(this);
        this.forwardButton.addActionListener(this);
        this.searchButton.addActionListener(this);
        this.exitButton.addActionListener(this);
    }

    public static URL getHomeURL() {
        return HelpFrame.getURL(CONTENT_HTML);
    }

    public static URL getURL(String string) {
        URL uRL;
        block5: {
            uRL = null;
            try {
                uRL = new URL(String.valueOf(Ikeyman.javaDocPath) + "/" + string);
                if (Ikeyman.printDebugMsg) {
                    Ikeyman.debugMsg("DEBUG......HelpFrame: htmlFileName=" + string + ", url=" + uRL);
                }
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                if (Ikeyman.printDebugMsg) {
                    Ikeyman.debugMsg("DEBUG......Malformed URL: " + malformedURLException);
                }
            }
            catch (IOException iOException) {
                if (!Ikeyman.printDebugMsg) break block5;
                Ikeyman.debugMsg("DEBUG......IOException: " + iOException);
            }
        }
        return uRL;
    }

    public synchronized URL getCurrentUrl() {
        return this.currentUrl;
    }

    public synchronized int getCurrentUrlIndex() {
        return this.currentUrlIndex;
    }

    public synchronized void setCurrentUrl(URL uRL) {
        this.currentUrl = uRL;
    }

    public synchronized Vector getUrlHistory() {
        return this.urlHistory;
    }

    protected synchronized URL getPrevUrl() {
        if (this.currentUrlIndex > 0) {
            return (URL)this.urlHistory.elementAt(this.currentUrlIndex - 1);
        }
        return null;
    }

    protected synchronized URL getCurrentUrlByIndex() {
        if (this.currentUrlIndex >= 0 && this.currentUrlIndex < this.urlHistory.size()) {
            return (URL)this.urlHistory.elementAt(this.currentUrlIndex);
        }
        return null;
    }

    protected synchronized URL getNextUrl() {
        if (this.currentUrlIndex < this.urlHistory.size() - 1) {
            return (URL)this.urlHistory.elementAt(this.currentUrlIndex + 1);
        }
        return null;
    }

    protected URL getContentUrl() {
        return HelpFrame.getURL(CONTENT_HTML);
    }

    protected synchronized void moveBack() {
        if (this.currentUrlIndex > 0) {
            --this.currentUrlIndex;
        }
    }

    protected synchronized void moveForward() {
        if (this.currentUrlIndex < this.urlHistory.size() - 1) {
            ++this.currentUrlIndex;
        }
    }

    protected synchronized void addNewLinkToHistory(URL uRL) {
        int n = this.currentUrlIndex + 1;
        while (n < this.urlHistory.size()) {
            this.urlHistory.removeElementAt(n);
            ++n;
        }
        this.urlHistory.addElement(uRL);
        ++this.currentUrlIndex;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......HelpFrame evt=" + actionEvent + ", arg=" + string);
        }
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......HelpFrame: history size=" + this.urlHistory.size() + ", currentUrlIndex=" + this.currentUrlIndex);
        }
        if (string.equals("Exit")) {
            this.dispose();
            return;
        }
        URL uRL = this.currentUrl;
        boolean bl = true;
        if (string.equals("Content")) {
            uRL = this.getContentUrl();
            if (uRL != null) {
                bl = false;
            }
        } else if (string.equals("Back")) {
            uRL = this.getPrevUrl();
        } else if (string.equals("Forward")) {
            uRL = this.getNextUrl();
        }
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......HelpFrame: url=" + uRL + ", currentUrl=" + this.currentUrl + ", currentUrlIndex=" + this.currentUrlIndex);
        }
        if (uRL != null && uRL != this.currentUrl) {
            this.htmlPanel.linkActivated(uRL, bl);
            this.currentUrl = uRL;
            if (bl) {
                if (string.equals("Back")) {
                    this.moveBack();
                    return;
                }
                if (string.equals("Forward")) {
                    this.moveForward();
                }
            }
        }
    }

    public void linkActivated(URL uRL, boolean bl) {
        this.htmlPanel.linkActivated(uRL, bl);
    }
}

