/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.HelpFrame;
import com.ibm.gsk.ikeyman.awt.PageLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class HtmlPanel
extends JPanel
implements HyperlinkListener {
    private JEditorPane html;
    private HelpFrame parent;

    public HtmlPanel(HelpFrame helpFrame, URL uRL) {
        this.parent = helpFrame;
        SoftBevelBorder softBevelBorder = new SoftBevelBorder(1);
        BevelBorder bevelBorder = new BevelBorder(0);
        this.setBorder(bevelBorder);
        this.setLayout(new BorderLayout());
        try {
            this.html = new JEditorPane(uRL);
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setBorder(softBevelBorder);
            JViewport jViewport = jScrollPane.getViewport();
            jViewport.add(this.html);
            jViewport.setBackingStoreEnabled(true);
            this.add((Component)jScrollPane, "Center");
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......htmlPanel hPolicy=" + jScrollPane.getHorizontalScrollBarPolicy());
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL: " + malformedURLException);
            return;
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
        }
    }

    JEditorPane getEditorPane() {
        return this.html;
    }

    public void linkActivated(URL uRL, boolean bl) {
        Cursor cursor = this.html.getCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor2);
        SwingUtilities.invokeLater(new PageLoader(this.parent, this.html, uRL, cursor, bl));
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......HelpFrame: link e=" + hyperlinkEvent + ", type=" + hyperlinkEvent.getEventType() + ", url=" + hyperlinkEvent.getURL());
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......HelpFrame: to activate url");
            }
            this.linkActivated(hyperlinkEvent.getURL(), false);
        }
    }
}

