/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMVerticalButtonPanel;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class KMKeyListDialog
extends JDialog
implements IkeymanConstants,
ActionListener {
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton helpButton;
    private JLabel listTitleLabel;
    private JPanel mainPanel = new JPanel();
    private JList list;
    private String[] selectedLabels;

    public KMKeyListDialog(Frame frame, String string) {
        this(frame, string, null);
    }

    public KMKeyListDialog(Frame frame, String string, Vector vector) {
        super(frame, string, true);
        this.populateFields(vector);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 10);
        gridBagLayout.setConstraints(this.listTitleLabel, gridBagConstraints);
        jPanel.add(this.listTitleLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        KMVerticalButtonPanel kMVerticalButtonPanel = new KMVerticalButtonPanel();
        kMVerticalButtonPanel.addButton(this.okButton);
        kMVerticalButtonPanel.addButton(this.cancelButton);
        kMVerticalButtonPanel.addButton(this.helpButton);
        kMVerticalButtonPanel.equalizeButtons();
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......KMKeyListDialog: to set mainPanel");
        }
        jPanel.setBackground(KMFrame.defaultBackgroundColor);
        kMVerticalButtonPanel.setBackground(KMFrame.defaultBackgroundColor);
        this.mainPanel.setBackground(KMFrame.defaultBackgroundColor);
        this.mainPanel.setLayout(new BorderLayout(20, 20));
        this.mainPanel.add((Component)jPanel, "Center");
        this.mainPanel.add((Component)kMVerticalButtonPanel, "East");
        BevelBorder bevelBorder = new BevelBorder(0);
        this.mainPanel.setBorder(bevelBorder);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.mainPanel, "Center");
        this.addWindowListener(new DiagAdapter());
        this.pack();
        this.setResizable(false);
        this.list.requestFocus();
    }

    protected void populateFields(Vector vector) {
        this.populateButtons();
        this.listTitleLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_SELECT_KEY_LABELS"));
        this.listTitleLabel.setFont(Ikeyman.defaultBoldFont);
        this.list = new JList(vector);
        this.list.addListSelectionListener(new JListSelectionListener());
        int n = 8;
        if (vector != null && vector.size() > n - 2) {
            n = vector.size() + 2;
        }
        this.list.setVisibleRowCount(n);
        this.setToolTips();
    }

    protected void populateButtons() {
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.helpButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_HELP"));
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("Cancel");
        this.helpButton.setActionCommand("Help");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        if (!Ikeyman.isHelpAvailable()) {
            this.helpButton.setEnabled(false);
        }
    }

    protected void setToolTips() {
    }

    public String[] getSelectedLabels() {
        return this.selectedLabels;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            Object[] objectArray = this.list.getSelectedValues();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            this.selectedLabels = new String[objectArray.length];
            int n = 0;
            while (n < this.selectedLabels.length) {
                if (Ikeyman.printDebugMsg) {
                    Ikeyman.debugMsg("DEBUG......selectedValues[" + n + "]=" + objectArray[n]);
                }
                this.selectedLabels[n] = (String)objectArray[n];
                ++n;
            }
            ((Component)this).setVisible(false);
            return;
        }
        if (string.equals("Cancel")) {
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("Cancel button is hit\n");
            }
            this.selectedLabels = null;
            ((Component)this).setVisible(false);
            return;
        }
        if (string.equals("Help")) {
            Ikeyman.showHelpWindow(this, "packages.html");
        }
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.okButton.requestFocus();
    }

    static /* synthetic */ String[] access$0(KMKeyListDialog kMKeyListDialog) {
        return kMKeyListDialog.selectedLabels;
    }

    static /* synthetic */ void access$1(KMKeyListDialog kMKeyListDialog, String[] stringArray) {
        kMKeyListDialog.selectedLabels = stringArray;
    }

    static /* synthetic */ KMButton access$2(KMKeyListDialog kMKeyListDialog) {
        return kMKeyListDialog.okButton;
    }

    class JListSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("DEBUG......JListSelectionListener is called, ListSelectionEvent=" + listSelectionEvent);
            }
            KMKeyListDialog kMKeyListDialog = KMKeyListDialog.this;
            kMKeyListDialog.okButton.requestFocus();
        }

        JListSelectionListener() {
            KMKeyListDialog.this = KMKeyListDialog.this;
        }
    }

    class DiagAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            KMKeyListDialog kMKeyListDialog = KMKeyListDialog.this;
            kMKeyListDialog.selectedLabels = null;
            ((Component)KMKeyListDialog.this).setVisible(false);
        }

        DiagAdapter() {
            KMKeyListDialog.this = KMKeyListDialog.this;
        }
    }
}

