/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.asn1.ASN1Exception;
import com.ibm.cfwk.CFWKException;
import com.ibm.cfwk.InterfaceErrorException;
import com.ibm.cfwk.tools.KeyCertGen;
import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperator;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.PrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabase;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.WEBDBKeyDatabase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class CMSKeyDatabase
extends KeyDatabase
implements KeyDatabaseOperator {
    public native int c_CreateNewKeyDb(String var1, String var2, long var3);

    public native int c_OpenKeyDb(String var1, String var2);

    public native int c_BuildKeyLabelList(String var1, String var2);

    public native KeyItem c_GetKeyItemByLabel(String var1, String var2, String var3, boolean var4);

    public native KeyItem c_GetDefaultKeyItem(String var1, String var2);

    public native KeyItem[] c_GetKeyItemsByPublicKey(String var1, String var2, int var3, byte[] var4);

    public native boolean c_ChangeKeyDbPwd(String var1, String var2, String var3, long var4);

    public static native boolean c_StashKeyDbPwd(String var0, String var1);

    public native int c_CreateNewSelfSigedCertificate(String var1, String var2, int var3, String var4, boolean var5, int var6, DNItem var7, int var8, String var9, boolean var10);

    public native int c_CreateNewCertRequest(String var1, String var2, String var3, int var4, DNItem var5, String var6, boolean var7);

    public native int c_IssueCertificate(String var1, String var2, String var3, int var4, String var5, int var6, String var7, String var8, boolean var9);

    public native boolean c_IsPrivateKeyPresent(String var1, String var2, String var3);

    public native int c_InsertKey(String var1, String var2, String var3, int var4, byte[] var5, int var6, byte[] var7, boolean var8, boolean var9);

    public native int c_InsertReqKey(String var1, String var2, String var3, int var4, byte[] var5, int var6, byte[] var7);

    public native int c_DeleteKeyByLabel(String var1, String var2, String var3, boolean var4);

    public native int c_SetDefaultKey(String var1, String var2, String var3);

    public native int c_SetKeyTrust(String var1, String var2, String var3, boolean var4);

    public native int c_ExportToPFXFile(String var1, String var2, String var3, String var4, String[] var5);

    public native int c_ImportFromPFXFile(String var1, String var2, String var3, String var4);

    public native int c_ReceiveCert(String var1, String var2, String var3, boolean var4, boolean var5);

    public native int c_AddCaCert(String var1, String var2, String var3, String var4, boolean var5);

    public native int c_ExtractCert(String var1, String var2, String var3, String var4, boolean var5);

    public native int c_ExtractCertReq(String var1, String var2, String var3, String var4);

    public native boolean c_CheckCertAsRenewal(String var1, String var2, int var3, byte[] var4);

    public native int c_RenewCert(String var1, String var2, int var3, byte[] var4);

    public static native int c_Kyr2Kdb(String var0, String var1, String var2, String var3);

    public static native int c_Kdb2Kyr(String var0, String var1, String var2, String var3);

    public native PrivateKeyInfoItem c_DecryptPrivateKey(int var1, byte[] var2, String var3);

    public native EncryptedPrivateKeyInfoItem c_EncryptPrivateKey(int var1, byte[] var2, String var3);

    public native KeyItem[] c_GetKeyItemListByLabel(String var1, String var2, String var3);

    public native CertificateItem[] c_ExtractCertFromPKCS7Data(String var1, boolean var2);

    public native boolean c_ValidateCertificateChain(String var1, String var2, byte[] var3, int var4);

    public CMSKeyDatabase() {
        this.type = 1;
        this.op = this;
    }

    public CMSKeyDatabase(KeyDatabase keyDatabase) {
        super(keyDatabase);
        this.type = 1;
        this.op = this;
    }

    public CMSKeyDatabase(String string, String string2) {
        super(1, string, string2);
        this.op = this;
    }

    public CMSKeyDatabase(String string, String string2, long l) {
        super(1, string, string2, l);
        this.op = this;
    }

    public void create() throws CMSKeyDatabaseException {
        int n = this.c_CreateNewKeyDb(this.keyDbFileName, this.keyDbPwd, this.keyDbPwdExpireTime);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_CREATE"));
        }
        this.buildKeyLabelList();
    }

    public void open() throws CMSKeyDatabaseException {
        int n = this.c_OpenKeyDb(this.keyDbFileName, this.keyDbPwd);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OPEN"));
        }
        this.buildKeyLabelList();
    }

    public void close() {
    }

    public void save() {
    }

    public void rename(String string) throws IOException {
        File file = new File(this.keyDbFileName);
        String string2 = file.getCanonicalPath();
        String string3 = KMUtil.changeFileNameExtension(string2, ".rdb");
        String string4 = KMUtil.changeFileNameExtension(string2, ".crl");
        File file2 = new File(string3);
        File file3 = new File(string4);
        File file4 = new File(string);
        String string5 = file4.getCanonicalPath();
        String string6 = KMUtil.changeFileNameExtension(string5, ".rdb");
        String string7 = KMUtil.changeFileNameExtension(string5, ".crl");
        File file5 = new File(string6);
        File file6 = new File(string7);
        if (file.exists()) {
            file.renameTo(file4);
        }
        if (file2.exists()) {
            file2.renameTo(file5);
        }
        if (file3.exists()) {
            file3.renameTo(file6);
        }
    }

    public void delete() throws IOException {
        String string;
        File file;
        String string2;
        File file2;
        File file3 = new File(this.keyDbFileName);
        String string3 = file3.getCanonicalPath();
        if (file3.exists()) {
            file3.delete();
        }
        if ((file2 = new File(string2 = KMUtil.changeFileNameExtension(string3, ".rdb"))).exists()) {
            file2.delete();
        }
        if ((file = new File(string = KMUtil.changeFileNameExtension(string3, ".crl"))).exists()) {
            file.delete();
        }
    }

    public void makeCopyFromKyr(WEBDBKeyDatabase wEBDBKeyDatabase) throws CMSKeyDatabaseException {
        try {
            String string = KMUtil.getTmpFileName(this.keyDbFileName, "_tmp" + KeyDatabase.DEFAULT_KEYDB_NAME_EXT_CMS);
            int n = CMSKeyDatabase.c_Kyr2Kdb(wEBDBKeyDatabase.getKeyDbFileName(), wEBDBKeyDatabase.getKeyDbPwd(), string, this.keyDbPwd);
            if (n != 0) {
                throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_KYR2KDB"));
            }
            CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string, this.keyDbPwd, 0L);
            cMSKeyDatabase.buildKeyLabelList();
            this.delete();
            this.copyKeyLabelLists(cMSKeyDatabase);
            cMSKeyDatabase.rename(this.keyDbFileName);
            return;
        }
        catch (IOException iOException) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void reCreate(KeyDatabase var1_1) throws CMSKeyDatabaseException {
        if (this.keyDbFileName == null || this.keyDbFileName.equals(var1_1.getKeyDbFileName())) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
        }
        var2_2 = (KeyDatabaseOperator)var1_1;
        try {
            block33: {
                block34: {
                    if (this.type == var1_1.getType()) break block33;
                    if (var1_1.getType() == 2) {
                        var3_3 = CMSKeyDatabase.c_Kyr2Kdb(var1_1.getKeyDbFileName(), var1_1.getKeyDbPwd(), this.keyDbFileName, this.keyDbPwd);
                        if (var3_3 != 0) {
                            throw new CMSKeyDatabaseException(var3_3, KMSystem.getNLSErrString("GSKKM_ERR_KYR2KDB"));
                        }
                        this.buildKeyLabelList();
                        return;
                    }
                    if (var1_1.getType() != 3) break block34;
                    var2_2.open();
                    this.create();
                    var3_4 = this.getKeyLabelList();
                    var4_9 = new String[30];
                    var5_11 = 0;
                    while (var5_11 < var3_4.size()) {
                        var4_9[var5_11] = (String)var3_4.elementAt(var5_11);
                        ++var5_11;
                    }
                    var6_13 = 0;
                    while (var6_13 < var4_9.length) {
                        this.deleteKeyByLabel(var4_9[var6_13]);
                        ++var6_13;
                    }
                    var7_15 = null;
                    var8_17 = new Enumeration[3];
                    var9_19 = var1_1.getCaCertLabelList();
                    if (var9_19 != null) {
                        var8_17[0] = var9_19.elements();
                    }
                    if ((var9_19 = var1_1.getMyCertLabelList()) != null) {
                        var8_17[1] = var9_19.elements();
                    }
                    if ((var9_19 = var1_1.getReqKeyLabelList()) != null) {
                        var8_17[2] = var9_19.elements();
                    }
                    var10_21 = 0;
                    while (var10_21 < 3) {
                        block35: {
                            if (var8_17[var10_21] != null) ** GOTO lbl57
                            break block35;
lbl-1000:
                            // 1 sources

                            {
                                var11_23 = (String)var8_17[var10_21].nextElement();
                                var12_25 = var2_2.getKeyItemByLabel(var11_23);
                                if (var12_25.isDefault()) {
                                    var7_15 = var12_25.getKeyLabel();
                                }
                                if (var12_25.hasPrivateKey()) {
                                    var13_27 = var12_25.getEncryptedPrivateKeyInfoItem();
                                    var14_29 = null;
                                    var15_31 = KeyCertGen.generatePrivateKeyInfo((byte[])var13_27.getEncoded(), (String)var1_1.getKeyDbPwd());
                                    var14_29 = new PrivateKeyInfoItem(var15_31);
                                    var16_33 = this.encryptPrivateKey(var14_29);
                                    var12_25.setEncryptedPrivateKeyInfoItem(var16_33);
                                }
                                if (var10_21 == 1 && var12_25.hasMultipleCertificateChain()) {
                                    var13_27 = var12_25.getKeyItemsForCertChain();
                                    this.insertKeyItemList(var13_27);
                                    continue;
                                }
                                this.insertKey(var12_25);
lbl57:
                                // 3 sources

                                ** while (var8_17[var10_21].hasMoreElements())
                            }
                        }
                        ++var10_21;
                    }
                    var2_2.close();
                    this.save();
                    if (var7_15 != null) {
                        this.setDefaultKey(var7_15);
                    }
                    this.buildKeyLabelList();
                    return;
                }
                throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
            }
            var3_5 = new File(var1_1.getKeyDbFileName());
            var4_10 = new File(this.keyDbFileName);
            var5_12 = var3_5.getCanonicalPath();
            var6_14 = KMUtil.changeFileNameExtension(var5_12, ".rdb");
            var7_16 = KMUtil.changeFileNameExtension(var5_12, ".crl");
            var8_18 = new File(var6_14);
            var9_20 = new File(var7_16);
            var10_22 = var4_10.getCanonicalPath();
            var11_24 = KMUtil.changeFileNameExtension(var10_22, ".rdb");
            var12_26 = KMUtil.changeFileNameExtension(var10_22, ".crl");
            var13_28 = new File(var11_24);
            var14_30 = new File(var12_26);
            var15_32 = var4_10.exists();
            var16_34 = null;
            var17_35 = null;
            try {
                var18_36 = new byte[512];
                var19_38 = 0;
                var16_34 = new FileInputStream(var3_5);
                var17_35 = new FileOutputStream(var4_10);
                while ((var19_38 = var16_34.read(var18_36)) > 0) {
                    var17_35.write(var18_36, 0, var19_38);
                    if (var19_38 > 0) continue;
                }
                var16_34.close();
                var17_35.close();
                if (var8_18.exists()) {
                    var16_34 = new FileInputStream(var8_18);
                    var17_35 = new FileOutputStream(var13_28);
                    while ((var19_38 = var16_34.read(var18_36)) > 0) {
                        var17_35.write(var18_36, 0, var19_38);
                        if (var19_38 > 0) continue;
                    }
                    var16_34.close();
                    var17_35.close();
                }
                if (var9_20.exists()) {
                    var16_34 = new FileInputStream(var9_20);
                    var17_35 = new FileOutputStream(var14_30);
                    while ((var19_38 = var16_34.read(var18_36)) > 0) {
                        var17_35.write(var18_36, 0, var19_38);
                        if (var19_38 > 0) continue;
                    }
                    var16_34.close();
                    var17_35.close();
                }
                this.copyKeyLabelLists(var1_1);
                return;
            }
            catch (IOException var18_37) {
                try {
                    if (var16_34 != null) {
                        var16_34.close();
                    }
                    if (var17_35 != null) {
                        var17_35.close();
                    }
                }
                catch (IOException var19_39) {
                    var19_39.printStackTrace();
                    throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
                }
                if (!var15_32 && var4_10.exists()) {
                    this.delete();
                }
                var18_37.printStackTrace();
                throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
            }
        }
        catch (InterfaceErrorException v0) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (CFWKException v1) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception v2) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (CMSKeyDatabaseException var3_6) {
            var3_6.printStackTrace();
            throw var3_6;
        }
        catch (KeyDatabaseException var3_7) {
            var3_7.printStackTrace();
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
        }
        catch (IOException var3_8) {
            var3_8.printStackTrace();
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
        }
    }

    public void changeKeyDbPwd(String string, long l) throws CMSKeyDatabaseException {
        this.changeKeyDbPwd(null, string, l);
    }

    public void changeKeyDbPwd(String string, String string2, long l) throws CMSKeyDatabaseException {
        if (string != null && !string.equals(this.keyDbPwd)) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_OLD_PASSWORD"));
        }
        if (this.c_ChangeKeyDbPwd(this.keyDbFileName, this.keyDbPwd, string2, l)) {
            this.keyDbPwd = string2;
            this.keyDbPwdExpireTime = l;
            return;
        }
        throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_PWDCHG"));
    }

    public static boolean stashKeyDbPwd(String string, String string2) {
        boolean bl = false;
        if (string == null || string2 == null || string2.length() == 0 || string.length() == 0) {
            return false;
        }
        bl = CMSKeyDatabase.c_StashKeyDbPwd(string, string2);
        return bl;
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, String string2, boolean bl2) throws CMSKeyDatabaseException {
        int n4 = this.c_CreateNewSelfSigedCertificate(this.keyDbFileName, this.keyDbPwd, n - 1, string, bl, n2, dNItem, n3, string2, bl2);
        if (n4 != 0) {
            throw new CMSKeyDatabaseException(n4, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_NEW_SSCERT"));
        }
        this.addKeyLabelAt(string, 0);
        this.addMyCertLabelAt(string, 0);
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, String string2, boolean bl) throws CMSKeyDatabaseException {
        int n2 = this.c_CreateNewCertRequest(this.keyDbFileName, this.keyDbPwd, string, n, dNItem, string2, bl);
        if (n2 != 0) {
            throw new CMSKeyDatabaseException(n2, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_NEW_CERTREQ"));
        }
        if (bl) {
            this.addReqKeyLabelAt(string, 0);
        }
    }

    public void issueCertificate(String string, int n, String string2, int n2, String string3, String string4, boolean bl) throws CMSKeyDatabaseException {
        int n3 = this.c_IssueCertificate(this.keyDbFileName, this.keyDbPwd, string, n - 1, string2, n2, string3, string4, bl);
        if (n3 != 0) {
            throw new CMSKeyDatabaseException(n3);
        }
    }

    public boolean isPrivateKeyPresent(String string) {
        return this.c_IsPrivateKeyPresent(this.keyDbFileName, this.keyDbPwd, string);
    }

    public void buildKeyLabelList() throws CMSKeyDatabaseException {
        if (this.keyLabelList != null) {
            return;
        }
        this.keyLabelList = new Vector();
        int n = this.c_BuildKeyLabelList(this.keyDbFileName, this.keyDbPwd);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
        }
        this.classifyKeyLabels();
    }

    public void classifyKeyLabels() {
        this.myCertLabelList = null;
        this.caCertLabelList = null;
        if (this.keyLabelList == null) {
            return;
        }
        int n = this.keyLabelList.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.keyLabelList.elementAt(n2);
            if (this.isPrivateKeyPresent(string)) {
                this.addMyCertLabel(string);
            } else {
                this.addCaCertLabel(string);
            }
            ++n2;
        }
    }

    public void refreshKeyLabelList() throws CMSKeyDatabaseException {
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
        } else {
            this.keyLabelList.removeAllElements();
        }
        if (this.reqKeyLabelList == null) {
            this.reqKeyLabelList = new Vector();
        } else {
            this.reqKeyLabelList.removeAllElements();
        }
        int n = this.c_BuildKeyLabelList(this.keyDbFileName, this.keyDbPwd);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
        }
        this.classifyKeyLabels();
    }

    public KeyItem getKeyItemByLabel(String string) throws CMSKeyDatabaseException {
        KeyItem keyItem;
        boolean bl = false;
        if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
            bl = true;
        }
        if ((keyItem = this.c_GetKeyItemByLabel(this.keyDbFileName, this.keyDbPwd, string, bl)) == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_LABEL"));
        }
        return keyItem;
    }

    public Vector getKeyItemsByPublicKey(BERObject bERObject) throws CMSKeyDatabaseException {
        byte[] byArray = bERObject.getEncoded();
        int n = bERObject.getLength();
        KeyItem[] keyItemArray = this.c_GetKeyItemsByPublicKey(this.keyDbFileName, this.keyDbPwd, n, byArray);
        if (keyItemArray == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_PUBKEY"));
        }
        Vector<KeyItem> vector = new Vector<KeyItem>(keyItemArray.length);
        int n2 = 0;
        while (n2 < keyItemArray.length) {
            vector.addElement(keyItemArray[n2]);
            ++n2;
        }
        return vector;
    }

    public KeyItem getDefaultKeyItem() throws CMSKeyDatabaseException {
        KeyItem keyItem = this.c_GetDefaultKeyItem(this.keyDbFileName, this.keyDbPwd);
        if (keyItem == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_DEFAULT_KEY"));
        }
        return keyItem;
    }

    public synchronized KeyItem getFirstKeyItem() throws CMSKeyDatabaseException {
        this.currentKeyIndex = 0;
        if (this.keyLabelList == null) {
            return null;
        }
        String string = (String)this.keyLabelList.elementAt(0);
        if (string == null) {
            return null;
        }
        return this.getKeyItemByLabel(string);
    }

    public synchronized KeyItem getNextKeyItem() throws CMSKeyDatabaseException {
        ++this.currentKeyIndex;
        if (this.currentKeyIndex < this.keyLabelList.size()) {
            String string = (String)this.keyLabelList.elementAt(this.currentKeyIndex);
            if (string == null) {
                return null;
            }
            return this.getKeyItemByLabel(string);
        }
        return null;
    }

    public void deleteKeyByLabel(String string) throws CMSKeyDatabaseException {
        int n;
        if (string == null) {
            return;
        }
        boolean bl = false;
        if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
            bl = true;
        }
        if ((n = this.c_DeleteKeyByLabel(this.keyDbFileName, this.keyDbPwd, string, bl)) != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_DELETE"));
        }
        if (bl) {
            this.reqKeyLabelList.removeElement(string);
            return;
        }
        this.keyLabelList.removeElement(string);
        if (this.caCertLabelList != null && this.caCertLabelList.contains(string)) {
            this.caCertLabelList.removeElement(string);
            return;
        }
        if (this.myCertLabelList != null && this.myCertLabelList.contains(string)) {
            this.myCertLabelList.removeElement(string);
            return;
        }
        throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_LABEL_LIST_CORRUPT"));
    }

    public void insertKey(KeyItem keyItem) throws CMSKeyDatabaseException {
        byte[] byArray;
        CertificateRequestItem certificateRequestItem;
        int n;
        int n2 = 0;
        if (keyItem == null) {
            return;
        }
        String string = keyItem.getKeyLabel();
        int n3 = 0;
        byte[] byArray2 = null;
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = keyItem.getEncryptedPrivateKeyInfoItem();
        if (encryptedPrivateKeyInfoItem != null) {
            byArray2 = encryptedPrivateKeyInfoItem.getEncoded();
            n3 = encryptedPrivateKeyInfoItem.getLength();
        }
        if (keyItem.hasCertificate()) {
            boolean bl;
            boolean bl2;
            byte[] byArray3;
            CertificateItem certificateItem = (CertificateItem)keyItem.getCertificateChain().elementAt(0);
            int n4 = certificateItem.getLength();
            n2 = this.c_InsertKey(this.keyDbFileName, this.keyDbPwd, string, n4, byArray3 = certificateItem.getEncoded(), n3, byArray2, bl2 = keyItem.isTrusted(), bl = keyItem.isDefault());
            if (n2 == 0) {
                this.addKeyLabelAt(string, 0);
                if (n3 > 0) {
                    this.addMyCertLabelAt(string, 0);
                } else {
                    this.addCaCertLabelAt(string, 0);
                }
            }
        } else if (keyItem.getCertificateRequestItem() != null && (n2 = this.c_InsertReqKey(this.keyDbFileName, this.keyDbPwd, string, n = (certificateRequestItem = keyItem.getCertificateRequestItem()).getLength(), byArray = certificateRequestItem.getEncoded(), n3, byArray2)) == 0) {
            this.addReqKeyLabelAt(string, 0);
        }
        if (n2 != 0) {
            throw new CMSKeyDatabaseException(n2, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
    }

    public void setDefaultKey(String string) throws CMSKeyDatabaseException {
        int n = this.c_SetDefaultKey(this.keyDbFileName, this.keyDbPwd, string);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SET_DEFAULT_KEY"));
        }
    }

    public void setKeyTrust(String string, boolean bl) throws CMSKeyDatabaseException {
        int n = this.c_SetKeyTrust(this.keyDbFileName, this.keyDbPwd, string, bl);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SET_TRUST_KEY"));
        }
    }

    public void exportToPFXFile(String string, String string2, String[] stringArray) throws CMSKeyDatabaseException {
        int n = this.c_ExportToPFXFile(this.keyDbFileName, this.keyDbPwd, string, string2, stringArray);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
        }
    }

    public void importFromPFXFile(String string, String string2) throws CMSKeyDatabaseException {
        int n = this.c_ImportFromPFXFile(this.keyDbFileName, this.keyDbPwd, string, string2);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_IMPORT_KEY_FROM_PFX"));
        }
        this.refreshKeyLabelList();
    }

    public KeyItem[] getKeyItemListByLabel(String string) throws CMSKeyDatabaseException {
        KeyItem[] keyItemArray = this.c_GetKeyItemListByLabel(this.keyDbFileName, this.keyDbPwd, string);
        if (keyItemArray == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
        }
        return keyItemArray;
    }

    public PrivateKeyInfoItem decryptPrivateKey(EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem) throws CMSKeyDatabaseException {
        PrivateKeyInfoItem privateKeyInfoItem = null;
        byte[] byArray = null;
        int n = 0;
        if (encryptedPrivateKeyInfoItem != null) {
            byArray = encryptedPrivateKeyInfoItem.getEncoded();
            n = encryptedPrivateKeyInfoItem.getLength();
            privateKeyInfoItem = this.c_DecryptPrivateKey(n, byArray, this.keyDbPwd);
        }
        if (privateKeyInfoItem == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
        }
        return privateKeyInfoItem;
    }

    public EncryptedPrivateKeyInfoItem encryptPrivateKey(PrivateKeyInfoItem privateKeyInfoItem) throws CMSKeyDatabaseException {
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = null;
        byte[] byArray = null;
        int n = 0;
        if (privateKeyInfoItem != null) {
            byArray = privateKeyInfoItem.getEncoded();
            n = privateKeyInfoItem.getLength();
            encryptedPrivateKeyInfoItem = this.c_EncryptPrivateKey(n, byArray, this.keyDbPwd);
        }
        if (encryptedPrivateKeyInfoItem == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_IMPORT_KEY_FROM_PFX"));
        }
        return encryptedPrivateKeyInfoItem;
    }

    public String resolveLabelConflict(KeyItem keyItem) {
        int n = 0;
        KeyItem keyItem2 = null;
        Vector vector = this.getKeyLabelList();
        String string = keyItem.getKeyLabel();
        if (string == null) {
            CertificateItem certificateItem;
            DNItem dNItem;
            if (keyItem.hasCertificate() && (dNItem = (certificateItem = (CertificateItem)keyItem.getCertificateChain().elementAt(0)).getSubject()) != null) {
                string = dNItem.getCommonName();
            }
            if (string == null || string.equals("")) {
                string = "Dummy Key Label_" + Integer.toString(Math.abs(new Random().nextInt()));
            }
        }
        if (vector != null && vector.contains(string)) {
            keyItem2 = null;
            try {
                keyItem2 = this.getKeyItemByLabel(string);
            }
            catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
                keyItem2 = null;
            }
            if (keyItem2 != null && !keyItem.equalsCert(keyItem2)) {
                while (vector.contains(string) && n < 1000) {
                    string = String.valueOf(string) + "_" + Integer.toString(new Random().nextInt());
                    ++n;
                }
            } else {
                string = null;
            }
        }
        return string;
    }

    public boolean[] insertKeyItemList(KeyItem[] keyItemArray) throws CMSKeyDatabaseException {
        return this.insertKeyItemList(keyItemArray, false);
    }

    /*
     * Unable to fully structure code
     */
    public boolean[] insertKeyItemList(KeyItem[] var1_1, boolean var2_2) throws CMSKeyDatabaseException {
        var3_3 = null;
        if (var1_1 != null && var1_1.length > 0) {
            var3_3 = new boolean[var1_1.length];
            var4_4 = var1_1.length - 1;
            while (var4_4 >= 0) {
                block12: {
                    var3_3[var4_4] = false;
                    if (var1_1[var4_4].getKeyLabel() == null && !var2_2) {
                        var1_1[var4_4].setKeyLabel(this.resolveLabelConflict(var1_1[var4_4]));
                    }
                    if (var1_1[var4_4].getKeyLabel() != null) {
                        try {
                            var1_1[var4_4].setTrusted(true);
                            this.insertKey(var1_1[var4_4]);
                            var3_3[var4_4] = true;
                            break block12;
                        }
                        catch (CMSKeyDatabaseException var5_5) {
                            var6_6 = var5_5.getErrCode();
                            var7_7 = CMSKeyDatabaseException.getErrKey(var6_6);
                            if (var7_7.equals("GSKKM_ERR_DATABASE_DUPLICATE_KEY")) {
                                var3_3[var4_4] = false;
                                if (var4_4 == 0) {
                                    throw var5_5;
                                }
                                break block12;
                            }
                            var3_3[var4_4] = false;
                            var8_8 = var1_1.length - 1;
                            ** while (var8_8 >= var4_4)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (var3_3[var8_8]) {
                                try {
                                    this.deleteKeyByLabel(var1_1[var8_8].getKeyLabel());
                                    var3_3[var8_8] = false;
                                }
                                catch (CMSKeyDatabaseException v0) {}
                            }
                            --var8_8;
                            continue;
                        }
lbl34:
                        // 1 sources

                        throw var5_5;
                    }
                }
                --var4_4;
            }
        }
        return var3_3;
    }

    public void receiveCertificate(String string, boolean bl, boolean bl2) throws CMSKeyDatabaseException {
        int n = this.c_ReceiveCert(this.keyDbFileName, this.keyDbPwd, string, bl, bl2);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
        }
        this.refreshKeyLabelList();
    }

    public void addCACertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        int n = this.c_AddCaCert(this.keyDbFileName, this.keyDbPwd, string, string2, bl);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_STORE"));
        }
        this.addCaCertLabelAt(string, 0);
        this.addKeyLabelAt(string, 0);
    }

    public void extractCertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        int n = this.c_ExtractCert(this.keyDbFileName, this.keyDbPwd, string, string2, bl);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYREC_EXTRACT_CERT"));
        }
    }

    public void extractCertificateRequest(String string, String string2) throws CMSKeyDatabaseException {
        int n = this.c_ExtractCertReq(this.keyDbFileName, this.keyDbPwd, string, string2);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
        }
    }

    public boolean checkCertAsRenewal(String string, boolean bl) throws CMSKeyDatabaseException {
        byte[] byArray = null;
        try {
            byArray = bl ? SSLightKeyDatabase.base64DearmorFileToBuf(string) : SSLightKeyDatabase.fileToBuf(string);
        }
        catch (SSLightKeyDatabaseException sSLightKeyDatabaseException) {
            throw new CMSKeyDatabaseException(0, KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        if (byArray != null && byArray.length > 0) {
            return this.c_CheckCertAsRenewal(this.keyDbFileName, this.keyDbPwd, byArray.length, byArray);
        }
        throw new CMSKeyDatabaseException(0, KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT"));
    }

    public void renewCert(String string, boolean bl) throws CMSKeyDatabaseException {
        byte[] byArray = null;
        int n = 0;
        try {
            byArray = bl ? SSLightKeyDatabase.base64DearmorFileToBuf(string) : SSLightKeyDatabase.fileToBuf(string);
        }
        catch (SSLightKeyDatabaseException sSLightKeyDatabaseException) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        if (byArray != null && byArray.length > 0) {
            n = this.c_RenewCert(this.keyDbFileName, this.keyDbPwd, byArray.length, byArray);
            if (n != 0) {
                throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_RENEW_CERT"));
            }
        } else {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT"));
        }
    }

    public CertificateItem[] receivePKCS7CertChain(String string, boolean bl) throws CMSKeyDatabaseException {
        if (string == null) {
            throw new CMSKeyDatabaseException(0, KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT"));
        }
        CertificateItem[] certificateItemArray = this.c_ExtractCertFromPKCS7Data(string, bl);
        if (certificateItemArray != null) {
            return certificateItemArray;
        }
        throw new CMSKeyDatabaseException(0, KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT"));
    }

    public void addSiteCertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    public boolean ValidateKeyItemList(KeyItem[] keyItemArray) {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = keyItemArray.length;
        Vector vector = null;
        CertificateItem certificateItem = null;
        CertificateItem[] certificateItemArray = new CertificateItem[n4];
        CertificateItem[] certificateItemArray2 = new CertificateItem[n4];
        System.out.println("Start ValidateKeyItemList()");
        int n5 = 0;
        while (n5 < n4) {
            vector = keyItemArray[n5].getCertificateChain();
            certificateItem = (CertificateItem)vector.elementAt(0);
            n += certificateItem.berData.length;
            certificateItemArray[n5] = certificateItem;
            ++n5;
        }
        if (n == 0) {
            return false;
        }
        System.out.println("The total cert length is " + n);
        DNItem dNItem = null;
        DNItem dNItem2 = null;
        DNItem dNItem3 = null;
        n5 = 0;
        while (n5 < n4) {
            dNItem2 = certificateItemArray[n5].getSubject();
            dNItem = certificateItemArray[n5].getIssuer();
            if (dNItem2.toString().equals(dNItem.toString())) {
                n2 = n4 - 1;
                certificateItemArray2[n2] = certificateItemArray[n5];
                n3 = n5;
                dNItem3 = dNItem;
                break;
            }
            ++n5;
        }
        if (n3 == -1) {
            System.out.println("Root not found in the chain, validation failed..");
            return false;
        }
        if (n4 != 1) {
            n5 = 0;
            while (n2 != 0) {
                if (n5 != n3 && (dNItem = certificateItemArray[n5].getIssuer()).toString().equals(dNItem3.toString())) {
                    certificateItemArray2[--n2] = certificateItemArray[n5];
                    dNItem3 = certificateItemArray[n5].getSubject();
                }
                if (++n5 != n4) continue;
                n5 = 0;
            }
        }
        byte[] byArray = new byte[n + n4 * 3];
        int n6 = 0;
        n5 = 0;
        while (n5 < n4) {
            int n7 = 3;
            do {
                byArray[n6++] = (byte)(certificateItemArray2[n5].berData.length >>> --n7 * 8);
            } while (n7 > 0);
            System.arraycopy(certificateItemArray2[n5].berData, 0, byArray, n6, certificateItemArray2[n5].berData.length);
            n6 += certificateItemArray2[n5].berData.length;
            ++n5;
        }
        System.out.println("Upon to call ValidateCertificateChain()");
        return this.ValidateCertificateChain(byArray);
    }

    public boolean ValidateCertificateChain(byte[] byArray) {
        int n = byArray.length;
        System.out.println("Start ValidateCertificateChain() with byte length " + n);
        return this.c_ValidateCertificateChain(this.keyDbFileName, this.keyDbPwd, byArray, n);
    }
}

