/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;

public class CMSKeyDatabaseException
extends KeyDatabaseException {
    public static final int GSKKM_ERR_SUCCESS = 0;
    public static int MAX_CMS_KEYDB_ERR_CODE;
    public static int MIN_CMS_KEYDB_ERR_CODE;
    public static Hashtable errKeyTable;
    protected int errCode = 0;

    public static native boolean c_BuildErrCodeNameTable();

    public CMSKeyDatabaseException() {
        this(0);
    }

    public CMSKeyDatabaseException(int n) {
        this(n, null);
    }

    public CMSKeyDatabaseException(String string) {
        this(0, string);
    }

    public CMSKeyDatabaseException(int n, String string) {
        super(string);
        if (errKeyTable == null) {
            try {
                CMSKeyDatabaseException.buildErrCodeNameTable();
            }
            catch (KMException kMException) {
                kMException.printStackTrace();
            }
        }
        this.errCode = n;
        this.setErrCodeName(CMSKeyDatabaseException.getErrKey(n));
        KMSystem.verboseMsg(this.toString());
    }

    public static void buildErrCodeNameTable() throws KMException {
        boolean bl = CMSKeyDatabaseException.c_BuildErrCodeNameTable();
        if (!bl) {
            String string = KMSystem.getNLSErrString("GSKKM_ERR_CMS_ERRNAME_TABLE");
            Object[] objectArray = new Object[]{"ikmjni"};
            String string2 = MessageFormat.format(string, objectArray);
            throw new KMException(string2);
        }
    }

    public static boolean addCMSErrCode(int n, String string) {
        if (n <= 0 || string == null) {
            return false;
        }
        if (errKeyTable == null) {
            errKeyTable = new Hashtable();
        }
        errKeyTable.put(new Integer(n), string);
        MAX_CMS_KEYDB_ERR_CODE = MAX_CMS_KEYDB_ERR_CODE >= n ? MAX_CMS_KEYDB_ERR_CODE : n;
        return true;
    }

    public static boolean isValidCMSKeyDbErrCode(int n) {
        return errKeyTable.containsKey(new Integer(n));
    }

    public static String getErrKey(int n) {
        if (errKeyTable.containsKey(new Integer(n))) {
            return (String)errKeyTable.get(new Integer(n));
        }
        String string = KMSystem.getNLSErrString("GSKKM_MSG_V_ERRNAME_NOT_FOUND");
        Object[] objectArray = new Object[]{String.valueOf(n)};
        String string2 = MessageFormat.format(string, objectArray);
        KMSystem.verboseMsg(string2);
        return null;
    }

    public static String getNLSErrStringByErrCode(int n) {
        String string = null;
        String string2 = CMSKeyDatabaseException.getErrKey(n);
        if (string2 != null) {
            try {
                string = KMSystem.getNLSErrString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                String string3 = KMSystem.getNLSErrString("GSKKM_MSG_V_ERRMSG_NOT_FOUND2");
                Object[] objectArray = new Object[]{String.valueOf(n), string2};
                String string4 = MessageFormat.format(string3, objectArray);
                KMSystem.verboseMsg(string4);
                string = null;
            }
        }
        return string;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int n) {
        this.errCode = n;
    }

    public String getNLSErrString() {
        String string = null;
        if (this.errCode != 0) {
            string = CMSKeyDatabaseException.getNLSErrStringByErrCode(this.errCode);
        }
        if (string == null) {
            string = super.getNLSErrString();
        }
        if (string == null) {
            string = "Can not find NLS error message for " + this.toString();
        }
        return string;
    }

    public String toString() {
        return this.paramString();
    }

    public String paramString() {
        return String.valueOf(super.toString()) + ", " + this.errCode;
    }

    static {
        MIN_CMS_KEYDB_ERR_CODE = 1;
        errKeyTable = null;
    }
}

