/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class AbstractAction
implements Action,
Cloneable,
Serializable {
    protected boolean enabled = true;
    private ArrayTable arrayTable = new ArrayTable();
    protected SwingPropertyChangeSupport changeSupport;

    public AbstractAction() {
    }

    public AbstractAction(String string) {
        this.putValue("Name", string);
    }

    public AbstractAction(String string, Icon icon) {
        this(string);
        this.putValue("SmallIcon", icon);
    }

    public abstract void actionPerformed(ActionEvent var1);

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractAction abstractAction = (AbstractAction)super.clone();
        abstractAction.arrayTable = (ArrayTable)this.arrayTable.clone();
        return abstractAction;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public Object getValue(String string) {
        return this.arrayTable.get(string);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void putValue(String string, Object object) {
        Object object2 = null;
        if (this.arrayTable.containsKey(string)) {
            object2 = this.arrayTable.get(string);
        }
        if (object == null) {
            this.arrayTable.remove(string);
        } else {
            this.arrayTable.put(string, object);
        }
        this.firePropertyChange(string, object2, object);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        this.firePropertyChange("enabled", new Boolean(bl2), new Boolean(bl));
    }

    private class ArrayTable
    implements Cloneable,
    Serializable {
        private Object table = null;

        ArrayTable() {
        }

        public synchronized Object clone() {
            ArrayTable arrayTable = new ArrayTable();
            if (this.isArray()) {
                Object[] objectArray = (Object[])this.table;
                int n = 0;
                while (n < objectArray.length - 1) {
                    arrayTable.put(objectArray[n], objectArray[n + 1]);
                    n += 2;
                }
            } else {
                Hashtable hashtable = (Hashtable)this.table;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    arrayTable.put(k, hashtable.get(k));
                }
            }
            return arrayTable;
        }

        public boolean containsKey(Object object) {
            boolean bl = false;
            if (this.table != null) {
                if (this.isArray()) {
                    Object[] objectArray = (Object[])this.table;
                    int n = 0;
                    while (n < objectArray.length - 1) {
                        if (objectArray[n].equals(object)) {
                            bl = true;
                            break;
                        }
                        n += 2;
                    }
                } else {
                    bl = ((Hashtable)this.table).containsKey(object);
                }
            }
            return bl;
        }

        public Object get(Object object) {
            Object object2 = null;
            if (this.table != null) {
                if (this.isArray()) {
                    Object[] objectArray = (Object[])this.table;
                    int n = 0;
                    while (n < objectArray.length - 1) {
                        if (objectArray[n].equals(object)) {
                            object2 = objectArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                } else {
                    object2 = ((Hashtable)this.table).get(object);
                }
            }
            return object2;
        }

        private void grow() {
            Object[] objectArray = (Object[])this.table;
            Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(objectArray.length / 2);
            int n = 0;
            while (n < objectArray.length) {
                hashtable.put(objectArray[n], objectArray[n + 1]);
                n += 2;
            }
            this.table = hashtable;
        }

        private boolean isArray() {
            return this.table instanceof Object[];
        }

        public synchronized void put(Object object, Object object2) {
            if (this.table == null) {
                this.table = new Object[]{object, object2};
            } else {
                int n = this.size();
                if (n < 8) {
                    if (this.containsKey(object)) {
                        Object[] objectArray = (Object[])this.table;
                        int n2 = 0;
                        while (n2 < objectArray.length - 1) {
                            if (objectArray[n2].equals(object)) {
                                objectArray[n2 + 1] = object2;
                                break;
                            }
                            n2 += 2;
                        }
                    } else {
                        Object[] objectArray = (Object[])this.table;
                        int n3 = objectArray.length;
                        Object[] objectArray2 = new Object[n3 + 2];
                        System.arraycopy(objectArray, 0, objectArray2, 0, n3);
                        objectArray2[n3] = object;
                        objectArray2[n3 + 1] = object2;
                        this.table = objectArray2;
                    }
                } else {
                    if (n == 8) {
                        this.grow();
                    }
                    ((Hashtable)this.table).put(object, object2);
                }
            }
        }

        public synchronized Object remove(Object object) {
            Object object2 = null;
            if (object == null) {
                return null;
            }
            if (this.table != null) {
                if (this.isArray()) {
                    int n = -1;
                    Object[] objectArray = (Object[])this.table;
                    int n2 = objectArray.length - 2;
                    while (n2 >= 0) {
                        if (objectArray[n2].equals(object)) {
                            n = n2;
                            object2 = objectArray[n2 + 1];
                            break;
                        }
                        n2 -= 2;
                    }
                    if (n != -1) {
                        Object[] objectArray2 = new Object[objectArray.length - 2];
                        System.arraycopy(objectArray, 0, objectArray2, 0, n);
                        if (n < objectArray2.length) {
                            System.arraycopy(objectArray, n + 2, objectArray2, n, objectArray2.length - n);
                        }
                        this.table = objectArray2.length == 0 ? null : objectArray2;
                    }
                } else {
                    object2 = ((Hashtable)this.table).remove(object);
                }
                if (this.size() == 7) {
                    this.shrink();
                }
            }
            return object2;
        }

        private void shrink() {
            Hashtable hashtable = (Hashtable)this.table;
            Object[] objectArray = new Object[hashtable.size() * 2];
            Enumeration enumeration = hashtable.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                objectArray[n] = k;
                objectArray[n + 1] = hashtable.get(k);
                n += 2;
            }
            this.table = objectArray;
        }

        public int size() {
            if (this.table == null) {
                return 0;
            }
            int n = this.isArray() ? ((Object[])this.table).length / 2 : ((Hashtable)this.table).size();
            return n;
        }
    }
}

