/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;

public class JToolBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "ToolBarUI";
    private boolean paintBorder = true;
    private Insets margin = null;
    private boolean floatable = true;
    private int orientation = 0;
    private static Hashtable listenerRegistry = null;

    public JToolBar() {
        this(0);
    }

    public JToolBar(int n) {
        this.checkOrientation(n);
        this.orientation = n;
        if (n == 1) {
            this.setLayout(new BoxLayout(this, 1));
        } else {
            this.setLayout(new BoxLayout(this, 0));
        }
        this.updateUI();
    }

    public JButton add(Action action) {
        JButton jButton = new JButton((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        jButton.setEnabled(action.isEnabled());
        jButton.addActionListener(action);
        this.add(jButton);
        this.registerButtonForAction(jButton, action);
        return jButton;
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (component instanceof JButton) {
            ((JButton)component).setDefaultCapable(false);
        }
    }

    public void addSeparator() {
        Separator separator = new Separator();
        this.add(separator);
    }

    public void addSeparator(Dimension dimension) {
        Separator separator = new Separator(dimension);
        this.add(separator);
    }

    private void checkOrientation(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
            case 0: 
            case 1: 
        }
    }

    protected PropertyChangeListener createActionChangeListener(JButton jButton) {
        return new ActionChangedListener(jButton);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToolBar();
        }
        return this.accessibleContext;
    }

    public Component getComponentAtIndex(int n) {
        return this.getComponent(n);
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public ToolBarUI getUI() {
        return (ToolBarUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public boolean isFloatable() {
        return this.floatable;
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    protected String paramString() {
        String string = this.paintBorder ? "true" : "false";
        String string2 = this.margin != null ? this.margin.toString() : "";
        String string3 = this.floatable ? "true" : "false";
        String string4 = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return String.valueOf(super.paramString()) + ",floatable=" + string3 + ",margin=" + string2 + ",orientation=" + string4 + ",paintBorder=" + string;
    }

    private void registerButtonForAction(JButton jButton, Action action) {
        PropertyChangeListener propertyChangeListener = this.createActionChangeListener(jButton);
        if (listenerRegistry == null) {
            listenerRegistry = new Hashtable();
        }
        listenerRegistry.put(jButton, propertyChangeListener);
        listenerRegistry.put(propertyChangeListener, action);
        action.addPropertyChangeListener(propertyChangeListener);
    }

    public void remove(Component component) {
        super.remove(component);
        if (component instanceof JButton) {
            JButton jButton = (JButton)component;
            this.unregisterButtonForAction(jButton);
        }
    }

    public void setBorderPainted(boolean bl) {
        if (this.paintBorder != bl) {
            boolean bl2 = this.paintBorder;
            this.paintBorder = bl;
            this.firePropertyChange("borderPainted", bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    public void setFloatable(boolean bl) {
        if (this.floatable != bl) {
            boolean bl2 = this.floatable;
            this.floatable = bl;
            this.firePropertyChange("floatable", bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.revalidate();
        this.repaint();
    }

    public void setOrientation(int n) {
        this.checkOrientation(n);
        if (this.orientation != n) {
            int n2 = this.orientation;
            this.orientation = n;
            if (n == 1) {
                this.setLayout(new BoxLayout(this, 1));
            } else {
                this.setLayout(new BoxLayout(this, 0));
            }
            this.firePropertyChange("orientation", n2, n);
            this.revalidate();
            this.repaint();
        }
    }

    public void setUI(ToolBarUI toolBarUI) {
        super.setUI(toolBarUI);
    }

    private void unregisterButtonForAction(JButton jButton) {
        ActionChangedListener actionChangedListener;
        if (listenerRegistry != null && (actionChangedListener = (ActionChangedListener)listenerRegistry.remove(jButton)) != null) {
            Action action = (Action)listenerRegistry.remove(actionChangedListener);
            if (action != null) {
                jButton.removeActionListener(action);
                action.removePropertyChangeListener(actionChangedListener);
            }
            actionChangedListener.setTarget(null);
        }
    }

    public void updateUI() {
        this.setUI((ToolBarUI)UIManager.getUI(this));
        this.invalidate();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JButton button;

        ActionChangedListener(JButton jButton) {
            this.setTarget(jButton);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.button.setText(string2);
                this.button.repaint();
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setEnabled(bl);
                this.button.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.button.setIcon(icon);
                this.button.invalidate();
                this.button.repaint();
            }
        }

        public void setTarget(JButton jButton) {
            this.button = jButton;
        }
    }

    public static class Separator
    extends JSeparator {
        private Dimension separatorSize;

        public Separator() {
            this(null);
        }

        public Separator(Dimension dimension) {
            super(0);
            this.setSeparatorSize(dimension);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return this.separatorSize.getSize();
        }

        public Dimension getSeparatorSize() {
            return this.separatorSize;
        }

        public String getUIClassID() {
            return "ToolBarSeparatorUI";
        }

        public void setSeparatorSize(Dimension dimension) {
            if (dimension != null) {
                this.separatorSize = dimension;
            } else {
                super.updateUI();
            }
            this.invalidate();
        }
    }

    protected class AccessibleJToolBar
    extends JComponent.AccessibleJComponent {
        protected AccessibleJToolBar() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOOL_BAR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(JToolBar.this);
            return accessibleStateSet;
        }
    }
}

