/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicLabelUI
extends LabelUI
implements PropertyChangeListener {
    protected static BasicLabelUI labelUI = new BasicLabelUI();
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle viewR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);
    private Color defaultForeground = null;
    private Color defaultBackground = null;
    private Font defaultFont = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return labelUI;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon = jLabel.getIcon();
        Insets insets = jLabel.getInsets(viewInsets);
        Font font = jLabel.getFont();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (icon == null && (string == null || string != null && font == null)) {
            return new Dimension(n, n2);
        }
        if (string == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + n, icon.getIconHeight() + n2);
        }
        FontMetrics fontMetrics = jLabel.getToolkit().getFontMetrics(font);
        BasicLabelUI.iconR.height = 0;
        BasicLabelUI.iconR.width = 0;
        BasicLabelUI.iconR.y = 0;
        BasicLabelUI.iconR.x = 0;
        BasicLabelUI.textR.height = 0;
        BasicLabelUI.textR.width = 0;
        BasicLabelUI.textR.y = 0;
        BasicLabelUI.textR.x = 0;
        BasicLabelUI.viewR.x = n;
        BasicLabelUI.viewR.y = n2;
        BasicLabelUI.viewR.height = Short.MAX_VALUE;
        BasicLabelUI.viewR.width = Short.MAX_VALUE;
        this.layoutCL(jLabel, fontMetrics, string, icon, viewR, iconR, textR);
        int n3 = Math.min(BasicLabelUI.iconR.x, BasicLabelUI.textR.x);
        int n4 = Math.max(BasicLabelUI.iconR.x + BasicLabelUI.iconR.width, BasicLabelUI.textR.x + BasicLabelUI.textR.width);
        int n5 = Math.min(BasicLabelUI.iconR.y, BasicLabelUI.textR.y);
        int n6 = Math.max(BasicLabelUI.iconR.y + BasicLabelUI.iconR.height, BasicLabelUI.textR.y + BasicLabelUI.textR.height);
        Dimension dimension = new Dimension(n4 - n3, n6 - n5);
        dimension.width += n;
        dimension.height += n2;
        return dimension;
    }

    protected void installComponents(JLabel jLabel) {
        BasicHTML.updateRenderer(jLabel, jLabel.getText());
    }

    protected void installDefaults(JLabel jLabel) {
        if (this.defaultForeground == null) {
            this.defaultForeground = UIManager.getColor("Label.foreground");
            this.defaultBackground = UIManager.getColor("Label.background");
            this.defaultFont = UIManager.getFont("Label.font");
        }
        Color color = jLabel.getForeground();
        Color color2 = jLabel.getBackground();
        Font font = jLabel.getFont();
        if (color == null || color instanceof UIResource) {
            jLabel.setForeground(this.defaultForeground);
        }
        if (color2 == null || color2 instanceof UIResource) {
            jLabel.setBackground(this.defaultBackground);
        }
        if (font == null || font instanceof UIResource) {
            jLabel.setFont(this.defaultFont);
        }
    }

    protected void installKeyboardActions(JLabel jLabel) {
        int n = jLabel.getDisplayedMnemonic();
        Component component = jLabel.getLabelFor();
        jLabel.resetKeyboardActions();
        if (n != 0 && component != null) {
            jLabel.registerKeyboardAction(new PressAction(jLabel, component), KeyStroke.getKeyStroke(n, 8, false), 2);
        }
    }

    protected void installListeners(JLabel jLabel) {
        jLabel.addPropertyChangeListener(this);
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults((JLabel)jComponent);
        this.installComponents((JLabel)jComponent);
        this.installListeners((JLabel)jComponent);
        this.installKeyboardActions((JLabel)jComponent);
    }

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        paintViewInsets = jComponent.getInsets(paintViewInsets);
        BasicLabelUI.paintViewR.x = BasicLabelUI.paintViewInsets.left;
        BasicLabelUI.paintViewR.y = BasicLabelUI.paintViewInsets.top;
        BasicLabelUI.paintViewR.width = jComponent.getWidth() - (BasicLabelUI.paintViewInsets.left + BasicLabelUI.paintViewInsets.right);
        BasicLabelUI.paintViewR.height = jComponent.getHeight() - (BasicLabelUI.paintViewInsets.top + BasicLabelUI.paintViewInsets.bottom);
        BasicLabelUI.paintIconR.height = 0;
        BasicLabelUI.paintIconR.width = 0;
        BasicLabelUI.paintIconR.y = 0;
        BasicLabelUI.paintIconR.x = 0;
        BasicLabelUI.paintTextR.height = 0;
        BasicLabelUI.paintTextR.width = 0;
        BasicLabelUI.paintTextR.y = 0;
        BasicLabelUI.paintTextR.x = 0;
        String string2 = this.layoutCL(jLabel, fontMetrics, string, icon, paintViewR, paintIconR, paintTextR);
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, BasicLabelUI.paintIconR.x, BasicLabelUI.paintIconR.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, paintTextR);
            } else {
                int n = BasicLabelUI.paintTextR.x;
                int n2 = BasicLabelUI.paintTextR.y + fontMetrics.getAscent();
                if (jLabel.isEnabled()) {
                    this.paintEnabledText(jLabel, graphics, string2, n, n2);
                } else {
                    this.paintDisabledText(jLabel, graphics, string2, n, n2);
                }
            }
        }
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonic();
        Color color = jLabel.getBackground();
        graphics.setColor(color.brighter());
        BasicGraphicsUtils.drawString(graphics, string, n3, n, n2);
        graphics.setColor(color.darker());
        BasicGraphicsUtils.drawString(graphics, string, n3, n + 1, n2 + 1);
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonic();
        graphics.setColor(jLabel.getForeground());
        BasicGraphicsUtils.drawString(graphics, string, n3, n, n2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getPropertyName().equals("labelFor") || propertyChangeEvent.getPropertyName().equals("displayedMnemonic")) {
            this.installKeyboardActions((JLabel)propertyChangeEvent.getSource());
        } else if (string.equals("text")) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            String string2 = jLabel.getText();
            BasicHTML.updateRenderer(jLabel, string2);
        }
    }

    protected void uninstallComponents(JLabel jLabel) {
        BasicHTML.updateRenderer(jLabel, "");
    }

    protected void uninstallDefaults(JLabel jLabel) {
    }

    protected void uninstallKeyboardActions(JLabel jLabel) {
        jLabel.resetKeyboardActions();
    }

    protected void uninstallListeners(JLabel jLabel) {
        jLabel.removePropertyChangeListener(this);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JLabel)jComponent);
        this.uninstallComponents((JLabel)jComponent);
        this.uninstallListeners((JLabel)jComponent);
        this.uninstallKeyboardActions((JLabel)jComponent);
    }

    static class PressAction
    implements ActionListener {
        JLabel owner;
        Component labelFor;

        PressAction(JLabel jLabel, Component component) {
            this.owner = jLabel;
            this.labelFor = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.owner.registerKeyboardAction(new ReleaseAction(this.owner, this.labelFor), KeyStroke.getKeyStroke(this.owner.getDisplayedMnemonic(), 8, true), 0);
            this.owner.registerKeyboardAction(new ReleaseAction(this.owner, this.labelFor), KeyStroke.getKeyStroke(0, 8, true), 0);
            this.owner.requestFocus();
        }
    }

    static class ReleaseAction
    implements ActionListener {
        JLabel owner;
        Component labelFor;

        ReleaseAction(JLabel jLabel, Component component) {
            this.owner = jLabel;
            this.labelFor = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.owner.unregisterKeyboardAction(KeyStroke.getKeyStroke(this.owner.getDisplayedMnemonic(), 8, true));
            this.owner.unregisterKeyboardAction(KeyStroke.getKeyStroke(0, 8, true));
            this.labelFor.requestFocus();
        }
    }
}

