/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Keymap;

public class BasicTableUI
extends TableUI {
    protected JTable table;
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    private Dimension createTableSize(long l) {
        int n = this.table.getRowCount() * (this.table.getRowHeight() + this.table.getRowMargin());
        int n2 = this.table.getColumnModel().getColumnMargin() * this.table.getColumnCount();
        long l2 = Math.abs(l) + (long)n2;
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l2, n);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMaxWidth();
        }
        return this.createTableSize(l);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createTableSize(l);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createTableSize(l);
    }

    protected void installDefaults() {
        Container container;
        Color color;
        Color color2;
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        Color color3 = this.table.getSelectionBackground();
        if (color3 == null || color3 instanceof UIResource) {
            this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        }
        if ((color2 = this.table.getSelectionForeground()) == null || color2 instanceof UIResource) {
            this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        }
        if ((color = this.table.getGridColor()) == null || color instanceof UIResource) {
            this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        }
        if ((container = this.table.getParent()) != null && (container = container.getParent()) != null && container instanceof JScrollPane) {
            LookAndFeel.installBorder((JScrollPane)container, "Table.scrollPaneBorder");
        }
    }

    protected void installKeyboardActions() {
        int n = 1;
        int n2 = 2;
        int n3 = n | n2;
        this.registerKey(39, 0, 1, 0);
        this.registerKey(37, 0, -1, 0);
        this.registerKey(40, 0, 0, 1);
        this.registerKey(38, 0, 0, -1);
        this.registerKey("KP_RIGHT", 1, 0);
        this.registerKey("KP_LEFT", -1, 0);
        this.registerKey("KP_DOWN", 0, 1);
        this.registerKey("KP_UP", 0, -1);
        this.registerKey(39, n, 1, 0);
        this.registerKey(37, n, -1, 0);
        this.registerKey(40, n, 0, 1);
        this.registerKey(38, n, 0, -1);
        this.registerKey("shift KP_RIGHT", 1, 0);
        this.registerKey("shift KP_LEFT", -1, 0);
        this.registerKey("shift KP_DOWN", 0, 1);
        this.registerKey("shift KP_UP", 0, -1);
        this.registerScrollKey(33, 0, false, true, false);
        this.registerScrollKey(34, 0, true, true, false);
        this.registerScrollKey(36, 0, false, false, true);
        this.registerScrollKey(35, 0, true, false, true);
        this.registerScrollKey(33, n, false, true, false);
        this.registerScrollKey(34, n, true, true, false);
        this.registerScrollKey(36, n, false, false, true);
        this.registerScrollKey(35, n, true, false, true);
        this.registerScrollKey(33, n2, false, false, false);
        this.registerScrollKey(34, n2, true, false, false);
        this.registerScrollKey(36, n2, false, true, true);
        this.registerScrollKey(35, n2, true, true, true);
        this.registerScrollKey(33, n3, false, false, false);
        this.registerScrollKey(34, n3, true, false, false);
        this.registerScrollKey(36, n3, false, true, true);
        this.registerScrollKey(35, n3, true, true, true);
        this.registerKey(9, 0, 1, 0, true, false, true);
        this.registerKey(9, n, -1, 0, true, false, true);
        this.registerKey(10, 0, 0, 1, true, false, true);
        this.registerKey(10, n, 0, -1, true, false, true);
        this.table.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicTableUI.this.table.selectAll();
            }
        }, KeyStroke.getKeyStroke(65, n2), 0);
        this.table.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicTableUI.this.table.removeEditor();
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        this.table.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelectionModel listSelectionModel = BasicTableUI.this.table.getSelectionModel();
                int n = listSelectionModel.getAnchorSelectionIndex();
                ListSelectionModel listSelectionModel2 = BasicTableUI.this.table.getColumnModel().getSelectionModel();
                int n2 = listSelectionModel2.getAnchorSelectionIndex();
                BasicTableUI.this.table.editCellAt(n, n2);
                BasicTableUI.this.table.getEditorComponent().requestFocus();
            }
        }, KeyStroke.getKeyStroke(113, 0), 0);
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
    }

    public void installUI(JComponent jComponent) {
        this.table = (JTable)jComponent;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    private int lastVisibleRow(Rectangle rectangle) {
        int n = this.table.rowAtPoint(new Point(0, rectangle.y + rectangle.height - 1));
        if (n == -1) {
            n = this.table.getRowCount() - 1;
        }
        return n;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n = this.table.getColumnModel().getTotalColumnWidth();
        rectangle2.width = Math.min(rectangle2.width, n);
        graphics.setClip(rectangle2);
        this.paintGrid(graphics);
        int n2 = this.table.rowAtPoint(new Point(0, rectangle2.y));
        int n3 = this.lastVisibleRow(rectangle2);
        Rectangle rectangle3 = new Rectangle(0, 0, n, this.table.getRowHeight() + this.table.getRowMargin());
        rectangle3.y = n2 * rectangle3.height;
        int n4 = n2;
        while (n4 <= n3) {
            if (rectangle3.intersects(rectangle2)) {
                this.paintRow(graphics, n4);
            }
            rectangle3.y += rectangle3.height;
            ++n4;
        }
        graphics.setClip(rectangle);
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3 = this.table.getRowMargin();
        int n4 = this.table.getColumnModel().getColumnMargin();
        rectangle.setBounds(rectangle.x + n4 / 2, rectangle.y + n3 / 2, rectangle.width - n4, rectangle.height - n3);
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
            Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
            if (component.getParent() == null) {
                this.rendererPane.add(component);
            }
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
        rectangle.setBounds(rectangle.x - n4 / 2, rectangle.y - n3 / 2, rectangle.width + n4, rectangle.height + n3);
    }

    private void paintGrid(Graphics graphics) {
        graphics.setColor(this.table.getGridColor());
        if (this.table.getShowHorizontalLines()) {
            this.paintHorizontalLines(graphics);
        }
        if (this.table.getShowVerticalLines()) {
            this.paintVerticalLines(graphics);
        }
    }

    private void paintHorizontalLines(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.table.rowAtPoint(new Point(0, rectangle.y));
        int n2 = this.lastVisibleRow(rectangle);
        int n3 = this.table.getColumnModel().getTotalColumnWidth();
        int n4 = this.table.getRowHeight() + this.table.getRowMargin();
        int n5 = n4 * n;
        int n6 = n;
        while (n6 <= n2) {
            graphics.drawLine(0, (n5 += n4) - 1, n3 - 1, n5 - 1);
            ++n6;
        }
    }

    private void paintRow(Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = 0;
        boolean bl = false;
        int n3 = -1;
        Rectangle rectangle2 = null;
        Dimension dimension = this.table.getIntercellSpacing();
        JTableHeader jTableHeader = this.table.getTableHeader();
        Rectangle rectangle3 = new Rectangle();
        rectangle3.height = this.table.getRowHeight() + dimension.height;
        rectangle3.y = n * rectangle3.height;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            rectangle3.width = tableColumn.getWidth() + dimension.width;
            if (rectangle3.intersects(rectangle)) {
                bl = true;
                if (jTableHeader == null || tableColumn != jTableHeader.getDraggedColumn()) {
                    this.paintCell(graphics, rectangle3, n, n2);
                } else {
                    graphics.setColor(this.table.getParent().getBackground());
                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    rectangle2 = new Rectangle(rectangle3);
                    n3 = n2;
                }
            } else if (bl) break;
            rectangle3.x += rectangle3.width;
            ++n2;
        }
        if (n3 != -1 && rectangle2 != null) {
            rectangle2.x += jTableHeader.getDraggedDistance();
            graphics.setColor(this.table.getBackground());
            graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            graphics.setColor(this.table.getGridColor());
            int n4 = rectangle2.x;
            int n5 = rectangle2.y;
            int n6 = n4 + rectangle2.width - 1;
            int n7 = n5 + rectangle2.height - 1;
            if (this.table.getShowVerticalLines()) {
                graphics.drawLine(n6, n5, n6, n7);
            }
            if (this.table.getShowHorizontalLines()) {
                graphics.drawLine(n4, n7, n6, n7);
            }
            this.paintCell(graphics, rectangle2, n, n3);
        }
    }

    private void paintVerticalLines(Graphics graphics) {
        int n = 0;
        int n2 = this.table.getColumnCount();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n3 = tableColumnModel.getColumnMargin();
        int n4 = this.table.getRowHeight() + this.table.getRowMargin();
        int n5 = n4 * this.table.getRowCount();
        int n6 = 0;
        while (n6 < n2) {
            graphics.drawLine((n += tableColumnModel.getColumn(n6).getWidth() + n3) - 1, 0, n - 1, n5 - 1);
            ++n6;
        }
    }

    private void registerKey(int n, int n2, int n3, int n4) {
        boolean bl = (n2 & 2) != 0;
        boolean bl2 = (n2 & 1) != 0;
        this.registerKey(n, n2, n3, n4, bl, bl2, false);
    }

    private void registerKey(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        class Javax_swing_plaf_basic_BasicTableUI$4 {
            /* synthetic */ Javax_swing_plaf_basic_BasicTableUI$4() {
            }
        }
        this.table.registerKeyboardAction(new NavigationalAction(null, n3, n4, bl, bl2, bl3), KeyStroke.getKeyStroke(n, n2), 0);
    }

    private void registerKey(String string, int n, int n2) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string);
        int n3 = keyStroke.getModifiers();
        boolean bl = (n3 & 2) != 0;
        boolean bl2 = (n3 & 1) != 0;
        this.registerKey(string, n, n2, bl, bl2, false);
    }

    private void registerKey(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.table.registerKeyboardAction(new NavigationalAction(null, n, n2, bl, bl2, bl3), KeyStroke.getKeyStroke(string), 0);
    }

    private void registerScrollKey(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = (n2 & 1) != 0;
        this.table.registerKeyboardAction(new PagingAction(null, bl4, bl, bl2, bl3), KeyStroke.getKeyStroke(n, n2), 0);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallKeyboardActions() {
        int n = 1;
        int n2 = 2;
        int n3 = n | n2;
        this.unregisterKey(38, 0);
        this.unregisterKey(40, 0);
        this.unregisterKey(39, 0);
        this.unregisterKey(37, 0);
        this.unregisterKey("KP_UP");
        this.unregisterKey("KP_DOWN");
        this.unregisterKey("KP_RIGHT");
        this.unregisterKey("KP_LEFT");
        this.unregisterKey(38, n);
        this.unregisterKey(40, n);
        this.unregisterKey(39, n);
        this.unregisterKey(37, n);
        this.unregisterKey("shift KP_UP");
        this.unregisterKey("shift KP_DOWN");
        this.unregisterKey("shift KP_RIGHT");
        this.unregisterKey("shift KP_LEFT");
        this.unregisterKey(33, 0);
        this.unregisterKey(34, 0);
        this.unregisterKey(36, 0);
        this.unregisterKey(35, 0);
        this.unregisterKey(33, n);
        this.unregisterKey(34, n);
        this.unregisterKey(36, n);
        this.unregisterKey(35, n);
        this.unregisterKey(33, n2);
        this.unregisterKey(34, n2);
        this.unregisterKey(36, n2);
        this.unregisterKey(35, n2);
        this.unregisterKey(33, n3);
        this.unregisterKey(34, n3);
        this.unregisterKey(36, n3);
        this.unregisterKey(35, n3);
        this.unregisterKey(9, 0);
        this.unregisterKey(9, n);
        this.unregisterKey(10, 0);
        this.unregisterKey(10, n);
        this.unregisterKey(65, n2);
        this.unregisterKey(27, 0);
        this.unregisterKey(113, 0);
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    private void unregisterKey(int n, int n2) {
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(n, n2));
    }

    private void unregisterKey(String string) {
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(string));
    }

    private void updateSelection(int n, int n2, boolean bl, boolean bl2) {
        Rectangle rectangle = this.table.getCellRect(n, n2, false);
        if (rectangle != null) {
            this.table.scrollRectToVisible(rectangle);
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.table.getColumnModel().getSelectionModel();
        this.updateSelectionModel(listSelectionModel2, n2, bl, bl2);
        this.updateSelectionModel(listSelectionModel, n, bl, bl2);
    }

    private void updateSelectionModel(ListSelectionModel listSelectionModel, int n, boolean bl, boolean bl2) {
        if (!bl2) {
            if (!bl) {
                listSelectionModel.setSelectionInterval(n, n);
            } else if (listSelectionModel.isSelectedIndex(n)) {
                listSelectionModel.removeSelectionInterval(n, n);
            } else {
                listSelectionModel.addSelectionInterval(n, n);
            }
        } else {
            listSelectionModel.setLeadSelectionIndex(n);
        }
    }

    private class NavigationalAction
    implements ActionListener {
        protected int dx;
        protected int dy;
        protected boolean toggle;
        protected boolean extend;
        protected boolean inSelection;
        protected int anchorRow;
        protected int anchorColumn;
        protected int leadRow;
        protected int leadColumn;

        private NavigationalAction(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            this.dx = n;
            this.dy = n2;
            this.toggle = bl;
            this.extend = bl2;
            this.inSelection = bl3;
        }

        /* synthetic */ NavigationalAction(4 var2_2, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            this(n, n2, bl, bl2, bl3);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ListSelectionModel listSelectionModel = BasicTableUI.this.table.getSelectionModel();
            this.anchorRow = listSelectionModel.getAnchorSelectionIndex();
            this.leadRow = listSelectionModel.getLeadSelectionIndex();
            ListSelectionModel listSelectionModel2 = BasicTableUI.this.table.getColumnModel().getSelectionModel();
            this.anchorColumn = listSelectionModel2.getAnchorSelectionIndex();
            this.leadColumn = listSelectionModel2.getLeadSelectionIndex();
            int n = this.anchorRow;
            int n2 = this.anchorColumn;
            if (!this.inSelection) {
                this.moveWithinTableRange(this.dx, this.dy, this.extend);
                if (!this.extend) {
                    BasicTableUI.this.updateSelection(this.anchorRow, this.anchorColumn, false, this.extend);
                } else {
                    BasicTableUI.this.updateSelection(this.leadRow, this.leadColumn, false, this.extend);
                }
            } else if (this.moveWithinSelectedRange(this.dx, this.dy, false)) {
                listSelectionModel.setAnchorSelectionIndex(this.anchorRow);
                listSelectionModel2.setAnchorSelectionIndex(this.anchorColumn);
            } else {
                BasicTableUI.this.updateSelection(this.anchorRow, this.anchorColumn, false, false);
            }
            if (BasicTableUI.this.table.isEditing() && (n != listSelectionModel.getAnchorSelectionIndex() || n2 != listSelectionModel2.getAnchorSelectionIndex())) {
                BasicTableUI.this.table.getCellEditor().stopCellEditing();
            }
        }

        private int clipToRange(int n, int n2, int n3) {
            return Math.min(Math.max(n, n2), n3 - 1);
        }

        private int compare(int n, int n2, int n3) {
            return n < n2 ? -1 : (n >= n3 ? 1 : 0);
        }

        private int compare(int n, ListSelectionModel listSelectionModel) {
            return this.compare(n, listSelectionModel.getMinSelectionIndex(), listSelectionModel.getMaxSelectionIndex() + 1);
        }

        private boolean moveWithinSelectedRange(int n, int n2, boolean bl) {
            int n3;
            int n4;
            int n5;
            boolean bl2;
            ListSelectionModel listSelectionModel = BasicTableUI.this.table.getSelectionModel();
            ListSelectionModel listSelectionModel2 = BasicTableUI.this.table.getColumnModel().getSelectionModel();
            int n6 = this.anchorRow + n2;
            int n7 = this.anchorColumn + n;
            int n8 = this.selectionSpan(listSelectionModel);
            boolean bl3 = bl2 = n8 * (n5 = this.selectionSpan(listSelectionModel2)) > 1;
            if (bl2) {
                n4 = this.compare(n6, listSelectionModel);
                n3 = this.compare(n7, listSelectionModel2);
            } else {
                n8 = BasicTableUI.this.table.getRowCount();
                n5 = BasicTableUI.this.table.getColumnCount();
                n4 = this.compare(n6, 0, n8);
                n3 = this.compare(n7, 0, n5);
            }
            this.anchorRow = n6 - n8 * n4;
            this.anchorColumn = n7 - n5 * n3;
            if (!bl) {
                return this.moveWithinSelectedRange(n4, n3, true);
            }
            return bl2;
        }

        private void moveWithinTableRange(int n, int n2, boolean bl) {
            if (bl) {
                this.leadRow = this.clipToRange(this.leadRow + n2, 0, BasicTableUI.this.table.getRowCount());
                this.leadColumn = this.clipToRange(this.leadColumn + n, 0, BasicTableUI.this.table.getColumnCount());
            } else {
                this.anchorRow = this.clipToRange(this.anchorRow + n2, 0, BasicTableUI.this.table.getRowCount());
                this.anchorColumn = this.clipToRange(this.anchorColumn + n, 0, BasicTableUI.this.table.getColumnCount());
            }
        }

        private int selectionSpan(ListSelectionModel listSelectionModel) {
            return listSelectionModel.getMaxSelectionIndex() - listSelectionModel.getMinSelectionIndex() + 1;
        }
    }

    private class PagingAction
    extends NavigationalAction {
        private boolean forwards;
        private boolean vertically;
        private boolean toLimit;

        /* synthetic */ PagingAction(4 var2_2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this(bl, bl2, bl3, bl4);
        }

        private PagingAction(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(null, 0, 0, false, bl, false);
            this.forwards = bl2;
            this.vertically = bl3;
            this.toLimit = bl4;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.toLimit) {
                if (this.vertically) {
                    int n = BasicTableUI.this.table.getRowCount();
                    this.dx = 0;
                    this.dy = this.forwards ? n : -n;
                } else {
                    int n = BasicTableUI.this.table.getColumnCount();
                    this.dx = this.forwards ? n : -n;
                    this.dy = 0;
                }
            } else {
                int n;
                if (!(BasicTableUI.this.table.getParent().getParent() instanceof JScrollPane)) {
                    return;
                }
                Dimension dimension = BasicTableUI.this.table.getParent().getSize();
                ListSelectionModel listSelectionModel = this.vertically ? BasicTableUI.this.table.getSelectionModel() : BasicTableUI.this.table.getColumnModel().getSelectionModel();
                int n2 = n = this.extend ? listSelectionModel.getLeadSelectionIndex() : listSelectionModel.getAnchorSelectionIndex();
                if (this.vertically) {
                    Rectangle rectangle = BasicTableUI.this.table.getCellRect(n, 0, true);
                    rectangle.y = rectangle.y + (this.forwards ? dimension.height : -dimension.height);
                    this.dx = 0;
                    int n3 = BasicTableUI.this.table.rowAtPoint(rectangle.getLocation());
                    if (n3 == -1 && this.forwards) {
                        n3 = BasicTableUI.this.table.getRowCount();
                    }
                    this.dy = n3 - n;
                } else {
                    Rectangle rectangle = BasicTableUI.this.table.getCellRect(0, n, true);
                    rectangle.x = rectangle.x + (this.forwards ? dimension.width : -dimension.width);
                    int n4 = BasicTableUI.this.table.columnAtPoint(rectangle.getLocation());
                    if (n4 == -1 && this.forwards) {
                        n4 = BasicTableUI.this.table.getColumnCount();
                    }
                    this.dx = n4 - n;
                    this.dy = 0;
                }
            }
            super.actionPerformed(actionEvent);
        }
    }

    public class KeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\n') {
                return;
            }
            int n = BasicTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            int n2 = BasicTableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n != -1 && n2 != -1 && !BasicTableUI.this.table.isEditing()) {
                boolean bl = BasicTableUI.this.table.editCellAt(n, n2);
                BasicTableUI.this.table.requestFocus();
                if (!bl) {
                    return;
                }
            }
            Component component = BasicTableUI.this.table.getEditorComponent();
            if (BasicTableUI.this.table.isEditing() && component != null) {
                char c = keyEvent.getKeyChar();
                if (component instanceof JTextField) {
                    KeyStroke keyStroke;
                    JTextField jTextField = (JTextField)component;
                    Keymap keymap = jTextField.getKeymap();
                    Action action = keymap.getAction(keyStroke = KeyStroke.getKeyStroke((int)c, 0));
                    if (action == null) {
                        action = keymap.getDefaultAction();
                    }
                    if (action != null) {
                        ActionEvent actionEvent = new ActionEvent(jTextField, 1001, String.valueOf(c));
                        action.actionPerformed(actionEvent);
                        keyEvent.consume();
                    }
                }
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            this.repaintAnchorCell();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintAnchorCell();
        }

        private void repaintAnchorCell() {
            int n = BasicTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            int n2 = BasicTableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            Rectangle rectangle = BasicTableUI.this.table.getCellRect(n, n2, false);
            BasicTableUI.this.table.repaint(rectangle);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (this.repostEvent(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = BasicTableUI.this.table.rowAtPoint(point);
            int n2 = BasicTableUI.this.table.columnAtPoint(point);
            if (n2 == -1 || n == -1) {
                return;
            }
            BasicTableUI.this.updateSelection(n, n2, false, true);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = BasicTableUI.this.table.rowAtPoint(point);
            int n2 = BasicTableUI.this.table.columnAtPoint(point);
            if (n2 == -1 || n == -1) {
                return;
            }
            boolean bl2 = BasicTableUI.this.table.editCellAt(n, n2, mouseEvent);
            boolean bl3 = bl = BasicTableUI.this.table.isEditing() && bl2;
            if (bl) {
                Component component = BasicTableUI.this.table.getEditorComponent();
                Point point2 = SwingUtilities.convertPoint(BasicTableUI.this.table, point, component);
                this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
                this.repostEvent(mouseEvent);
            }
            if (!bl || BasicTableUI.this.table.getCellEditor().shouldSelectCell(mouseEvent)) {
                BasicTableUI.this.table.requestFocus();
                this.setValueIsAdjusting(true);
                BasicTableUI.this.updateSelection(n, n2, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            this.repostEvent(mouseEvent);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(BasicTableUI.this.table, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        private void setValueIsAdjusting(boolean bl) {
            BasicTableUI.this.table.getSelectionModel().setValueIsAdjusting(bl);
            BasicTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(bl);
        }
    }
}

