/***************************************************************************
*  Print Statistics.
*  (C) 1994 IBM Corporation.  All rights reserved.
*
*  Purpose:    Print Statistics from the LS 4.0 GUI to the default printer.
*
*  Parameters: Location  = "LOCAL" or "REMOTE"
*              StatType  = "SERVER" or REQUESTER"
*              MachineID = the machine ID for which statistics should be
*                          printed.
*
*  Notes:      Location refers to whether the statistics are requested for
*              the local machine or a remote machine. StatType refers to
*              which statistics about the machine should be printed.
*              MachineID is only necessary if the machine is REMOTE.
*
*  Example:    LSGPSTAT REMOTE SERVER MAINSERV
*
*              will print server statistics for the remote server \\MAINSERV.
*
*              * You must have ADMIN authority to print statistics remotely.
*
****************************************************************************/

Trace 'o'

parse upper arg Location StatType MachineID .

prtport = 'PRN'

if MachineID = ' ' then
   Location = 'LOCAL'
else
  do
   MachineID = strip(MachineID,B,'/')
   MachineID = '\\'MachineID
  end

if (StatType <> 'SERVER') then
   StatType = 'REQUESTER'

netcmd = '@NET STATISTICS' StatType

if (Location = 'REMOTE') then
   netcmd = '@NET ADMIN' MachineID '/c' netcmd


address cmd netcmd '1>' prtport '2>' prtport

exit
