C**********************************************************************
C
C  Module Name    = UPM.FOR
C
C  Descriptive Name = User Profile Management Include file
C
C  (C) Copyright IBM Corporation 1988, 1990.  All rights reserved.
C  (C) Copyright MicroSoft Corporation 1988, 1990.  All rights reserved.
C  Licensed Material - Program Property of IBM
C
C  Function = Include File defining Api Logon/Logoff
C
C  Operating System = OS/2 Extended Edition
C
C**********************************************************************


C    Log an application process on the the system

      OS EXTERNAL   UPMGLGN
      INTEGER*2     UPMGLGN

C    Log an application process off the system

      OS EXTERNAL   UPMGLGFF
      INTEGER*2     UPMGLGFF

C    Get the locally logged on user ID

      OS EXTERNAL   UPMGLOCU
      INTEGER*2     UPMGLOCU

C    Logon a local user ID

      OS EXTERNAL   UPMGLOCL
      INTEGER*2     UPMGLOCL

C    Valid values for the remotetype parameter

      INTEGER       UPM_LOCAL
      PARAMETER   ( UPM_LOCAL              = 1  )

      INTEGER       UPM_DNODE
      PARAMETER   ( UPM_DNODE              = 2  )

      INTEGER       UPM_DOMAIN
      PARAMETER   ( UPM_DOMAIN             = 3  )

C    Valid values for the authcheck parameter

      INTEGER       UPM_CONFIG
      PARAMETER   ( UPM_CONFIG             = 1  )

      INTEGER       UPM_ADMIN
      PARAMETER   ( UPM_ADMIN              = 2  )

      INTEGER       UPM_USER
      PARAMETER   ( UPM_USER               = 3  )

C    Return values from upmelgn and upmelgff
C
C    Note:  These values are all negative.  Any positive return
C          value signifies an unexpected OS/2 system level error
C          occurred.  The positive value is the OS/2 return code.
C

C    Successful.
      INTEGER    UPM_OK
      PARAMETER( UPM_OK             = Z'0000' )

C    Another logon is in process.
      INTEGER    UPM_LOG_INPROC
      PARAMETER( UPM_LOG_INPROC     = Z'FB01' )

C    Bad remotetype.
      INTEGER    UPM_BAD_TYPE
      PARAMETER( UPM_BAD_TYPE       = Z'FB02' )

C    Cannot allocate required memory for RAT.
      INTEGER    UPM_NOMEM
      PARAMETER( UPM_NOMEM          = Z'FB03' )

C    An execute file could not be found.
      INTEGER    UPM_LOG_FILE_NOT_FOUND
      PARAMETER( UPM_LOG_FILE_NOT_FOUND = Z'FB04' )

C    User not logged, failed security clearance.
      INTEGER    UPM_FAIL_SECURITY
      PARAMETER( UPM_FAIL_SECURITY  = Z'FB05' )

C    A parameter passed was invalid.
      INTEGER    UPM_BAD_PARAMETER
      PARAMETER( UPM_BAD_PARAMETER  = Z'FB06' )

C    Authcheck was not valid.
      INTEGER    UPM_BAD_AUTHCHECK
      PARAMETER( UPM_BAD_AUTHCHECK  = Z'FB07' )

C    A logon has not occured for this userid.
      INTEGER    UPM_NOT_LOGGED
      PARAMETER( UPM_NOT_LOGGED     = Z'FB10' )

C    A domain logon is currently active.
      INTEGER    UPM_LOGGED
      PARAMETER( UPM_LOGGED         = Z'FB12' )

