(**************************************************************************

   Module Name    = UPM.INC

   Descriptive Name = User Profile Management Include file

   (C) Copyright IBM Corporation 1988, 1990.  All rights reserved.
   (C) Copyright MicroSoft Corporation 1988, 1990.  All rights reserved.
   Licensed Material - Program Property of IBM

   Function = Include File defining Api Logon/Logoff

   Operating System = OS/2 Extended Edition

**************************************************************************)
(*
     Valid values for the remotetype parameter
*)
CONST

  UPM_LOCAL        = 1;
  UPM_DNODE        = 2;
  UPM_DOMAIN       = 3;

(*
     Valid values for the authcheck parameter
*)
  UPM_CONFIG      = 1;
  UPM_ADMIN       = 2;
  UPM_USER        = 3;

(*
     Return values from upmelgn and upmelgff

     Note:  These values are all negative.  Any positive return
           value signifies an unexpected OS/2 system level error
           occurred.  The positive value is the OS/2 return code.
*)
  UPM_OK                =  0;     (* Successful.                         *)
  UPM_LOG_INPROC        = 16#FB01;(* Another logon is in process.        *)
  UPM_BAD_TYPE          = 16#FB02;(* Bad remotetype.                     *)
  UPM_NOMEM             = 16#FB03;(* Cannot allocate required memory for
                                     RAT.                                *)
  UPM_LOG_FILE_NOT_FOUND= 16#FB04;(* An execute file could not be found. *)
  UPM_FAIL_SECURITY     = 16#FB05;(* User not logged, failed security
                                     clearance.                          *)
  UPM_BAD_PARAMETER     = 16#FB06;(* A parameter passed was invalid.     *)
  UPM_BAD_AUTHCHECK     = 16#FB06;(* Authcheck was not valid.            *)
  UPM_NOT_LOGGED        = 16#FB10;(* A logon has not occured for this
                                     userid.                             *)
  UPM_LOGGED            = 16#FB12;(* A domain logon is currently active. *)


(*
     Log an application process on the the system
*)
  FUNCTION UPMGLGN(userid_len     : WORD;
                   password_len   : WORD;
                   remotename_len : WORD;
                   remotetype     : WORD;
                   authcheck      : WORD;
                   userid         : ADSMEM;
                   password       : ADSMEM;
                   remotename     : ADSMEM ) : INTEGER; EXTERN ;

(*
     Log an application process off the system
*)
  FUNCTION UPMGLGFF( userid_len    : WORD;
                     remotename_len: WORD;
                     remotetype    : WORD;
                     userid        : ADSMEM;
                     remotename    : ADSMEM ) : INTEGER; EXTERN ;
(*
     Get locally logged on user ID
*)
  FUNCTION UPMGLOCU( userid        : ADSMEM;
                     userid_type   : ADSMEM ) : INTEGER; EXTERN ;
(*
     Logon a local user ID
*)
  FUNCTION UPMGLOCL( userid        : ADSMEM;
                     userid_type   : ADSMEM ) : INTEGER; EXTERN ;

