/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;

class ButtonPanel
extends Panel {
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final String HELP = "Help";
    public static final String CLEAR = "Clear";
    public static final String APPLY = "Apply";
    private static final Color BACKGROUND_COLOR = Utility.NOTEBOOK_COLOR;
    private static final int NUM_DEFAULT_BUTTONS = 4;
    private int buttonsInARow = 4;
    private Container parent;
    private Button[] buttons;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public ButtonPanel(Container container, String[] stringArray, int n) {
        this.parent = container;
        this.buttonsInARow = n;
        this.setBackground(BACKGROUND_COLOR);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        this.constrain(gridBagLayout, gridBagConstraints);
        this.buttons = new Button[stringArray.length];
        int n2 = 2;
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            this.buttons[n4] = new Button(stringArray[n4]);
            if (n4 % this.buttonsInARow == 0) {
                n3 = 0;
                ++n2;
            }
            this.add(this.buttons[n4], gridBagLayout, gridBagConstraints, n3, n2, 1, 1);
            ++n3;
            ++n4;
        }
    }

    public ButtonPanel(Container container, String[] stringArray) {
        this(container, stringArray, 4);
    }

    public ButtonPanel(Container container) {
        this.parent = container;
        this.setBackground(BACKGROUND_COLOR);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.constrain(gridBagLayout, gridBagConstraints);
        this.buttons = new Button[4];
        this.buttons[0] = new Button(OK);
        this.buttons[1] = new Button(CLEAR);
        this.buttons[2] = new Button(CANCEL);
        this.buttons[3] = new Button(HELP);
        int n = 0;
        while (n < 4) {
            this.add(this.buttons[n], gridBagLayout, gridBagConstraints, n, 2, 1, 1);
            ++n;
        }
    }

    public Button[] getButtons() {
        return this.buttons;
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public void disable(String string) {
        int n = 0;
        while (n < this.buttons.length) {
            if (string.compareTo(this.buttons[n].getLabel()) == 0) {
                this.buttons[n].setEnabled(false);
                return;
            }
            ++n;
        }
    }

    public void enable(String string) {
        int n = 0;
        while (n < this.buttons.length) {
            if (string.compareTo(this.buttons[n].getLabel()) == 0) {
                this.buttons[n].setEnabled(true);
                return;
            }
            ++n;
        }
    }

    public void enable(int n) {
        this.buttons[n].setEnabled(true);
    }

    public void disable(int n) {
        this.buttons[n].setEnabled(false);
    }

    public int getListSize() {
        return this.buttons.length;
    }

    private void setAllButtons(boolean bl) {
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            this.buttons[n2].setEnabled(bl);
            ++n2;
        }
    }

    private void constrain(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        switch (this.buttons.length) {
            case 1: {
                gridBagConstraints.insets = new Insets(3, 20, 3, 20);
                break;
            }
            case 2: {
                gridBagConstraints.insets = new Insets(3, 15, 3, 15);
                break;
            }
            case 3: {
                gridBagConstraints.insets = new Insets(3, 10, 3, 10);
                break;
            }
            case 4: {
                gridBagConstraints.insets = new Insets(3, 7, 3, 7);
                break;
            }
            case 5: {
                gridBagConstraints.insets = new Insets(3, 5, 3, 5);
                break;
            }
            default: {
                gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            }
        }
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }
}

