/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BorderPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Validation;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;

public class DlgFtpd
extends BaseDialog
implements ActionListener,
MessageListener,
KeyListener,
ItemListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblShell;
    private Label lblRead;
    private Label lblWrite;
    private Label lblTimeout;
    private Label lblLog;
    private TextField tfRead;
    private TextField tfWrite;
    private TextField tfTimeout;
    private Checkbox cbLogAll;
    private Checkbox cbDbg;
    private Checkbox cbEnable;
    private Checkbox cbDenyRead;
    private Checkbox cbDenyWrite;
    private Checkbox cbCd;
    private Checkbox cbMd;
    private Checkbox cbRd;
    private Checkbox cbDir;
    private Checkbox cbDel;
    private Checkbox cbGet;
    private Checkbox cbPut;
    private Checkbox cbRen;
    private Panel directoryPanel;
    private Panel timeoutPanel;
    private BorderPanel logPanel;
    private BorderPanel bpReadPanel;
    private BorderPanel bpWritePanel;
    private Panel centerPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private static final int MIN_FTP_TIMEOUT = 30;
    private static final int MAX_FTP_TIMEOUT = 7200;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private Component myOwner;
    private GridBagLayout gridBag = new GridBagLayout();

    public DlgFtpd(Container container) {
        super(new Frame(), "", false, container);
        this.myOwner = container;
        this.myBundle = ClientMsg.getBundle();
        this.createGUI();
        ((Component)this).setSize(this.getMinSize());
    }

    private Dimension getMinSize() {
        super.pack();
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager == null) {
            this.setLayout(this.gridBag);
            layoutManager = this.getLayout();
        }
        return layoutManager.minimumLayoutSize(this);
    }

    private void addButtonGUI(int n, int n2, int n3) {
        DlgFtpd.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        DlgFtpd.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        DlgFtpd.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createGUI() {
        this.setTitle(this.myBundle.getString("DF_TITLE"));
        this.logPanel = new BorderPanel(this.myBundle.getString("DF_LOG_HEAD"));
        this.directoryPanel = new Panel();
        this.timeoutPanel = new Panel();
        this.bpReadPanel = new BorderPanel(this.myBundle.getString("DF_READ"));
        this.bpWritePanel = new BorderPanel(this.myBundle.getString("DF_WRITE"));
        this.logPanel.setLayout(this.gridBag);
        this.directoryPanel.setLayout(this.gridBag);
        this.timeoutPanel.setLayout(this.gridBag);
        this.bpReadPanel.setLayout(this.gridBag);
        this.bpWritePanel.setLayout(this.gridBag);
        this.lblPageTitle = new Label(this.myBundle.getString("DF_TITLE"));
        this.lblLog = new Label(this.myBundle.getString("DF_LOG_HEADING"));
        this.lblShell = new Label(this.myBundle.getString("DF_SHELL"));
        this.lblRead = new Label(this.myBundle.getString("DF_READ_NOTE"));
        this.lblWrite = new Label(this.myBundle.getString("DF_WRITE_NOTE"));
        this.lblTimeout = new Label(this.myBundle.getString("DF_TIMEOUT"));
        this.tfRead = new TextField();
        this.tfWrite = new TextField();
        this.tfTimeout = new TextField();
        this.cbLogAll = new Checkbox(this.myBundle.getString("DF_LOG_ALL"));
        this.cbDbg = new Checkbox(this.myBundle.getString("DF_DBG"));
        this.cbEnable = new Checkbox(this.myBundle.getString("DF_ENABLE"));
        this.cbDenyRead = new Checkbox(this.myBundle.getString("DF_DENYREAD"));
        this.cbDenyWrite = new Checkbox(this.myBundle.getString("DF_DENYWRITE"));
        this.cbCd = new Checkbox(this.myBundle.getString("DF_CD"));
        this.cbMd = new Checkbox(this.myBundle.getString("DF_MD"));
        this.cbRd = new Checkbox(this.myBundle.getString("DF_RD"));
        this.cbDir = new Checkbox(this.myBundle.getString("DF_DIR"));
        this.cbDel = new Checkbox(this.myBundle.getString("DF_DEL"));
        this.cbGet = new Checkbox(this.myBundle.getString("DF_GET"));
        this.cbPut = new Checkbox(this.myBundle.getString("DF_PUT"));
        this.cbRen = new Checkbox(this.myBundle.getString("DF_REN"));
        this.cbDenyRead.setState(false);
        this.cbDenyWrite.setState(false);
        this.cbLogAll.addItemListener(this);
        this.cbDbg.addItemListener(this);
        this.cbEnable.addItemListener(this);
        this.cbCd.addItemListener(this);
        this.cbMd.addItemListener(this);
        this.cbRd.addItemListener(this);
        this.cbDir.addItemListener(this);
        this.cbDel.addItemListener(this);
        this.cbGet.addItemListener(this);
        this.cbPut.addItemListener(this);
        this.cbRen.addItemListener(this);
        this.cbDenyRead.addItemListener(this);
        this.cbDenyWrite.addItemListener(this);
        this.cbLogAll.addKeyListener(this);
        this.cbDbg.addKeyListener(this);
        this.cbEnable.addKeyListener(this);
        this.cbCd.addKeyListener(this);
        this.cbMd.addKeyListener(this);
        this.cbRd.addKeyListener(this);
        this.cbDir.addKeyListener(this);
        this.cbDel.addKeyListener(this);
        this.cbGet.addKeyListener(this);
        this.cbPut.addKeyListener(this);
        this.cbRen.addKeyListener(this);
        this.cbDenyRead.addKeyListener(this);
        this.cbDenyWrite.addKeyListener(this);
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        this.setLayout(this.gridBag);
        Utility.constrain(this.centerPanel, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.cbEnable, 0, 1, 0, 1, 2, 17, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.bpReadPanel, this.tfRead, 0, 0, 0, 1, 2, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.bpReadPanel, this.cbDenyRead, 0, 1, 0, 1, 2, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.bpReadPanel, this.lblRead, 0, 2, 0, 1, 2, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.bpWritePanel, this.tfWrite, 0, 0, 0, 1, 2, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.bpWritePanel, this.cbDenyWrite, 0, 1, 0, 1, 2, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.bpWritePanel, this.lblWrite, 0, 2, 0, 1, 2, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.directoryPanel, this.bpReadPanel, 0, 0, 0, 1, 2, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.directoryPanel, this.bpWritePanel, 0, 1, 0, 1, 2, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.directoryPanel, 0, 2, 0, 1, 0, 10, 1.0, 0.8, 0, 0, 0, 0);
        Utility.constrain(this.timeoutPanel, this.lblTimeout, 0, 4, 1, 1, 2, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.timeoutPanel, this.tfTimeout, 1, 4, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.timeoutPanel, 0, 3, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.logPanel, this.cbDbg, 0, 0, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.logPanel, this.cbLogAll, 0, 1, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.logPanel, this.lblLog, 0, 2, 0, 1, 2, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.logPanel, this.cbCd, 0, 3, 1, 1, 2, 17, 1.0, 1.0, 0, 40, 0, 0);
        Utility.constrain(this.logPanel, this.cbMd, 1, 3, 1, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.logPanel, this.cbRd, 2, 3, -1, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.logPanel, this.cbDir, 3, 3, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.logPanel, this.cbDel, 0, 4, 1, 1, 2, 17, 1.0, 1.0, 0, 40, 0, 0);
        Utility.constrain(this.logPanel, this.cbGet, 1, 4, 1, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.logPanel, this.cbPut, 2, 4, -1, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.logPanel, this.cbRen, 3, 4, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.logPanel, 0, 4, 0, 1, 2, 10, 1.0, 0.8, 0, 0, 0, 0);
        this.addButtonGUI(0, 5, 5);
        Utility.constrain(this, this.centerPanel, 0, 0, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        this.setCursorFocus(this.tfRead);
    }

    public void enableGUI(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].setEnabled(bl);
            ++n;
        }
        this.cbLogAll.setEnabled(bl);
        this.cbCd.setEnabled(bl);
        this.cbMd.setEnabled(bl);
        this.cbRd.setEnabled(bl);
        this.cbDir.setEnabled(bl);
        this.cbDel.setEnabled(bl);
        this.cbGet.setEnabled(bl);
        this.cbPut.setEnabled(bl);
        this.cbRen.setEnabled(bl);
        this.cbDbg.setEnabled(bl);
        this.cbEnable.setEnabled(bl);
        this.cbDenyRead.setEnabled(bl);
        this.cbDenyWrite.setEnabled(bl);
        this.tfRead.setEnabled(bl);
        this.tfWrite.setEnabled(bl);
        this.tfTimeout.setEnabled(bl);
    }

    private void doHelpButton() {
        this.getHelp("TCNBCUS.htm");
    }

    public boolean getEnableUser() {
        return this.cbEnable.getState();
    }

    public void setEnableUser(boolean bl) {
        this.cbEnable.setState(bl);
    }

    public String getRead() {
        return this.tfRead.getText();
    }

    public void setRead(String string) {
        ((TextComponent)this.tfRead).setText(string);
    }

    public String getWrite() {
        return this.tfWrite.getText();
    }

    public void setWrite(String string) {
        ((TextComponent)this.tfWrite).setText(string);
    }

    public boolean getDenyRead() {
        return this.cbDenyRead.getState();
    }

    public void setDenyRead(boolean bl) {
        this.cbDenyRead.setState(bl);
    }

    public boolean getDenyWrite() {
        return this.cbDenyWrite.getState();
    }

    public void setDenyWrite(boolean bl) {
        this.cbDenyWrite.setState(bl);
    }

    public int getTimeout() {
        int n;
        try {
            n = Integer.parseInt(this.tfTimeout.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public void setTimeout(int n) {
        ((TextComponent)this.tfTimeout).setText(String.valueOf(n));
    }

    public boolean getCd() {
        return this.cbCd.getState();
    }

    public void setCd(boolean bl) {
        this.cbCd.setState(bl);
    }

    public boolean getMd() {
        return this.cbMd.getState();
    }

    public void setMd(boolean bl) {
        this.cbMd.setState(bl);
    }

    public boolean getRd() {
        return this.cbRd.getState();
    }

    public void setRd(boolean bl) {
        this.cbRd.setState(bl);
    }

    public boolean getDir() {
        return this.cbDir.getState();
    }

    public void setDir(boolean bl) {
        this.cbDir.setState(bl);
    }

    public boolean getDbg() {
        return this.cbDbg.getState();
    }

    public void setDbg(boolean bl) {
        this.cbDbg.setState(bl);
    }

    public boolean getLogAll() {
        return this.cbLogAll.getState();
    }

    public void setLogAll(boolean bl) {
        this.cbLogAll.setState(bl);
        if (bl) {
            this.cbCd.setEnabled(false);
            this.cbMd.setEnabled(false);
            this.cbRd.setEnabled(false);
            this.cbDir.setEnabled(false);
            this.cbDel.setEnabled(false);
            this.cbGet.setEnabled(false);
            this.cbPut.setEnabled(false);
            this.cbRen.setEnabled(false);
        }
    }

    public boolean getDel() {
        return this.cbDel.getState();
    }

    public void setDel(boolean bl) {
        this.cbDel.setState(bl);
    }

    public boolean getGet() {
        return this.cbGet.getState();
    }

    public void setGet(boolean bl) {
        this.cbGet.setState(bl);
    }

    public boolean getPut() {
        return this.cbPut.getState();
    }

    public void setPut(boolean bl) {
        this.cbPut.setState(bl);
    }

    public boolean getRen() {
        return this.cbRen.getState();
    }

    public void setRen(boolean bl) {
        this.cbRen.setState(bl);
    }

    private boolean validateDialog() {
        if (!Cfg2Validation.IsValidNumeric(this.tfTimeout.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DF_BAD_TIMEOUT"), true, this);
            this.setCursorFocus(this.tfTimeout);
            return false;
        }
        if (!Utility.isEmptyTextField(this.tfTimeout)) {
            if (!Cfg2Validation.IsValidNumeric(this.tfTimeout.getText())) {
                this.enableGUI(false);
                this.showErrorDialog(this.myBundle.getString("DF_BAD_TIMEOUT"), true, this);
                this.setCursorFocus(this.tfTimeout);
                return false;
            }
            int n = Integer.parseInt(this.tfTimeout.getText());
            if (n < 30 || n > 7200) {
                this.enableGUI(false);
                this.showErrorDialog(this.myBundle.getString("DF_BAD_TIMEOUT"), true, this);
                this.setCursorFocus(this.tfTimeout);
                return false;
            }
        }
        if (!Utility.isEmptyTextField(this.tfRead) && !Cfg2Validation.IsValidDirectory(this.tfRead.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("GLO_BAD_DIRECTORY"), true, this);
            this.setCursorFocus(this.tfRead);
            return false;
        }
        if (!Utility.isEmptyTextField(this.tfWrite) && !Cfg2Validation.IsValidDirectory(this.tfWrite.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("GLO_BAD_DIRECTORY"), true, this);
            this.setCursorFocus(this.tfWrite);
            return false;
        }
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            this.handleCheckbox((Checkbox)object);
        }
    }

    public void messageFinished(int n) {
        this.enableGUI(true);
        this.requestFocus();
        this.getCursorFocus();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        Dimension dimension = Utility.getDimension(3);
        int n5 = n4 - dimension.height;
        if (n5 > 0) {
            super.setBounds(n, n2, n3, n4 - n5);
            Dimension dimension2 = this.directoryPanel.getSize();
            this.logPanel.getSize();
            int n6 = n5 / 2;
            this.directoryPanel.setSize(dimension2.width, dimension2.height - n6);
            this.logPanel.setSize(dimension2.width, dimension2.height - n6);
            this.getParent().invalidate();
            this.validate();
        }
    }

    public void setVisible(boolean bl) {
        Frame frame = Utility.getFrame((Container)this.myOwner);
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = this.getSize();
        int n = point.x + dimension.width / 2 - dimension2.width / 2;
        int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
        this.setBounds(n, n2, dimension2.width, dimension2.height);
        FocusKeeper.setFocusWindow(this);
        super.setVisible(bl);
        this.getCursorFocus();
    }

    public void handleCheckbox(Checkbox checkbox) {
        if (checkbox == this.cbLogAll) {
            if (this.cbLogAll.getState()) {
                this.cbCd.setEnabled(false);
                this.cbMd.setEnabled(false);
                this.cbRd.setEnabled(false);
                this.cbDir.setEnabled(false);
                this.cbDel.setEnabled(false);
                this.cbGet.setEnabled(false);
                this.cbPut.setEnabled(false);
                this.cbRen.setEnabled(false);
                return;
            }
            this.cbCd.setEnabled(true);
            this.cbMd.setEnabled(true);
            this.cbRd.setEnabled(true);
            this.cbDir.setEnabled(true);
            this.cbDel.setEnabled(true);
            this.cbGet.setEnabled(true);
            this.cbPut.setEnabled(true);
            this.cbRen.setEnabled(true);
        }
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            if (this.validateDialog()) {
                this.setStatus(0);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(0);
                this.dispose();
                return;
            }
        } else {
            if (button == buttonArray[1]) {
                this.setStatus(1);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(1);
                this.dispose();
                return;
            }
            if (button == buttonArray[2]) {
                this.doHelpButton();
            }
        }
    }
}

