/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class DlgHostname1ACDd
extends BaseDialog
implements ActionListener,
MessageListener {
    private ResourceBundle myBundle;
    private MulColumn domainList;
    private Label lblLanDomain;
    private TextField tfLanDomain;
    private Panel centerPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private Component myOwner;
    private GridBagLayout gridBag = new GridBagLayout();
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public DlgHostname1ACDd(int n, Container container, MulColumn mulColumn) {
        super(new Frame(), "", false, container);
        this.setReason(n);
        this.myOwner = container;
        this.domainList = mulColumn;
        this.myBundle = ClientMsg.getBundle();
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(1));
    }

    private void addButtonGUI(int n, int n2, int n3) {
        DlgHostname1ACDd.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        DlgHostname1ACDd.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        DlgHostname1ACDd.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createGUI() {
        this.setTitle(this.myBundle.getString("DHD1_UPDATE_TITLE"));
        this.tfLanDomain = new TextField("");
        this.lblLanDomain = new Label(this.myBundle.getString("DHD1_LAN_DOMAIN"));
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        this.setLayout(this.gridBag);
        Utility.constrain(this.centerPanel, this.lblLanDomain, 0, 1, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.tfLanDomain, 0, 2, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 3, 5);
        Utility.constrain(this, this.centerPanel, 0, 0, 1, 1, 2, 17, 1.0, 1.0, 0, 10, 0, 10);
        if (this.getReason() == 2) {
            this.tfLanDomain.setEnabled(false);
            this.setTitle(this.myBundle.getString("DHD1_DELETE_TITLE"));
            this.lblLanDomain.setEnabled(false);
        }
        this.setCursorFocus(this.tfLanDomain);
    }

    public void enableGUI(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].setEnabled(bl);
            ++n;
        }
        this.tfLanDomain.setEnabled(bl);
    }

    private void doHelpButton() {
        this.getHelp("TCNBCSDN.htm");
    }

    public String getLanDomain() {
        return this.tfLanDomain.getText();
    }

    public void setLanDomain(String string) {
        ((TextComponent)this.tfLanDomain).setText(string);
    }

    private boolean validateDialog() {
        if (this.getReason() == 2) {
            return true;
        }
        String string = null;
        if (Utility.isNoEntries(this.tfLanDomain)) {
            Object[] objectArray = new Object[]{this.myBundle.getString("GLO_NO_ENTRIES")};
            string = MessageFormat.format(this.myBundle.getString("GLO_BAD_NO_ENTRIES"), objectArray);
            this.enableGUI(false);
            this.showErrorDialog(string, true, this);
            this.setCursorFocus(this.tfLanDomain);
            return false;
        }
        if (Utility.isEmptyTextField(this.tfLanDomain)) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DHD1_ENTER_LAN_DOMAIN"), true, this);
            this.setCursorFocus(this.tfLanDomain);
            return false;
        }
        if (this.isDuplicate()) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("GLO_DUPLICATE_ENTRY"), true, this);
            this.setCursorFocus(this.tfLanDomain);
            return false;
        }
        if (!TcpipValidation.IsValidNonFQTcpipName((String)this.tfLanDomain.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DOMAIN_INVALID"), true, this);
            this.setCursorFocus(this.tfLanDomain);
            return false;
        }
        if (Utility.isValidIPAddress(this.tfLanDomain.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DOMAIN_INVALID"), true, this);
            this.setCursorFocus(this.tfLanDomain);
            return false;
        }
        return true;
    }

    public boolean isDuplicate() {
        boolean bl = false;
        int n = this.domainList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray = this.domainList.getItem(n2);
            if (stringArray[0].compareTo(this.tfLanDomain.getText()) == 0) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void messageFinished(int n) {
        this.enableGUI(true);
        this.requestFocus();
        this.getCursorFocus();
    }

    public void setVisible(boolean bl) {
        Frame frame = Utility.getFrame((Container)this.myOwner);
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = this.getSize();
        int n = point.x + dimension.width / 2 - dimension2.width / 2;
        int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
        ((Component)this).setBounds(n, n2, dimension2.width, dimension2.height);
        super.setVisible(bl);
        FocusKeeper.setFocusWindow(this);
        this.getCursorFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            if (this.validateDialog()) {
                this.setStatus(0);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(0);
                if (this.getReason() == 2) {
                    this.dispose();
                    return;
                }
                this.setVisible(false);
                return;
            }
        } else {
            if (button == buttonArray[1]) {
                this.setStatus(1);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(1);
                this.dispose();
                return;
            }
            if (button == buttonArray[2]) {
                this.doHelpButton();
            }
        }
    }
}

