/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.HelpHandle;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class DlgHostname2ACD
extends BaseDialog
implements ActionListener,
MessageListener {
    private ResourceBundle myBundle;
    private MulColumn nameserverList;
    private Label lblIPAddress;
    private Label lblHostname;
    private Label lblAlias;
    private Label lblComment;
    private TextField tfIPAddress;
    private TextField tfHostname;
    private TextField tfAlias;
    private TextField tfComment;
    private Panel centerPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private static final int MAX_COL_SIZE = 25;
    private GridBagLayout gridBag = new GridBagLayout();
    private Component myOwner;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public DlgHostname2ACD(int n, Container container, MulColumn mulColumn) {
        super(new Frame(), "", false, container);
        this.setReason(n);
        this.myOwner = container;
        this.nameserverList = mulColumn;
        this.myBundle = ClientMsg.getBundle();
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(2));
    }

    private void addButtonGUI(int n, int n2, int n3) {
        DlgHostname2ACD.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        DlgHostname2ACD.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        DlgHostname2ACD.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createGUI() {
        this.setTitle(this.myBundle.getString("DH2_UPDATE_TITLE"));
        this.tfIPAddress = new TextField("");
        this.tfHostname = new TextField("");
        this.tfAlias = new TextField("");
        this.tfAlias.setColumns(25);
        this.tfComment = new TextField("");
        this.tfComment.setColumns(25);
        this.lblIPAddress = new Label(this.myBundle.getString("PH2_IP_ADDRESS"));
        this.lblHostname = new Label(this.myBundle.getString("PH2_HOST_NAME"));
        this.lblAlias = new Label(this.myBundle.getString("PH2_ALIAS"));
        this.lblComment = new Label(this.myBundle.getString("PH2_COMMENTS"));
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        this.setLayout(this.gridBag);
        Utility.constrain(this.centerPanel, this.lblIPAddress, 0, 1, 1, 1, 2, 10, 1.0, 1.0, 0, 30, 10, 0);
        Utility.constrain(this.centerPanel, this.tfIPAddress, 1, 1, 1, 1, 2, 17, 1.0, 1.0, 0, 0, 10, 30);
        Utility.constrain(this.centerPanel, this.lblHostname, 0, 2, 1, 1, 2, 10, 1.0, 1.0, 0, 30, 10, 0);
        Utility.constrain(this.centerPanel, this.tfHostname, 1, 2, 1, 1, 2, 17, 1.0, 1.0, 0, 0, 10, 30);
        Utility.constrain(this.centerPanel, this.lblAlias, 0, 3, 1, 1, 2, 10, 1.0, 1.0, 0, 30, 10, 0);
        Utility.constrain(this.centerPanel, this.tfAlias, 1, 3, 1, 1, 2, 17, 1.0, 1.0, 0, 0, 10, 30);
        Utility.constrain(this.centerPanel, this.lblComment, 0, 4, 1, 1, 2, 10, 1.0, 1.0, 0, 30, 10, 0);
        Utility.constrain(this.centerPanel, this.tfComment, 1, 4, 1, 1, 2, 17, 1.0, 1.0, 0, 0, 10, 30);
        this.addButtonGUI(0, 5, 5);
        Utility.constrain(this, this.centerPanel, 0, 0, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        if (this.getReason() == 2) {
            this.tfIPAddress.setEnabled(false);
            this.tfHostname.setEnabled(false);
            this.tfAlias.setEnabled(false);
            this.tfComment.setEnabled(false);
            this.setTitle(this.myBundle.getString("DH2_DELETE_TITLE"));
            this.lblIPAddress.setEnabled(false);
            this.lblHostname.setEnabled(false);
            this.lblAlias.setEnabled(false);
            this.lblComment.setEnabled(false);
        }
        this.setCursorFocus(this.tfIPAddress);
    }

    public void enableGUI(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].setEnabled(bl);
            ++n;
        }
        this.tfIPAddress.setEnabled(bl);
        this.tfHostname.setEnabled(bl);
        this.tfAlias.setEnabled(bl);
        this.tfComment.setEnabled(bl);
    }

    private void doHelpButton() {
        HelpHandle.getHelp("TCNBCSD2.htm");
    }

    public String getIPAddress() {
        return this.tfIPAddress.getText();
    }

    public String getHostname() {
        return this.tfHostname.getText();
    }

    public String getAlias() {
        return this.tfAlias.getText();
    }

    public String getComment() {
        return this.tfComment.getText();
    }

    public void setIPAddress(String string) {
        ((TextComponent)this.tfIPAddress).setText(string);
    }

    public void setHostname(String string) {
        ((TextComponent)this.tfHostname).setText(string);
    }

    public void setAlias(String string) {
        ((TextComponent)this.tfAlias).setText(string);
    }

    public void setComment(String string) {
        ((TextComponent)this.tfComment).setText(string);
    }

    private boolean validateDialog() {
        if (this.getReason() == 2) {
            return true;
        }
        if (Utility.isEmptyTextField(this.tfIPAddress) || Utility.isEmptyTextField(this.tfHostname)) {
            this.showErrorDialog(this.myBundle.getString("DH2_RQD_FIELDS"), true, this);
            this.setCursorFocus(this.tfIPAddress);
            return false;
        }
        if (Utility.isEmptyTextField(this.tfIPAddress)) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DH2_ENTER_IP_ADDR"), true, this);
            this.setCursorFocus(this.tfIPAddress);
            return false;
        }
        if (!TcpipValidation.IsValidTcpipAddr((String)this.tfIPAddress.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("IP_INVALID"), true, this);
            this.setCursorFocus(this.tfIPAddress);
            return false;
        }
        if (!Utility.isEmptyTextField(this.tfIPAddress) && !TcpipValidation.IsValidNonFQTcpipName((String)this.tfIPAddress.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("HOST_INVALID"), true, this);
            this.setCursorFocus(this.tfIPAddress);
            return false;
        }
        if (this.isDuplicate()) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("GLO_DUPLICATE_ENTRY"), true, this);
            this.setCursorFocus(this.tfIPAddress);
            return false;
        }
        return true;
    }

    public boolean isDuplicate() {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.nameserverList.getSelectedIndex();
        int n2 = this.nameserverList.getItemCount();
        if (this.getReason() == 1) {
            bl2 = true;
        }
        int n3 = 0;
        while (n3 < n2) {
            String[] stringArray;
            if (!(n == n3 && bl2 || (stringArray = this.nameserverList.getItem(n3))[0].compareTo(this.tfIPAddress.getText()) != 0)) {
                bl = true;
                break;
            }
            ++n3;
        }
        return bl;
    }

    public void messageFinished(int n) {
        this.enableGUI(true);
        this.requestFocus();
        this.getCursorFocus();
    }

    public void setVisible(boolean bl) {
        Frame frame = Utility.getFrame((Container)this.myOwner);
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = this.getSize();
        int n = point.x + dimension.width / 2 - dimension2.width / 2;
        int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
        ((Component)this).setBounds(n, n2, dimension2.width, dimension2.height);
        super.setVisible(bl);
        FocusKeeper.setFocusWindow(this);
        this.getCursorFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            if (this.validateDialog()) {
                this.setStatus(0);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(0);
                if (this.getReason() == 2) {
                    this.dispose();
                    return;
                }
                this.setVisible(false);
                return;
            }
        } else {
            if (button == buttonArray[1]) {
                this.setStatus(1);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(1);
                this.dispose();
                return;
            }
            if (button == buttonArray[2]) {
                this.doHelpButton();
            }
        }
    }
}

