/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class DlgNFS1ACD
extends BaseDialog
implements ActionListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblDirectory;
    private Label lblAlias;
    private Label lblComments;
    private TextField tfDirectory;
    private TextField tfAlias;
    private TextField tfComments;
    private CheckboxGroup cbGroup;
    private Checkbox cbReadOnly;
    private Checkbox cbReadWrite;
    private MulColumn myList;
    private Panel centerPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private GridBagLayout gridBag = new GridBagLayout();
    private Component myOwner;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public DlgNFS1ACD(int n, Container container, MulColumn mulColumn) {
        super(new Frame(), "", false, container);
        this.setReason(n);
        this.myBundle = ClientMsg.getBundle();
        this.myList = mulColumn;
        this.myOwner = container;
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(1));
    }

    private void addButtonGUI(int n, int n2, int n3) {
        DlgNFS1ACD.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        DlgNFS1ACD.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        DlgNFS1ACD.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createGUI() {
        this.tfDirectory = new TextField();
        this.tfAlias = new TextField();
        this.tfComments = new TextField();
        this.cbGroup = new CheckboxGroup();
        this.setTitle(this.myBundle.getString("DF1_UPDATE_TITLE"));
        this.lblDirectory = new Label(this.myBundle.getString("DSC3ACD_DIRECTORY"));
        this.lblAlias = new Label(this.myBundle.getString("PH2_ALIAS"));
        this.lblComments = new Label(this.myBundle.getString("PH2_COMMENTS"));
        if (this.getReason() == 2) {
            this.tfDirectory.setEnabled(false);
            this.tfAlias.setEnabled(false);
            this.tfComments.setEnabled(false);
            this.lblDirectory.setEnabled(false);
            this.lblAlias.setEnabled(false);
            this.lblComments.setEnabled(false);
        }
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        this.setLayout(this.gridBag);
        Utility.constrain(this.centerPanel, this.lblDirectory, 0, 0, -1, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.tfDirectory, 1, 0, 0, 1, 2, 17, 2.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblAlias, 0, 1, -1, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.tfAlias, 1, 1, 0, 1, 2, 17, 2.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblComments, 0, 2, -1, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.tfComments, 1, 2, 0, 1, 2, 17, 2.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 10, 0, 0);
        this.addButtonGUI(0, 2, 5);
        this.setCursorFocus(this.tfDirectory);
    }

    public void enableGUI(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].setEnabled(bl);
            ++n;
        }
        this.tfDirectory.setEnabled(bl);
    }

    private void doHelpButton() {
        this.getHelp("TCNBNFST.htm");
    }

    public String getAlias() {
        return this.tfAlias.getText();
    }

    public String getComments() {
        return this.tfComments.getText();
    }

    public String getDirectory() {
        return this.tfDirectory.getText();
    }

    public void setAlias(String string) {
        ((TextComponent)this.tfAlias).setText(string);
    }

    public void setComments(String string) {
        ((TextComponent)this.tfComments).setText(string);
    }

    public void setDirectory(String string) {
        ((TextComponent)this.tfDirectory).setText(string);
    }

    private boolean validateDialog() {
        Object[] objectArray;
        if (this.getReason() == 2) {
            return true;
        }
        if (!Utility.isEmptyTextField(this.tfAlias) && Utility.isEmptyTextField(this.tfDirectory)) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DNF_FIELDS_RQD"), true, this);
            this.setCursorFocus(this.tfDirectory);
            return false;
        }
        if (!Utility.isEmptyTextField(this.tfAlias)) {
            objectArray = this.getAlias();
            int n = (objectArray = objectArray.trim()).indexOf(" ");
            if (n > -1) {
                this.showErrorDialog(this.myBundle.getString("DNF_SINGLE_ALIAS"), true, this);
                this.setCursorFocus(this.tfAlias);
                return false;
            }
        }
        if (!Utility.isEmptyTextField(this.tfComments)) {
            objectArray = this.getComments();
            if (!(objectArray = objectArray.trim()).startsWith("# ")) {
                objectArray = "# " + this.getComments();
                this.setComments((String)objectArray);
            }
        }
        if (Utility.isEmptyTextField(this.tfAlias) && Utility.isEmptyTextField(this.tfComments) && Utility.isEmptyTextField(this.tfDirectory)) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DNF_FIELDS_RQD"), true, this);
            this.setCursorFocus(this.tfDirectory);
            return false;
        }
        this.myList.getItemCount();
        if (Utility.isNoEntries(this.tfDirectory)) {
            objectArray = new Object[]{this.myBundle.getString("GLO_NO_ENTRIES")};
            String string = MessageFormat.format(this.myBundle.getString("GLO_BAD_NO_ENTRIES"), objectArray);
            this.enableGUI(false);
            this.showErrorDialog(string, true, this);
            this.setCursorFocus(this.tfDirectory);
            return false;
        }
        return true;
    }

    public void messageFinished(int n) {
        this.enableGUI(true);
        this.requestFocus();
        this.getCursorFocus();
    }

    public void setVisible(boolean bl) {
        Frame frame = Utility.getFrame((Container)this.myOwner);
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = this.getSize();
        int n = point.x + dimension.width / 2 - dimension2.width / 2;
        int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
        ((Component)this).setBounds(n, n2, dimension2.width, dimension2.height);
        super.setVisible(bl);
        FocusKeeper.setFocusWindow(this);
        this.getCursorFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            if (this.validateDialog()) {
                this.setStatus(0);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(0);
                if (this.getReason() == 2) {
                    this.dispose();
                    return;
                }
                this.setVisible(false);
                return;
            }
        } else {
            if (button == buttonArray[1]) {
                this.setStatus(1);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(1);
                this.dispose();
                return;
            }
            if (button == buttonArray[2]) {
                this.doHelpButton();
            }
        }
    }

    public void handleCheckbox(Checkbox checkbox) {
    }
}

