/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BorderPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Validation;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;

public class DlgRouting1ACD
extends BaseDialog
implements ActionListener,
MessageListener,
KeyListener,
ItemListener {
    private ResourceBundle myBundle;
    private MulColumn myList;
    private Label lblDestinationAddress;
    private Label lblRouterAddress;
    private Label lblMetricCount;
    private Label lblSubnetMask;
    private TextField metfDestinationAddress;
    private TextField metfRouterAddress;
    private TextField ntfMetricCount;
    private TextField metfSubnetMask;
    private Checkbox cbBefore;
    private Checkbox cbAfter;
    private Checkbox cbNet;
    private Checkbox cbHost;
    private Checkbox cbDefault;
    private CheckboxGroup cbg;
    private CheckboxGroup cbgRouteType;
    private Panel topPanel;
    private Panel centerPanel;
    private BorderPanel routeTypePanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static boolean originalcbNet;
    private static boolean originalcbHost;
    private static boolean originalcbDefault;
    private static boolean originalmetfDestinationAddress;
    private static boolean originalmetfRouterAddress;
    private static boolean originalntfMetricCount;
    private static boolean originalmetfSubnetMask;
    private static boolean originalcbBefore;
    private static boolean originalcbAfter;
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private Component myOwner;
    private GridBagLayout gridBag = new GridBagLayout();
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public DlgRouting1ACD(int n, Container container, MulColumn mulColumn) {
        super(new Frame(), "", false, container);
        this.setReason(n);
        this.myOwner = container;
        this.myList = mulColumn;
        this.myBundle = ClientMsg.getBundle();
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(2));
    }

    private void addButtonGUI(int n, int n2, int n3) {
        DlgRouting1ACD.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        DlgRouting1ACD.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        DlgRouting1ACD.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createGUI() {
        this.setTitle(this.myBundle.getString("DR1_UPDATE_TITLE"));
        this.lblDestinationAddress = new Label(this.myBundle.getString("DR1_DEST_ADDRESS"));
        this.lblRouterAddress = new Label(this.myBundle.getString("DR1_ROUTER_ADDRESS"));
        this.lblMetricCount = new Label(this.myBundle.getString("DR1_METRIC_COUNT"));
        this.lblSubnetMask = new Label(this.myBundle.getString("DR1_SUBNET_MASK"));
        this.metfSubnetMask = new TextField("");
        this.metfDestinationAddress = new TextField("");
        this.metfRouterAddress = new TextField("");
        this.ntfMetricCount = new TextField("");
        this.cbNet = new Checkbox("net");
        this.cbHost = new Checkbox("host");
        this.cbDefault = new Checkbox("default");
        this.cbgRouteType = new CheckboxGroup();
        this.cbNet.setCheckboxGroup(this.cbgRouteType);
        this.cbHost.setCheckboxGroup(this.cbgRouteType);
        this.cbDefault.setCheckboxGroup(this.cbgRouteType);
        this.cbBefore = new Checkbox(this.myBundle.getString("DR1_BEFORE"));
        this.cbAfter = new Checkbox(this.myBundle.getString("DR1_AFTER"));
        this.cbNet.addItemListener(this);
        this.cbHost.addItemListener(this);
        this.cbDefault.addItemListener(this);
        this.cbBefore.addItemListener(this);
        this.cbAfter.addItemListener(this);
        this.cbBefore.addKeyListener(this);
        this.cbAfter.addKeyListener(this);
        this.cbg = new CheckboxGroup();
        this.cbBefore.setCheckboxGroup(this.cbg);
        this.cbAfter.setCheckboxGroup(this.cbg);
        this.topPanel = new Panel();
        this.centerPanel = new Panel();
        this.routeTypePanel = new BorderPanel(this.myBundle.getString("DR1_ROUTE_TYPE"));
        this.topPanel.setLayout(this.gridBag);
        this.centerPanel.setLayout(this.gridBag);
        this.routeTypePanel.setLayout(this.gridBag);
        this.setLayout(this.gridBag);
        int n = 0;
        if (this.getReason() == 0) {
            Utility.constrain(this.topPanel, this.cbAfter, 0, 0, 0, 1, 2, 10, 1.0, 1.0, 0, 50, 0, 0);
            Utility.constrain(this.topPanel, this.cbBefore, 0, 1, 0, 1, 2, 10, 1.0, 1.0, 0, 50, 0, 0);
            Utility.constrain(this, this.topPanel, 0, 0, 0, 1, 2, 10, 1.0, 1.0, 0, 50, 0, 0);
            this.cbAfter.setState(true);
            n = 1;
        } else if (this.getReason() == 2) {
            this.setTitle(this.myBundle.getString("DR1_DELETE_TITLE"));
            this.cbNet.setEnabled(false);
            this.cbHost.setEnabled(false);
            this.cbDefault.setEnabled(false);
            this.metfDestinationAddress.setEnabled(false);
            this.metfRouterAddress.setEnabled(false);
            this.ntfMetricCount.setEnabled(false);
            this.metfSubnetMask.setEnabled(false);
            this.lblDestinationAddress.setEnabled(false);
            this.lblRouterAddress.setEnabled(false);
            this.lblMetricCount.setEnabled(false);
            this.lblSubnetMask.setEnabled(false);
        }
        Utility.constrain(this.routeTypePanel, this.cbNet, 0, 0, 1, 1, 2, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.routeTypePanel, this.cbHost, 1, 0, -1, 1, 2, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.routeTypePanel, this.cbDefault, 2, 0, 0, 1, 2, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.routeTypePanel, 1, n, 0, 1, 2, 10, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblDestinationAddress, 0, ++n, -1, 1, 2, 10, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.metfDestinationAddress, 1, n, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblRouterAddress, 0, ++n, -1, 1, 2, 10, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.metfRouterAddress, 1, n, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblMetricCount, 0, ++n, -1, 1, 2, 10, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.ntfMetricCount, 1, n, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblSubnetMask, 0, ++n, -1, 1, 2, 10, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.metfSubnetMask, 1, n, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        this.addButtonGUI(0, ++n, 5);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        this.setCursorFocus(this.metfDestinationAddress);
    }

    public void enableGUI(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].setEnabled(bl);
            ++n;
        }
        if (!bl) {
            originalcbNet = this.cbNet.isEnabled();
            originalcbHost = this.cbHost.isEnabled();
            originalcbDefault = this.cbDefault.isEnabled();
            originalmetfDestinationAddress = this.metfDestinationAddress.isEnabled();
            originalmetfRouterAddress = this.metfRouterAddress.isEnabled();
            originalntfMetricCount = this.ntfMetricCount.isEnabled();
            originalmetfSubnetMask = this.metfSubnetMask.isEnabled();
            originalcbBefore = this.cbBefore.isEnabled();
            originalcbAfter = this.cbAfter.isEnabled();
            this.metfDestinationAddress.setEnabled(bl);
            this.metfRouterAddress.setEnabled(bl);
            this.ntfMetricCount.setEnabled(bl);
            this.metfSubnetMask.setEnabled(bl);
            this.cbBefore.setEnabled(bl);
            this.cbAfter.setEnabled(bl);
        } else {
            this.cbNet.setEnabled(originalcbNet);
            this.cbHost.setEnabled(originalcbHost);
            this.cbDefault.setEnabled(originalcbDefault);
            this.metfDestinationAddress.setEnabled(originalmetfDestinationAddress);
            this.metfRouterAddress.setEnabled(originalmetfRouterAddress);
            this.ntfMetricCount.setEnabled(originalntfMetricCount);
            this.metfSubnetMask.setEnabled(originalmetfSubnetMask);
            this.cbBefore.setEnabled(originalcbBefore);
            this.cbAfter.setEnabled(originalcbAfter);
        }
        this.refreshContainer(this.centerPanel);
    }

    private void doHelpButton() {
        this.getHelp("TCNBROUT.htm");
    }

    public String getDestinationAddress() {
        return this.metfDestinationAddress.getText();
    }

    public boolean getAddBeforeState() {
        return this.cbBefore.getState();
    }

    public boolean getAddAfterState() {
        return this.cbAfter.getState();
    }

    public String getMetricCount() {
        return this.ntfMetricCount.getText();
    }

    public String getRouterAddress() {
        return this.metfRouterAddress.getText();
    }

    public String getRouteType() {
        if (this.cbNet.getState()) {
            return "net";
        }
        if (this.cbHost.getState()) {
            return "host";
        }
        return "default";
    }

    public String getSubnetMask() {
        return this.metfSubnetMask.getText();
    }

    public void setAddBeforeState(boolean bl) {
        this.cbBefore.setState(bl);
    }

    public void setAddAfterState(boolean bl) {
        this.cbAfter.setState(bl);
    }

    public void setDestinationAddress(String string) {
        ((TextComponent)this.metfDestinationAddress).setText(string);
    }

    public void setMetricCount(String string) {
        ((TextComponent)this.ntfMetricCount).setText(string);
    }

    public void setRouterAddress(String string) {
        ((TextComponent)this.metfRouterAddress).setText(string);
    }

    public void setRouteType(String string) {
        this.cbNet.setState(false);
        this.cbHost.setState(false);
        this.cbDefault.setState(false);
        if (string.compareTo("default") == 0) {
            this.cbDefault.setState(true);
            this.lblDestinationAddress.setEnabled(false);
            this.lblSubnetMask.setEnabled(false);
            return;
        }
        if (string.compareTo("host") == 0) {
            this.cbHost.setState(true);
            this.lblSubnetMask.setEnabled(false);
            return;
        }
        this.cbNet.setState(true);
    }

    public void setSubnetMask(String string) {
        ((TextComponent)this.metfSubnetMask).setText(string);
    }

    private boolean validateDialog() {
        if (this.getReason() == 2) {
            return true;
        }
        if (!this.cbDefault.getState() && (Utility.isEmptyTextField(this.metfDestinationAddress) || Utility.isEmptyTextField(this.metfRouterAddress) || Utility.isEmptyTextField(this.ntfMetricCount))) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DR1_FIELDS_RQD"), true, this);
            this.setCursorFocus(this.metfDestinationAddress);
            return false;
        }
        if (this.cbDefault.getState() && (Utility.isEmptyTextField(this.metfRouterAddress) || Utility.isEmptyTextField(this.ntfMetricCount))) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("GLO_RQD_FIELDS"), true, this);
            this.setCursorFocus(this.metfRouterAddress);
            return false;
        }
        if (!Cfg2Validation.IsValidNumeric(this.ntfMetricCount.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("PN2_INVALID_METRIC_COUNT"), true, this);
            this.setCursorFocus(this.ntfMetricCount);
            return false;
        }
        if (!Utility.isEmptyTextField(this.ntfMetricCount)) {
            if (!Cfg2Validation.IsValidNumeric(this.ntfMetricCount.getText())) {
                this.enableGUI(false);
                this.showErrorDialog(this.myBundle.getString("PN2_INVALID_METRIC_COUNT"), true, this);
                this.setCursorFocus(this.ntfMetricCount);
                return false;
            }
            Integer n = new Integer(this.ntfMetricCount.getText());
            if (n < 1 || n > 15) {
                this.enableGUI(false);
                this.showErrorDialog(this.myBundle.getString("PN2_INVALID_METRIC_COUNT"), true, this);
                this.setCursorFocus(this.ntfMetricCount);
                return false;
            }
        }
        if (!(Utility.isEmptyTextField(this.metfDestinationAddress) || this.cbDefault.getState() || TcpipValidation.IsValidTcpipAddr((String)this.metfDestinationAddress.getText()))) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("IP_INVALID"), true, this);
            this.setCursorFocus(this.metfDestinationAddress);
            return false;
        }
        if (!Utility.isEmptyTextField(this.metfRouterAddress) && !TcpipValidation.IsValidTcpipAddr((String)this.metfRouterAddress.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("IP_INVALID"), true, this);
            this.setCursorFocus(this.metfRouterAddress);
            return false;
        }
        if (!Utility.isEmptyTextField(this.metfSubnetMask) && !TcpipValidation.IsValidTcpipAddr((String)this.metfSubnetMask.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("SUBNET_INVALID"), true, this);
            this.setCursorFocus(this.metfSubnetMask);
            return false;
        }
        if (this.isDuplicate()) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("GLO_DUPLICATE_ENTRY"), true, this);
            this.setCursorFocus(this.metfDestinationAddress);
            return false;
        }
        return true;
    }

    public boolean isDuplicate() {
        boolean bl = false;
        if (this.myList.getItemCount() == 0) {
            return false;
        }
        String[] stringArray = this.myList.getItem(0);
        if (stringArray[0].compareTo(this.myBundle.getString("GLO_NO_ENTRIES")) == 0) {
            return false;
        }
        int n = this.myList.getItemCount();
        int n2 = this.myList.getSelectedIndex();
        if (this.getReason() == 1) {
            bl = true;
        }
        String string = null;
        int n3 = 0;
        while (n3 < n) {
            stringArray = this.myList.getItem(n3);
            string = this.cbNet.getState() ? new String("net") : (this.cbHost.getState() ? new String("host") : new String("default"));
            if (stringArray[2].compareTo(this.metfRouterAddress.getText()) == 0 && stringArray[0].compareTo(string) == 0 && stringArray[1].compareTo(this.metfDestinationAddress.getText()) == 0 && stringArray[3].compareTo(this.ntfMetricCount.getText()) == 0 && stringArray[4].compareTo(this.metfSubnetMask.getText()) == 0) {
                return true;
            }
            ++n3;
        }
        if (this.cbDefault.getState()) {
            String string2 = Utility.getOctet(1, this.metfRouterAddress.getText());
            int n4 = 0;
            while (n4 < n) {
                if (!(n2 == n4 && bl || (stringArray = this.myList.getItem(n4))[0].compareTo("net") != 0 || stringArray[1].compareTo(string2) != 0)) {
                    return true;
                }
                ++n4;
            }
        }
        if (this.cbNet.getState()) {
            int n5 = 0;
            while (n5 < n) {
                if (!(n2 == n5 && bl || (stringArray = this.myList.getItem(n5))[0].compareTo("net") != 0 || stringArray[1].compareTo(this.metfDestinationAddress.getText()) != 0)) {
                    return true;
                }
                ++n5;
            }
        }
        return false;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox && (object == this.cbBefore || object == this.cbAfter)) {
            return;
        }
        if (object instanceof Checkbox) {
            this.handleCheckbox((Checkbox)object);
        }
        this.refreshContainer(this.centerPanel);
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            if (this.validateDialog()) {
                this.setStatus(0);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(0);
                if (this.getReason() == 2) {
                    this.dispose();
                    return;
                }
                this.setVisible(false);
                return;
            }
        } else {
            if (button == buttonArray[1]) {
                this.setStatus(1);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(1);
                this.dispose();
                return;
            }
            if (button == buttonArray[2]) {
                this.doHelpButton();
            }
        }
    }

    public void handleCheckbox(Checkbox checkbox) {
        ((TextComponent)this.metfSubnetMask).setText("");
        ((TextComponent)this.metfDestinationAddress).setText("");
        ((TextComponent)this.metfRouterAddress).setText("");
        Integer n = new Integer(1);
        ((TextComponent)this.ntfMetricCount).setText(n.toString());
        if (this.cbDefault.getState()) {
            this.lblDestinationAddress.setEnabled(false);
            this.metfDestinationAddress.setEnabled(false);
            this.lblSubnetMask.setEnabled(false);
            this.metfSubnetMask.setEnabled(false);
            return;
        }
        if (this.cbHost.getState()) {
            this.lblDestinationAddress.setEnabled(true);
            this.metfDestinationAddress.setEnabled(true);
            this.lblSubnetMask.setEnabled(false);
            this.metfSubnetMask.setEnabled(false);
            return;
        }
        this.lblDestinationAddress.setEnabled(true);
        this.metfDestinationAddress.setEnabled(true);
        this.lblSubnetMask.setEnabled(true);
        this.metfSubnetMask.setEnabled(true);
    }

    public void messageFinished(int n) {
        this.enableGUI(true);
        this.requestFocus();
        this.getCursorFocus();
    }

    public void setVisible(boolean bl) {
        Frame frame = Utility.getFrame((Container)this.myOwner);
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = this.getSize();
        int n = point.x + dimension.width / 2 - dimension2.width / 2;
        int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
        ((Component)this).setBounds(n, n2, dimension2.width, dimension2.height);
        super.setVisible(bl);
        FocusKeeper.setFocusWindow(this);
        this.getCursorFocus();
    }
}

