/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class DlgSecurity3ACD
extends BaseDialog
implements ActionListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblDirectory;
    private TextField tfDirectory;
    private CheckboxGroup cbGroup;
    private Checkbox cbReadOnly;
    private Checkbox cbReadWrite;
    private MulColumn myList;
    private Panel centerPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private GridBagLayout gridBag = new GridBagLayout();
    private Component myOwner;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public DlgSecurity3ACD(int n, Container container, MulColumn mulColumn) {
        super(new Frame(), "", false, container);
        this.setReason(n);
        this.myBundle = ClientMsg.getBundle();
        this.myList = mulColumn;
        this.myOwner = container;
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(1));
    }

    private void addButtonGUI(int n, int n2, int n3) {
        DlgSecurity3ACD.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        DlgSecurity3ACD.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        DlgSecurity3ACD.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createGUI() {
        this.tfDirectory = new TextField();
        this.cbGroup = new CheckboxGroup();
        this.setTitle(this.myBundle.getString("DSC3ACD_TITLE"));
        this.cbReadOnly = new Checkbox(this.myBundle.getString("DSC3ACD_READONLY"), this.cbGroup, true);
        this.cbReadWrite = new Checkbox(this.myBundle.getString("DSC3ACD_READWRITE"), this.cbGroup, false);
        this.cbReadOnly.addKeyListener(this);
        this.cbReadWrite.addKeyListener(this);
        this.lblDirectory = new Label(this.myBundle.getString("DSC3ACD_DIRECTORY"));
        if (this.getReason() == 2) {
            this.tfDirectory.setEnabled(false);
            this.cbReadOnly.setEnabled(false);
            this.cbReadWrite.setEnabled(false);
            this.lblDirectory.setEnabled(false);
        }
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        this.setLayout(this.gridBag);
        Utility.constrain(this.centerPanel, this.lblDirectory, 0, 1, 0, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.tfDirectory, 0, 2, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.cbReadOnly, 0, 3, 0, 1, 2, 10, 1.0, 1.0, 0, 10, 0, 10);
        Utility.constrain(this.centerPanel, this.cbReadWrite, 0, 4, 0, 1, 2, 10, 1.0, 1.0, 0, 10, 0, 10);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 10, 0, 0);
        this.addButtonGUI(0, 2, 5);
        this.setCursorFocus(this.tfDirectory);
    }

    public void enableGUI(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].setEnabled(bl);
            ++n;
        }
        this.tfDirectory.setEnabled(bl);
        this.cbReadOnly.setEnabled(bl);
        this.cbReadWrite.setEnabled(bl);
    }

    private void doHelpButton() {
        this.getHelp("TCNBCTS.htm");
    }

    public String getDirectory() {
        return this.tfDirectory.getText();
    }

    public void setDirectory(String string) {
        ((TextComponent)this.tfDirectory).setText(string);
    }

    public boolean isReadOnly() {
        return this.cbReadOnly.getState();
    }

    public void setReadOnly(boolean bl) {
        this.cbReadOnly.setState(bl);
    }

    public boolean isReadWrite() {
        return this.cbReadWrite.getState();
    }

    public void setReadWrite(boolean bl) {
        this.cbReadWrite.setState(bl);
    }

    private boolean validateDialog() {
        if (this.getReason() == 2) {
            return true;
        }
        if (Utility.isEmptyTextField(this.tfDirectory)) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DSC3ACD_FIELDS_RQD"), true, this);
            this.setCursorFocus(this.tfDirectory);
            return false;
        }
        int n = this.myList.getItemCount();
        String[] stringArray = null;
        String string = this.cbReadWrite.getState() ? this.myBundle.getString("GLO_READ_WRITE") : this.myBundle.getString("GLO_READ_ONLY");
        if (!this.isNoEntries(this.myList, 1) && this.myList.getItemCount() > 0) {
            int n2 = 0;
            while (n2 < n) {
                stringArray = this.myList.getItem(n2);
                if (stringArray[0].compareTo(string) == 0 && stringArray[1].compareTo(this.tfDirectory.getText()) == 0) {
                    this.enableGUI(false);
                    this.showErrorDialog(this.myBundle.getString("DSC3ACD_DUPLICATE_ENTRY"), true, this);
                    this.setCursorFocus(this.tfDirectory);
                    return false;
                }
                ++n2;
            }
        }
        if (Utility.isNoEntries(this.tfDirectory)) {
            Object[] objectArray = new Object[]{this.myBundle.getString("GLO_NO_ENTRIES")};
            String string2 = MessageFormat.format(this.myBundle.getString("GLO_BAD_NO_ENTRIES"), objectArray);
            this.enableGUI(false);
            this.showErrorDialog(string2, true, this);
            this.setCursorFocus(this.tfDirectory);
            return false;
        }
        return true;
    }

    public void messageFinished(int n) {
        this.enableGUI(true);
        this.requestFocus();
        this.getCursorFocus();
    }

    public void setVisible(boolean bl) {
        Frame frame = Utility.getFrame((Container)this.myOwner);
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = this.getSize();
        int n = point.x + dimension.width / 2 - dimension2.width / 2;
        int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
        ((Component)this).setBounds(n, n2, dimension2.width, dimension2.height);
        super.setVisible(bl);
        FocusKeeper.setFocusWindow(this);
        this.getCursorFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            if (this.validateDialog()) {
                this.setStatus(0);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(0);
                if (this.getReason() == 2) {
                    this.dispose();
                    return;
                }
                this.setVisible(false);
                return;
            }
        } else {
            if (button == buttonArray[1]) {
                this.setStatus(1);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(1);
                this.dispose();
                return;
            }
            if (button == buttonArray[2]) {
                this.doHelpButton();
            }
        }
    }

    public void handleCheckbox(Checkbox checkbox) {
    }
}

