/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewEventListener;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgError;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgMessage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.HelpHandle;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgAutostart1;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgGeneral1;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgHostname1;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgHostname2;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgNFS1;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgNetwork1;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgNetwork2;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgNetwork3;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgPrinting1;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgRouting1;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgSOCKS1;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgSOCKS2;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgSOCKS3;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgSecurity1;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgSecurity2;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgSecurity3;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgSecurity4;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgSecurity5;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgTimed1;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Tcpcfg2;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookProfile;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

public class Notebook
extends Frame
implements Cfg2Defines,
ActionListener,
WindowListener,
KeyListener,
TabViewEventListener,
DialogListener,
MessageListener {
    public static final String BNB_tag = new String("Bnb");
    public static final String ENB_tag = new String("Enb");
    private ResourceBundle myBundle;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 14));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(Utility.NOTEBOOK_COLOR, Utility.TEXT_COLOR, Utility.HIGHLIGHT_COLOR);
    private TabView tabView;
    private TabView networkTabView;
    private TabView hostnameTabView;
    private TabView securityTabView;
    private TabView SOCKSTabView;
    private TabViewNode[] tabNodes;
    private static final int TAB_ID_NONE = -1;
    private static final int TAB_ID_NETWORK = 0;
    private static final int TAB_ID_BASIC = 1;
    private static final int TAB_ID_ADVANCED1 = 2;
    private static final int TAB_ID_ADVANCED2 = 3;
    private static final int TAB_ID_ROUTING = 4;
    private static final int TAB_ID_HOSTNAMES = 5;
    private static final int TAB_ID_NAME_RES = 6;
    private static final int TAB_ID_HOSTS = 7;
    private static final int TAB_ID_AUTOSTART = 8;
    private static final int TAB_ID_GENERAL = 9;
    private static final int TAB_ID_SECURITY = 10;
    private static final int TAB_ID_USER_ACCESS = 11;
    private static final int TAB_ID_RSHD = 12;
    private static final int TAB_ID_TFTPD = 13;
    private static final int TAB_ID_TCPAUTH = 14;
    private static final int TAB_ID_SOCKS = 15;
    private static final int TAB_ID_DEFAULTS = 16;
    private static final int TAB_ID_DIRECT_ROUTES = 17;
    private static final int TAB_ID_SERVERS = 18;
    private static final int TAB_ID_PRINTING = 19;
    private static final int TAB_ID_NFS = 20;
    private static final int TAB_ID_TIMED = 21;
    private static final int TAB_ID_TFTPA = 22;
    private static final int TAB_ID_SIZE = 23;
    private int tabIamOn = 1;
    private int lastNetworkTabVisited = 1;
    private int lastHostnamesTabVisited = 6;
    private int lastSecurityTabVisited = 11;
    private int lastSocksTabVisited = 16;
    private String[] buttonLabels = new String[]{null, null, null};
    private ButtonPanel myButtonPanel;
    private final int OK_BUTTON = 0;
    private final int CANCEL_BUTTON = 1;
    private final int HELP_BUTTON = 2;
    private final int START_TRACE_BUTTON = 3;
    private final int STOP_TRACE_BUTTON = 4;
    private PgNetwork1 pgNetwork1;
    private PgNetwork2 pgNetwork2;
    private PgNetwork3 pgNetwork3;
    private PgRouting1 pgRouting1;
    private PgHostname1 pgHostname1;
    private PgHostname2 pgHostname2;
    private PgAutostart1 pgAutostart1;
    private PgGeneral1 pgGeneral1;
    private PgSecurity1 pgSecurity1;
    private PgSecurity2 pgSecurity2;
    private PgSecurity3 pgSecurity3;
    private PgSecurity4 pgSecurity4;
    private PgSecurity5 pgSecurity5;
    private PgSOCKS1 pgSOCKS1;
    private PgSOCKS2 pgSOCKS2;
    private PgSOCKS3 pgSOCKS3;
    private PgPrinting1 pgPrinting1;
    private PgNFS1 pgNFS1;
    private PgTimed1 pgTimed1;
    private Panel notebookPanel;
    private Panel pagesPanel;
    private TextField myStatusLine;
    private Label lblHost;
    private Label lblProfile;
    private Label lblHostProfile;
    private NotebookProfile myCurrentlyLoadedProfile;
    private boolean myTrace = false;
    private Dimension dimFrame = new Dimension(1, 1);
    private DlgMessage okDialog;
    private DlgMessage cancelDialog;
    private DlgError loadErrorDialog;
    private DlgError saveErrorDialog;
    private int notebook_dialogActivity = 0;
    private Tcpcfg2 myOwner;
    private BaseProxy myServerProxy;
    private ErrorListController myErrorListController;
    private int myWidth = 652;
    private int myHeight = 521;
    private AppletContext myContext;
    private String tabIamLeaving;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public Notebook(Tcpcfg2 tcpcfg2, BaseProxy baseProxy) {
        super("");
        this.myOwner = tcpcfg2;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.myServerProxy = baseProxy;
        this.tabIamLeaving = new String(this.myBundle.getString("NB_NETWORK"));
        this.myContext = this.myOwner.getTheContext();
        this.myWidth = 500;
        this.myHeight = 600;
        this.createGUI();
        this.addWindowListener(this);
        this.createDataObjects();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        this.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        this.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        this.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        this.myButtonPanel = new ButtonPanel(this, this.buttonLabels, n3);
        Utility.constrain(this.notebookPanel, this.myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(this.myButtonPanel);
    }

    private void createDataObjects() {
        try {
            this.myServerProxy.talkToNetwork(1);
            this.myOwner.setStatusMessage(this.myBundle.getString("NB_LOAD_STATUS"));
            this.myServerProxy.talkToNetwork(3);
            this.myErrorListController = this.myServerProxy.getErrorListControllerDataHandle();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Notebook.createDataObjects() - NullPointerException caught by client communication with server");
            nullPointerException.printStackTrace();
            return;
        }
        if (this.myErrorListController.isMoreMessages()) {
            this.processLoadMessages();
        }
        if (this.myErrorListController.getErrorListSize(3) > 0) {
            this.myOwner.shutDown();
            return;
        }
        this.notebookReload();
    }

    private void createGUI() {
        ((Component)this).setBackground(Utility.NOTEBOOK_COLOR);
        this.setTitle(this.myBundle.getString("NB_TITLE"));
        this.myStatusLine = new TextField();
        this.myStatusLine.setEditable(false);
        this.setLayout(new GridBagLayout());
        this.createTabNodes();
        this.tabView = new TabView(new Point(0, 0), new Dimension(this.myWidth, this.myHeight), this.ffcFont, this.cfcColor, null, 1);
        this.tabView.addTabViewEventListener((TabViewEventListener)this);
        this.networkTabView = new TabView(new Point(0, 0), this.tabView.getDisplaySize(), this.ffcFont, this.cfcColor, null, 2);
        this.networkTabView.addTabViewEventListener((TabViewEventListener)this);
        this.pgNetwork1 = new PgNetwork1(this);
        this.tabNodes[1].setText(this.myBundle.getString("NB_BASIC"));
        this.tabNodes[1].setPanel((Panel)this.pgNetwork1);
        this.networkTabView.addTab(this.tabNodes[1]);
        this.pgNetwork2 = new PgNetwork2(this);
        this.tabNodes[2].setText(this.myBundle.getString("NB_ADVANCED1"));
        this.tabNodes[2].setPanel((Panel)this.pgNetwork2);
        this.networkTabView.addTab(this.tabNodes[2]);
        this.pgNetwork3 = new PgNetwork3(this);
        this.tabNodes[3].setText(this.myBundle.getString("NB_ADVANCED2"));
        this.tabNodes[3].setPanel((Panel)this.pgNetwork3);
        this.networkTabView.addTab(this.tabNodes[3]);
        this.networkTabView.committ();
        this.tabNodes[0].setText(this.myBundle.getString("NB_NETWORK"));
        this.tabNodes[0].setPanel((Panel)this.networkTabView);
        this.tabView.addTab(this.tabNodes[0]);
        this.pgRouting1 = new PgRouting1(this);
        this.tabNodes[4].setText(this.myBundle.getString("NB_ROUTING"));
        this.tabNodes[4].setPanel((Panel)this.pgRouting1);
        this.tabView.addTab(this.tabNodes[4]);
        this.hostnameTabView = new TabView(new Point(0, 0), this.tabView.getDisplaySize(), this.ffcFont, this.cfcColor, null, 2);
        this.hostnameTabView.addTabViewEventListener((TabViewEventListener)this);
        this.pgHostname1 = new PgHostname1(this);
        this.tabNodes[6].setText(this.myBundle.getString("NB_NAME_RES"));
        this.tabNodes[6].setPanel((Panel)this.pgHostname1);
        this.hostnameTabView.addTab(this.tabNodes[6]);
        this.pgHostname2 = new PgHostname2(this);
        this.tabNodes[7].setText(this.myBundle.getString("NB_HOSTS"));
        this.tabNodes[7].setPanel((Panel)this.pgHostname2);
        this.hostnameTabView.addTab(this.tabNodes[7]);
        this.hostnameTabView.committ();
        this.tabNodes[5].setText(this.myBundle.getString("NB_HOSTNAMES"));
        this.tabNodes[5].setPanel((Panel)this.hostnameTabView);
        this.tabView.addTab(this.tabNodes[5]);
        this.pgAutostart1 = new PgAutostart1(this);
        this.tabNodes[8].setText(this.myBundle.getString("NB_AUTOSTART"));
        this.tabNodes[8].setPanel((Panel)this.pgAutostart1);
        this.tabView.addTab(this.tabNodes[8]);
        this.pgGeneral1 = new PgGeneral1(this);
        this.tabNodes[9].setText(this.myBundle.getString("NB_GGENERAL"));
        this.tabNodes[9].setPanel((Panel)this.pgGeneral1);
        this.tabView.addTab(this.tabNodes[9]);
        this.securityTabView = new TabView(new Point(0, 0), this.tabView.getDisplaySize(), this.ffcFont, this.cfcColor, null, 2);
        this.securityTabView.addTabViewEventListener((TabViewEventListener)this);
        this.pgSecurity1 = new PgSecurity1(this);
        this.tabNodes[11].setText(this.myBundle.getString("NB_USER_ACCESS"));
        this.tabNodes[11].setPanel((Panel)this.pgSecurity1);
        this.securityTabView.addTab(this.tabNodes[11]);
        this.pgSecurity2 = new PgSecurity2(this);
        this.tabNodes[12].setText(this.myBundle.getString("NB_RSH_ACCESS"));
        this.tabNodes[12].setPanel((Panel)this.pgSecurity2);
        this.securityTabView.addTab(this.tabNodes[12]);
        this.pgSecurity3 = new PgSecurity3(this);
        this.tabNodes[13].setText(this.myBundle.getString("NB_TFTP_ACCESS"));
        this.tabNodes[13].setPanel((Panel)this.pgSecurity3);
        this.securityTabView.addTab(this.tabNodes[13]);
        this.pgSecurity4 = new PgSecurity4(this);
        this.tabNodes[14].setText(this.myBundle.getString("NB_TCPAUTH_ACCESS"));
        this.tabNodes[14].setPanel((Panel)this.pgSecurity4);
        if (Utility.isLocalConfig()) {
            this.securityTabView.addTab(this.tabNodes[14]);
        }
        this.pgSecurity5 = new PgSecurity5(this);
        this.tabNodes[22].setText(this.myBundle.getString("NB_TFTPA_ACCESS"));
        this.tabNodes[22].setPanel((Panel)this.pgSecurity5);
        this.securityTabView.addTab(this.tabNodes[22]);
        this.securityTabView.committ();
        this.tabNodes[10].setText(this.myBundle.getString("NB_SECURITY"));
        this.tabNodes[10].setPanel((Panel)this.securityTabView);
        this.tabView.addTab(this.tabNodes[10]);
        this.SOCKSTabView = new TabView(new Point(0, 0), this.tabView.getDisplaySize(), this.ffcFont, this.cfcColor, null, 2);
        this.SOCKSTabView.addTabViewEventListener((TabViewEventListener)this);
        this.pgSOCKS1 = new PgSOCKS1(this);
        this.tabNodes[16].setText(this.myBundle.getString("NB_DEFAULTS"));
        this.tabNodes[16].setPanel((Panel)this.pgSOCKS1);
        this.SOCKSTabView.addTab(this.tabNodes[16]);
        this.pgSOCKS2 = new PgSOCKS2(this);
        this.tabNodes[17].setText(this.myBundle.getString("NB_DIRECT_ROUTES"));
        this.tabNodes[17].setPanel((Panel)this.pgSOCKS2);
        this.SOCKSTabView.addTab(this.tabNodes[17]);
        this.pgSOCKS3 = new PgSOCKS3(this);
        this.tabNodes[18].setText(this.myBundle.getString("NB_SSERVERS"));
        this.tabNodes[18].setPanel((Panel)this.pgSOCKS3);
        this.SOCKSTabView.addTab(this.tabNodes[18]);
        this.SOCKSTabView.committ();
        this.tabNodes[15].setText(this.myBundle.getString("NB_SOCKS"));
        this.tabNodes[15].setPanel((Panel)this.SOCKSTabView);
        this.tabView.addTab(this.tabNodes[15]);
        this.pgPrinting1 = new PgPrinting1(this);
        this.tabNodes[19].setText(this.myBundle.getString("NB_PRINTING"));
        this.tabNodes[19].setPanel((Panel)this.pgPrinting1);
        this.tabView.addTab(this.tabNodes[19]);
        this.pgNFS1 = new PgNFS1(this);
        this.tabNodes[20].setText(this.myBundle.getString("NB_NFS"));
        this.tabNodes[20].setPanel((Panel)this.pgNFS1);
        this.tabView.addTab(this.tabNodes[20]);
        this.tabView.committ();
        this.myStatusLine = new TextField();
        this.myStatusLine.setEditable(false);
        this.lblProfile = new Label(this.myBundle.getString("NB_PROFILE"));
        if (Utility.isLocalConfig()) {
            this.lblHost = new Label("");
            this.lblHostProfile = new Label("");
        } else {
            this.lblHost = new Label(this.myBundle.getString("NB_HOST"));
            this.lblHostProfile = new Label(this.myBundle.getString("GLO_HOST_CONFIGURED"));
        }
        this.lblHostProfile.setFont(new Font("Helvetica", 0, 14));
        this.notebookPanel = new Panel();
        this.pagesPanel = new Panel();
        this.notebookPanel.setLayout(new GridBagLayout());
        this.pagesPanel.setLayout(new GridBagLayout());
        Utility.constrain(this.pagesPanel, (Component)this.tabView, 0, 0, 0, 1, 1, 10, 1.0, 1.0, 5, 0, 0, 0);
        Utility.constrain(this.notebookPanel, this.lblHostProfile, 0, 0, 0, 1, 0, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 1, 5);
        Utility.constrain(this.pagesPanel, this.notebookPanel, 0, 1, 0, 1, 1, 15, 1.0, 0.0, 5, 0, 0, 0);
        Utility.constrain(this, this.pagesPanel, 0, 0, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        Dimension dimension = Utility.getDimension(0);
        this.setSize(dimension);
    }

    private void createTabNodes() {
        this.tabNodes = new TabViewNode[23];
        int n = 0;
        while (n < 23) {
            this.tabNodes[n] = new TabViewNode();
            this.tabNodes[n].setColors(this.cfcColor);
            this.tabNodes[n].setFonts(this.ffcFont);
            this.tabNodes[n].setImage(null);
            this.tabNodes[n].setId(n);
            ++n;
        }
    }

    private Dimension getMinimumSize(Container container) {
        LayoutManager layoutManager = container.getLayout();
        return layoutManager.minimumLayoutSize(container);
    }

    private void listenToButtons(ButtonPanel buttonPanel) {
        Button[] buttonArray = buttonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].addActionListener(this);
            buttonArray[n].addKeyListener(this);
            ++n;
        }
    }

    public void notebookReload() {
        if (Utility.isLocalConfig()) {
            this.lblHostProfile.setText("");
        } else {
            this.lblHostProfile.setText(String.valueOf(this.lblHost.getText()) + this.myServerProxy.getHostName());
        }
        this.pgNetwork1.loadData(this.myServerProxy);
        this.pgNetwork2.loadData(this.myServerProxy);
        this.pgNetwork3.loadData(this.myServerProxy);
        this.pgRouting1.loadData(this.myServerProxy);
        this.pgSOCKS1.loadData(this.myServerProxy);
        this.pgSOCKS2.loadData(this.myServerProxy);
        this.pgSOCKS3.loadData(this.myServerProxy);
        this.pgPrinting1.loadData(this.myServerProxy);
        this.pgGeneral1.loadData(this.myServerProxy);
        this.pgHostname1.loadData(this.myServerProxy);
        this.pgHostname2.loadData(this.myServerProxy);
        this.pgSecurity1.loadData(this.myServerProxy);
        this.pgSecurity2.loadData(this.myServerProxy);
        this.pgSecurity3.loadData(this.myServerProxy);
        this.pgSecurity4.loadData(this.myServerProxy);
        this.pgSecurity5.loadData(this.myServerProxy);
        this.pgAutostart1.loadData(this.myServerProxy);
        this.pgNFS1.loadData(this.myServerProxy);
        this.pgNetwork1.setGUIfromData();
        this.pgNetwork2.setGUIfromData();
        this.pgNetwork3.setGUIfromData();
        this.pgRouting1.setGUIfromData();
        this.pgSOCKS1.setGUIfromData();
        this.pgSOCKS2.setGUIfromData();
        this.pgSOCKS3.setGUIfromData();
        this.pgPrinting1.setGUIfromData();
        this.pgGeneral1.setGUIfromData();
        this.pgHostname1.setGUIfromData();
        this.pgHostname2.setGUIfromData();
        this.pgSecurity1.setGUIfromData();
        this.pgSecurity2.setGUIfromData();
        this.pgSecurity3.setGUIfromData();
        this.pgSecurity4.setGUIfromData();
        this.pgSecurity5.setGUIfromData();
        this.pgAutostart1.setGUIfromData();
        this.pgNFS1.setGUIfromData();
    }

    public void processLoadMessages() {
        boolean bl = false;
        int n = 0;
        int n2 = 1;
        while (!bl) {
            int n3 = this.myErrorListController.getLastMessageTypeShown();
            int n4 = this.myErrorListController.getLastMessageShownIndex();
            TcpError tcpError = this.myErrorListController.getError(n3, n4);
            this.loadErrorDialog = null;
            this.loadErrorDialog = new DlgError(tcpError, this);
            this.loadErrorDialog.setCurrentNumShown(n4 + 1);
            this.loadErrorDialog.setTotalNumShown(this.myErrorListController.getErrorListSize(tcpError.getType()));
            this.myErrorListController.setLastMessageShownIndex(++n4);
            this.loadErrorDialog.setVisible(true);
            int n5 = 0;
            while (n5 < 1000000) {
                ++n5;
            }
            n = this.loadErrorDialog.getStatus();
            if (n == n2) {
                bl = true;
                continue;
            }
            if (this.myErrorListController.isMoreMessages()) continue;
            bl = true;
        }
    }

    public void processSaveMessages() {
        boolean bl = false;
        int n = 0;
        int n2 = 1;
        while (!bl) {
            int n3 = this.myErrorListController.getLastMessageTypeShown();
            int n4 = this.myErrorListController.getLastMessageShownIndex();
            TcpError tcpError = this.myErrorListController.getError(n3, n4);
            this.saveErrorDialog = new DlgError(tcpError, this);
            this.saveErrorDialog.setCurrentNumShown(n4 + 1);
            this.saveErrorDialog.setTotalNumShown(this.myErrorListController.getErrorListSize(tcpError.getType()));
            this.myErrorListController.setLastMessageShownIndex(++n4);
            this.saveErrorDialog.setVisible(true);
            int n5 = 0;
            while (n5 < 1000000) {
                ++n5;
            }
            n = this.saveErrorDialog.getStatus();
            if (n == n2) {
                bl = true;
                continue;
            }
            if (this.myErrorListController.isMoreMessages()) continue;
            bl = true;
        }
    }

    public void setStatusLine(String string) {
        ((TextComponent)this.myStatusLine).setText(string);
    }

    private void callCommit(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.pgNetwork1.commit();
                return;
            }
            case 8: {
                this.pgAutostart1.commit();
            }
            case 10: 
            case 11: {
                this.pgSecurity1.commit();
                return;
            }
            case 12: {
                this.pgSecurity2.commit();
                return;
            }
            case 13: {
                this.pgSecurity3.commit();
                return;
            }
        }
    }

    private void setDataFromGUI(int n) {
        switch (n) {
            case 0: {
                System.out.println("setDataFromGUI TAB_ID_NETWORK  THIS IS A PROBLEM!!!!!!!!!");
                return;
            }
            case 1: {
                this.pgNetwork1.setDataFromGUI();
                return;
            }
            case 2: {
                this.pgNetwork2.setDataFromGUI();
                return;
            }
            case 3: {
                this.pgNetwork3.setDataFromGUI();
                return;
            }
            case 4: {
                this.pgRouting1.setDataFromGUI();
                return;
            }
            case 5: {
                if (!this.myTrace) break;
                System.out.println("setDataFromGUI TAB_ID_HOSTNAMES THIS IS A PROBLEM!!!!!!!!1");
                return;
            }
            case 6: {
                this.pgHostname1.setDataFromGUI();
                return;
            }
            case 7: {
                this.pgHostname2.setDataFromGUI();
                return;
            }
            case 8: {
                this.pgAutostart1.setDataFromGUI();
                return;
            }
            case 9: {
                this.pgGeneral1.setDataFromGUI();
                return;
            }
            case 10: {
                System.out.println("setDataFromGUI TAB_ID_SECURITY THIS IS A PROBLEM!!!!!!!");
                return;
            }
            case 11: {
                this.pgSecurity1.setDataFromGUI();
                return;
            }
            case 12: {
                this.pgSecurity2.setDataFromGUI();
                return;
            }
            case 13: {
                this.pgSecurity3.setDataFromGUI();
                return;
            }
            case 14: {
                this.pgSecurity4.setDataFromGUI();
                return;
            }
            case 22: {
                this.pgSecurity5.setDataFromGUI();
                return;
            }
            case 15: {
                System.out.println("setDataFromGUI TAB_ID_SOCKS THIS IS A PROBLEM!!!!!!");
                return;
            }
            case 16: {
                this.pgSOCKS1.setDataFromGUI();
                return;
            }
            case 17: {
                this.pgSOCKS2.setDataFromGUI();
                return;
            }
            case 18: {
                this.pgSOCKS3.setDataFromGUI();
                return;
            }
            case 19: {
                this.pgPrinting1.setDataFromGUI();
                return;
            }
            case 20: {
                this.pgPrinting1.setDataFromGUI();
                return;
            }
        }
    }

    private void setGUIfromData(int n) {
        switch (n) {
            case 0: {
                System.out.println("setGUIfromData TAB_ID_NETWORK  THIS IS A PROBLEM!!!!!!!!!");
                return;
            }
            case 1: {
                this.pgNetwork1.setGUIfromData();
                return;
            }
            case 2: {
                this.pgNetwork2.setGUIfromData();
                return;
            }
            case 3: {
                this.pgNetwork3.setGUIfromData();
                return;
            }
            case 4: {
                this.pgRouting1.setGUIfromData();
                return;
            }
            case 5: {
                System.out.println("setGUIfromData TAB_ID_HOSTNAMES THIS IS A PROBLEM!!!!!!!!1");
                this.pgHostname1.setGUIfromData();
                this.pgHostname2.setGUIfromData();
                return;
            }
            case 6: {
                this.pgHostname1.setGUIfromData();
                return;
            }
            case 7: {
                this.pgHostname2.setGUIfromData();
                return;
            }
            case 8: {
                this.pgAutostart1.setGUIfromData();
                return;
            }
            case 9: {
                this.pgGeneral1.setGUIfromData();
                return;
            }
            case 10: {
                System.out.println("setGUIfromData TAB_ID_SECURITY THIS IS A PROBLEM!!!!!!!");
                this.pgSecurity1.setGUIfromData();
                this.pgSecurity2.setGUIfromData();
                this.pgSecurity3.setGUIfromData();
                return;
            }
            case 11: {
                this.pgSecurity1.setGUIfromData();
                return;
            }
            case 12: {
                this.pgSecurity2.setGUIfromData();
                return;
            }
            case 13: {
                this.pgSecurity3.setGUIfromData();
                return;
            }
            case 22: {
                this.pgSecurity5.setGUIfromData();
                return;
            }
            case 14: {
                this.pgSecurity4.setGUIfromData();
                return;
            }
            case 15: {
                System.out.println("setGUIfromData TAB_ID_SOCKS THIS IS A PROBLEM!!!!!!");
                this.pgSOCKS1.setGUIfromData();
                this.pgSOCKS2.setGUIfromData();
                this.pgSOCKS3.setGUIfromData();
                return;
            }
            case 16: {
                this.pgSOCKS1.setGUIfromData();
                return;
            }
            case 17: {
                this.pgSOCKS2.setGUIfromData();
                return;
            }
            case 18: {
                this.pgSOCKS3.setGUIfromData();
                return;
            }
            case 19: {
                this.pgPrinting1.setGUIfromData();
                return;
            }
            case 20: {
                this.pgPrinting1.setGUIfromData();
                return;
            }
        }
    }

    private boolean validatePage(int n) {
        if (this.myTrace) {
            System.out.println("in Notebook.isValidPage()");
        }
        switch (n) {
            case 0: {
                if (!this.myTrace) break;
                System.out.println("TAB_ID_NETWORK");
                break;
            }
            case 1: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_BASIC, pgNetwork1.validatePage()");
                }
                if (this.pgNetwork1.validatePage()) break;
                return false;
            }
            case 2: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_ADVANCED1, pgNetwork2.validatePage()");
                }
                if (this.pgNetwork2.validatePage()) break;
                return false;
            }
            case 3: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_ADVANCED2, pgNetwork3.validatePage()");
                }
                if (this.pgNetwork3.validatePage()) break;
                return false;
            }
            case 4: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_ROUTING, pgRouting1.validatePage()");
                }
                if (this.pgRouting1.validatePage()) break;
                return false;
            }
            case 5: {
                if (!this.myTrace) break;
                System.out.println("TAB_ID_HOSTNAMES");
                break;
            }
            case 6: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_NAME_RES, pgHostname1.validatePage()");
                }
                if (this.pgHostname1.validatePage()) break;
                return false;
            }
            case 7: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_HOSTS, pgHostname2.validatePage()");
                }
                if (this.pgHostname2.validatePage()) break;
                return false;
            }
            case 8: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_AUTOSTART, pgAutostart1.validatePage()");
                }
                if (this.pgAutostart1.validatePage()) break;
                return false;
            }
            case 9: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_GENERAL, pgGeneral1.validatePage()");
                }
                if (this.pgGeneral1.validatePage()) break;
                return false;
            }
            case 10: {
                if (!this.myTrace) break;
                System.out.println("TAB_ID_SECURITY");
                break;
            }
            case 11: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_USER_ACCESS, pgSecurity1.validatePage()");
                }
                if (this.pgSecurity1.validatePage()) break;
                return false;
            }
            case 12: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_RSHD, pgSecurity2.validatePage()");
                }
                if (this.pgSecurity2.validatePage()) break;
                return false;
            }
            case 13: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_TFTPD, pgSecurity3.validatePage()");
                }
                if (this.pgSecurity3.validatePage()) break;
                return false;
            }
            case 14: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_TCPAUTH, pgSecurity4.validatePage()");
                }
                if (this.pgSecurity4.validatePage()) break;
                return false;
            }
            case 22: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_TFTPA, pgSecurity5.validatePage()");
                }
                if (this.pgSecurity5.validatePage()) break;
                return false;
            }
            case 15: {
                if (!this.myTrace) break;
                System.out.println("TAB_ID_SOCKS");
                break;
            }
            case 16: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_DEFAULTS, pgSOCKS1.validatePage()");
                }
                if (this.pgSOCKS1.validatePage()) break;
                return false;
            }
            case 17: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_DIRECT_ROUTES, pgSOCKS2.validatePage()");
                }
                if (this.pgSOCKS2.validatePage()) break;
                return false;
            }
            case 18: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_SERVERS, pgSOCKS3.validatePage()");
                }
                if (this.pgSOCKS3.validatePage()) break;
                return false;
            }
            case 19: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_PRINTING, pgPrinting1.validatePage()");
                }
                if (this.pgPrinting1.validatePage()) break;
                return false;
            }
            case 20: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_NFS, pgNFS1.validatePage()");
                }
                if (this.pgNFS1.validatePage()) break;
                return false;
            }
        }
        return true;
    }

    private boolean isSocksTab(int n) {
        return n == 15 || n == 16 || n == 17 || n == 18;
    }

    private boolean validateMajorTab(int n) {
        if (this.myTrace) {
            System.out.println("in Notebook.isValidPage()");
        }
        switch (n) {
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                if (this.myTrace) {
                    System.out.println("TAB_ID_DEFAULTS, pgSOCKS1.validatePage()");
                }
                if (this.pgSOCKS1.validateMajorTab()) break;
                return false;
            }
        }
        return true;
    }

    private void doHelpPage() {
        if (this.myTrace) {
            System.out.println("in Notebook.doHelpPage()");
        }
        String string = null;
        switch (this.tabIamOn) {
            case 1: {
                string = "TCNBCNIP.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_BASIC - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 2: {
                string = "TCNBICAO.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_ADVANCED1 - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 3: {
                string = "TCNBICGO.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_ADVANCED2 - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 4: {
                string = "TCNBROUT.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_ROUTING - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 6: {
                string = "TCNBCSDN.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_NAME_RES - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 7: {
                string = "TCNBCSD2.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_HOSTS - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 8: {
                string = "TCNBAUTO.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_AUTOSTART - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 9: {
                string = "TCNBGENT.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_GENERAL - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 11: {
                string = "TCNBCUS.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_USER_ACCESS - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 12: {
                string = "TCNBCRS.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_RSHD - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 13: {
                string = "TCNBCTS.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_TFTPD - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 14: {
                string = "TCNBADPW.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_TCPAUTH - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 22: {
                string = "TCNBCTAU.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_TFTPA - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 16: {
                string = "TCNBCSSO.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_DEFAULTS (SOCKS1) - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 17: {
                string = "TCNBC2SO.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_DIRECT_ROUTES (SOCKS2)- doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 18: {
                string = "TCNBC3SO.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_SERVERS (SOCKS3) - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 19: {
                string = "TCNBPRIN.htm";
                if (!this.myTrace) break;
                System.out.println("TAB_ID_PRINTING - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
            case 20: {
                string = "TCNBNFST.htm";
                if (this.myTrace) {
                    System.out.println("TAB_ID_NFS - doHelpPage");
                    System.out.println("help = " + string);
                }
            }
            case 21: {
                if (!this.myTrace) break;
                string = "TCNBPRIN.htm";
                System.out.println("TAB_ID_TIMED - doHelpPage");
                System.out.println("help = " + string);
                break;
            }
        }
        HelpHandle.getHelp(string);
    }

    private int identifyTab(TabViewNode tabViewNode) {
        int n = -1;
        int n2 = 0;
        while (n2 < 23) {
            if (tabViewNode == this.tabNodes[n2]) {
                n = n2;
            }
            ++n2;
        }
        if (this.isSimpleTab(n)) {
            return n;
        }
        if (this.isSubTab(n)) {
            this.setLastVisit(n);
            return n;
        }
        return this.getLastVisit(n);
    }

    private int getLastVisit(int n) {
        switch (n) {
            case 0: {
                return this.lastNetworkTabVisited;
            }
            case 5: {
                return this.lastHostnamesTabVisited;
            }
            case 10: {
                return this.lastSecurityTabVisited;
            }
            case 15: {
                return this.lastSocksTabVisited;
            }
        }
        System.out.println("DEVELOPMENT ERROR: see Notebook.getLastVisit(int)");
        return -1;
    }

    private void setLastVisit(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.lastNetworkTabVisited = n;
                return;
            }
            case 6: 
            case 7: {
                this.lastHostnamesTabVisited = n;
                return;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                this.lastSecurityTabVisited = n;
                return;
            }
            case 16: 
            case 17: 
            case 18: {
                this.lastSocksTabVisited = n;
                return;
            }
        }
        System.out.println("DEVELOPMENT ERROR: see Notebook.setLastVisit()");
    }

    private void showMe(TabViewNode tabViewNode) {
        int n = 0;
        while (n < 23) {
            if (tabViewNode == this.tabNodes[n] && this.myTrace) {
                System.out.println("TabViewNode = " + tabViewNode);
            }
            ++n;
        }
    }

    private void showMe(int n) {
        if (this.myTrace) {
            System.out.println("Tab = " + this.tabNodes[n]);
        }
    }

    private boolean isSimpleTab(int n) {
        return n == 4 || n == 8 || n == 9 || n == 20 || n == 21 || n == 19;
    }

    private boolean isSubTab(int n) {
        return n == 1 || n == 2 || n == 3 || n == 6 || n == 7 || n == 11 || n == 12 || n == 13 || n == 22 || n == 14 || n == 16 || n == 17 || n == 18;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public boolean preTabSelected(TabView tabView, TabViewNode tabViewNode) {
        if (this.myTrace) {
            System.out.println("in Notebook.preTabSelected()");
        }
        if (this.myTrace) {
            System.out.println("tab hit = ");
        }
        this.showMe(tabViewNode);
        if (this.myTrace) {
            System.out.println(" tabIamOn = ");
        }
        this.showMe(this.tabIamOn);
        if (this.myTrace) {
            System.out.println("Calling validatePage for tab = ");
        }
        this.showMe(this.tabIamOn);
        if (!this.validatePage(this.tabIamOn)) {
            return false;
        }
        if (this.myTrace) {
            System.out.println("continue - no error");
        }
        if (this.myTrace) {
            System.out.println("Calling setDataFromGUI for tabIamOn = ");
        }
        this.showMe(this.tabIamOn);
        this.setDataFromGUI(this.tabIamOn);
        if (!this.isSocksTab(this.identifyTab(tabViewNode))) {
            if (this.myTrace) {
                System.out.println("Leaving SOCKS calling validateMajorTab for tab = ");
            }
            this.showMe(this.tabIamOn);
            if (!this.validateMajorTab(this.tabIamOn)) {
                return false;
            }
        }
        if (this.myTrace) {
            System.out.println("Calling commit for tabIamOn");
        }
        this.callCommit(this.tabIamOn);
        if ((this.myServerProxy.getNotebookProfileDataHandle().getSetupDataHandle().isUpdated() || this.myServerProxy.getNotebookProfileDataHandle().getConfigDataHandle().isUpdated() || this.myServerProxy.getNotebookProfileDataHandle().getTcpstartDataHandle().isUpdated()) && this.myTrace) {
            System.out.println("Page " + this.tabIamOn + " - data has been updated");
        }
        return true;
    }

    public void postTabSelected(TabView tabView, TabViewNode tabViewNode) {
        if (this.myTrace) {
            System.out.println("in Notebook.postTabSelected()");
        }
        this.tabIamOn = this.identifyTab(tabViewNode);
        if (this.myTrace) {
            System.out.println("TabIamOn is now = ");
        }
        this.showMe(this.tabIamOn);
        this.setGUIfromData(this.tabIamOn);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.myTrace) {
            System.out.println("in Notebook.windowClosing()");
        }
        if (!this.validatePage(this.tabIamOn)) {
            return;
        }
        if (!this.validatePage(this.tabIamOn)) {
            return;
        }
        if (this.finishSession()) {
            this.myOwner.shutDown();
        }
    }

    private boolean finishSession() {
        this.okDialog = new DlgMessage(this.myBundle.getString("NB_OK_YES_NO"), this);
        this.okDialog.setVisible(true);
        if (this.okDialog.getStatus() == 0) {
            this.setVisible(false);
            this.setDataFromGUI(this.tabIamOn);
            this.callCommit(this.tabIamOn);
            this.myServerProxy.talkToNetwork(2);
            this.myServerProxy.talkToNetwork(6);
            this.myErrorListController = this.myServerProxy.getErrorListControllerDataHandle();
            if (this.myErrorListController.isMoreMessages()) {
                this.processSaveMessages();
            }
            if (this.myServerProxy.isRebootRequired()) {
                TcpError tcpError = new TcpError(this.myBundle.getString("SAVING_REBOOT"), 1);
                DlgError dlgError = new DlgError(tcpError, this, true);
                dlgError.setVisible(true);
                int n = 0;
                while (n < 2500000) {
                    ++n;
                }
                if (dlgError.getStatus() == 0) {
                    System.out.println("reboot server");
                } else {
                    System.out.println("do not reboot server");
                }
                if (dlgError.getStatus() == 0) {
                    this.myServerProxy.talkToNetwork(7);
                }
            }
            return true;
        }
        return false;
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (FocusKeeper.getFocusWindow() != null) {
            FocusKeeper.giveWindowFocus();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void setSize(Dimension dimension) {
        if (this.myTrace) {
            System.out.println("in Notebook.setSize()");
        }
        super.setSize(dimension);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Utility.getDimension(0);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension2.width / 2 - dimension.width / 2;
        int n2 = dimension2.height / 2 - dimension.height / 2;
        if (this.myTrace) {
            System.out.println("In Notebook.setVisible() frameSize width = " + dimension.width + " framesize.height = " + dimension.height);
        }
        ((Component)this).setBounds(n, n2, dimension.width, dimension.height);
        this.toFront();
        super.setVisible(bl);
    }

    public void messageFinished(int n) {
        if (this.myTrace) {
            System.out.println("In Notebook.messageFinished()");
        }
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (this.myTrace) {
            System.out.println("In Notebook.dialogFinished()");
        }
        FocusKeeper.setFocusWindow(null);
        this.requestFocus();
    }

    public Applet getAppletHandle() {
        return this.myOwner;
    }

    public void handleButton(Button button) {
        Button[] buttonArray = this.myButtonPanel.getButtons();
        if (button == buttonArray[0] && !this.validatePage(this.tabIamOn)) {
            return;
        }
        if (button == buttonArray[0]) {
            if (this.myTrace) {
                System.out.println("OK Button Hit");
            }
            if (this.finishSession()) {
                this.myOwner.shutDown();
                return;
            }
        } else if (button == buttonArray[1]) {
            if (this.myTrace) {
                System.out.println("CANCEL Button Hit");
            }
            this.cancelDialog = new DlgMessage(this.myBundle.getString("NB_CANCEL_YES_NO"), this);
            this.cancelDialog.setVisible(true);
            if (this.cancelDialog.getStatus() == 0) {
                this.setVisible(false);
                this.myOwner.shutDown();
                return;
            }
        } else if (button == buttonArray[2]) {
            if (this.myTrace) {
                System.out.println("HELP Button Hit");
            }
            this.doHelpPage();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

