/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BorderPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.AutostartService;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpstartData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;

public class PgAutostart1
extends BasePage
implements ActionListener,
ItemListener,
MouseListener,
Cfg2Defines,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblServices;
    private Label lblOptions;
    private Label lblParameters;
    private MulColumn myList;
    private Checkbox cbAutostart;
    private Checkbox cbInetd;
    private Checkbox cbDetached;
    private Checkbox cbForeground;
    private Checkbox cbMinimized;
    private CheckboxGroup cbg;
    private TextField tfParameters;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null};
    private static final int UNDO_BUTTON = 0;
    private static final int MAX_BUTTONS_IN_ROW = 2;
    private Panel leftPanel;
    private BorderPanel rightPanel;
    private String originalTcpstartString = new String();
    private boolean undoTheUpdate = true;
    private BaseProxy myServerProxy;
    private TcpstartData myTcpstartData;
    GridBagLayout gridBag = new GridBagLayout();
    private boolean myTrace = false;
    private int prevSel = -1;
    private static final int AUTOSTART_LIST_MAX_COLUMNS = 1;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgAutostart1(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgAutostart1.buttonLabels[0] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PA1_TITLE"));
        this.lblServices = new Label(this.myBundle.getString("PA1_AUTOSTART_SERVICES"));
        this.lblParameters = new Label(this.myBundle.getString("PA1_PARAMETERS"));
        String[] stringArray = new String[]{this.myBundle.getString("PA1_AUTOSTART_SERVICES")};
        int[] nArray = new int[]{100};
        this.myList = new MulColumn(stringArray, nArray);
        this.myList.addMouseListener(this);
        this.cbAutostart = new Checkbox(this.myBundle.getString("PA1_AUTOSTART_SERVICE"));
        this.cbInetd = new Checkbox(this.myBundle.getString("PA1_INETD_SUPER_SERVER"));
        this.cbDetached = new Checkbox(this.myBundle.getString("PA1_DETATCHED"));
        this.cbForeground = new Checkbox(this.myBundle.getString("PA1_FOREGROUND"));
        this.cbMinimized = new Checkbox(this.myBundle.getString("PA1_MINIMIZED"));
        this.cbAutostart.addItemListener(this);
        this.cbInetd.addItemListener(this);
        this.cbDetached.addItemListener(this);
        this.cbForeground.addItemListener(this);
        this.cbMinimized.addItemListener(this);
        this.cbAutostart.addKeyListener(this);
        this.cbInetd.addKeyListener(this);
        this.cbDetached.addKeyListener(this);
        this.cbForeground.addKeyListener(this);
        this.cbMinimized.addKeyListener(this);
        this.cbg = new CheckboxGroup();
        this.cbInetd.setCheckboxGroup(this.cbg);
        this.cbDetached.setCheckboxGroup(this.cbg);
        this.cbForeground.setCheckboxGroup(this.cbg);
        this.tfParameters = new TextField();
        myButtonPanel = new ButtonPanel(this, buttonLabels);
        this.leftPanel = new Panel();
        this.rightPanel = new BorderPanel(this.myBundle.getString("PA1_AUTOSTART_OPTIONS"));
        this.setLayout(this.gridBag);
        this.leftPanel.setLayout(this.gridBag);
        this.rightPanel.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.leftPanel, this.myList, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 10, 0, 10);
        Utility.constrain(this, this.leftPanel, 0, 1, -1, 1, 1, 10, 1.0, 1.0, 10, 0, 10, 0);
        Utility.constrain(this.rightPanel, this.cbAutostart, 0, 2, 0, 1, 2, 17, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.rightPanel, this.cbInetd, 0, 3, 0, 1, 2, 17, 1.0, 1.0, 0, 35, 0, 0);
        Utility.constrain(this.rightPanel, this.cbDetached, 0, 4, 0, 1, 2, 17, 1.0, 1.0, 0, 35, 0, 0);
        Utility.constrain(this.rightPanel, this.cbForeground, 0, 5, 0, 1, 2, 17, 1.0, 1.0, 0, 35, 0, 0);
        Utility.constrain(this.rightPanel, this.cbMinimized, 0, 6, 0, 1, 2, 17, 1.0, 1.0, 0, 60, 0, 0);
        Utility.constrain(this.rightPanel, this.lblParameters, 0, 7, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        Utility.constrain(this.rightPanel, this.tfParameters, 0, 8, 0, 1, 2, 17, 1.0, 1.0, 0, 10, 0, 10);
        Utility.constrain(this, this.rightPanel, 1, 1, -1, 1, 1, 10, 1.0, 1.0, 10, 0, 10, 0);
        this.addButtonGUI(0, 2, 2);
        this.refreshContainer(this.rightPanel);
    }

    private void doHelpButton() {
    }

    private void doUndoButton() {
        this.myTcpstartData.deCommit();
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalTcpstartString = this.toStringTcpstart();
            if (this.myTrace) {
                System.out.println("setting updated to false originalTcpstartString = " + this.originalTcpstartString);
            }
            this.myTcpstartData.setUpdated(false);
        }
    }

    public void loadData(BaseProxy baseProxy) {
        if (this.myTrace) {
            System.out.println("in PgAutostart1.loadData()");
        }
        this.myServerProxy = baseProxy;
        this.myTcpstartData = this.myServerProxy.getNotebookProfileDataHandle().getTcpstartDataHandle();
    }

    private boolean isServiceInetd(String string) {
        if (this.myTrace) {
            System.out.println("In PgAutostart1.isServiceInetd()");
        }
        AutostartService autostartService = null;
        int n = this.myTcpstartData.getAutostartServiceListSize();
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (n2 < n && !bl) {
            autostartService = this.myTcpstartData.getAutostartService(n2);
            if (autostartService.getServiceName().compareTo(string) == 0) {
                bl = true;
                bl2 = autostartService.isViaInetd();
            }
            ++n2;
        }
        return bl2;
    }

    private boolean isServiceDetached(String string) {
        if (this.myTrace) {
            System.out.println("In PgAutostart1.isServiceDetached()");
        }
        AutostartService autostartService = null;
        int n = this.myTcpstartData.getAutostartServiceListSize();
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (n2 < n && !bl) {
            autostartService = this.myTcpstartData.getAutostartService(n2);
            if (autostartService.getServiceName().compareTo(string) == 0) {
                bl = true;
                bl2 = autostartService.isDetached();
            }
            ++n2;
        }
        return bl2;
    }

    private void loadGuiPage(int n) {
        if (this.myTrace) {
            System.out.println("In PgAutostart1.loadGuiPage()");
        }
        AutostartService autostartService = this.myTcpstartData.getAutostartService(n);
        this.cbAutostart.setState(autostartService.isAutomaticallyStarted());
        this.cbInetd.setState(autostartService.isViaInetd());
        this.cbDetached.setState(autostartService.isDetached());
        this.cbForeground.setState(autostartService.isForeground());
        this.cbMinimized.setState(autostartService.isMinimized());
        ((TextComponent)this.tfParameters).setText(autostartService.getParameters());
        this.rightPanel.setText(String.valueOf(autostartService.getServiceName()) + " " + this.myBundle.getString("PA1_AUTOSTART_OPTIONS"));
        this.cbAutostart.setEnabled(true);
        this.cbInetd.setEnabled(true);
        this.cbDetached.setEnabled(true);
        this.cbForeground.setEnabled(true);
        this.cbMinimized.setEnabled(this.cbForeground.getState());
        this.lblParameters.setEnabled(!this.cbInetd.getState());
        this.tfParameters.setEnabled(!this.cbInetd.getState());
        if (this.myTrace) {
            System.out.println("in loadGuiPage of PgAutostart1, service clicked: " + autostartService.getServiceName());
        }
        if (autostartService.getServiceName().compareTo("inetd") == 0) {
            this.cbInetd.setEnabled(false);
            this.lblParameters.setEnabled(false);
            this.tfParameters.setEnabled(false);
            if (this.isServiceInetd("telnetd")) {
                this.cbDetached.setEnabled(false);
            }
        } else if (autostartService.getServiceName().compareTo("telnetd") == 0) {
            if (this.isServiceDetached("inetd")) {
                this.cbInetd.setEnabled(false);
            }
            this.cbDetached.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("rsvpd") == 0) {
            this.cbInetd.setEnabled(false);
            this.cbDetached.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("lprportd") == 0) {
            this.cbInetd.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("routed") == 0) {
            this.cbInetd.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("portmap") == 0) {
            this.cbInetd.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("sendmail") == 0) {
            this.cbInetd.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("talkd") == 0) {
            this.cbInetd.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("tftpd") == 0) {
            this.cbInetd.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("ftpd") == 0) {
            this.cbInetd.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("syslogd") == 0) {
            if (this.myTrace) {
                System.out.println("in GLO_SYSLOG...");
            }
            this.cbInetd.setEnabled(false);
            this.cbDetached.setEnabled(false);
            this.lblParameters.setEnabled(false);
            this.tfParameters.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("nfsd") == 0) {
            this.cbInetd.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("pmx") == 0) {
            this.cbInetd.setEnabled(false);
        } else if (autostartService.getServiceName().compareTo("httpd") == 0) {
            this.cbInetd.setEnabled(false);
        }
        this.refreshContainer(this.rightPanel);
        this.myList.select(n);
        this.originalTcpstartString = this.toStringTcpstart();
        if (this.myTrace) {
            System.out.println("PgAutostart1 Original string = " + this.originalTcpstartString);
        }
    }

    private void saveListSelection(int n) {
        if (this.myTrace) {
            System.out.println(":in PgAutostart1.saveListSelection(idx)");
        }
        if (!this.isNoEntries(this.myList)) {
            String[] stringArray = this.myList.getItem(n);
            AutostartService autostartService = this.myTcpstartData.getAutostartService(n);
            autostartService.setServiceName(stringArray[0]);
            autostartService.setAutomaticallyStarted(this.cbAutostart.getState());
            autostartService.setViaInetd(this.cbInetd.getState());
            autostartService.setDetached(this.cbDetached.getState());
            autostartService.setForeground(this.cbForeground.getState());
            autostartService.setMinimized(this.cbMinimized.getState());
            autostartService.setParameters(this.tfParameters.getText());
        }
        if (this.myTrace) {
            System.out.println("PgAutostart1 COMPARING Original string = " + this.originalTcpstartString);
            System.out.println("PgAutostart1 COMPARING Current  string = " + this.toStringTcpstart());
        }
        if (this.originalTcpstartString.compareTo(this.toStringTcpstart()) != 0) {
            if (this.myTrace) {
                System.out.println("PgAutostart1 TcpstartData has changed!!setting updated to true!");
            }
            this.myTcpstartData.setUpdated(true);
            return;
        }
        if (this.myTrace) {
            System.out.println("PgAutostart1 TcpstartData has NOT changed!!!");
        }
    }

    public void setDataFromGUI() {
        if (this.myTrace) {
            System.out.println(":in PgAutostart1.setDataFromGUI()");
        }
        this.saveListSelection(this.myList.getSelectedIndex());
        if (this.myTcpstartData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgAutostart1 TcpstartData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
        this.originalTcpstartString = null;
    }

    public void commit() {
        if (this.myTrace) {
            System.out.println(":in PgAutostart1.commit()");
        }
        this.myTcpstartData.commit();
        this.undoTheUpdate = false;
    }

    public void setGUIfromData() {
        if (this.myTrace) {
            System.out.println(":in PgAutostart1.setGUIfromData()");
        }
        this.myList.removeAll();
        int n = this.myTcpstartData.getAutostartServiceListSize();
        String[] stringArray = new String[1];
        AutostartService autostartService = null;
        if (n == 0) {
            stringArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            this.myList.add(stringArray);
        } else {
            int n2 = 0;
            while (n2 < n) {
                autostartService = this.myTcpstartData.getAutostartService(n2);
                stringArray[0] = autostartService.getServiceName();
                this.myList.add(stringArray);
                ++n2;
            }
            this.loadGuiPage(0);
        }
        this.myList.select(0);
        this.prevSel = 0;
    }

    public boolean validatePage() {
        if (this.myTrace) {
            System.out.println(":in PgAutostart1.validatePage()");
        }
        this.saveListSelection(this.myList.getSelectedIndex());
        AutostartService autostartService = null;
        int n = this.myTcpstartData.getAutostartServiceListSize();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            autostartService = this.myTcpstartData.getAutostartService(n2);
            if (autostartService.getServiceName().compareTo("inetd") == 0) {
                bl = autostartService.isAutomaticallyStarted();
            } else if (!bl2 && autostartService.isAutomaticallyStarted()) {
                bl2 = autostartService.isViaInetd();
            }
            ++n2;
        }
        if (!bl && bl2) {
            this.showMessageDialog(this.myBundle.getString("PA1_NEED_INETD"), this);
            return false;
        }
        if (bl && !bl2) {
            this.showMessageDialog(this.myBundle.getString("PA1_INETD_NO_OTHERS"), this);
            return false;
        }
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            this.handleCheckbox((Checkbox)object);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof MulColumn && object == this.myList && this.prevSel != this.myList.getSelectedIndex() && !this.isNoEntries(this.myList)) {
            this.saveListSelection(this.prevSel);
            this.loadGuiPage(this.myList.getSelectedIndex());
            this.prevSel = this.myList.getSelectedIndex();
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void messageFinished(int n) {
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public void handleCheckbox(Checkbox checkbox) {
        if (checkbox == this.cbInetd) {
            if (!this.cbAutostart.getState()) {
                this.cbAutostart.setState(true);
            }
            if (this.cbMinimized.isEnabled()) {
                this.cbMinimized.setState(false);
                this.cbMinimized.setEnabled(false);
            }
            if (this.tfParameters.isEnabled()) {
                this.lblParameters.setEnabled(false);
                this.tfParameters.setEnabled(false);
            }
        } else if (checkbox == this.cbDetached) {
            if (!this.cbAutostart.getState()) {
                this.cbAutostart.setState(true);
            }
            if (this.cbMinimized.isEnabled()) {
                this.cbMinimized.setState(false);
                this.cbMinimized.setEnabled(false);
            }
            if (!this.tfParameters.isEnabled()) {
                this.lblParameters.setEnabled(true);
                this.tfParameters.setEnabled(true);
            }
        } else if (checkbox == this.cbForeground) {
            if (!this.cbAutostart.getState()) {
                this.cbAutostart.setState(true);
            }
            if (!this.cbMinimized.isEnabled()) {
                this.cbMinimized.setEnabled(true);
            }
            if (!this.tfParameters.isEnabled()) {
                this.lblParameters.setEnabled(true);
                this.tfParameters.setEnabled(true);
            }
        } else if (checkbox == this.cbMinimized && !this.cbAutostart.getState()) {
            this.cbAutostart.setState(true);
        }
        this.refreshContainer(this.rightPanel);
    }

    public String toStringTcpstart() {
        if (this.myTrace) {
            System.out.println("in PgAutostart1.toStringTcpstart()");
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.myList.getItem(this.myList.getSelectedIndex());
        stringBuffer.append(stringArray[0]);
        if (this.cbAutostart.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbInetd.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbDetached.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbForeground.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbMinimized.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        stringBuffer.append(this.tfParameters.getText());
        return stringBuffer.toString();
    }
}

