/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BorderPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgHostname1ACDd;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgHostname1ACDn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ListSelector;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumnCallback;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Validation;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ConfigData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ResolvData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class PgHostname1
extends BasePage
implements ActionListener,
MulColumnCallback,
DialogListener,
MessageListener,
Cfg2Defines {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblThisMachine;
    private Label lblLocalDomain;
    private Label lblLanNameServer;
    private BorderPanel bottomPanel;
    private MulColumn nameserverList;
    private MulColumn lLanDomain;
    private TextField tfHostname;
    private TextField tfLocalDomain;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null, null};
    private static final int ADD_BUTTON = 0;
    private static final int CHANGE_BUTTON = 1;
    private static final int DELETE_BUTTON = 2;
    private static final int UNDO_BUTTON = 3;
    private int dialogCommand = -1;
    private String originalConfigString = new String();
    private String originalResolvString = new String();
    private boolean undoTheUpdate = true;
    private boolean undoTheResolvUpdate = true;
    private ConfigData myConfigData;
    private ResolvData myResolvData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private static final int NAME_SERVER_LIST_MAX_COLUMNS = 1;
    private static final int LAN_DOMAIN_LIST_MAX_COLUMNS = 1;
    private ListSelector myListSelector;
    private DlgHostname1ACDn nameServerDialog;
    private DlgHostname1ACDd lanDomainDialog;
    private static boolean validateNsLanError;
    private boolean myTrace = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgHostname1(Notebook notebook) {
        this.myOwner = notebook;
        this.myBundle = ClientMsg.getBundle();
        this.myTrace = Utility.isTraceOn();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgHostname1.buttonLabels[0] = this.myBundle.getString("GLO_ADD");
        PgHostname1.buttonLabels[1] = this.myBundle.getString("GLO_CHANGE");
        PgHostname1.buttonLabels[2] = this.myBundle.getString("GLO_DELETE");
        PgHostname1.buttonLabels[3] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PH1_TITLE"));
        String[] stringArray = new String[]{this.myBundle.getString("PH1_SERVER_ADDRESS")};
        int[] nArray = new int[]{100};
        this.nameserverList = new MulColumn(stringArray, nArray, this);
        String[] stringArray2 = new String[]{this.myBundle.getString("PH1_DOMAIN_SEARCH")};
        int[] nArray2 = new int[]{100};
        this.lLanDomain = new MulColumn(stringArray2, nArray2, this);
        this.myListSelector = new ListSelector(this.nameserverList, this.lLanDomain);
        this.lblThisMachine = new Label(this.myBundle.getString("PH1_THIS_MACHINE"));
        this.lblLocalDomain = new Label(this.myBundle.getString("PH1_LOCAL_DOMAIN"));
        this.lblLanNameServer = new Label(this.myBundle.getString("PH1_SERVER_CONFIG"));
        this.bottomPanel = new BorderPanel(this.myBundle.getString("PH1_SERVER_CONFIG"));
        this.tfHostname = new TextField();
        this.tfLocalDomain = new TextField();
        this.setLayout(this.gridBag);
        this.bottomPanel.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this, this.lblThisMachine, 0, 1, -1, 1, 0, 13, 1.0, 0.0, 0, 0, 10, 0);
        Utility.constrain(this, this.tfHostname, 1, 1, 0, 1, 2, 17, 1.0, 0.0, 0, 0, 10, 10);
        Utility.constrain(this, this.lblLocalDomain, 0, 2, -1, 1, 0, 13, 1.0, 0.0, 0, 0, 0, 0);
        Utility.constrain(this, this.tfLocalDomain, 1, 2, 0, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 10);
        Utility.constrain(this.bottomPanel, this.nameserverList, 0, 1, -1, 1, 1, 10, 1.0, 1.0, 0, 10, 0, 15);
        Utility.constrain(this.bottomPanel, this.lLanDomain, 1, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 15, 0, 10);
        Utility.constrain(this, this.bottomPanel, 0, 3, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 4, 5);
        String[] stringArray3 = new String[]{this.myBundle.getString("GLO_NO_ENTRIES")};
        this.nameserverList.add(stringArray3);
        stringArray3[0] = "lan domain";
        this.lLanDomain.add(stringArray3);
    }

    private void doUndoButton() {
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalConfigString = this.toStringConfig();
            this.myConfigData.setUpdated(false);
        }
        if (this.undoTheResolvUpdate) {
            this.originalResolvString = this.toStringResolv();
            this.myResolvData.setUpdated(false);
        }
    }

    private void doHelpButton() {
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.myConfigData = this.myServerProxy.getNotebookProfileDataHandle().getConfigDataHandle();
        this.myResolvData = this.myServerProxy.getNotebookProfileDataHandle().getResolvDataHandle();
    }

    public void setDataFromGUI() {
        String[] stringArray;
        this.myConfigData.setHostname(this.tfHostname.getText());
        this.myResolvData.setLocalDomain(this.tfLocalDomain.getText());
        this.myResolvData.deleteNameServerList();
        int n = this.isNoEntries(this.nameserverList) ? 0 : this.nameserverList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.nameserverList.getItem(n2);
            this.myResolvData.addNameServer(stringArray[0]);
            ++n2;
        }
        this.myResolvData.deleteSearchDomainList();
        n = this.isNoEntries(this.lLanDomain) ? 0 : this.lLanDomain.getItemCount();
        n2 = 0;
        while (n2 < n) {
            stringArray = this.lLanDomain.getItem(n2);
            this.myResolvData.addSearchDomain(stringArray[0]);
            ++n2;
        }
        if (this.myTrace) {
            System.out.println("PgHostname1 COMPARING Original Config string = " + this.originalConfigString);
            System.out.println("PgHostname1 COMPARING Current  Config string = " + this.toStringConfig());
        }
        if (this.originalConfigString.compareTo(this.toStringConfig()) != 0) {
            if (this.myTrace) {
                System.out.println("PgHostname1 config.sys has changed!!!");
            }
            this.myConfigData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgHostname1 config.sys has NOT changed!!!");
        }
        this.originalConfigString = null;
        if (this.myConfigData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgHostname1 config.sys been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
        if (this.myTrace) {
            System.out.println("PgHostname1 COMPARING Original Resolv string = " + this.originalResolvString);
            System.out.println("PgHostname1 COMPARING Current  Resolv string = " + this.toStringResolv());
        }
        if (this.originalResolvString.compareTo(this.toStringResolv()) != 0) {
            if (this.myTrace) {
                System.out.println("PgHostname1 resolv has changed!!!");
            }
            this.myResolvData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgHostname1 resolv has NOT changed!!!");
        }
        this.originalResolvString = null;
        if (this.myResolvData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgHostname1 resolv been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheResolvUpdate = false;
        }
    }

    public void setGUIfromData() {
        if (this.myTrace) {
            System.out.println("In the code. PgHostname1 setGUIfromData");
        }
        ((TextComponent)this.tfHostname).setText(this.myConfigData.getHostname());
        ((TextComponent)this.tfLocalDomain).setText(this.myResolvData.getLocalDomain());
        String[] stringArray = new String[1];
        this.nameserverList.removeAll();
        int n = this.myResolvData.getNameServerListSize();
        if (n == 0) {
            stringArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            this.nameserverList.add(stringArray);
        } else {
            int n2 = 0;
            while (n2 < n) {
                stringArray[0] = this.myResolvData.getNameServer(n2);
                this.nameserverList.add(stringArray);
                ++n2;
            }
        }
        String[] stringArray2 = new String[1];
        this.lLanDomain.removeAll();
        n = this.myResolvData.getSearchDomainListSize();
        if (n == 0) {
            stringArray2[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            this.lLanDomain.add(stringArray2);
        } else {
            int n3 = 0;
            while (n3 < n) {
                stringArray2[0] = this.myResolvData.getSearchDomain(n3);
                this.lLanDomain.add(stringArray2);
                ++n3;
            }
        }
        if (this.myListSelector.isSelected(this.lLanDomain)) {
            this.lLanDomain.select(0);
        } else {
            this.nameserverList.select(0);
        }
        this.originalConfigString = this.toStringConfig();
        if (this.myTrace) {
            System.out.println("PgHostname1 Original string = " + this.originalConfigString);
        }
        if (this.myConfigData.isUpdated()) {
            this.undoTheUpdate = false;
        }
        this.originalResolvString = this.toStringResolv();
        if (this.myTrace) {
            System.out.println("PgHostname1 Original resolv string = " + this.originalResolvString);
        }
        if (this.myResolvData.isUpdated()) {
            this.undoTheResolvUpdate = false;
        }
    }

    public boolean validatePage() {
        validateNsLanError = false;
        if (Utility.isEmptyTextField(this.tfHostname) && !Utility.isEmptyTextField(this.tfLocalDomain)) {
            this.showMessageDialog(this.myBundle.getString("PH1_DOMAIN_NO_HOST"), this, Utility.getDimension(3));
            return false;
        }
        if (!(Utility.getIgnoreLanNsError() || Utility.isEmptyTextField(this.tfLocalDomain) || this.isNoEntries(this.lLanDomain))) {
            validateNsLanError = true;
            this.showMessageDialog(this.myBundle.getString("PH1_NOT_BOTH"), this, Utility.getDimension(3));
            return false;
        }
        if (!Utility.isEmptyTextField(this.tfLocalDomain) && !TcpipValidation.IsValidNonFQTcpipName((String)this.tfLocalDomain.getText())) {
            this.showMessageDialog(this.myBundle.getString("DOMAIN_INVALID"), this);
            return false;
        }
        if (!Utility.isEmptyTextField(this.tfHostname) && !Cfg2Validation.IsValidHost_IPName(this.tfHostname.getText())) {
            this.showMessageDialog(this.myBundle.getString("HOST_INVALID"), this);
            return false;
        }
        if (!Utility.isEmptyTextField(this.tfLocalDomain) && Utility.isValidIPAddress(this.tfLocalDomain.getText())) {
            this.showMessageDialog(this.myBundle.getString("DOMAIN_INVALID"), this);
            return false;
        }
        return true;
    }

    private void doOKdlgACDadd() {
        if (this.myListSelector.isSelected(this.nameserverList)) {
            if (this.isNoEntries(this.nameserverList)) {
                this.removeNoEntries(this.nameserverList);
            }
            String[] stringArray = new String[]{this.nameServerDialog.getNameServer()};
            this.nameserverList.add(stringArray);
            this.nameserverList.select(this.nameserverList.getItemCount() - 1);
            this.nameServerDialog.dispose();
            return;
        }
        if (this.isNoEntries(this.lLanDomain)) {
            this.removeNoEntries(this.lLanDomain);
        }
        String[] stringArray = new String[]{this.lanDomainDialog.getLanDomain()};
        this.lLanDomain.add(stringArray);
        this.lLanDomain.select(this.lLanDomain.getItemCount() - 1);
        this.lanDomainDialog.dispose();
    }

    private void doOKdlgACDchange() {
        if (this.myListSelector.isSelected(this.nameserverList)) {
            int n = this.nameserverList.getSelectedIndex();
            if (n != -1) {
                String[] stringArray = new String[]{this.nameServerDialog.getNameServer()};
                this.nameserverList.replaceItem(stringArray, n);
                this.nameserverList.select(n);
            }
            this.nameServerDialog.dispose();
            return;
        }
        int n = this.lLanDomain.getSelectedIndex();
        if (n != -1) {
            String[] stringArray = new String[]{this.lanDomainDialog.getLanDomain()};
            this.lLanDomain.replaceItem(stringArray, n);
            this.lLanDomain.select(n);
        }
        this.lanDomainDialog.dispose();
    }

    private void doOKdlgACDdelete() {
        if (this.myListSelector.isSelected(this.nameserverList)) {
            int n = this.nameserverList.getSelectedIndex();
            if (n != -1) {
                this.nameserverList.remove(n);
                int n2 = this.nameserverList.getItemCount();
                if (n2 < 1) {
                    String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES")};
                    this.nameserverList.add(stringArray);
                    n = 0;
                } else if (n == n2) {
                    --n;
                }
                this.nameserverList.select(n);
                return;
            }
        } else {
            int n = this.lLanDomain.getSelectedIndex();
            if (n != -1) {
                this.lLanDomain.remove(n);
                int n3 = this.lLanDomain.getItemCount();
                if (n3 < 1) {
                    String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES")};
                    this.lLanDomain.add(stringArray);
                    n = 0;
                } else if (n == n3) {
                    --n;
                }
                this.lLanDomain.select(n);
            }
        }
    }

    private void populateDlgACDn() {
        if (this.isNoEntries(this.nameserverList)) {
            this.nameServerDialog.setNameServer("");
            return;
        }
        String[] stringArray = this.nameserverList.getItem(this.nameserverList.getSelectedIndex());
        this.nameServerDialog.setNameServer(stringArray[0]);
    }

    private void populateDlgACDd() {
        if (this.isNoEntries(this.lLanDomain)) {
            this.lanDomainDialog.setLanDomain("");
            return;
        }
        String[] stringArray = this.lLanDomain.getItem(this.lLanDomain.getSelectedIndex());
        this.lanDomainDialog.setLanDomain(stringArray[0]);
    }

    private void showACDdialog(int n) {
        this.nameServerDialog = null;
        this.lanDomainDialog = null;
        switch (n) {
            case 0: {
                if (this.myListSelector.isSelected(this.nameserverList)) {
                    this.nameServerDialog = new DlgHostname1ACDn(0, this, this.nameserverList);
                    break;
                }
                this.lanDomainDialog = new DlgHostname1ACDd(0, this, this.lLanDomain);
                break;
            }
            case 1: {
                if (this.myListSelector.isSelected(this.nameserverList)) {
                    this.nameServerDialog = new DlgHostname1ACDn(1, this, this.nameserverList);
                    this.populateDlgACDn();
                    break;
                }
                this.lanDomainDialog = new DlgHostname1ACDd(1, this, this.lLanDomain);
                this.populateDlgACDd();
                break;
            }
            case 2: {
                if (this.myListSelector.isSelected(this.nameserverList)) {
                    this.nameServerDialog = new DlgHostname1ACDn(2, this, this.nameserverList);
                    this.populateDlgACDn();
                    break;
                }
                this.lanDomainDialog = new DlgHostname1ACDd(2, this, this.lLanDomain);
                this.populateDlgACDd();
                break;
            }
            default: {
                if (this.myListSelector.isSelected(this.nameserverList)) {
                    this.nameServerDialog = new DlgHostname1ACDn(0, this, this.nameserverList);
                    break;
                }
                this.lanDomainDialog = new DlgHostname1ACDd(0, this, this.lLanDomain);
            }
        }
        if (this.myListSelector.isSelected(this.nameserverList)) {
            this.myOwner.setEnabled(false);
            this.nameServerDialog.setVisible(true);
            return;
        }
        this.myOwner.setEnabled(false);
        this.lanDomainDialog.setVisible(true);
    }

    public void singleClick(MulColumn mulColumn, int n) {
        if (mulColumn == this.nameserverList) {
            this.myListSelector.selectList(this.nameserverList);
        }
        if (mulColumn == this.lLanDomain) {
            this.myListSelector.selectList(this.lLanDomain);
        }
    }

    public void doubleClick(MulColumn mulColumn, int n) {
        if (mulColumn == this.nameserverList) {
            this.myListSelector.selectList(this.nameserverList);
        }
        if (mulColumn == this.lLanDomain) {
            this.myListSelector.selectList(this.lLanDomain);
        }
    }

    public void messageFinished(int n) {
        if (validateNsLanError) {
            if (n == 0) {
                Utility.setIgnoreLanNsError(true);
            } else if (n == 1) {
                Utility.setIgnoreLanNsError(false);
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (this.myTrace) {
            System.out.println("In PgHostname1.dialogFinished() - userAction=" + n);
        }
        if (n == 0) {
            if (this.dialogCommand == 1) {
                this.doOKdlgACDchange();
            } else if (this.dialogCommand == 2) {
                this.doOKdlgACDdelete();
            } else if (this.dialogCommand == 0) {
                this.doOKdlgACDadd();
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if ((button == buttonArray[1] || button == buttonArray[2]) && (this.myListSelector.isSelected(this.nameserverList) ? !this.isChangeDeleteOk(this.nameserverList, this) : !this.isChangeDeleteOk(this.lLanDomain, this))) {
            return;
        }
        if (button == buttonArray[0]) {
            if (this.myTrace) {
                System.out.println("ADD button hit");
            }
            this.dialogCommand = 0;
            if (this.myListSelector.isSelected(this.nameserverList)) {
                if (this.nameserverList.getItemCount() == 3) {
                    this.showMessageDialog(this.myBundle.getString("PH1_MAX_NAME_SERVER"), this);
                    return;
                }
            } else if (this.lLanDomain.getItemCount() == 3) {
                this.showMessageDialog(this.myBundle.getString("PH1_MAX_DOMAIN"), this);
                return;
            }
            this.showACDdialog(0);
            return;
        }
        if (button == buttonArray[1]) {
            if (this.myTrace) {
                System.out.println("EDIT button hit");
            }
            this.showACDdialog(1);
            this.dialogCommand = 1;
            return;
        }
        if (button == buttonArray[2]) {
            if (this.myTrace) {
                System.out.println("DELETE button hit");
            }
            this.dialogCommand = 2;
            this.showACDdialog(2);
            return;
        }
        if (button == buttonArray[3] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringConfig() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tfHostname.getText());
        return stringBuffer.toString();
    }

    public String toStringResolv() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tfLocalDomain.getText());
        String[] stringArray = new String[1];
        int n = this.nameserverList.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.nameserverList.getItem(n2);
            stringBuffer.append(String.valueOf(stringArray[0]) + " ");
            ++n2;
        }
        String[] stringArray2 = new String[1];
        int n3 = this.lLanDomain.getColumnCount();
        int n4 = 0;
        while (n4 < n3) {
            stringArray2 = this.lLanDomain.getItem(n4);
            stringBuffer.append(String.valueOf(stringArray2[0]) + " ");
            ++n4;
        }
        return stringBuffer.toString();
    }
}

