/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgNFS1sACDr;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgNFS1sACDw;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ListSelector;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumnCallback;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NFSDirEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class PgNFS1s
extends BasePage
implements ActionListener,
MulColumnCallback,
DialogListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private MulColumn lRead;
    private MulColumn lReadWrite;
    private Panel hostPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static final int ADD_BUTTON = 0;
    private static final int CHANGE_BUTTON = 1;
    private static final int DELETE_BUTTON = 2;
    private int dialogCommand = -1;
    GridBagLayout gridBag = new GridBagLayout();
    private ListSelector myListSelector;
    private static final int MAX_BUTTONS_IN_ROW = 3;
    private static final int READ_HOST_LIST_MAX_COLUMNS = 1;
    private static final int WRITE_HOST_LIST_MAX_COLUMNS = 1;
    private DlgNFS1sACDr readDialog;
    private DlgNFS1sACDw writeDialog;
    public static final String CStmt1 = new String("Licensed Materials = Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n");
    public static final String CStmt2 = new String("US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.");

    public PgNFS1s(Notebook notebook) {
        this.myOwner = notebook;
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgNFS1s.buttonLabels[0] = this.myBundle.getString("GLO_ADD");
        PgNFS1s.buttonLabels[1] = this.myBundle.getString("GLO_CHANGE");
        PgNFS1s.buttonLabels[2] = this.myBundle.getString("GLO_DELETE");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.hostPanel = new Panel();
        this.hostPanel.setLayout(this.gridBag);
        String[] stringArray = new String[]{this.myBundle.getString("PF1S_READ_ONLY_HOSTS")};
        int[] nArray = new int[]{100};
        this.lRead = new MulColumn(stringArray, nArray, this);
        String[] stringArray2 = new String[]{this.myBundle.getString("PF1S_READ_WRITE_HOSTS")};
        int[] nArray2 = new int[]{100};
        this.lReadWrite = new MulColumn(stringArray2, nArray2, this);
        this.myListSelector = new ListSelector(this.lRead, this.lReadWrite);
        this.setLayout(this.gridBag);
        Utility.constrain(this.hostPanel, this.lRead, 0, 0, -1, 1, 1, 10, 1.0, 1.0, 10, 0, 0, 5);
        Utility.constrain(this.hostPanel, this.lReadWrite, 1, 0, 0, 1, 1, 10, 1.0, 1.0, 10, 5, 0, 0);
        Utility.constrain(this, this.hostPanel, 0, 1, -1, 1, 1, 10, 2.0, 1.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 0, 3);
    }

    private void doHelpButton() {
    }

    public boolean hasEntries() {
        return !this.isNoEntries(this.lRead) || !this.isNoEntries(this.lReadWrite);
    }

    public void setDataFromGUI(NFSDirEntry nFSDirEntry) {
        int n;
        String[] stringArray;
        int n2;
        nFSDirEntry.deleteReadHostList();
        if (!this.isNoEntries(this.lRead)) {
            n2 = this.lRead.getItemCount();
            stringArray = new String[1];
            n = 0;
            while (n < n2) {
                stringArray = this.lRead.getItem(n);
                nFSDirEntry.addReadHost(stringArray[0]);
                ++n;
            }
        }
        nFSDirEntry.deleteReadWriteHostList();
        if (!this.isNoEntries(this.lReadWrite)) {
            n2 = this.lReadWrite.getItemCount();
            stringArray = new String[1];
            n = 0;
            while (n < n2) {
                stringArray = this.lReadWrite.getItem(n);
                nFSDirEntry.addReadWriteHost(stringArray[0]);
                ++n;
            }
        }
    }

    public void setEmptyList() {
        String[] stringArray = new String[1];
        this.lRead.removeAll();
        stringArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
        this.lRead.add(stringArray);
        String[] stringArray2 = new String[1];
        this.lReadWrite.removeAll();
        stringArray2[0] = this.myBundle.getString("GLO_NO_ENTRIES");
        this.lReadWrite.add(stringArray);
        Button[] buttonArray = myButtonPanel.getButtons();
        buttonArray[1].setEnabled(false);
        buttonArray[2].setEnabled(false);
        this.lRead.select(0);
        this.lReadWrite.select(-1);
    }

    public void setEmptyList(boolean bl) {
        Object[] objectArray;
        if (bl) {
            objectArray = new String[1];
            this.lRead.removeAll();
            objectArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            this.lRead.add((String[])objectArray);
            this.lRead.select(0);
            this.lReadWrite.select(-1);
        } else {
            objectArray = new String[1];
            this.lReadWrite.removeAll();
            objectArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            this.lReadWrite.add((String[])objectArray);
            this.lReadWrite.select(0);
            this.lRead.select(-1);
        }
        objectArray = myButtonPanel.getButtons();
        ((Component)objectArray[1]).setEnabled(false);
        ((Component)objectArray[2]).setEnabled(false);
    }

    public void setGUIfromData(NFSDirEntry nFSDirEntry) {
        int n;
        this.lRead.removeAll();
        this.lReadWrite.removeAll();
        String[] stringArray = new String[1];
        int n2 = nFSDirEntry.getReadHostListSize();
        int n3 = nFSDirEntry.getReadWriteHostListSize();
        Button[] buttonArray = myButtonPanel.getButtons();
        buttonArray[0].setEnabled(true);
        buttonArray[1].setEnabled(true);
        buttonArray[2].setEnabled(true);
        if (n2 > 0) {
            n = 0;
            while (n < n2) {
                stringArray[0] = nFSDirEntry.getReadHost(n);
                this.lRead.add(stringArray);
                ++n;
            }
        }
        if (n3 > 0) {
            n = 0;
            while (n < n3) {
                stringArray[0] = nFSDirEntry.getReadWriteHost(n);
                this.lReadWrite.add(stringArray);
                ++n;
            }
        }
        if (this.myListSelector.isSelected(this.lRead)) {
            this.lRead.select(0);
            this.lReadWrite.select(-1);
        } else {
            this.lRead.select(-1);
            this.lReadWrite.select(0);
        }
        if (n2 < 1 && n3 < 1) {
            this.setEmptyList();
            return;
        }
        if (n2 < 1) {
            this.setEmptyList(true);
        }
        if (n3 < 1) {
            this.setEmptyList(false);
        }
    }

    public void okToAdd(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (bl) {
            buttonArray[0].setEnabled(true);
            return;
        }
        buttonArray[0].setEnabled(false);
    }

    private boolean validatePage() {
        return true;
    }

    private void doOKdlgACDadd() {
        Object[] objectArray;
        if (this.myListSelector.isSelected(this.lRead)) {
            if (this.isNoEntries(this.lRead)) {
                this.removeNoEntries(this.lRead);
            }
            objectArray = new String[]{this.readDialog.getHost()};
            this.lRead.add((String[])objectArray);
            this.lRead.select(this.lRead.getItemCount() - 1);
            this.lReadWrite.select(-1);
            this.readDialog.dispose();
        } else {
            if (this.isNoEntries(this.lReadWrite)) {
                this.removeNoEntries(this.lReadWrite);
            }
            objectArray = new String[]{this.writeDialog.getHost()};
            this.lReadWrite.add((String[])objectArray);
            this.lReadWrite.select(this.lReadWrite.getItemCount() - 1);
            this.lRead.select(-1);
            this.writeDialog.dispose();
        }
        objectArray = myButtonPanel.getButtons();
        ((Component)objectArray[1]).setEnabled(true);
        ((Component)objectArray[2]).setEnabled(true);
    }

    private void doOKdlgACDchange() {
        if (this.myListSelector.isSelected(this.lRead)) {
            int n = this.lRead.getSelectedIndex();
            if (n != -1) {
                String[] stringArray = new String[]{this.readDialog.getHost()};
                this.lRead.replaceItem(stringArray, n);
                this.lRead.select(n);
                this.lReadWrite.select(-1);
            }
            this.readDialog.dispose();
            return;
        }
        int n = this.lReadWrite.getSelectedIndex();
        if (n != -1) {
            String[] stringArray = new String[]{this.writeDialog.getHost()};
            this.lReadWrite.replaceItem(stringArray, n);
            this.lReadWrite.select(n);
            this.lRead.select(-1);
        }
        this.writeDialog.dispose();
    }

    private void doOKdlgACDdelete() {
        int n;
        boolean bl = false;
        if (this.myListSelector.isSelected(this.lRead)) {
            int n2 = this.lRead.getSelectedIndex();
            if (n2 != -1) {
                this.lRead.remove(n2);
                n = this.lRead.getItemCount();
                if (n < 1) {
                    String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES")};
                    bl = true;
                    this.lRead.add(stringArray);
                    n2 = 0;
                } else if (n2 == n) {
                    --n2;
                }
                this.lRead.select(n2);
                this.lReadWrite.select(-1);
            }
        } else {
            int n3 = this.lReadWrite.getSelectedIndex();
            if (n3 != -1) {
                this.lReadWrite.remove(n3);
                n = this.lReadWrite.getItemCount();
                if (n < 1) {
                    String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES")};
                    bl = true;
                    this.lReadWrite.add(stringArray);
                    n3 = 0;
                } else if (n3 == n) {
                    --n3;
                }
                this.lReadWrite.select(n3);
                this.lRead.select(-1);
            }
        }
        if (bl) {
            Button[] buttonArray = myButtonPanel.getButtons();
            buttonArray[1].setEnabled(false);
            buttonArray[2].setEnabled(false);
        }
    }

    public boolean isEmptyList() {
        return this.isNoEntries(this.lRead);
    }

    private void populateDlgACDr() {
        int n = this.lRead.getSelectedIndex();
        String[] stringArray = this.lRead.getItem(n);
        this.readDialog.setHost(stringArray[0]);
    }

    private void populateDlgACDw() {
        int n = this.lReadWrite.getSelectedIndex();
        String[] stringArray = this.lReadWrite.getItem(n);
        this.writeDialog.setHost(stringArray[0]);
    }

    private void showACDdialog(int n) {
        this.readDialog = null;
        this.writeDialog = null;
        switch (n) {
            case 0: {
                if (this.myListSelector.isSelected(this.lRead)) {
                    this.readDialog = new DlgNFS1sACDr(0, this, this.lRead);
                    break;
                }
                this.writeDialog = new DlgNFS1sACDw(0, this, this.lReadWrite);
                break;
            }
            case 1: {
                if (this.myListSelector.isSelected(this.lRead)) {
                    this.readDialog = new DlgNFS1sACDr(1, this, this.lRead);
                    this.populateDlgACDr();
                    break;
                }
                this.writeDialog = new DlgNFS1sACDw(1, this, this.lReadWrite);
                this.populateDlgACDw();
                break;
            }
            case 2: {
                if (this.myListSelector.isSelected(this.lRead)) {
                    this.readDialog = new DlgNFS1sACDr(2, this, this.lRead);
                    this.populateDlgACDr();
                    break;
                }
                this.writeDialog = new DlgNFS1sACDw(2, this, this.lReadWrite);
                this.populateDlgACDw();
                break;
            }
            default: {
                if (this.myListSelector.isSelected(this.lRead)) {
                    this.readDialog = new DlgNFS1sACDr(0, this, this.lRead);
                    break;
                }
                this.writeDialog = new DlgNFS1sACDw(0, this, this.lReadWrite);
            }
        }
        if (this.myListSelector.isSelected(this.lRead)) {
            this.myOwner.setEnabled(false);
            this.readDialog.setVisible(true);
            return;
        }
        this.myOwner.setEnabled(false);
        this.writeDialog.setVisible(true);
    }

    public void messageFinished(int n) {
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (n == 0) {
            if (this.dialogCommand == 1) {
                this.doOKdlgACDchange();
            } else if (this.dialogCommand == 2) {
                this.doOKdlgACDdelete();
            } else if (this.dialogCommand == 0) {
                this.doOKdlgACDadd();
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void singleClick(MulColumn mulColumn, int n) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (mulColumn == this.lRead) {
            this.myListSelector.selectList(this.lRead);
            if (this.isNoEntries(this.lRead)) {
                buttonArray[1].setEnabled(false);
                buttonArray[2].setEnabled(false);
            } else {
                buttonArray[1].setEnabled(true);
                buttonArray[2].setEnabled(true);
            }
        }
        if (mulColumn == this.lReadWrite) {
            this.myListSelector.selectList(this.lReadWrite);
            if (this.isNoEntries(this.lReadWrite)) {
                buttonArray[1].setEnabled(false);
                buttonArray[2].setEnabled(false);
                return;
            }
            buttonArray[1].setEnabled(true);
            buttonArray[2].setEnabled(true);
        }
    }

    public void doubleClick(MulColumn mulColumn, int n) {
        if (mulColumn == this.lRead) {
            this.myListSelector.selectList(this.lRead);
        }
        if (mulColumn == this.lReadWrite) {
            this.myListSelector.selectList(this.lReadWrite);
        }
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if ((button == buttonArray[1] || button == buttonArray[2]) && (this.myListSelector.isSelected(this.lRead) ? !this.isChangeDeleteOk(this.lRead, this) : !this.isChangeDeleteOk(this.lReadWrite, this))) {
            return;
        }
        if (button == buttonArray[0]) {
            this.dialogCommand = 0;
            this.showACDdialog(0);
            return;
        }
        if (button == buttonArray[1]) {
            this.dialogCommand = 1;
            this.showACDdialog(1);
            return;
        }
        if (button == buttonArray[2]) {
            this.dialogCommand = 2;
            this.showACDdialog(2);
        }
    }

    public String toStringNFS1s() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[1];
        int n = this.lRead.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.lRead.getItem(n2);
            stringBuffer.append(String.valueOf(stringArray[0]) + " ");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

