/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.LanInterface;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookProfile;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SetupData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class PgNetwork3
extends BasePage
implements ActionListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Checkbox cbEnableAllrs;
    private Checkbox cbDisableARP;
    private Checkbox cbICMP;
    private Checkbox cbDisableSendingSnapFormat;
    private Checkbox cbDisableRoutingFieldSupport;
    private Checkbox cbEnableTrailerEncapsulation;
    private Checkbox cbEnableEthernetProtocol;
    private Checkbox cbCanonical;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null};
    private static final int UNDO_BUTTON = 0;
    private static final int MAX_BUTTONS_IN_ROW = 2;
    private Panel centerPanel;
    private String originalSetupString = new String();
    private boolean undoTheUpdate = true;
    private NotebookProfile myNotebookProfile;
    private SetupData mySetupData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private boolean myTrace = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgNetwork3(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgNetwork3.buttonLabels[0] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(String.valueOf(this.myBundle.getString("PN3_TITLE")) + " -                                        ");
        this.centerPanel = new Panel();
        this.cbEnableAllrs = new Checkbox(this.myBundle.getString("PN3_ALLRS"));
        this.cbDisableARP = new Checkbox(this.myBundle.getString("PN3_ARP"));
        this.cbICMP = new Checkbox(this.myBundle.getString("PN3_ICMPRED"));
        this.cbDisableSendingSnapFormat = new Checkbox(this.myBundle.getString("PN3_SNAP"));
        this.cbDisableRoutingFieldSupport = new Checkbox(this.myBundle.getString("PN3_BRIDGE"));
        this.cbEnableTrailerEncapsulation = new Checkbox(this.myBundle.getString("PN3_TRAILERS"));
        this.cbEnableEthernetProtocol = new Checkbox(this.myBundle.getString("PN3_IEEE"));
        this.cbCanonical = new Checkbox(this.myBundle.getString("PN3_CANONICAL"));
        this.cbEnableAllrs.addKeyListener(this);
        this.cbDisableARP.addKeyListener(this);
        this.cbICMP.addKeyListener(this);
        this.cbDisableSendingSnapFormat.addKeyListener(this);
        this.cbDisableRoutingFieldSupport.addKeyListener(this);
        this.cbEnableTrailerEncapsulation.addKeyListener(this);
        this.cbEnableEthernetProtocol.addKeyListener(this);
        this.cbCanonical.addKeyListener(this);
        this.setLayout(this.gridBag);
        this.centerPanel.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.cbEnableAllrs, 0, 0, 0, 1, 2, 17, 1.0, 1.0, 3, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.cbDisableARP, 0, 1, 0, 1, 2, 17, 1.0, 1.0, 3, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.cbICMP, 0, 2, 0, 1, 2, 17, 1.0, 1.0, 3, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.cbDisableSendingSnapFormat, 0, 3, 0, 1, 2, 17, 1.0, 1.0, 3, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.cbDisableRoutingFieldSupport, 0, 4, 0, 1, 2, 17, 1.0, 1.0, 3, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.cbEnableTrailerEncapsulation, 0, 5, 0, 1, 2, 17, 1.0, 1.0, 3, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.cbEnableEthernetProtocol, 0, 6, 0, 1, 2, 17, 1.0, 1.0, 3, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.cbCanonical, 0, 7, 0, 1, 2, 17, 1.0, 1.0, 3, 0, 0, 0);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 20, 0, 0);
        this.addButtonGUI(0, 2, 2);
    }

    private void doHelpButton() {
    }

    private void doUndoButton() {
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalSetupString = this.toStringSetup();
            this.mySetupData.setUpdated(false);
        }
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.mySetupData = this.myServerProxy.getNotebookProfileDataHandle().getSetupDataHandle();
    }

    public void setDataFromGUI() {
        LanInterface lanInterface = this.mySetupData.getLanInterface(this.mySetupData.getLanSelectedIndex());
        lanInterface.setAllrsEnabled(this.cbEnableAllrs.getState());
        lanInterface.setArpDisabled(this.cbDisableARP.getState());
        lanInterface.setICMP(this.cbICMP.getState());
        lanInterface.setSendingSnapFormatDisabled(this.cbDisableSendingSnapFormat.getState());
        lanInterface.setRoutingFieldSupportDisabled(this.cbDisableRoutingFieldSupport.getState());
        lanInterface.setTrailerEncapsulationEnabled(this.cbEnableTrailerEncapsulation.getState());
        lanInterface.setEthernetProtocolEnabled(this.cbEnableEthernetProtocol.getState());
        lanInterface.setCanonical(this.cbCanonical.getState());
        if (this.myTrace) {
            System.out.println("PgNetwork3 COMPARING Original string = " + this.originalSetupString);
            System.out.println("PgNetwork3 COMPARING Current  string = " + this.toStringSetup());
        }
        if (this.originalSetupString.compareTo(this.toStringSetup()) != 0) {
            if (this.myTrace) {
                System.out.println("PgNetwork3 SetupData has changed!!!");
            }
            this.mySetupData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgNetwork3 SetupData has NOT changed!!!");
        }
        this.originalSetupString = null;
        if (this.mySetupData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgNetwork3 SetupData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
    }

    public void setGUIfromData() {
        this.cbEnableAllrs.setEnabled(true);
        this.cbDisableARP.setEnabled(true);
        this.cbICMP.setEnabled(true);
        this.cbDisableSendingSnapFormat.setEnabled(true);
        this.cbDisableRoutingFieldSupport.setEnabled(true);
        this.cbEnableTrailerEncapsulation.setEnabled(true);
        this.cbEnableEthernetProtocol.setEnabled(true);
        this.cbCanonical.setEnabled(true);
        LanInterface lanInterface = this.mySetupData.getLanInterface(this.mySetupData.getLanSelectedIndex());
        this.cbEnableAllrs.setState(lanInterface.isAllrsEnabled());
        this.cbDisableARP.setState(lanInterface.isArpDisabled());
        this.cbICMP.setState(lanInterface.isICMP());
        this.cbDisableSendingSnapFormat.setState(lanInterface.isSendingSnapFormatDisabled());
        this.cbDisableRoutingFieldSupport.setState(lanInterface.isRoutingFieldSupportDisabled());
        this.cbEnableTrailerEncapsulation.setState(lanInterface.isTrailerEncapsulationEnabled());
        this.cbEnableEthernetProtocol.setState(lanInterface.isEthernetProtocolEnabled());
        this.cbCanonical.setState(lanInterface.isCanonical());
        String string = lanInterface.getInterfaceName();
        this.lblPageTitle.setText(String.valueOf(this.myBundle.getString("PN3_TITLE")) + " - " + string + "  ");
        if (string.compareTo(Cfg2Defines.LOOPBACK_tag) == 0) {
            this.cbEnableAllrs.setEnabled(false);
            this.cbDisableARP.setEnabled(false);
            this.cbICMP.setEnabled(false);
            this.cbDisableSendingSnapFormat.setEnabled(false);
            this.cbDisableRoutingFieldSupport.setEnabled(false);
            this.cbEnableTrailerEncapsulation.setEnabled(false);
            this.cbEnableEthernetProtocol.setEnabled(false);
            this.cbCanonical.setEnabled(false);
        }
        this.originalSetupString = this.toStringSetup();
        if (this.myTrace) {
            System.out.println("PgNetwork3 Original string = " + this.originalSetupString);
        }
        if (this.mySetupData.isUpdated()) {
            this.undoTheUpdate = false;
        }
    }

    public boolean validatePage() {
        return true;
    }

    public void messageFinished(int n) {
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public void handleCheckbox(Checkbox checkbox) {
    }

    public String toStringSetup() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cbEnableAllrs.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbDisableARP.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbICMP.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbDisableSendingSnapFormat.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbDisableRoutingFieldSupport.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbEnableTrailerEncapsulation.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbEnableEthernetProtocol.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbCanonical.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        return stringBuffer.toString();
    }
}

