/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Validation;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ConfigData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class PgPrinting1
extends BasePage
implements ActionListener,
MessageListener {
    private static final int LPDPORTS_DEFAULT = 2;
    private static final int LPDPORTS_MIN = 2;
    private static final int LPDPORTS_MAX = 64;
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblRemoteServer;
    private Label lblRemotePrinter;
    private Label lblLPDports;
    private TextField tfRemoteServer;
    private TextField tfRemotePrinter;
    private TextField tfLPDports;
    private Panel centerPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null};
    private static final int UNDO_BUTTON = 0;
    private static final int MAX_BUTTONS_IN_ROW = 2;
    private String originalConfigString = new String();
    private boolean undoTheUpdate = true;
    private ConfigData myConfigData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private boolean myTrace = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgPrinting1(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgPrinting1.buttonLabels[0] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PP1_TITLE"));
        this.lblRemoteServer = new Label(this.myBundle.getString("PP1_REMOTE_SERVER"));
        this.lblRemotePrinter = new Label(this.myBundle.getString("PP1_REMOTE_SERVER_PRINTER"));
        this.lblLPDports = new Label(this.myBundle.getString("PP1_MAX_LPD_PORTS"));
        this.tfRemoteServer = new TextField();
        this.tfRemotePrinter = new TextField();
        this.tfLPDports = new TextField();
        this.setLayout(this.gridBag);
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.lblRemoteServer, 0, 0, -1, 1, 2, 13, 1.0, 1.0, 50, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.tfRemoteServer, 1, 0, 0, 1, 2, 13, 1.0, 1.0, 50, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblRemotePrinter, 0, 1, -1, 1, 2, 13, 1.0, 1.0, 50, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.tfRemotePrinter, 1, 1, 0, 1, 2, 13, 1.0, 1.0, 50, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblLPDports, 0, 2, -1, 1, 2, 13, 1.0, 1.0, 50, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.tfLPDports, 1, 2, 0, 1, 2, 13, 1.0, 1.0, 50, 0, 0, 10);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 2, 10, 1.0, 1.0, 10, 20, 0, 0);
        this.addButtonGUI(0, 2, 2);
    }

    private void doHelpButton() {
    }

    private void doUndoButton() {
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalConfigString = this.toStringConfig();
            this.myConfigData.setUpdated(false);
        }
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.myConfigData = this.myServerProxy.getNotebookProfileDataHandle().getConfigDataHandle();
    }

    public void setDataFromGUI() {
        this.myConfigData.setRemotePrintServer(this.tfRemoteServer.getText());
        this.myConfigData.setRemotePrinter(this.tfRemotePrinter.getText());
        if (!Utility.isEmptyTextField(this.tfLPDports)) {
            this.myConfigData.setLpdPortsMaxCount(Integer.parseInt(this.tfLPDports.getText()));
        } else {
            this.myConfigData.setLpdPortsMaxCount(2);
        }
        if (this.myTrace) {
            System.out.println("PgPrinting1 COMPARING Original string = " + this.originalConfigString);
            System.out.println("PgPrinting1 COMPARING Current  string = " + this.toStringConfig());
        }
        if (this.originalConfigString.compareTo(this.toStringConfig()) != 0) {
            if (this.myTrace) {
                System.out.println("PgPrinting1 ConfigData has changed!!!");
            }
            this.myConfigData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgPrinting1 ConfigData has NOT changed!!!");
        }
        this.originalConfigString = null;
        if (this.myConfigData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgPrinting1 ConfigData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
    }

    public void setGUIfromData() {
        ((TextComponent)this.tfRemoteServer).setText(this.myConfigData.getRemotePrintServer());
        ((TextComponent)this.tfRemotePrinter).setText(this.myConfigData.getRemotePrinter());
        ((TextComponent)this.tfLPDports).setText(String.valueOf(this.myConfigData.getLpdPortsMaxCount()));
        this.originalConfigString = this.toStringConfig();
        if (this.myTrace) {
            System.out.println("PgPrinting1 Original string = " + this.originalConfigString);
        }
        if (this.myConfigData.isUpdated()) {
            this.undoTheUpdate = false;
        }
    }

    public boolean validatePage() {
        if (!Utility.isEmptyTextField(this.tfRemotePrinter) || !Utility.isEmptyTextField(this.tfRemoteServer)) {
            if (!Cfg2Validation.IsValidNumeric(this.tfLPDports.getText())) {
                this.showMessageDialog(this.myBundle.getString("PP1_INVALID_LPDPORTS_COUNT"), this);
                return false;
            }
            int n = Integer.parseInt(this.tfLPDports.getText());
            if (n < 2 || n > 64) {
                this.showMessageDialog(this.myBundle.getString("PP1_INVALID_LPDPORTS_COUNT"), this);
                return false;
            }
        }
        return true;
    }

    public void messageFinished(int n) {
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringConfig() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tfRemoteServer.getText());
        stringBuffer.append(this.tfRemotePrinter.getText());
        stringBuffer.append(this.tfLPDports.getText());
        return stringBuffer.toString();
    }
}

