/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgCreateRoute;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgRouting1ACD;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.LanInterface;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Route;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SetupData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class PgRouting1
extends BasePage
implements ActionListener,
DialogListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblRouteList;
    private Checkbox cbIPForwarding;
    private MulColumn myList;
    private static String[] buttonLabels1 = new String[]{null};
    private ButtonPanel myButtons1;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null, null};
    private static final int ADD_BUTTON = 0;
    private static final int CHANGE_BUTTON = 1;
    private static final int DELETE_BUTTON = 2;
    private static final int UNDO_BUTTON = 3;
    private Panel centerPanel;
    private static final int CREATE_BUTTON = 0;
    private static final int CREATE_DIALOG = 990;
    private DlgRouting1ACD routingDialog;
    private DlgCreateRoute createRouteDialog;
    private String[] netRouteArray;
    private static String ipClassMask = "0.0.0.0";
    private static String routerNet = null;
    private static String mySubNet = null;
    private static boolean validateNoRouteError;
    private static String ipa;
    private static String snm;
    private static String ip;
    private static String sn;
    private static String subNetAddress;
    private static String[] oct;
    private static int k;
    private int dialogCommand = -1;
    private String originalSetupString = new String();
    private boolean undoTheUpdate = true;
    private SetupData mySetupData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private boolean myTrace = false;
    private boolean addNet;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgRouting1(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgRouting1.buttonLabels1[0] = this.myBundle.getString("PGR1_CREATE");
        PgRouting1.buttonLabels[0] = this.myBundle.getString("GLO_ADD");
        PgRouting1.buttonLabels[1] = this.myBundle.getString("GLO_CHANGE");
        PgRouting1.buttonLabels[2] = this.myBundle.getString("GLO_DELETE");
        PgRouting1.buttonLabels[3] = this.myBundle.getString("GLO_UNDO");
        this.myButtons1 = new ButtonPanel(this, buttonLabels1);
        Utility.constrain(this, this.myButtons1, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(this.myButtons1);
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, ++n, ++n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PGR1_TITLE"));
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        String[] stringArray = new String[]{this.myBundle.getString("PGR1_ROUTE_TYPE"), this.myBundle.getString("PGR1_DESTINATION"), this.myBundle.getString("PGR1_ROUTER"), this.myBundle.getString("PGR1_METRIC"), this.myBundle.getString("PGR1_SUBNET_MASK")};
        int[] nArray = new int[]{20, 20, 20, 20, 20};
        this.myList = new MulColumn(stringArray, nArray);
        this.cbIPForwarding = new Checkbox(this.myBundle.getString("PGR1_IP_FORWARDING"));
        this.cbIPForwarding.addKeyListener(this);
        this.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.myList, 0, 0, 0, 1, 1, 10, 1.0, 1.0, 10, 10, 10, 10);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this, this.cbIPForwarding, 0, 2, 0, 1, 0, 10, 1.0, 0.0, 0, 10, 0, 0);
        this.addButtonGUI(0, 3, 5);
    }

    private void doUndoButton() {
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalSetupString = this.toStringSetup();
            this.mySetupData.setUpdated(false);
        }
    }

    private void doHelpButton() {
    }

    public void disableCreateButton() {
        this.myButtons1.disable(this.myBundle.getString("PGR1_CREATE"));
    }

    public void enableCreateButton() {
        this.myButtons1.enable(this.myBundle.getString("PGR1_CREATE"));
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.mySetupData = this.myServerProxy.getNotebookProfileDataHandle().getSetupDataHandle();
    }

    public void setDataFromGUI() {
        this.mySetupData.deleteRouteList();
        int n = this.isNoEntries(this.myList) ? 0 : this.myList.getItemCount();
        String[] stringArray = new String[5];
        Route route = null;
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.myList.getItem(n2);
            Integer n3 = new Integer(stringArray[3]);
            route = new Route(stringArray[0], stringArray[1], stringArray[2], n3, stringArray[4]);
            this.mySetupData.addRoute(route);
            ++n2;
        }
        this.mySetupData.setIPForwarding(this.cbIPForwarding.getState());
        if (this.myTrace) {
            System.out.println("PgrOUTING1 COMPARING Original string = " + this.originalSetupString);
            System.out.println("PgrOUTING1 COMPARING Current  string = " + this.toStringSetup());
        }
        if (this.originalSetupString.compareTo(this.toStringSetup()) != 0) {
            if (this.myTrace) {
                System.out.println("PgrOUTING1 SetupData has changed!!!");
            }
            this.mySetupData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgrOUTING1 SetupData has NOT changed!!!");
        }
        this.originalSetupString = null;
        if (this.mySetupData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgrOUTING1 SetupData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
    }

    public void setGUIfromData() {
        boolean bl = false;
        this.myList.removeAll();
        int n = this.mySetupData.getRouteListSize();
        String[] stringArray = new String[5];
        if (n == 0) {
            stringArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            stringArray[1] = "";
            stringArray[2] = "";
            stringArray[3] = "";
            stringArray[4] = "";
            this.myList.add(stringArray);
        } else {
            int n2 = 0;
            while (n2 < n) {
                Route route = this.mySetupData.getRoute(n2);
                stringArray[0] = route.getRouteType();
                stringArray[1] = route.getDest();
                stringArray[2] = route.getRouter();
                Integer n3 = new Integer(route.getMetric());
                stringArray[3] = n3.toString();
                stringArray[4] = route.getSubnetMask();
                this.myList.add(stringArray);
                if (stringArray[0].compareTo("default") == 0) {
                    bl = true;
                }
                ++n2;
            }
        }
        if (this.mySetupData.isIPForwarding()) {
            this.cbIPForwarding.setState(true);
        } else {
            this.cbIPForwarding.setState(false);
        }
        if (bl) {
            this.enableCreateButton();
        } else {
            this.disableCreateButton();
        }
        this.myList.select(0);
        this.originalSetupString = this.toStringSetup();
        if (this.myTrace) {
            System.out.println("PgNetwork2 Original string = " + this.originalSetupString);
        }
        if (this.mySetupData.isUpdated()) {
            this.undoTheUpdate = false;
        }
    }

    public boolean validatePage() {
        validateNoRouteError = false;
        if (!Utility.getIgnoreNoRouteError() && this.isNoEntries(this.myList)) {
            validateNoRouteError = true;
            this.showMessageDialog(this.myBundle.getString("PGR1_EMPTY_LIST"), this);
            return false;
        }
        return true;
    }

    private void doOKdlgACDadd() {
        int n;
        int n2 = n = this.myList.getSelectedIndex();
        if (this.routingDialog.getAddAfterState()) {
            ++n2;
        }
        if (this.isNoEntries(this.myList)) {
            this.removeNoEntries(this.myList);
            n2 = 0;
        }
        String[] stringArray = new String[5];
        stringArray[0] = this.routingDialog.getRouteType();
        if (stringArray[0].compareTo("default") == 0) {
            stringArray[1] = "";
            stringArray[2] = this.routingDialog.getRouterAddress();
            stringArray[3] = this.routingDialog.getMetricCount();
            stringArray[4] = "";
            if (this.isNoEntries(this.myList)) {
                this.myList.add(stringArray);
            } else {
                this.myList.insertItem(stringArray, n2);
            }
            this.myList.select(n2);
            stringArray[0] = "net";
            stringArray[2] = this.routingDialog.getRouterAddress();
            stringArray[3] = this.routingDialog.getMetricCount();
            int n3 = Utility.getClassRange(stringArray[2]);
            switch (n3) {
                case 0: {
                    stringArray[1] = String.valueOf(Utility.getOctet(1, stringArray[2])) + ".0.0.0";
                    stringArray[4] = "255.0.0.0";
                    break;
                }
                case 1: {
                    stringArray[1] = String.valueOf(Utility.getOctet(1, stringArray[2])) + "." + Utility.getOctet(2, stringArray[2]) + ".0.0";
                    stringArray[4] = "255.255.0.0";
                    break;
                }
                case 2: {
                    stringArray[1] = String.valueOf(Utility.getOctet(1, stringArray[2])) + "." + Utility.getOctet(2, stringArray[2]) + "." + Utility.getOctet(3, stringArray[2]) + ".0";
                    stringArray[4] = "255.255.255.0";
                    break;
                }
                case 3: {
                    stringArray[1] = String.valueOf(Utility.getOctet(1, stringArray[2])) + "." + Utility.getOctet(2, stringArray[2]) + "." + Utility.getOctet(3, stringArray[2]) + "." + Utility.getOctet(4, stringArray[2]);
                    stringArray[4] = "255.255.255.255";
                    break;
                }
                default: {
                    stringArray[1] = "";
                    stringArray[4] = "";
                }
            }
            int n4 = 0;
            while (n4 < 7) {
                this.addNet = true;
                LanInterface lanInterface = this.mySetupData.getLanInterface(n4);
                if (lanInterface.isEnabled()) {
                    ipa = lanInterface.getIPaddress();
                    snm = lanInterface.getSubnetMask();
                    n3 = Utility.getClassRange(ipa);
                    switch (n3) {
                        case 0: {
                            ipClassMask = "255.0.0.0";
                            break;
                        }
                        case 1: {
                            ipClassMask = "255.255.0.0";
                            break;
                        }
                        case 2: {
                            ipClassMask = "255.255.255.0";
                            break;
                        }
                        case 3: {
                            ipClassMask = "255.255.255.255";
                            break;
                        }
                    }
                    routerNet = this.getSubnetAddress(ipa, ipClassMask);
                    mySubNet = this.getSubnetAddress(ipa, snm);
                    if (routerNet.equals(mySubNet)) {
                        this.addNet = false;
                    }
                    if (!this.addNet) break;
                }
                ++n4;
            }
            if (this.addNet) {
                this.myList.insertItem(stringArray, n2 + 1);
            }
            this.enableCreateButton();
        } else {
            stringArray[1] = this.routingDialog.getDestinationAddress();
            stringArray[2] = this.routingDialog.getRouterAddress();
            stringArray[3] = this.routingDialog.getMetricCount();
            stringArray[4] = this.routingDialog.getSubnetMask();
            this.myList.insertItem(stringArray, n2);
            if (this.isNoEntries(this.myList)) {
                this.removeNoEntries(this.myList);
                --n2;
            }
            this.myList.select(n2);
        }
        this.routingDialog.dispose();
    }

    private String getSubnetAddress(String string, String string2) {
        ip = string;
        sn = string2;
        int n = 0;
        while (n < 4) {
            try {
                Integer n2 = Integer.valueOf(Utility.getOctet(n + 1, ip));
                Integer n3 = Integer.valueOf(Utility.getOctet(n + 1, sn));
                int n4 = n2 & n3;
                PgRouting1.oct[n] = Integer.toString(n4);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("NumberFormatException Occured :");
            }
            ++n;
        }
        subNetAddress = String.valueOf(oct[0]) + "." + oct[1] + "." + oct[2] + "." + oct[3];
        return subNetAddress;
    }

    private void doOKdlgACDchange() {
        int n = this.myList.getSelectedIndex();
        boolean bl = false;
        String[] stringArray = new String[5];
        stringArray = this.myList.getItem(n);
        if (stringArray[0].compareTo("default") == 0) {
            bl = true;
        }
        stringArray[0] = this.routingDialog.getRouteType();
        stringArray[1] = this.routingDialog.getDestinationAddress();
        stringArray[2] = this.routingDialog.getRouterAddress();
        stringArray[3] = this.routingDialog.getMetricCount();
        stringArray[4] = this.routingDialog.getSubnetMask();
        this.myList.replaceItem(stringArray, n);
        this.myList.select(n);
        if (stringArray[0].compareTo("default") == 0) {
            this.enableCreateButton();
        } else {
            int n2 = this.myList.getItemCount();
            if (bl) {
                boolean bl2 = false;
                int n3 = 0;
                while (n3 < n2) {
                    stringArray = this.myList.getItem(n3);
                    if (stringArray[0].compareTo("default") == 0) {
                        bl2 = true;
                        break;
                    }
                    ++n3;
                }
                if (bl2) {
                    this.enableCreateButton();
                } else {
                    this.disableCreateButton();
                }
            }
        }
        this.routingDialog.dispose();
    }

    private void doOKdlgACDdelete() {
        String[] stringArray = new String[5];
        int n = this.myList.getSelectedIndex();
        boolean bl = false;
        stringArray = this.myList.getItem(n);
        if (stringArray[0].compareTo("default") == 0) {
            bl = true;
        }
        this.myList.remove(n);
        int n2 = this.myList.getItemCount();
        if (n2 < 1) {
            stringArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            stringArray[1] = "";
            stringArray[2] = "";
            stringArray[3] = "";
            stringArray[4] = "";
            this.myList.add(stringArray);
            n = 0;
            this.disableCreateButton();
        } else {
            if (bl) {
                boolean bl2 = false;
                int n3 = 0;
                while (n3 < n2) {
                    stringArray = this.myList.getItem(n3);
                    if (stringArray[0].compareTo("default") == 0) {
                        bl2 = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl2) {
                    this.disableCreateButton();
                }
            }
            if (n == n2) {
                --n;
            }
        }
        this.myList.select(n);
    }

    private void populateDlgACD() {
        String[] stringArray = this.myList.getItem(this.myList.getSelectedIndex());
        this.routingDialog.setRouteType(stringArray[0]);
        this.routingDialog.setDestinationAddress(stringArray[1]);
        this.routingDialog.setRouterAddress(stringArray[2]);
        this.routingDialog.setMetricCount(stringArray[3]);
        this.routingDialog.setSubnetMask(stringArray[4]);
    }

    private void showACDdialog(int n) {
        this.routingDialog = null;
        switch (n) {
            case 0: {
                this.routingDialog = new DlgRouting1ACD(0, this, this.myList);
                this.routingDialog.setRouteType("net");
                Integer n2 = new Integer(1);
                this.routingDialog.setMetricCount(n2.toString());
                break;
            }
            case 1: {
                this.routingDialog = new DlgRouting1ACD(1, this, this.myList);
                this.populateDlgACD();
                break;
            }
            case 2: {
                this.routingDialog = new DlgRouting1ACD(2, this, this.myList);
                this.populateDlgACD();
                break;
            }
            case 990: {
                this.createRouteDialog = new DlgCreateRoute(this, this.myList);
                break;
            }
            default: {
                this.routingDialog = new DlgRouting1ACD(0, this, this.myList);
            }
        }
        this.myOwner.setEnabled(false);
        if (n == 990) {
            this.createRouteDialog.setVisible(true);
            return;
        }
        this.routingDialog.setVisible(true);
    }

    private void doDlgCreateRoute() {
        if (this.isNoEntries(this.myList)) {
            this.removeNoEntries(this.myList);
        }
        if (this.createRouteDialog.isDefNetRouteCreated()) {
            this.netRouteArray = this.createRouteDialog.getDefNetRoute();
            this.myList.add(this.netRouteArray);
            this.myList.select(this.myList.getItemCount() - 1);
        }
        this.createRouteDialog.dispose();
    }

    public void messageFinished(int n) {
        if (validateNoRouteError) {
            if (n == 0) {
                Utility.setIgnoreNoRouteError(true);
            } else if (n == 1) {
                Utility.setIgnoreNoRouteError(false);
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (this.myTrace) {
            System.out.println("In PgHostname1.dialogFinished() - userAction=" + n);
        }
        if (n == 0) {
            if (this.dialogCommand == 1) {
                this.doOKdlgACDchange();
            } else if (this.dialogCommand == 2) {
                this.doOKdlgACDdelete();
            } else if (this.dialogCommand == 0) {
                this.doOKdlgACDadd();
            } else if (this.dialogCommand == 990) {
                this.doDlgCreateRoute();
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleCheckbox(Checkbox checkbox) {
    }

    public void handleButton(Button button) {
        Button[] buttonArray;
        Button[] buttonArray2 = this.myButtons1.getButtons();
        if (button == buttonArray2[0]) {
            this.dialogCommand = 990;
            this.showACDdialog(990);
        }
        if (button == (buttonArray = myButtonPanel.getButtons())[0]) {
            this.dialogCommand = 0;
            this.showACDdialog(0);
            return;
        }
        if (button == buttonArray[1]) {
            if (this.isChangeDeleteOk(this.myList, this)) {
                this.dialogCommand = 1;
                this.showACDdialog(1);
                return;
            }
        } else if (button == buttonArray[2]) {
            if (this.isChangeDeleteOk(this.myList, this)) {
                this.dialogCommand = 2;
                this.showACDdialog(2);
                return;
            }
        } else if (button == buttonArray[3] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringSetup() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cbIPForwarding.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        String[] stringArray = new String[5];
        int n = this.myList.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.myList.getItem(n2);
            stringBuffer.append(String.valueOf(stringArray[0]) + " ");
            stringBuffer.append(String.valueOf(stringArray[1]) + " ");
            stringBuffer.append(String.valueOf(stringArray[2]) + " ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    static {
        ipa = null;
        snm = null;
        ip = null;
        sn = null;
        subNetAddress = null;
        oct = new String[]{"0", "0", "0", "0"};
    }
}

