/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgSOCKS1ACDd;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgSOCKS1ACDn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ListSelector;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumnCallback;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class PgSOCKS1
extends BasePage
implements ActionListener,
MulColumnCallback,
DialogListener,
MessageListener {
    private ResourceBundle myBundle;
    private static final int MAX_USERID_SIZE = 75;
    private Label lblPageTitle;
    private Label lblUserId;
    private Label lblPassword;
    private Label lblVerifyPW;
    private MulColumn DomainList;
    private MulColumn DNSList;
    private Panel centerPanel;
    private Panel topPanel;
    private TextField antfUserId;
    private TextField antfPassword;
    private TextField antfVerifyPW;
    private Checkbox cbEnableSOCKS;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null, null};
    private static final int ADD_BUTTON = 0;
    private static final int CHANGE_BUTTON = 1;
    private static final int DELETE_BUTTON = 2;
    private static final int UNDO_BUTTON = 3;
    private int dialogCommand = -1;
    private byte[] myEncryptedPw;
    private String originalSocksString = new String();
    private boolean undoTheUpdate = true;
    private SocksData mySocksData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private boolean myTrace = false;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private static final int DOMAIN_LIST_MAX_COLUMNS = 1;
    private static final int NAME_SERVER_LIST_MAX_COLUMNS = 1;
    private ListSelector myListSelector;
    private DlgSOCKS1ACDn nameserverDialog;
    private DlgSOCKS1ACDd domainDialog;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgSOCKS1(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgSOCKS1.buttonLabels[0] = this.myBundle.getString("GLO_ADD");
        PgSOCKS1.buttonLabels[1] = this.myBundle.getString("GLO_CHANGE");
        PgSOCKS1.buttonLabels[2] = this.myBundle.getString("GLO_DELETE");
        PgSOCKS1.buttonLabels[3] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PS1_TITLE"));
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        this.topPanel = new Panel();
        this.topPanel.setLayout(this.gridBag);
        String[] stringArray = new String[]{this.myBundle.getString("PS1_DOMAIN")};
        int[] nArray = new int[]{100};
        this.DomainList = new MulColumn(stringArray, nArray, this);
        String[] stringArray2 = new String[]{this.myBundle.getString("PS1_NAMESERVER")};
        int[] nArray2 = new int[]{100};
        this.DNSList = new MulColumn(stringArray2, nArray2, this);
        this.myListSelector = new ListSelector(this.DomainList, this.DNSList);
        myButtonPanel = new ButtonPanel(this, buttonLabels);
        this.lblUserId = new Label(this.myBundle.getString("PS1_USERID"));
        this.lblPassword = new Label(this.myBundle.getString("PS1_PASSWORD"));
        this.lblVerifyPW = new Label(this.myBundle.getString("PS1_VERIFYPW"));
        this.cbEnableSOCKS = new Checkbox(this.myBundle.getString("PS1_ENABLE"));
        this.cbEnableSOCKS.addKeyListener(this);
        this.antfUserId = new TextField();
        this.antfPassword = new TextField();
        this.antfPassword.setEchoChar('*');
        this.antfVerifyPW = new TextField();
        this.antfVerifyPW.setEchoChar('*');
        this.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.topPanel, this.cbEnableSOCKS, 0, 0, 0, 1, 0, 10, 1.0, 0.5, 0, 0, 0, 0);
        Utility.constrain(this.topPanel, this.lblUserId, 0, 1, -1, 1, 0, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.topPanel, this.antfUserId, 1, 1, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.topPanel, this.lblPassword, 0, 2, -1, 1, 0, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.topPanel, this.antfPassword, 1, 2, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.topPanel, this.lblVerifyPW, 0, 3, -1, 1, 0, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.topPanel, this.antfVerifyPW, 1, 3, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.DomainList, 0, 4, -1, 1, 1, 10, 1.0, 1.0, 0, 10, 0, 15);
        Utility.constrain(this.centerPanel, this.DNSList, 1, 4, 0, 1, 1, 10, 1.0, 1.0, 0, 15, 0, 10);
        Utility.constrain(this, this.topPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this, this.centerPanel, 0, 2, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 5, 5);
    }

    private void doUndoButton() {
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalSocksString = this.toStringSocks();
            this.mySocksData.setUpdated(false);
        }
    }

    private void doHelpButton() {
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.mySocksData = this.myServerProxy.getNotebookProfileDataHandle().getSocksDataHandle();
    }

    public void setDataFromGUI() {
        String[] stringArray;
        int n;
        int n2;
        this.mySocksData.setEnabled(this.cbEnableSOCKS.getState());
        this.mySocksData.setUserID(this.antfUserId.getText());
        if (!Utility.isEmptyTextField(this.antfPassword)) {
            this.mySocksData.setmyPasswordChanged(true);
            this.mySocksData.setPassword(this.antfPassword.getText());
        }
        this.mySocksData.deleteDomainList();
        if (!this.isNoEntries(this.DomainList)) {
            n2 = this.DomainList.getItemCount();
            n = 0;
            while (n < n2) {
                stringArray = this.DomainList.getItem(n);
                this.mySocksData.addDomain(stringArray[0]);
                ++n;
            }
        }
        this.mySocksData.deleteNameserverList();
        if (!this.isNoEntries(this.DNSList)) {
            n2 = this.DNSList.getItemCount();
            n = 0;
            while (n < n2) {
                stringArray = this.DNSList.getItem(n);
                this.mySocksData.addNameserver(stringArray[0]);
                ++n;
            }
        }
        if (this.myTrace) {
            System.out.println("PgSocks1 COMPARING Original string = " + this.originalSocksString);
            System.out.println("PgSocks1 COMPARING Current  string = " + this.toStringSocks());
        }
        if (this.originalSocksString.compareTo(this.toStringSocks()) != 0) {
            if (this.myTrace) {
                System.out.println("PgSocks1 SocksData has changed!!!");
            }
            this.mySocksData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgSocks1 SocksData has NOT changed!!!");
        }
        this.originalSocksString = null;
        if (this.mySocksData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgSocks1 SocksData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
    }

    public void setGUIfromData() {
        int n = this.mySocksData.getDomainListSize();
        int n2 = this.mySocksData.getNameserverListSize();
        this.DomainList.removeAll();
        this.DNSList.removeAll();
        this.cbEnableSOCKS.setState(this.mySocksData.isEnabled());
        ((TextComponent)this.antfUserId).setText(this.mySocksData.getUserID());
        ((TextComponent)this.antfPassword).setText("");
        ((TextComponent)this.antfVerifyPW).setText("");
        String[] stringArray = new String[1];
        if (n == 0) {
            stringArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            this.DomainList.add(stringArray);
        } else {
            int n3 = 0;
            while (n3 < n) {
                stringArray[0] = this.mySocksData.getDomain(n3);
                this.DomainList.add(stringArray);
                ++n3;
            }
        }
        String[] stringArray2 = new String[1];
        if (n2 == 0) {
            stringArray2[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            this.DNSList.add(stringArray2);
        } else {
            int n4 = 0;
            while (n4 < n2) {
                stringArray2[0] = this.mySocksData.getNameserver(n4);
                this.DNSList.add(stringArray2);
                ++n4;
            }
        }
        if (this.myListSelector.isSelected(this.DNSList)) {
            this.DNSList.select(0);
        } else {
            this.DomainList.select(0);
        }
        this.originalSocksString = this.toStringSocks();
        if (this.myTrace) {
            System.out.println("PgSocks1 Original string = " + this.originalSocksString);
        }
        if (this.mySocksData.isUpdated()) {
            this.undoTheUpdate = false;
        }
    }

    public boolean validatePage() {
        if (this.cbEnableSOCKS.getState() && this.isNoEntries(this.DNSList)) {
            this.showMessageDialog(this.myBundle.getString("PS1_ENABLED_NO_NS"), this);
            return false;
        }
        if (!this.antfPassword.getText().equals(this.antfVerifyPW.getText())) {
            this.showMessageDialog(this.myBundle.getString("PS1_PASSWORD_MATCH_ERROR"), this);
            return false;
        }
        return true;
    }

    public boolean validateMajorTab() {
        int n = this.mySocksData.getSocksServerEntryListSize();
        if (this.cbEnableSOCKS.getState() && n == 0) {
            this.showMessageDialog(this.myBundle.getString("PS1_ENABLED_NO_SS"), this);
            return false;
        }
        if (!this.antfPassword.getText().equals(this.antfVerifyPW.getText())) {
            this.showMessageDialog(this.myBundle.getString("PS1_PASSWORD_MATCH_ERROR"), this);
            return false;
        }
        return true;
    }

    private void doOKdlgACDadd() {
        if (this.myListSelector.isSelected(this.DomainList)) {
            if (this.isNoEntries(this.DomainList)) {
                this.removeNoEntries(this.DomainList);
            }
            String[] stringArray = new String[]{this.domainDialog.getDomain()};
            this.DomainList.add(stringArray);
            this.DomainList.select(this.DomainList.getItemCount() - 1);
            this.domainDialog.dispose();
            return;
        }
        if (this.isNoEntries(this.DNSList)) {
            this.removeNoEntries(this.DNSList);
        }
        String[] stringArray = new String[]{this.nameserverDialog.getNameServer()};
        this.DNSList.add(stringArray);
        this.DNSList.select(this.DNSList.getItemCount() - 1);
        this.nameserverDialog.dispose();
    }

    private void doOKdlgACDchange() {
        if (this.myListSelector.isSelected(this.DomainList)) {
            int n = this.DomainList.getSelectedIndex();
            if (n != -1) {
                String[] stringArray = new String[]{this.domainDialog.getDomain()};
                this.DomainList.replaceItem(stringArray, n);
                this.DomainList.select(n);
            }
            this.domainDialog.dispose();
            return;
        }
        int n = this.DNSList.getSelectedIndex();
        if (n != -1) {
            String[] stringArray = new String[]{this.nameserverDialog.getNameServer()};
            this.DNSList.replaceItem(stringArray, n);
            this.DNSList.select(n);
        }
        this.nameserverDialog.dispose();
    }

    private void doOKdlgACDdelete() {
        if (this.myListSelector.isSelected(this.DomainList)) {
            int n = this.DomainList.getSelectedIndex();
            this.DomainList.remove(n);
            int n2 = this.DomainList.getItemCount();
            if (n2 < 1) {
                String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES")};
                this.DomainList.add(stringArray);
                n = 0;
            } else if (n > 0) {
                --n;
            }
            this.DomainList.select(n);
            return;
        }
        int n = this.DNSList.getSelectedIndex();
        this.DNSList.remove(n);
        int n3 = this.DNSList.getItemCount();
        if (n3 < 1) {
            String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES")};
            this.DNSList.add(stringArray);
            n = 0;
        } else if (n > 0) {
            --n;
        }
        this.DNSList.select(n);
    }

    private void populateDlgACDd() {
        if (this.isNoEntries(this.DomainList)) {
            this.domainDialog.setDomain("");
            return;
        }
        String[] stringArray = this.DomainList.getItem(this.DomainList.getSelectedIndex());
        this.domainDialog.setDomain(stringArray[0]);
    }

    private void populateDlgACDn() {
        if (this.isNoEntries(this.DNSList)) {
            this.nameserverDialog.setNameServer("");
            return;
        }
        String[] stringArray = this.DNSList.getItem(this.DNSList.getSelectedIndex());
        this.nameserverDialog.setNameServer(stringArray[0]);
    }

    private void showACDdialog(int n) {
        switch (n) {
            case 0: {
                if (this.myListSelector.isSelected(this.DomainList)) {
                    this.domainDialog = new DlgSOCKS1ACDd(0, this, this.DomainList);
                    break;
                }
                this.nameserverDialog = new DlgSOCKS1ACDn(0, this, this.DNSList);
                break;
            }
            case 1: {
                if (this.myListSelector.isSelected(this.DomainList)) {
                    this.domainDialog = new DlgSOCKS1ACDd(1, this, this.DomainList);
                    this.populateDlgACDd();
                    break;
                }
                this.nameserverDialog = new DlgSOCKS1ACDn(1, this, this.DNSList);
                this.populateDlgACDn();
                break;
            }
            case 2: {
                if (this.myListSelector.isSelected(this.DomainList)) {
                    this.domainDialog = new DlgSOCKS1ACDd(2, this, this.DomainList);
                    this.populateDlgACDd();
                    break;
                }
                this.nameserverDialog = new DlgSOCKS1ACDn(2, this, this.DNSList);
                this.populateDlgACDn();
                break;
            }
            default: {
                if (this.myListSelector.isSelected(this.DomainList)) {
                    this.domainDialog = new DlgSOCKS1ACDd(0, this, this.DomainList);
                    break;
                }
                this.nameserverDialog = new DlgSOCKS1ACDn(0, this, this.DNSList);
            }
        }
        if (this.myListSelector.isSelected(this.DomainList)) {
            this.myOwner.setEnabled(false);
            this.domainDialog.setVisible(true);
            return;
        }
        this.myOwner.setEnabled(false);
        this.nameserverDialog.setVisible(true);
    }

    public void singleClick(MulColumn mulColumn, int n) {
        if (mulColumn == this.DomainList) {
            this.myListSelector.selectList(this.DomainList);
        }
        if (mulColumn == this.DNSList) {
            this.myListSelector.selectList(this.DNSList);
        }
    }

    public void doubleClick(MulColumn mulColumn, int n) {
        if (mulColumn == this.DomainList) {
            this.myListSelector.selectList(this.DomainList);
        }
        if (mulColumn == this.DNSList) {
            this.myListSelector.selectList(this.DNSList);
        }
    }

    public void messageFinished(int n) {
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (this.myTrace) {
            System.out.println("In PgSocks1.dialogFinished() - userAction=" + n);
        }
        if (n == 0) {
            if (this.dialogCommand == 1) {
                this.doOKdlgACDchange();
            } else if (this.dialogCommand == 2) {
                this.doOKdlgACDdelete();
            } else if (this.dialogCommand == 0) {
                this.doOKdlgACDadd();
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleCheckbox(Checkbox checkbox) {
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if ((button == buttonArray[1] || button == buttonArray[2]) && (this.myListSelector.isSelected(this.DomainList) ? !this.isChangeDeleteOk(this.DomainList, this) : !this.isChangeDeleteOk(this.DNSList, this))) {
            return;
        }
        if (button == buttonArray[0]) {
            if (this.myListSelector.isSelected(this.DomainList) && this.DomainList.getItemCount() == 3) {
                this.showMessageDialog(this.myBundle.getString("PH1_MAX_DOMAIN"), this);
                return;
            }
            this.dialogCommand = 0;
            this.showACDdialog(0);
            return;
        }
        if (button == buttonArray[1]) {
            this.dialogCommand = 1;
            this.showACDdialog(1);
            return;
        }
        if (button == buttonArray[2]) {
            this.dialogCommand = 2;
            this.showACDdialog(2);
            return;
        }
        if (button == buttonArray[3] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringSocks() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.antfUserId.getText());
        stringBuffer.append(this.antfPassword.getText());
        stringBuffer.append(this.antfVerifyPW.getText());
        if (this.cbEnableSOCKS.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        String[] stringArray = new String[1];
        int n = this.DomainList.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.DomainList.getItem(n2);
            stringBuffer.append(String.valueOf(stringArray[0]) + " ");
            ++n2;
        }
        String[] stringArray2 = new String[1];
        int n3 = this.DNSList.getColumnCount();
        int n4 = 0;
        while (n4 < n3) {
            stringArray2 = this.DNSList.getItem(n4);
            stringBuffer.append(String.valueOf(stringArray2[0]) + " ");
            ++n4;
        }
        return stringBuffer.toString();
    }
}

