/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgSOCKS2ACD;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksRouteEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class PgSOCKS2
extends BasePage
implements ActionListener,
DialogListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblDestIPaddress;
    private Panel centerPanel;
    private MulColumn myList;
    private DlgSOCKS2ACD directRoutesDialog;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null, null};
    private static final int ADD_BUTTON = 0;
    private static final int CHANGE_BUTTON = 1;
    private static final int DELETE_BUTTON = 2;
    private static final int UNDO_BUTTON = 3;
    private int dialogCommand = -1;
    private String originalSocksString = new String();
    private boolean undoTheUpdate = true;
    private SocksData mySocksData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private boolean myTrace = false;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private static final int SOCKS_ROUTE_LIST_MAX_COLUMNS = 2;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgSOCKS2(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgSOCKS2.buttonLabels[0] = this.myBundle.getString("GLO_ADD");
        PgSOCKS2.buttonLabels[1] = this.myBundle.getString("GLO_CHANGE");
        PgSOCKS2.buttonLabels[2] = this.myBundle.getString("GLO_DELETE");
        PgSOCKS2.buttonLabels[3] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PS2_TITLE"));
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        String[] stringArray = new String[]{this.myBundle.getString("PS2_DEST_IP_ADDR"), this.myBundle.getString("PS2_SUBNET_MASK")};
        int[] nArray = new int[]{50, 50};
        this.myList = new MulColumn(stringArray, nArray);
        this.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.myList, 0, 0, 0, 1, 1, 10, 1.0, 1.0, 10, 10, 10, 10);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 1, 10, 0.5, 1.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 2, 5);
    }

    private void doUndoButton() {
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalSocksString = this.toStringSocks();
            this.mySocksData.setUpdated(false);
        }
    }

    private void doHelpButton() {
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.mySocksData = this.myServerProxy.getNotebookProfileDataHandle().getSocksDataHandle();
    }

    public void setDataFromGUI() {
        this.mySocksData.deleteSocksRouteEntryList();
        int n = this.isNoEntries(this.myList) ? 0 : this.myList.getItemCount();
        String[] stringArray = new String[2];
        SocksRouteEntry socksRouteEntry = null;
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.myList.getItem(n2);
            socksRouteEntry = new SocksRouteEntry(stringArray[0], stringArray[1]);
            this.mySocksData.addSocksRouteEntry(socksRouteEntry);
            ++n2;
        }
        if (this.myTrace) {
            System.out.println("PgSocks2 COMPARING Original string = " + this.originalSocksString);
            System.out.println("PgSocks2 COMPARING Current  string = " + this.toStringSocks());
        }
        if (this.originalSocksString.compareTo(this.toStringSocks()) != 0) {
            if (this.myTrace) {
                System.out.println("PgSocks2 SocksData has changed!!!");
            }
            this.mySocksData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgSocks2 SocksData has NOT changed!!!");
        }
        this.originalSocksString = null;
        if (this.mySocksData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgSocks2 SocksData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
    }

    public void setGUIfromData() {
        int n = this.mySocksData.getSocksRouteEntryListSize();
        this.myList.removeAll();
        if (n == 0) {
            String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES"), ""};
            this.myList.add(stringArray);
        } else {
            int n2 = 0;
            while (n2 < n) {
                SocksRouteEntry socksRouteEntry = this.mySocksData.getSocksRouteEntry(n2);
                String[] stringArray = new String[]{socksRouteEntry.getIPaddress(), socksRouteEntry.getSubnetMask()};
                this.myList.add(stringArray);
                ++n2;
            }
        }
        this.myList.select(0);
        this.originalSocksString = this.toStringSocks();
        if (this.myTrace) {
            System.out.println("PgSocks2 Original string = " + this.originalSocksString);
        }
        if (this.mySocksData.isUpdated()) {
            this.undoTheUpdate = false;
        }
    }

    public boolean validatePage() {
        return true;
    }

    private void doOKdlgACDadd() {
        if (this.isNoEntries(this.myList)) {
            this.removeNoEntries(this.myList);
        }
        String[] stringArray = new String[]{this.directRoutesDialog.getIPaddress(), this.directRoutesDialog.getSubnetMask()};
        this.myList.add(stringArray);
        this.myList.select(this.myList.getItemCount() - 1);
        this.directRoutesDialog.dispose();
    }

    private void doOKdlgACDchange() {
        int n = this.myList.getSelectedIndex();
        if (n != -1) {
            String[] stringArray = new String[]{this.directRoutesDialog.getIPaddress(), this.directRoutesDialog.getSubnetMask()};
            this.myList.replaceItem(stringArray, n);
            this.myList.select(n);
        }
        this.directRoutesDialog.dispose();
    }

    private void doOKdlgACDdelete() {
        int n = this.myList.getSelectedIndex();
        if (n != -1) {
            this.myList.remove(n);
            int n2 = this.myList.getItemCount();
            if (n2 < 1) {
                String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES"), ""};
                this.myList.add(stringArray);
                n = 0;
            } else if (n == n2) {
                --n;
            }
            this.myList.select(n);
        }
    }

    private void populateDlgACD() {
        String[] stringArray = this.myList.getItem(this.myList.getSelectedIndex());
        this.directRoutesDialog.setIPaddress(stringArray[0]);
        this.directRoutesDialog.setSubnetMask(stringArray[1]);
    }

    private void showACDdialog(int n) {
        this.directRoutesDialog = null;
        switch (n) {
            case 0: {
                this.directRoutesDialog = new DlgSOCKS2ACD(0, this, this.myList);
                break;
            }
            case 1: {
                this.directRoutesDialog = new DlgSOCKS2ACD(1, this, this.myList);
                this.populateDlgACD();
                break;
            }
            case 2: {
                this.directRoutesDialog = new DlgSOCKS2ACD(2, this, this.myList);
                this.populateDlgACD();
                break;
            }
            default: {
                this.directRoutesDialog = new DlgSOCKS2ACD(0, this, this.myList);
            }
        }
        this.myOwner.setEnabled(false);
        this.directRoutesDialog.setVisible(true);
    }

    public void messageFinished(int n) {
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (this.myTrace) {
            System.out.println("In PgHostname1.dialogFinished() - userAction=" + n);
        }
        if (n == 0) {
            if (this.dialogCommand == 1) {
                this.doOKdlgACDchange();
            } else if (this.dialogCommand == 2) {
                this.doOKdlgACDdelete();
            } else if (this.dialogCommand == 0) {
                this.doOKdlgACDadd();
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            this.dialogCommand = 0;
            this.showACDdialog(0);
            return;
        }
        if (button == buttonArray[1]) {
            if (this.isChangeDeleteOk(this.myList, this)) {
                this.dialogCommand = 1;
                this.showACDdialog(1);
                return;
            }
        } else if (button == buttonArray[2]) {
            if (this.isChangeDeleteOk(this.myList, this)) {
                this.dialogCommand = 2;
                this.showACDdialog(2);
                return;
            }
        } else if (button == buttonArray[3] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringSocks() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[2];
        int n = this.myList.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.myList.getItem(n2);
            stringBuffer.append(String.valueOf(stringArray[0]) + " ");
            stringBuffer.append(String.valueOf(stringArray[1]) + " ");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

