/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgSOCKS3ACD;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksServerEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class PgSOCKS3
extends BasePage
implements ActionListener,
DialogListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Panel centerPanel;
    private MulColumn myList;
    private DlgSOCKS3ACD socksServersDialog;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null, null};
    private static final int ADD_BUTTON = 0;
    private static final int CHANGE_BUTTON = 1;
    private static final int DELETE_BUTTON = 2;
    private static final int UNDO_BUTTON = 3;
    private int dialogCommand = -1;
    private String originalSocksString = new String();
    private boolean undoTheUpdate = true;
    private SocksData mySocksData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private boolean myTrace = false;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private static final int SOCKS_SERVER_LIST_MAX_COLUMNS = 6;
    boolean myPasswordChange = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgSOCKS3(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgSOCKS3.buttonLabels[0] = this.myBundle.getString("GLO_ADD");
        PgSOCKS3.buttonLabels[1] = this.myBundle.getString("GLO_CHANGE");
        PgSOCKS3.buttonLabels[2] = this.myBundle.getString("GLO_DELETE");
        PgSOCKS3.buttonLabels[3] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PS3_TITLE"));
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        String[] stringArray = new String[]{this.myBundle.getString("PS3_SOCKS_SERVER"), this.myBundle.getString("PS3_DEST_IP_ADDR"), this.myBundle.getString("PS3_SUBNET_MASK"), this.myBundle.getString("PS3_USER_ID"), " ", " "};
        int[] nArray = new int[]{33, 33, 34, 33, 1, 1};
        this.myList = new MulColumn(stringArray, nArray);
        this.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.myList, 0, 0, 0, 1, 1, 10, 1.0, 1.0, 10, 10, 10, 10);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 2, 5);
    }

    private void doUndoButton() {
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalSocksString = this.toStringSocks();
            this.mySocksData.setUpdated(false);
        }
    }

    private void doHelpButton() {
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.mySocksData = this.myServerProxy.getNotebookProfileDataHandle().getSocksDataHandle();
    }

    public void setDataFromGUI() {
        int n;
        this.mySocksData.deleteSocksServerEntryList();
        if (this.isNoEntries(this.myList)) {
            this.myList.removeAll();
            n = 0;
        } else {
            n = this.myList.getItemCount();
        }
        String[] stringArray = new String[6];
        SocksServerEntry socksServerEntry = null;
        if (n == 0) {
            stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES"), "", "", "", "", ""};
            this.myList.add(stringArray);
        }
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.myList.getItem(n2);
            if (stringArray[4] == "") {
                this.myPasswordChange = false;
                socksServerEntry = new SocksServerEntry(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[5], this.myPasswordChange);
            } else {
                this.myPasswordChange = true;
                socksServerEntry = new SocksServerEntry(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], this.myPasswordChange);
            }
            this.mySocksData.addSocksServerEntry(socksServerEntry);
            ++n2;
        }
        if (this.myTrace) {
            System.out.println("PgSocks3 COMPARING Original string = " + this.originalSocksString);
            System.out.println("PgSocks3 COMPARING Current  string = " + this.toStringSocks());
        }
        if (this.originalSocksString.compareTo(this.toStringSocks()) != 0) {
            if (this.myTrace) {
                System.out.println("PgSocks3 SocksData has changed!!!");
            }
            this.mySocksData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgSocks3 SocksData has NOT changed!!!");
        }
        this.originalSocksString = null;
        if (this.mySocksData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgSocks3 SocksData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
    }

    public void setGUIfromData() {
        int n = this.mySocksData.getSocksServerEntryListSize();
        this.myList.removeAll();
        if (n == 0) {
            String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES"), "", "", "", "", ""};
            this.myList.add(stringArray);
        } else {
            int n2 = 0;
            while (n2 < n) {
                SocksServerEntry socksServerEntry = this.mySocksData.getSocksServerEntry(n2);
                String[] stringArray = new String[]{socksServerEntry.getServer(), socksServerEntry.getIPaddress(), socksServerEntry.getSubnetMask(), socksServerEntry.getUserID(), "", socksServerEntry.getPassword()};
                this.myList.add(stringArray);
                ++n2;
            }
        }
        this.myList.select(0);
        this.originalSocksString = this.toStringSocks();
        if (this.myTrace) {
            System.out.println("PgSocks3 Original string = " + this.originalSocksString);
        }
        if (this.mySocksData.isUpdated()) {
            this.undoTheUpdate = false;
        }
    }

    public boolean validatePage() {
        return true;
    }

    private void doOKdlgACDadd() {
        if (this.isNoEntries(this.myList)) {
            this.removeNoEntries(this.myList);
        }
        String[] stringArray = new String[]{this.socksServersDialog.getSocksServer(), this.socksServersDialog.getIPaddress(), this.socksServersDialog.getSubnetMask(), this.socksServersDialog.getUserID(), this.socksServersDialog.getPassword(), ""};
        this.myList.add(stringArray);
        this.myList.select(this.myList.getItemCount() - 1);
        this.socksServersDialog.dispose();
    }

    private void doOKdlgACDchange() {
        int n = this.myList.getSelectedIndex();
        if (n != -1) {
            String[] stringArray = new String[]{this.socksServersDialog.getSocksServer(), this.socksServersDialog.getIPaddress(), this.socksServersDialog.getSubnetMask(), this.socksServersDialog.getUserID(), this.socksServersDialog.getPassword(), ""};
            this.myList.replaceItem(stringArray, n);
            this.myList.select(n);
        }
        this.socksServersDialog.dispose();
    }

    private void doOKdlgACDdelete() {
        int n = this.myList.getSelectedIndex();
        if (n != -1) {
            this.myList.remove(n);
            int n2 = this.myList.getItemCount();
            if (n2 < 1) {
                String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES"), "", "", "", "", ""};
                this.myList.add(stringArray);
                n = 0;
            } else if (n == n2) {
                --n;
            }
            this.myList.select(n);
        }
    }

    private void populateDlgACD(DlgSOCKS3ACD dlgSOCKS3ACD) {
        String[] stringArray = this.myList.getItem(this.myList.getSelectedIndex());
        dlgSOCKS3ACD.setSocksServer(stringArray[0]);
        dlgSOCKS3ACD.setIPaddress(stringArray[1]);
        dlgSOCKS3ACD.setSubnetMask(stringArray[2]);
        dlgSOCKS3ACD.setUserID(stringArray[3]);
        dlgSOCKS3ACD.setPassword("");
    }

    private void showACDdialog(int n) {
        this.socksServersDialog = null;
        switch (n) {
            case 0: {
                this.socksServersDialog = new DlgSOCKS3ACD(0, this, this.myList);
                break;
            }
            case 1: {
                this.socksServersDialog = new DlgSOCKS3ACD(1, this, this.myList);
                this.populateDlgACD(this.socksServersDialog);
                break;
            }
            case 2: {
                this.socksServersDialog = new DlgSOCKS3ACD(2, this, this.myList);
                this.populateDlgACD(this.socksServersDialog);
                break;
            }
            default: {
                this.socksServersDialog = new DlgSOCKS3ACD(0, this, this.myList);
            }
        }
        this.myOwner.setEnabled(false);
        this.socksServersDialog.setVisible(true);
    }

    public void messageFinished(int n) {
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (this.myTrace) {
            System.out.println("In PgSOCKS3.dialogFinished() - userAction=" + n);
        }
        if (n == 0) {
            if (this.dialogCommand == 1) {
                this.doOKdlgACDchange();
            } else if (this.dialogCommand == 2) {
                this.doOKdlgACDdelete();
            } else if (this.dialogCommand == 0) {
                this.doOKdlgACDadd();
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            this.dialogCommand = 0;
            this.showACDdialog(0);
            return;
        }
        if (button == buttonArray[1]) {
            if (this.isChangeDeleteOk(this.myList, this)) {
                this.dialogCommand = 1;
                this.showACDdialog(1);
                return;
            }
        } else if (button == buttonArray[2]) {
            if (this.isChangeDeleteOk(this.myList, this)) {
                this.dialogCommand = 2;
                this.showACDdialog(2);
                return;
            }
        } else if (button == buttonArray[3] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringSocks() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[6];
        int n = this.myList.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.myList.getItem(n2);
            stringBuffer.append(String.valueOf(stringArray[0]) + " ");
            stringBuffer.append(String.valueOf(stringArray[1]) + " ");
            stringBuffer.append(String.valueOf(stringArray[2]) + " ");
            stringBuffer.append(String.valueOf(stringArray[3]) + " ");
            stringBuffer.append(String.valueOf(stringArray[4]) + " ");
            stringBuffer.append(String.valueOf(stringArray[5]) + " ");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

