/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BorderPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgFtpd;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgNFSD;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgRexecd;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgSecurity1ACD;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgTelnetd;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.FtpAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NfsAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.RexecAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TelnetAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;

public class PgSecurity1
extends BasePage
implements ActionListener,
MouseListener,
DialogListener,
MessageListener,
Cfg2Defines {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblServerAuth;
    private Button bFtpd;
    private Button bTelnetd;
    private Button bRexecd;
    private Button bNFSD;
    private MulColumn myList;
    private ButtonPanel myButtons1;
    private static String[] buttonLabels1 = new String[]{null};
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null, null};
    private static final int ADD_BUTTON = 0;
    private static final int CHANGE_BUTTON = 1;
    private static final int DELETE_BUTTON = 2;
    private static final int UNDO_BUTTON = 3;
    private final int COPY_BUTTON = 0;
    private Label lblFtpdStatus;
    private Label lblTelnetdStatus;
    private Label lblRexecdStatus;
    private Label lblNFSDStatus;
    private Panel leftPanel;
    private Panel rightPanel;
    private BorderPanel ftpdPanel;
    private BorderPanel telnetdPanel;
    private BorderPanel rexecdPanel;
    private BorderPanel tcpcfg2dPanel;
    private static final int FTP_DIALOG = 990;
    private static final int TELNET_DIALOG = 991;
    private static final int REXEC_DIALOG = 992;
    private static final int COPY_USER_DIALOG = 993;
    private static final int NFS_DIALOG = 994;
    private DlgSecurity1ACD securityDialog;
    private DlgFtpd configureFtpdDialog;
    private DlgTelnetd configureTelnetdDialog;
    private DlgRexecd configureRexecdDialog;
    private DlgNFSD configureNFSDialog;
    private int dialogCommand = -1;
    private boolean undoTheUpdate = true;
    private UserData myUserData;
    private BaseProxy myServerProxy;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    int prevSel = -1;
    GridBagLayout gridBag = new GridBagLayout();
    private boolean myTrace = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgSecurity1(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgSecurity1.buttonLabels1[0] = this.myBundle.getString("PSC1_COPY");
        PgSecurity1.buttonLabels[0] = this.myBundle.getString("GLO_ADD");
        PgSecurity1.buttonLabels[1] = this.myBundle.getString("GLO_CHANGE");
        PgSecurity1.buttonLabels[2] = this.myBundle.getString("GLO_DELETE");
        PgSecurity1.buttonLabels[3] = this.myBundle.getString("GLO_UNDO");
        this.myButtons1 = new ButtonPanel(this, buttonLabels1);
        Utility.constrain(this, this.myButtons1, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(this.myButtons1);
        myButtonPanel = new ButtonPanel(this, buttonLabels);
        Utility.constrain(this, myButtonPanel, n, ++n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PSC1_TITLE"));
        this.leftPanel = new Panel();
        this.rightPanel = new Panel();
        this.ftpdPanel = new BorderPanel(this.myBundle.getString("PSC1_FTP"));
        this.telnetdPanel = new BorderPanel(this.myBundle.getString("PSC1_TELNETD"));
        this.rexecdPanel = new BorderPanel(this.myBundle.getString("PSC1_REXEC"));
        this.tcpcfg2dPanel = new BorderPanel(this.myBundle.getString("PSC1_NFS"));
        this.lblServerAuth = new Label(this.myBundle.getString("PSC1_SERVER_AUTH"));
        this.lblFtpdStatus = new Label(this.myBundle.getString("PSC1_NOT_CONFIGURED"));
        this.lblTelnetdStatus = new Label(this.myBundle.getString("PSC1_NOT_CONFIGURED"));
        this.lblRexecdStatus = new Label(this.myBundle.getString("PSC1_NOT_CONFIGURED"));
        this.lblNFSDStatus = new Label(this.myBundle.getString("PSC1_NOT_CONFIGURED"));
        String[] stringArray = new String[]{this.myBundle.getString("PSC1_USER_ID"), this.myBundle.getString("PSC1_COMMENTS")};
        int[] nArray = new int[]{45, 55};
        this.myList = new MulColumn(stringArray, nArray);
        this.myList.addMouseListener(this);
        this.bFtpd = new Button(this.myBundle.getString("PSC1_C_FTPD"));
        this.bTelnetd = new Button(this.myBundle.getString("PSC1_C_TELNETD"));
        this.bRexecd = new Button(this.myBundle.getString("PSC1_C_REXECD"));
        this.bNFSD = new Button(this.myBundle.getString("PSC1_C_TCPCFG2D"));
        this.bFtpd.addActionListener(this);
        this.bTelnetd.addActionListener(this);
        this.bRexecd.addActionListener(this);
        this.bNFSD.addActionListener(this);
        this.bFtpd.addKeyListener(this);
        this.bTelnetd.addKeyListener(this);
        this.bRexecd.addKeyListener(this);
        this.bNFSD.addKeyListener(this);
        this.myButtons1 = new ButtonPanel(this, buttonLabels1);
        this.setLayout(this.gridBag);
        this.leftPanel.setLayout(this.gridBag);
        this.rightPanel.setLayout(this.gridBag);
        this.ftpdPanel.setLayout(this.gridBag);
        this.telnetdPanel.setLayout(this.gridBag);
        this.rexecdPanel.setLayout(this.gridBag);
        this.tcpcfg2dPanel.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.leftPanel, this.myList, 0, 0, 0, 1, 1, 10, 1.0, 1.0, 10, 10, 10, 0);
        Utility.constrain(this.ftpdPanel, this.bFtpd, 0, 0, -1, 2, 2, 17, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.ftpdPanel, this.lblFtpdStatus, 1, 0, 0, 1, 0, 17, 1.0, 0.0, 0, 5, 0, 0);
        Utility.constrain(this.rightPanel, this.ftpdPanel, 0, 1, 0, 1, 2, 13, 1.0, 1.0, 5, 5, 10, 5);
        Utility.constrain(this.telnetdPanel, this.bTelnetd, 0, 0, -1, 2, 2, 17, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.telnetdPanel, this.lblTelnetdStatus, 1, 0, 0, 1, 0, 17, 1.0, 0.0, 0, 5, 0, 0);
        Utility.constrain(this.rightPanel, this.telnetdPanel, 0, 2, 0, 1, 2, 13, 1.0, 1.0, 0, 5, 10, 5);
        Utility.constrain(this.rexecdPanel, this.bRexecd, 0, 0, -1, 2, 2, 17, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.rexecdPanel, this.lblRexecdStatus, 1, 0, 0, 1, 0, 17, 1.0, 0.0, 0, 5, 0, 0);
        Utility.constrain(this.rightPanel, this.rexecdPanel, 0, 3, 0, 1, 2, 13, 1.0, 1.0, 0, 5, 10, 5);
        Utility.constrain(this.tcpcfg2dPanel, this.bNFSD, 0, 0, -1, 2, 2, 17, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.tcpcfg2dPanel, this.lblNFSDStatus, 1, 0, 0, 1, 0, 17, 1.0, 0.0, 0, 5, 0, 0);
        Utility.constrain(this.rightPanel, this.tcpcfg2dPanel, 0, 4, 0, 1, 2, 13, 1.0, 1.0, 0, 5, 10, 5);
        Utility.constrain(this, this.leftPanel, 0, 1, -1, 1, 1, 10, 3.0, 1.0, 0, 5, 0, 0);
        Utility.constrain(this, this.rightPanel, 1, 1, 0, 1, 3, 10, 1.0, 0.0, 0, 0, 0, 5);
        this.addButtonGUI(0, 2, 5);
    }

    private void doUndoButton() {
        this.myUserData.deCommit(2);
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.myUserData.setUpdated(false);
        }
    }

    private void doHelpButton() {
    }

    private void doOKDlgFtpd() {
        UserEntry userEntry = this.myUserData.getUserEntry(this.myUserData.getUserSelectedIndex());
        FtpAccess ftpAccess = userEntry.getFtpAccess();
        ftpAccess.setReadDirectories(this.configureFtpdDialog.getRead());
        ftpAccess.setWriteDirectories(this.configureFtpdDialog.getWrite());
        ftpAccess.setLogCd(this.configureFtpdDialog.getCd());
        ftpAccess.setLogDebug(this.configureFtpdDialog.getDbg());
        ftpAccess.setLogAll(this.configureFtpdDialog.getLogAll());
        ftpAccess.setLogDel(this.configureFtpdDialog.getDel());
        ftpAccess.setLogDir(this.configureFtpdDialog.getDir());
        ftpAccess.setLogGet(this.configureFtpdDialog.getGet());
        ftpAccess.setLogMd(this.configureFtpdDialog.getMd());
        ftpAccess.setLogPut(this.configureFtpdDialog.getPut());
        ftpAccess.setLogRd(this.configureFtpdDialog.getRd());
        ftpAccess.setLogRen(this.configureFtpdDialog.getRen());
        ftpAccess.setRead(this.configureFtpdDialog.getDenyRead());
        ftpAccess.setWrite(this.configureFtpdDialog.getDenyWrite());
        ftpAccess.setIdleTimeout(this.configureFtpdDialog.getTimeout());
        ftpAccess.setEnableUser(this.configureFtpdDialog.getEnableUser());
        this.lblFtpdStatus.setText(this.getConfiguredState(ftpAccess.isConfigured(), ftpAccess.getEnableUser()));
    }

    private void doOKDlgTelnetd() {
        UserEntry userEntry = this.myUserData.getUserEntry(this.myUserData.getUserSelectedIndex());
        TelnetAccess telnetAccess = userEntry.getTelnetAccess();
        userEntry.setShellProgram(this.configureTelnetdDialog.getShellProgram());
        userEntry.setShellParameters(this.configureTelnetdDialog.getShellParameters());
        userEntry.setConnectedAfterExit(this.configureTelnetdDialog.getDisconnect());
        telnetAccess.setEnableUser(this.configureTelnetdDialog.getEnableUser());
        this.lblTelnetdStatus.setText(this.getConfiguredState(telnetAccess.isConfigured(), telnetAccess.getEnableUser()));
    }

    private void doOKDlgRexecd() {
        UserEntry userEntry = this.myUserData.getUserEntry(this.myUserData.getUserSelectedIndex());
        RexecAccess rexecAccess = userEntry.getRexecAccess();
        rexecAccess.setEnableUser(this.configureRexecdDialog.getEnableUser());
        this.lblRexecdStatus.setText(this.getConfiguredState(rexecAccess.isConfigured(), rexecAccess.getEnableUser()));
    }

    private void doOKDlgNFSD() {
        UserEntry userEntry = this.myUserData.getUserEntry(this.myUserData.getUserSelectedIndex());
        NfsAccess nfsAccess = userEntry.getNfsAccess();
        nfsAccess.setEnableUser(this.configureNFSDialog.getEnableUser());
        nfsAccess.setUID(this.configureNFSDialog.getUID());
        nfsAccess.setGID(this.configureNFSDialog.getGID());
        userEntry.setUID(this.configureNFSDialog.getUID());
        userEntry.setGID(this.configureNFSDialog.getGID());
        this.lblNFSDStatus.setText(this.getConfiguredState(nfsAccess.isConfigured(), nfsAccess.getEnableUser()));
    }

    public void commit() {
        this.myUserData.commit(2);
        this.undoTheUpdate = false;
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.myUserData = this.myServerProxy.getNotebookProfileDataHandle().getUserDataHandle();
    }

    private void loadGuiPage(int n) {
        this.myUserData.setUserSelectedIndex(n);
        UserEntry userEntry = this.myUserData.getUserEntry(n);
        this.bFtpd.setEnabled(true);
        this.bTelnetd.setEnabled(true);
        this.bRexecd.setEnabled(true);
        this.bNFSD.setEnabled(true);
        if (userEntry.getUserName().compareTo("anonymous") == 0) {
            this.bTelnetd.setEnabled(false);
            this.bRexecd.setEnabled(false);
            this.bNFSD.setEnabled(false);
        }
        FtpAccess ftpAccess = userEntry.getFtpAccess();
        this.lblFtpdStatus.setText(this.getConfiguredState(ftpAccess.isConfigured(), ftpAccess.getEnableUser()));
        TelnetAccess telnetAccess = userEntry.getTelnetAccess();
        this.lblTelnetdStatus.setText(this.getConfiguredState(telnetAccess.isConfigured(), telnetAccess.getEnableUser()));
        RexecAccess rexecAccess = userEntry.getRexecAccess();
        this.lblRexecdStatus.setText(this.getConfiguredState(rexecAccess.isConfigured(), rexecAccess.getEnableUser()));
        NfsAccess nfsAccess = userEntry.getNfsAccess();
        this.lblNFSDStatus.setText(this.getConfiguredState(nfsAccess.isConfigured(), nfsAccess.getEnableUser()));
    }

    private String getConfiguredState(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return this.myBundle.getString("PSC1_CONFIGURED_ENABLED");
            }
            return this.myBundle.getString("PSC1_CONFIGURED_DISABLED");
        }
        if (bl2) {
            return this.myBundle.getString("PSC1_NOT_CONFIGURED_ENABLED");
        }
        return this.myBundle.getString("PSC1_NOT_CONFIGURED_DISABLED");
    }

    public void setDataFromGUI() {
    }

    public void setGUIfromData() {
        this.myList.removeAll();
        Button[] buttonArray = myButtonPanel.getButtons();
        buttonArray[1].setEnabled(true);
        buttonArray[2].setEnabled(true);
        Button[] buttonArray2 = myButtonPanel.getButtons();
        buttonArray2 = this.myButtons1.getButtons();
        buttonArray2[0].setEnabled(true);
        int n = this.myUserData.getUserEntryListSize();
        String[] stringArray = new String[2];
        if (n < 1) {
            stringArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            stringArray[1] = "";
            this.myList.add(stringArray);
            buttonArray[1].setEnabled(false);
            buttonArray[2].setEnabled(false);
            this.bFtpd.setEnabled(false);
            this.bTelnetd.setEnabled(false);
            this.bRexecd.setEnabled(false);
            this.bNFSD.setEnabled(false);
            buttonArray = this.myButtons1.getButtons();
            buttonArray[0].setEnabled(false);
        } else {
            int n2 = 0;
            while (n2 < n) {
                UserEntry userEntry = this.myUserData.getUserEntry(n2);
                stringArray[0] = userEntry.getUserName();
                stringArray[1] = userEntry.getComment();
                this.myList.add(stringArray);
                ++n2;
            }
        }
        this.myList.select(0);
        if (this.myUserData.getUserEntryListSize() > 0) {
            this.loadGuiPage(0);
        } else {
            this.lblFtpdStatus.setText(this.getConfiguredState(false, false));
            this.lblTelnetdStatus.setText(this.getConfiguredState(false, false));
            this.lblRexecdStatus.setText(this.getConfiguredState(false, false));
            this.lblNFSDStatus.setText(this.getConfiguredState(false, false));
        }
        this.prevSel = 0;
        if (this.myUserData.isUpdated()) {
            this.undoTheUpdate = false;
        }
    }

    public boolean validatePage() {
        return true;
    }

    private void doOKCopyUserAccess() {
        UserEntry userEntry = (UserEntry)this.myUserData.getUserEntry(this.myUserData.getUserSelectedIndex()).clone();
        userEntry.setUserName(this.securityDialog.getUserName());
        userEntry.setComment(this.securityDialog.getComment());
        userEntry.setPassword(this.securityDialog.getPassword());
        userEntry.setHomeDir(this.securityDialog.getHomeDir());
        this.myUserData.addUserEntry(userEntry);
        String[] stringArray = new String[]{userEntry.getUserName(), userEntry.getComment()};
        this.myList.add(stringArray);
        int n = this.myList.getItemCount() - 1;
        this.myList.select(n);
        this.loadGuiPage(n);
    }

    private void doOKdlgACDadd() {
        Object[] objectArray;
        UserEntry userEntry = new UserEntry();
        userEntry.setUserName(this.securityDialog.getUserName());
        userEntry.setComment(this.securityDialog.getComment());
        if (Utility.hasValue(this.securityDialog.getPassword())) {
            userEntry.setPassword(this.securityDialog.getPassword());
        }
        userEntry.setHomeDir(this.securityDialog.getHomeDir());
        this.myUserData.addUserEntry(userEntry);
        if (this.isNoEntries(this.myList)) {
            this.myList.remove(0);
            objectArray = myButtonPanel.getButtons();
            ((Component)objectArray[1]).setEnabled(true);
            ((Component)objectArray[2]).setEnabled(true);
            this.bFtpd.setEnabled(true);
            this.bTelnetd.setEnabled(true);
            this.bRexecd.setEnabled(true);
            this.bNFSD.setEnabled(true);
            objectArray = this.myButtons1.getButtons();
            ((Component)objectArray[0]).setEnabled(true);
        }
        objectArray = new String[]{userEntry.getUserName(), userEntry.getComment()};
        this.myList.add((String[])objectArray);
        int n = this.myList.getItemCount() - 1;
        this.myList.select(n);
        this.loadGuiPage(n);
        this.securityDialog.dispose();
    }

    private void doOKdlgACDchange() {
        int n = this.myUserData.getUserSelectedIndex();
        UserEntry userEntry = this.myUserData.getUserEntry(n);
        if (Utility.hasValue(this.securityDialog.getPassword())) {
            userEntry.setPassword(this.securityDialog.getPassword());
        }
        userEntry.setHomeDir(this.securityDialog.getHomeDir());
        userEntry.setUserName(this.securityDialog.getUserName());
        userEntry.setComment(this.securityDialog.getComment());
        String[] stringArray = new String[]{userEntry.getUserName(), userEntry.getComment()};
        this.myList.replaceItem(stringArray, n);
        this.loadGuiPage(n);
        this.securityDialog.dispose();
    }

    private void doOKdlgACDdelete() {
        int n = this.myList.getSelectedIndex();
        this.myList.remove(n);
        this.myUserData.deleteUserEntry(n);
        int n2 = this.myList.getItemCount();
        if (n2 < 1) {
            String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES"), ""};
            this.myList.add(stringArray);
            this.lblFtpdStatus.setText(this.getConfiguredState(false, false));
            this.lblTelnetdStatus.setText(this.getConfiguredState(false, false));
            this.lblRexecdStatus.setText(this.getConfiguredState(false, false));
            this.lblNFSDStatus.setText(this.getConfiguredState(false, false));
            Button[] buttonArray = myButtonPanel.getButtons();
            buttonArray[1].setEnabled(false);
            buttonArray[2].setEnabled(false);
            this.bFtpd.setEnabled(false);
            this.bTelnetd.setEnabled(false);
            this.bRexecd.setEnabled(false);
            this.bNFSD.setEnabled(false);
            buttonArray = this.myButtons1.getButtons();
            buttonArray[0].setEnabled(false);
            this.myList.select(0);
            return;
        }
        if (n > 0) {
            --n;
        }
        this.myList.select(n);
        this.loadGuiPage(n);
    }

    private void populateDlgACD() {
        UserEntry userEntry = this.myUserData.getUserEntry(this.myUserData.getUserSelectedIndex());
        this.securityDialog.setUserName(userEntry.getUserName());
        this.securityDialog.setComment(userEntry.getComment());
        this.securityDialog.setHomeDir(userEntry.getHomeDir());
    }

    private void populateDlgCopyUser() {
        UserEntry userEntry = this.myUserData.getUserEntry(this.myUserData.getUserSelectedIndex());
        this.securityDialog.setUserName("");
        this.securityDialog.setComment(userEntry.getComment());
        this.securityDialog.setHomeDir(userEntry.getHomeDir());
    }

    private void populateDlgFtpd() {
        UserEntry userEntry = this.myUserData.getUserEntry(this.myUserData.getUserSelectedIndex());
        FtpAccess ftpAccess = userEntry.getFtpAccess();
        this.configureFtpdDialog.setRead(ftpAccess.getReadDirectories());
        this.configureFtpdDialog.setWrite(ftpAccess.getWriteDirectories());
        this.configureFtpdDialog.setEnableUser(ftpAccess.getEnableUser());
        this.configureFtpdDialog.setCd(ftpAccess.isLogCd());
        this.configureFtpdDialog.setDenyRead(ftpAccess.isRead());
        this.configureFtpdDialog.setDenyWrite(ftpAccess.isWrite());
        this.configureFtpdDialog.setTimeout(ftpAccess.getIdleTimeout());
        this.configureFtpdDialog.setDel(ftpAccess.isLogDel());
        this.configureFtpdDialog.setMd(ftpAccess.isLogMd());
        this.configureFtpdDialog.setGet(ftpAccess.isLogGet());
        this.configureFtpdDialog.setRd(ftpAccess.isLogRd());
        this.configureFtpdDialog.setPut(ftpAccess.isLogPut());
        this.configureFtpdDialog.setDir(ftpAccess.isLogDir());
        this.configureFtpdDialog.setRen(ftpAccess.isLogRen());
        this.configureFtpdDialog.setDbg(ftpAccess.isLogDebug());
        this.configureFtpdDialog.setLogAll(ftpAccess.isLogAll());
    }

    private void populateDlgTelnetd() {
        UserEntry userEntry = this.myUserData.getUserEntry(this.myUserData.getUserSelectedIndex());
        TelnetAccess telnetAccess = userEntry.getTelnetAccess();
        if (this.myTrace) {
            System.out.println("populating the telnetd dialog");
        }
        this.configureTelnetdDialog.setShellProgram(userEntry.getShellProgram());
        this.configureTelnetdDialog.setShellParameters(userEntry.getShellParameters());
        this.configureTelnetdDialog.setDisconnect(userEntry.isConnectedAfterExit());
        this.configureTelnetdDialog.setEnableUser(telnetAccess.getEnableUser());
    }

    private void populateDlgRexecd() {
        UserEntry userEntry = this.myUserData.getUserEntry(this.myUserData.getUserSelectedIndex());
        RexecAccess rexecAccess = userEntry.getRexecAccess();
        this.configureRexecdDialog.setEnableUser(rexecAccess.getEnableUser());
    }

    private void populateDlgNFSD() {
        if (this.myTrace) {
            System.out.println("populating the nfsd dialog");
        }
        UserEntry userEntry = this.myUserData.getUserEntry(this.myUserData.getUserSelectedIndex());
        NfsAccess nfsAccess = userEntry.getNfsAccess();
        this.configureNFSDialog.setEnableUser(nfsAccess.getEnableUser());
        this.configureNFSDialog.setUID(userEntry.getUID());
        this.configureNFSDialog.setGID(userEntry.getGID());
        if (this.myTrace) {
            System.out.println("uid is" + userEntry.getUID() + "and gid is:" + userEntry.getGID());
        }
    }

    private void showACDdialog(int n) {
        switch (n) {
            case 0: {
                this.securityDialog = new DlgSecurity1ACD(0, this, this.myList);
                break;
            }
            case 1: {
                this.securityDialog = new DlgSecurity1ACD(1, this, this.myList);
                this.populateDlgACD();
                break;
            }
            case 2: {
                this.securityDialog = new DlgSecurity1ACD(2, this, this.myList);
                this.populateDlgACD();
                break;
            }
            case 993: {
                this.securityDialog = new DlgSecurity1ACD(0, this, this.myList);
                this.populateDlgCopyUser();
                break;
            }
            case 990: {
                this.configureFtpdDialog = new DlgFtpd(this);
                this.populateDlgFtpd();
                break;
            }
            case 991: {
                this.configureTelnetdDialog = new DlgTelnetd(this);
                this.populateDlgTelnetd();
                break;
            }
            case 992: {
                this.configureRexecdDialog = new DlgRexecd(this);
                this.populateDlgRexecd();
                break;
            }
            case 994: {
                this.configureNFSDialog = new DlgNFSD(this);
                this.populateDlgNFSD();
                break;
            }
            default: {
                this.securityDialog = new DlgSecurity1ACD(0, this, this.myList);
            }
        }
        this.myOwner.setEnabled(false);
        if (n == 990) {
            this.configureFtpdDialog.setVisible(true);
            return;
        }
        if (n == 991) {
            this.configureTelnetdDialog.setVisible(true);
            return;
        }
        if (n == 992) {
            this.configureRexecdDialog.setVisible(true);
            return;
        }
        if (n == 994) {
            this.configureNFSDialog.setVisible(true);
            return;
        }
        this.securityDialog.setVisible(true);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof MulColumn && object == this.myList && this.prevSel != this.myList.getSelectedIndex() && !this.isNoEntries(this.myList)) {
            this.loadGuiPage(this.myList.getSelectedIndex());
            this.prevSel = this.myList.getSelectedIndex();
            return;
        }
    }

    public void messageFinished(int n) {
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (this.myTrace) {
            System.out.println("In PgHostname1.dialogFinished() - userAction=" + n);
        }
        if (n == 0) {
            this.myUserData.setUpdated(true);
            if (this.dialogCommand == 1) {
                this.doOKdlgACDchange();
            } else if (this.dialogCommand == 2) {
                this.doOKdlgACDdelete();
            } else if (this.dialogCommand == 0) {
                this.doOKdlgACDadd();
            } else if (this.dialogCommand == 990) {
                this.doOKDlgFtpd();
            } else if (this.dialogCommand == 991) {
                this.doOKDlgTelnetd();
            } else if (this.dialogCommand == 992) {
                this.doOKDlgRexecd();
            } else if (this.dialogCommand == 994) {
                this.doOKDlgNFSD();
            } else if (this.dialogCommand == 993) {
                this.doOKCopyUserAccess();
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = this.myButtons1.getButtons();
        if (button == buttonArray[0]) {
            if (this.isNoEntries(this.myList)) {
                this.showMessageDialog(this.myBundle.getString("GLO_EMPTY_LIST"), this);
                return;
            }
            this.dialogCommand = 993;
            this.showACDdialog(993);
            return;
        }
        Button[] buttonArray2 = myButtonPanel.getButtons();
        if (button == buttonArray2[0]) {
            this.dialogCommand = 0;
            this.showACDdialog(0);
            return;
        }
        if (button == buttonArray2[1]) {
            if (this.isChangeDeleteOk(this.myList, this)) {
                this.dialogCommand = 1;
                this.showACDdialog(1);
                return;
            }
        } else if (button == buttonArray2[2]) {
            if (this.isChangeDeleteOk(this.myList, this)) {
                this.dialogCommand = 2;
                this.showACDdialog(2);
                return;
            }
        } else if (button == buttonArray2[3]) {
            if (this.isUndoConfirmed(this)) {
                this.doUndoButton();
                return;
            }
        } else {
            if (button == this.bFtpd) {
                this.dialogCommand = 990;
                this.showACDdialog(990);
                return;
            }
            if (button == this.bTelnetd) {
                this.dialogCommand = 991;
                this.showACDdialog(991);
                return;
            }
            if (button == this.bRexecd) {
                this.dialogCommand = 992;
                this.showACDdialog(992);
                return;
            }
            if (button == this.bNFSD) {
                this.dialogCommand = 994;
                this.showACDdialog(994);
            }
        }
    }
}

