/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TimedData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

public class PgTimed1
extends BasePage
implements ActionListener,
ItemListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblServerPort;
    private Label lblNetworkByteOrder;
    private Label lblAdjustLocal;
    private TextField tfServerPort;
    private Checkbox cbNetworkByteOrder;
    private Checkbox cbAdjustLocal;
    private Panel centerPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null};
    private static final int UNDO_BUTTON = 0;
    private static final int MAX_BUTTONS_IN_ROW = 2;
    private String originalTimedString = new String();
    private boolean undoTheUpdate = true;
    private TimedData myTimedData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private boolean myTrace = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgTimed1(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgTimed1.buttonLabels[0] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("TD1_TITLE"));
        this.lblServerPort = new Label(this.myBundle.getString("TD1_SERVER_PORT"));
        this.lblNetworkByteOrder = new Label(this.myBundle.getString("TD1_NETWORK_BYTE"));
        this.lblAdjustLocal = new Label(this.myBundle.getString("TD1_ADJUST_TO_LOCAL_TIME"));
        this.tfServerPort = new TextField();
        this.cbNetworkByteOrder = new Checkbox();
        this.cbAdjustLocal = new Checkbox();
        this.cbNetworkByteOrder.addItemListener(this);
        this.cbAdjustLocal.addItemListener(this);
        this.setLayout(this.gridBag);
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.lblServerPort, 0, 0, -1, 1, 2, 13, 1.0, 1.0, 50, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.tfServerPort, 1, 0, 0, 1, 2, 13, 1.0, 1.0, 50, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblNetworkByteOrder, 0, 1, -1, 1, 2, 13, 1.0, 1.0, 50, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.cbNetworkByteOrder, 1, 1, 0, 1, 2, 13, 1.0, 1.0, 50, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblAdjustLocal, 0, 2, -1, 1, 2, 13, 1.0, 1.0, 50, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.cbAdjustLocal, 1, 2, 0, 1, 2, 13, 1.0, 1.0, 50, 0, 0, 10);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 2, 10, 1.0, 1.0, 10, 20, 0, 0);
        this.addButtonGUI(0, 2, 2);
    }

    private void doHelpButton() {
    }

    private void doUndoButton() {
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalTimedString = this.toStringTimed();
            this.myTimedData.setUpdated(false);
        }
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.myTimedData = this.myServerProxy.getNotebookProfileDataHandle().getTimedDataHandle();
    }

    public void setDataFromGUI() {
        this.myTimedData.setServerPort(Integer.parseInt(this.tfServerPort.getText()));
        this.myTimedData.setNetworkByteOrder(this.cbNetworkByteOrder.getState());
        this.myTimedData.setAdjustToLocalTime(this.cbAdjustLocal.getState());
        if (this.myTrace) {
            System.out.println("PgTimed1 COMPARING Original string = " + this.originalTimedString);
            System.out.println("PgTimed1 COMPARING Current  string = " + this.toStringTimed());
        }
        if (this.originalTimedString.compareTo(this.toStringTimed()) != 0) {
            if (this.myTrace) {
                System.out.println("PgTimed1 TimedData has changed!!!");
            }
            this.myTimedData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgTimed1 TimedData has NOT changed!!!");
        }
        this.originalTimedString = null;
        if (this.myTimedData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgTimed1 TimedData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
    }

    public void setGUIfromData() {
        ((TextComponent)this.tfServerPort).setText(String.valueOf(this.myTimedData.getServerPort()));
        this.cbAdjustLocal.setState(this.myTimedData.isAdjustToLocalTime());
        this.cbNetworkByteOrder.setState(this.myTimedData.isNetworkByteOrder());
        this.originalTimedString = this.toStringTimed();
        if (this.myTrace) {
            System.out.println("PgTimed1 Original string = " + this.originalTimedString);
        }
        if (this.myTimedData.isUpdated()) {
            this.undoTheUpdate = false;
        }
    }

    public boolean validatePage() {
        return true;
    }

    public void messageFinished(int n) {
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            this.handleCheckbox((Checkbox)object);
        }
    }

    public void handleCheckbox(Checkbox checkbox) {
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringTimed() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tfServerPort.getText());
        stringBuffer.append(this.cbNetworkByteOrder.getState());
        stringBuffer.append(this.cbAdjustLocal.getState());
        return stringBuffer.toString();
    }
}

